/**
 * @file info.c
 * Information structures
 * @author Marko Mkel (msmakela@nic.funet.fi)
 */

/* Copyright  2001 Marko Mkel.

   This file is part of CBMLINK, a program for data communications between
   Commodore 8-bit microcomputers and other computer systems.

   CBMLINK is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   CBMLINK is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

#include "info.h"
#include <stdio.h>

/** Detect a Commodore computer
 * @param host	host type
 * @return	name of the host
 */
const char*
cbmname (enum cbm host)
{
  static char unknown[12];
  switch (host) {
  case PET:
    return "PET";
  case PET3:
    return "PET 3000";
  case PET4:
    return "PET 4000/8000";
  case P500:
    return "P500";
  case B128:
    return "B-128/610/710";
  case B256:
    return "B-256/620/720";
  case Vic:
    return "VIC-20";
  case C64:
    return "C64";
  case C128:
    return "C128";
  case C264:
    return "264 series";
  }
  sprintf (unknown, "?%u", host);
  return unknown;
}

#if defined __WIN32 || defined __WIN32__
# include <windows.h>
# ifndef WIN32
#  define WIN32
# endif /* WIN32 */
/** Report a Windows error
 * @param op	the failed operation
 * @param dev	(optional) the device name
 */
void
report_error (const char* op,
	      const char* dev)
{
  char* msg;
  long err = GetLastError ();
  FormatMessage (FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		 FORMAT_MESSAGE_FROM_SYSTEM | 
		 FORMAT_MESSAGE_IGNORE_INSERTS,
		 0,
		 err,
		 0, /* default language */
		 (LPTSTR) &msg,
		 0,
		 0);
  AnsiToOem (msg, msg);
  if (dev)
    fputs (dev, stderr), fputs (": ", stderr);
  fputs (op, stderr);
  fprintf (stderr, " failed with code %ld: ", err);
  fputs (msg, stderr);
  LocalFree (msg);
}
#endif /* defined __WIN32 || defined __WIN32__ */
