;;; @file cbm/rom.s
;;; Useful VIC-20/C64/C128/264/B KERNAL file handling routines
;;; @author Marko Mkel (msmakela@nic.funet.fi)

utilstart = $1800
;;; this is not a PET
pet = 0

;;; file handling routines
readst	= $ffb7			; read the status of last operation
setlfs	= $ffba			; set default file parameters
setnam	= $ffbd			; set default file name
open	= $ffc0			; open file with default parameters and name
close	= $ffc3			; close file
chkout	= $ffc9			; redirect standard output to file .X
clrchn	= $ffcc			; clear input/output redirections
chrout	= $ffd2			; write .A to standard output
stop	= $ffe1			; check for STOP key
chkin	= $ffc6			; redirect standard input to file .X
chrin	= $ffcf			; read .A from standard input

	;; macro => read the status to .A
#define READST jsr readst
	;; macro => set the file parameters
#define SETLFS jsr setlfs
	;; macro => set the file name (length in .A)
#define SETNAM(n) ldx #<n:ldy #>n:jsr setnam
	;; macro => set an empty file name (.A=0)
#define SETNAM0 jsr setnam
	;; macro => store device number if necessary
#define STDEV stx device
	;; macro => set the file parameters, preserving the device number
#define SETLFSD device=*+1:ldx #0:jsr setlfs
