/***************************************************************************
                          cdbakeovenview.h  -  description
                             -------------------
    begin                : Fri May 18 23:05:50 EDT 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDBAKEOVENVIEW_H
#define CDBAKEOVENVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>
#include <qsplitter.h>
#include <kio/job.h>


class QWidgetStack;

// forward declaration of the CDBakeOvenView classes
class SrcTreeCntPanel;
class SrcListPnl;
class NewCdCompilationView;
class NewAudioCdCompilationView;
class NewAdvancedCdCompilationView;
class FoldersListView;
class KConfig;


class CDBakeOvenView : public QSplitter{
  Q_OBJECT
public:
    /** Constructor for the main view */
    CDBakeOvenView(QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~CDBakeOvenView();

	void saveOptions();
	bool queryClose();
public slots:
	void showSrcControl(bool);
	void showTargetControl(bool);
	void showEstimate(bool);
	void showFilterPnl(bool);
	bool showAudio();
  	bool showData();
  	bool showAdvanced();
  	bool newActive();
	
protected slots:
	void startLongProcess();
	void stopLongProcess();
	void enableParts(bool);

private:
  	void initView();
  	void initRegConnections();
  	void connectData();
  	void disconnectData();
  	void connectAudio();
  	void disconnectAudio();
  	void connectAdvanced();
  	void disconnectAdvanced();
  	bool disconnectActive();
  	
  	
  	
  	//members
  	QWidgetStack * buttomViewHolder;
  	KConfig *config;
  	NewCdCompilationView* compilView;
  	NewAudioCdCompilationView* audioCompilView;
  	NewAdvancedCdCompilationView* advancedCompilView;
  	SrcTreeCntPanel *srcCont;
  	SrcListPnl *listPnl;
  	FoldersListView *srcTree; 	
  	
  	int eTimeId;
  	int lastPercent; 	
	int activeType;
	
};

#endif // CDBAKEOVENVIEW_H
