/***************************************************************************
                          SettingsDialog.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// #include <iostream.h>

#include <qvariant.h>

#include <kdialogbase.h>
#include <kiconloader.h>
#include <klocale.h>


#include "SettingsDialog.h"
#include "dialogWidgets/DetectTbsPnl.h"
#include "dialogWidgets/RecordOptPnl.h"
#include "dialogWidgets/CdboOpt.h"
#include "dialogWidgets/AudioOptPnl.h"
#include "dialogWidgets/IsoOptPnl.h"
#include "dialogWidgets/InfoPnl.h"

SettingsDialog::SettingsDialog(QWidget* parent, const char* name, bool modal, int index):KDialogBase(
		KDialogBase::IconList,
		"CD  Bake Oven Settings Dialog",
		KDialogBase::Help|KDialogBase::Default|KDialogBase::Ok|KDialogBase::Apply|KDialogBase::Cancel,
		KDialogBase::Cancel,
		parent,
		name,
		modal,
		true){
	///////////////////////////////
	initSlots();

	///////////////////////////////////
	QVBox *page = addVBoxPage(i18n("Specifications"),
									"Specifications",
									BarIcon("info", KIcon::SizeMedium ));
	info = new InfoPnl( (QWidget *)page);
	///////////////////////////////////
	page = addVBoxPage(i18n("Device Settings"),
									"Device Settings",
									BarIcon("kfm", KIcon::SizeMedium ));
	detectPnl = new DetectTbsPnl( (QWidget *)page );
	
	///////////////////////////////////
	page = addVBoxPage(i18n("Recording Options"),
									"Customize Recording Options",//rec);
									BarIcon("cdwriter_unmount", KIcon::SizeMedium ));
	recordOptPnl = new RecordOptPnl( (QWidget *)page );
	///////////////////////////////////
	page = addVBoxPage(i18n("New CD Setings"),
									i18n("New CD Type (ISO Settings)"),
									UserIcon("cdImage", KIcon::SizeMedium ));
									//"/home/shlomo/build/images/isoSetupTop.png");
	isoOptPnl = new IsoOptPnl( (QWidget *)page );

	///////////////////////////////////
	page = addVBoxPage(i18n("Audio Options"),
									"Audio Options",
									BarIcon("cdaudio_unmount", KIcon::SizeMedium ));
	if(index == AudioMP3){
		audioOptPnl = new AudioOptPnl(1, (QWidget *)page );
		index = Audio;
	}
	else{
		audioOptPnl = new AudioOptPnl( (QWidget *)page );	
	}

	///////////////////////////////////
	page = addVBoxPage(i18n("Customize Defaults"),
									"CD Bake Oven Default Setings",
									BarIcon("wizard", KIcon::SizeMedium ));
	cdboOpt = new CdboOpt( (QWidget *)page );
	
	setSizePolicy( QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed, false) );
	setMaximumSize(725,525);
	setMinimumSize(725,525);
	//resize(10,10);
	
	showPage(index);
	
}
//-----------------------------------------------------------------
SettingsDialog::~SettingsDialog(){}
//-----------------------------------------------------------------
void SettingsDialog::initSlots(){
	  connect( this, SIGNAL(applyClicked()), this, SLOT(applyClickedSlot()) );
	  connect( this, SIGNAL(defaultClicked()), this, SLOT(defaultClickedSlot()) );
	  connect( this, SIGNAL(okClicked()), this, SLOT(okClickedSlot()) );
	  connect( this, SIGNAL(cancelClicked()), this, SLOT(cancelClickedSlot()) );
}
//-----------------------------------------------------------------
void SettingsDialog::applyClickedSlot(){
	switch(activePageIndex()){
		case Defaults: cdboOpt->saveOptions(); break;
    		case Devices: detectPnl->saveOptions(); break;
    		case Recording: recordOptPnl->saveOptions(); break;
    		case Image: isoOptPnl->saveOptions(); break;
    		case Audio: audioOptPnl->saveOptions(); break;
	}
	emit applied();
}
//-----------------------------------------------------------------
void SettingsDialog::defaultClickedSlot(){
	switch(activePageIndex()){
		case Defaults: cdboOpt->applyDefaults(); break;
    		case Devices: detectPnl->applyDefaults(); break;
    		case Recording: recordOptPnl->applyDefaults(); break;
    		case Image: isoOptPnl->applyDefaults(); break;
    		case Audio: audioOptPnl->applyDefaults(); break;
	}
}
//-----------------------------------------------------------------
void SettingsDialog::okClickedSlot(){
	cdboOpt->saveOptions();
	detectPnl->saveOptions();
	recordOptPnl->saveOptions();
	isoOptPnl->saveOptions();
	audioOptPnl->saveOptions();
	info->saveData();
}
//-----------------------------------------------------------------
void SettingsDialog::cancelClickedSlot(){
	info->saveData();
}