/***************************************************************************
                          DialogCntPnl.h  -  description
                             -------------------
    begin                : Thu May 31 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef DIALOGCNTPNL_H
#define DIALOGCNTPNL_H

#include <qvariant.h>
#include <qwidget.h>
#include <qdatetime.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <klistview.h>

#include <klocale.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QFrame;
class QGroupBox;
class QListViewItem;

class DialogCntPnl : public QWidget{
    Q_OBJECT

public:
     DialogCntPnl( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
     ~DialogCntPnl();

     void output(int type, QString message);
     inline void status(QString msg) { statusLbl->setText( tr( msg) ); }
	void stopForwardTimer();
	void startForwardTimer();
	
	inline void setStartBtnTitle(QString title) { startBtn->setText( tr( title ) ); }
	inline void resizeOutputViewColomns(int w1, int w2){
		outputView->setColumnWidth(0,w1);
		outputView->setColumnWidth(1,w2);
	}
	inline QPushButton* getStartBtn() { return startBtn; }
	inline QPushButton* getCancelBtn() { return cancelBtn; }
	inline QPushButton* getSettingsBtn() { return settingsBtn; }
	inline QPushButton* getDumpBtn() { return dumpBtn; }
	inline QPushButton* getQuitBtn() { return quitBtn; }
	inline void clearOutput() {outputView->clear();}
	
protected slots:
 	virtual void timerEvent(QTimerEvent *event);

     virtual void cancelSlot();
     virtual void dumpSlot();
     virtual void helpSlot();
     virtual void quitSlot();
     virtual void startSlot();
     virtual void settingsSlot();

private:
	int eTimeId;
	QTime timer;
	
	//GUI PARTS ========================
     KListView* outputView;

     QLabel* statusLbl;
     QLabel* eTimeLbl;
     QLabel* rTimeLbl;

     QPushButton* startBtn;
     QPushButton* cancelBtn;
     QPushButton* settingsBtn;
     QPushButton* dumpBtn;
     QPushButton* helpBtn;
     QPushButton* quitBtn;


     QLabel* timeRemLbl;
     QLabel* elapsedTimeLbl;
     QFrame* Frame11_2_2_2;
     QFrame* mainFrm;
     QGroupBox* GroupBox42_2;
	QFrame* controlPanel_2;
      QHBoxLayout* DialogCntPnlLayout;
     QGridLayout* mainFrmLayout;
     QVBoxLayout* GroupBox42_2Layout;
     QHBoxLayout* Frame11_2_2_2Layout;
     QVBoxLayout* controlPanel_2Layout;
     bool event( QEvent* );
};

#endif // DIALOGCNTPNL_H
