/***************************************************************************
                          DriveInfoPnl.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "DriveInfoPnl.h"

#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <kconfig.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kprocess.h>



DriveInfoPnl::DriveInfoPnl( QWidget* parent,  const char* name, WFlags fl)
    : QWidget( parent, name, fl ){

     if ( !name )
 		setName( "DriveInfoPnl" );
	type = 0;
	//ejected = false;
	config = kapp->config();
	
     resize( 284, 131 );
     driveInfoPnlLayout = new QHBoxLayout( this );
     driveInfoPnlLayout->setSpacing( 0 );
     driveInfoPnlLayout->setMargin( 0 );

     driveInfoPnlFrm = new QButtonGroup( this, "driveInfoPnlFrm" );

     driveInfoPnlFrm->setColumnLayout(0, Qt::Vertical );
     driveInfoPnlFrm->layout()->setSpacing( 0 );
     driveInfoPnlFrm->layout()->setMargin( 0 );
     driveInfoPnlFrmLayout = new QGridLayout( driveInfoPnlFrm->layout() );
     driveInfoPnlFrmLayout->setAlignment( Qt::AlignTop );
     driveInfoPnlFrmLayout->setSpacing( 7 );
     driveInfoPnlFrmLayout->setMargin( 5 );
////????????????????????????????
     usrBtn = new QPushButton( driveInfoPnlFrm, "usrBtn" );
     usrBtn->setMinimumSize( QSize( 90, 30 ) );
     usrBtn->setMaximumSize( QSize( 100, 30 ) );
     usrBtn->setText( tr( "&Preview" ) );
     QToolTip::add(  usrBtn, tr( "Preview your CD-RW" ) );
////????????????????????????????
     driveInfoPnlFrmLayout->addMultiCellWidget( usrBtn, 1, 1, 1, 2 );

     devicesCmb = new QComboBox( FALSE, driveInfoPnlFrm, "devicesCmb" );
     devicesCmb->setEnabled( TRUE );
     devicesCmb->setMinimumSize( QSize( 180, 30 ) );
     devicesCmb->setMaximumSize( QSize( 200, 30 ) );
     devicesCmb->setEditable( false );
     devicesCmb->setCurrentItem( 0 );

     driveInfoPnlFrmLayout->addMultiCellWidget( devicesCmb, 0, 0, 2, 4 );

     detectBtn = new QPushButton( driveInfoPnlFrm, "detectBtn" );
     detectBtn->setMinimumSize( QSize( 90, 30 ) );
     detectBtn->setMaximumSize( QSize( 100, 30 ) );
     detectBtn->setText( tr( "&Detect" ) );
     QToolTip::add(  detectBtn, tr( "Detect devices" ) );
     QWhatsThis::add(  detectBtn, tr( "Invoke detection dialog." ) );

     driveInfoPnlFrmLayout->addWidget( detectBtn, 1, 3 );
     QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
     driveInfoPnlFrmLayout->addItem( spacer, 1, 4 );

     deviceBtn = new QPushButton( driveInfoPnlFrm, "deviceBtn" );
     deviceBtn->setMinimumSize( QSize( 55, 55 ) );
     deviceBtn->setMaximumSize( QSize( 55, 55 ) );
     deviceBtn->setText( tr( "" ) );

     driveInfoPnlFrmLayout->addMultiCellWidget( deviceBtn, 0, 0, 0, 1 );
     QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
     driveInfoPnlFrmLayout->addItem( spacer_2, 1, 0 );
     driveInfoPnlLayout->addWidget( driveInfoPnlFrm );

     // signals and slots connections
     connect( deviceBtn, SIGNAL( clicked() ), this, SLOT( deviceBtnSlot() ) );

     //connect( usrBtn, SIGNAL( clicked() ), this, SLOT( usrBtnSlot() ) );
}
/*  
 *  Destroys the object and frees any allocated resources
 */
DriveInfoPnl::~DriveInfoPnl(){
}
//---------------------------------------------------------------------------
void DriveInfoPnl::setType(int t) {
	if(t < 1 || t > 2) return;//invalid type
	type = t;
	if(type == Target){
		setTitle( tr( "Destination" ) );
     		QWhatsThis::add(  driveInfoPnlFrm, tr( "Target (writing device)." ) );
     		QToolTip::add(  devicesCmb, i18n( "Available recording devices." ) );
		
		QPixmap image = UserIcon("target", KIcon::SizeMedium );
		setDevImage(image);
     		QToolTip::add(  deviceBtn, tr( "Eject destination media." ) );
	}
	else{
		setTitle("Source");
		QWhatsThis::add(  driveInfoPnlFrm, tr( "Source (reading device)." ) );
     		QToolTip::add(  devicesCmb, i18n( "Available cdrom drives." ) );
     		
		QPixmap image = UserIcon("source", KIcon::SizeMedium );
		setDevImage(image);
     		QToolTip::add(  deviceBtn, tr( "Eject source media." ) );
	}
}
//---------------------------------------------------------------------------------------------
void DriveInfoPnl::readOptions(){
	if(!type) return;
	if(type == Target){
		///////////////////////////////////////////////////////////
       	config->setGroup("Target Devices");
       	QStringList targetsList(config->readListEntry("Targets List"));
       	devicesCmb->clear();
       	devicesCmb->insertStringList(targetsList,0);
       	
       	int pos = config->readNumEntry("Last Target", 0);
          	if(pos <= devicesCmb->count())
          		devicesCmb->setCurrentItem(pos);
	}
	else{
		///////////////////////////////////////////////////////////    	
           config->setGroup("Source Devices");
       	QStringList sourceList(config->readListEntry("Source List"));
           devicesCmb->clear();
       	devicesCmb->insertStringList(sourceList,0);
       	
       	int pos = config->readNumEntry("Last Source", 0);
       	if(pos <= devicesCmb->count())
          		devicesCmb->setCurrentItem(pos);
     	}
}
//---------------------------------------------------------------------------------------------
void DriveInfoPnl::saveOptions(){
	if(!type) return;
	if(type == Target){
		///////////////////////////////////////////////////////////////
     		config->setGroup("Target Devices");
		config->writeEntry("Last Target", devicesCmb->currentItem());
	}
	else{
		///////////////////////////////////////////////////////////////
		config->setGroup("Source Devices");
		config->writeEntry("Last Source", devicesCmb->currentItem());
	}
}
//---------------------------------------------------------------------------------------------
QString DriveInfoPnl::getScsiDevice(){
	if(type != Target) return "";
	config->setGroup("Target Devices");
	return config->readEntry(devicesCmb->currentText(),"");
}
//---------------------------------------------------------------------------
void DriveInfoPnl::deviceBtnSlot(){
    	deviceBtn->setEnabled(false);
    	if(!ejected) eject();
	else closeTray();
}
//---------------------------------------------------------------------------------------------
void DriveInfoPnl::eject(){
	cdboProc = new KProcess();
	*cdboProc << "eject" << getDriveName();
	QApplication::connect(cdboProc, SIGNAL(processExited(KProcess *)),
     			this, SLOT(processComplited(KProcess *)));
	ejected = true;
	if(!cdboProc->start(KProcess::NotifyOnExit)){
		deviceBtn->setEnabled(true);
		delete cdboProc;
	}
}
//---------------------------------------------------------------------------------------------
void DriveInfoPnl::closeTray(){
	cdboProc = new KProcess();
	*cdboProc << "eject" << "-t" << getDriveName();
	ejected = false;
	QApplication::connect(cdboProc, SIGNAL(processExited(KProcess *)),
      			this, SLOT(processComplited(KProcess *)));
	if(!cdboProc->start(KProcess::NotifyOnExit)){
	//if(!cdboProc->start(KProcess::Block)){
		deviceBtn->setEnabled(true);
		delete cdboProc;
	}
	
}
//---------------------------------------------------------------------------------------------
void DriveInfoPnl::closeTrayAndWait(){
	//done = false;
	cdboProc = new KProcess();
	*cdboProc << "eject" << "-t" << getDriveName();
	ejected = false;
	//QApplication::connect(cdboProc, SIGNAL(processExited(KProcess *)),
      //			this, SLOT(processComplited(KProcess *)));
	cdboProc->start(KProcess::Block);
	//if(!cdboProc->start(KProcess::NotifyOnExit))
	//	done = true;
	delete cdboProc;	
}
//---------------------------------------------------------------------------------------------
void DriveInfoPnl::processComplited(KProcess *){
	if(!blocked)
		deviceBtn->setEnabled(true);
	delete cdboProc;
}
//---------------------------------------------------------------------------------------------
void DriveInfoPnl::blockBtns(bool yes){
	blocked = yes;
	deviceBtn->setEnabled(!yes);
	devicesCmb->setEnabled(!yes);
	usrBtn->setEnabled(!yes);
}
//=======================================================
QString DriveInfoPnl::getDriveName() {
	//
	if(type != Target){
		///////////////////////////////////////////////////////////
		config->setGroup("Source Devices");
       	return config->readEntry(devicesCmb->currentText());
	}
	else{	
       	config->setGroup("Target Devices");
       	return config->readEntry(devicesCmb->currentText() + " device");
     	}
     	return "";
}
