/***************************************************************************
                          DetectTbsPnl.cpp  -  description
                             -------------------
    begin                : Fri Jun 1 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//#include  <iostream.h>

#include <qfile.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

#include <kapp.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <kprocess.h>
#include <kmessagebox.h>

#include "DetectTbsPnl.h"
#include "CommandOutputDialog.h"

DetectTbsPnl::DetectTbsPnl( QWidget* parent,  const char* name)
	: DetectPnlBase( parent, name){
	config = kapp->config();
	customBrowseBtn->setPixmap( UserIcon("fileopen", KIcon::SizeMedium ) );
	
	autoLst->setColumnWidth(0,110);
	autoLst->setColumnWidth(1,220);
	autoLst->setColumnWidth(2,85);
	autoLst->setColumnWidth(3,89);
	
	scsiLst->setColumnWidth(0,75);
	scsiLst->setColumnWidth(1,85);
	scsiLst->setColumnWidth(2,185);
	scsiLst->setColumnWidth(3,160);
	
	customLst->setColumnWidth(0,110);
	customLst->setColumnWidth(1,95);
	customLst->setColumnWidth(2,308);
	
	////////////////////////////
    	config->setGroup("Default Settings");
	if(config->readBoolEntry("Auto Scan Devices", true))
		rescanSlot();
	if(config->readBoolEntry("Auto Scan SCSI Devices", false))
		retryScsiSlot();
	readOptions();
}
DetectTbsPnl::~DetectTbsPnl(){
}
//------------------------------------------------------------------------------------------------------
void DetectTbsPnl::saveOptions(){	

	///////////////////////////////////////////////////
	config->setGroup("Source Devices");
     config->writeEntry("Source List", sourceList);
     //config->writeEntry("Source Names List", sourceNameMappings);
	
	for(int i = 0; i < (int)sourceNameMappings.count(); i++){
		QString buff = sourceNameMappings[i];
		config->writeEntry( buff.left(buff.find("=")) , buff.right(buff.length() - buff.find("=") - 1) );
	}
	
	////////////////////////////////////////////////////////////
	config->setGroup("Target Devices");
     config->writeEntry("Targets List", targetsList);
	for(int i = 0; i < (int)targetsMappings.count(); i++){
		QString buff = targetsMappings[i];
		config->writeEntry( buff.left(buff.find("=")) , buff.right(buff.length() - buff.find("=") - 1) );
	}
 	
 	for(int i = 0; i < (int)targetsNameMappings.count(); i++){
		QString buff = targetsNameMappings[i];
		config->writeEntry( buff.left(buff.find("=")) + " device" , buff.right(buff.length() - buff.find("=") - 1) );
	}
	
 	config->setGroup("Custom Devices");
 	config->writeEntry("Unknown", unknown);
 	
     config->writeEntry("Custom List", customList);
	for(int i = 0; i < (int)customMappings.count(); i++){
		config->writeEntry( customList[i] , customMappings[i] );
	}
	config->writeEntry("Custom Scsi", customScsiChk->isChecked());
 	config->sync();
}
//---------------------------------------------------------------------------------------------
void DetectTbsPnl::readOptions(){
	////////////////////////////////////
	config->setGroup("Custom Devices");
	unknown = config->readNumEntry("Unknown", 0);
	
     customList = config->readListEntry("Custom List");
 	
 	QListViewItem * item;

	for(int i = 0; i < (int)customList.count(); i++){
		QString name = customList[i];
		
     		QString mappings = config->readEntry(customList[i]);
		QString device = mappings.right(mappings.length() - mappings.find("|") - 1);
		
		QString scsi =  mappings.left(mappings.find("|"));
		
		if(scsi && scsi != "n/a"){
			if(scsiList.contains(scsi) > 0){
			     KMessageBox::error(this,
			     		"Refuse to add '" + name + "' to the custom devices list.\n"\
             			"Device with same scsi settings already detected!");
          			customList.remove(customList[i]);
				continue;
			}
			scsiList.append(scsi);/////////////////////////////////////////////////
			targetsList.append(name);
			targetsMappings.append(device + "=" + scsi);	
			targetsNameMappings.append(name + "=" + device);
			scsi = "[" + scsi + "]";		
		}
		customMappings.append(mappings);
		sourceList.append(name);
		sourceNameMappings.append( name + "=" + device);

		item = new QListViewItem( customLst, 0);	
		item->setPixmap( 0, BarIcon("exec", KIcon::SizeSmall ));
     		item->setText( 2, name);
     		item->setText( 0, device);
     		item->setText( 1, scsi);
	}
	
	
	customScsiChk->setChecked(config->readBoolEntry("Custom Scsi", true));
	customScsiSlot();
}
//---------------------------------------------------------------------------------------------
void DetectTbsPnl::applyDefaults(){
	KSimpleConfig *config = (KSimpleConfig *)(kapp->config());
	config->deleteGroup("Custom Devices");
	config->deleteGroup("Source Devices");
	config->deleteGroup("Target Devices");
	
	customMappings.clear();
	customList.clear();
	sourceList.clear();
	targetsList.clear();
	targetsMappings.clear();
	sourceNameMappings.clear();
	targetsNameMappings.clear();
	scsiList.clear();
	
	customLst->clear();
	autoLst->clear();
	customPathTxt->clear();	
	customScsiSpn->setValue(0);
	customTargetSpn->setValue(0);
	customLunSpn->setValue(0);
	descriptionTxt->clear();
	customScsiChk->setChecked(true);
	
}
//------------------------------------------------------------------------------------------------------
void DetectTbsPnl::rescanSlot(){
	autoLst->clear();
	scanScsi();
	scanIdes();	
}
//------------------------------------------------------------------------------------------------
void DetectTbsPnl::scanIdes(){
	//sourceList = new QStringList();
	QString buff, cdromSt = "cdrom";
	QString ides[4];
	ides[0] = "hda";
	ides[1] = "hdb";
	ides[2] = "hdc";
	ides[3] = "hdd";
	QListViewItem * item ;
	for(int i = 0; i < 4; i++){
		
		QFile medfile("/proc/ide/" + ides[i] + "/media");	
		if(medfile.open(IO_ReadOnly)) {
        		medfile.readLine(buff,(unsigned int)250);
        		//cerr << buff;
        		if(buff.contains(cdromSt,TRUE) > 0){
        			item = new QListViewItem( autoLst, 0);
        			
        			item->setPixmap( 0, BarIcon("cdrom_unmount", KIcon::SizeSmall ));
        			item->setText( 0, " /dev/" + ides[i] + " ");
        			//sourceList.append( "/dev/" + ides[i]);
        			
        			QFile modfile("/proc/ide/" + ides[i] + "/model");
        			if(modfile.open(IO_ReadOnly)) {	
        				modfile.readLine(buff,(unsigned int)250);
        				buff = buff.remove(buff.length() - 1,buff.length());
        				
        				//QString p = buff.left(buff.find(" ")) + " ";     				
    					item->setText( 1, buff);
    					if(sourceList.contains(buff) == 0){
    						sourceList.append(buff);
    						sourceNameMappings.append( buff + "=" + "/dev/" + ides[i]);
    					}
    					//p = buff.right(buff.length() - buff.find(" ") - 1) + " ";     				
    					//item->setText( 2, p);
    					
        				modfile.close();
    				}
    				
    				QFile drfile("/proc/ide/" + ides[i] + "/driver");
        			if(drfile.open(IO_ReadOnly)) {	
        				drfile.readLine(buff,(unsigned int)250);
        				buff = buff.left(buff.find(" "));				
    					item->setText( 2, buff);
        				drfile.close();
    				}
    				buff = "n/a";
    				item->setText( 3, buff);
    				//delete item;
  			}
        		medfile.close();
    		}
	}
}
//-----------------------------------------------------------------------------------------------------------
void DetectTbsPnl::scanScsi(){
	//targetsList = new QStringList();
	
	QString buff, scsiData = "";
	QListViewItem * item ;
	int drivePos = 0;
	
	QFile scsifile("/proc/scsi/scsi");	
	//QFile scsifile("/home/alexpod/scsi");	
	if(scsifile.open(IO_ReadOnly)) {
 		while(!scsifile.atEnd()){
        		scsifile.readLine(buff,(unsigned int)250);
        		//cerr << buff;
        		scsiData += buff;
   		}
   		scsifile.close();
	}
	else{
    		//cerr << "not found: " + scsifile.name();
    		return;
	}
	int num = scsiData.contains("Vendor:",TRUE);
	if( num > 0){
		int pos = 0;
		for(int i = 0; i < num; i++){
			
			buff = scsiData.mid(scsiData.find("Type", pos), 24);
    			if(buff.find("CD-ROM") == -1){
    				pos = scsiData.find("Type", pos)+4;
    				continue;
    			}
    				
			item = new QListViewItem( autoLst, 0);
        		item->setPixmap( 0, BarIcon("cdwriter_unmount", KIcon::SizeSmall ));

        		item->setText( 0, " /dev/scd"+ QString::number(drivePos) + " ");
			
        		buff = "n/a";
        		//buff = "scsi cd-rom";
			item->setText( 2, buff);
        		
        		//pos = scsiData.find("Channel:", pos)+9;
    			//buff =  scsiData.mid(pos, scsiData.find(" ",pos) - pos);
    			
    			pos = scsiData.find("scsi", pos) + 4;
    			buff =  scsiData.mid(pos, scsiData.find(" ",pos) - pos);
    			if(buff.toInt() < 10)
    				buff = "0" + buff;
    			
			pos = scsiData.find("Id:",pos)+4;
    			buff = buff + "," + scsiData.mid(pos, scsiData.find(" ",pos) - pos);
    			pos = scsiData.find("Lun:",pos)+5;
    			buff = buff + "," + scsiData.mid(pos, scsiData.find(" ",pos) - pos);
    			buff = buff.remove(buff.length() - 1,buff.length());
    				
    			buff.replace( QRegExp(" "), "" );
    			
    			
    			QString scsi = buff;
    			buff = "[" + buff + "]";
    			item->setText( 3, buff);
    			
    			pos = scsiData.find("Vendor:", pos)+8;
    			buff = scsiData.mid(pos, scsiData.find("Rev: ",pos) - pos);
    			buff.replace( QRegExp(" Model: "), "" );
    			buff = buff.simplifyWhiteSpace();

    			item->setText( 1, buff);
    			
    			if(scsiList.contains(scsi) == 0){
    				scsiList.append(scsi);
    				targetsList.append(buff);
    				targetsMappings.append(buff + "=" + scsi);
    				targetsNameMappings.append( buff + "=" + "/dev/scd" + QString::number(drivePos) );
    			}

    			if(sourceList.contains(buff) == 0){
    				sourceList.append(buff);
    				sourceNameMappings.append( buff + "=" + "/dev/scd" + QString::number(drivePos) );
    			}
    			drivePos++;
    			pos = scsiData.find("Type", pos)+4;
   		}
    	}
}
//---------------------------------------------------------------------------------------------------------
void DetectTbsPnl::retryScsiSlot(){
	scsiLst->clear();
	cdboProc = new KProcess();
	*cdboProc << "cdrecord" << "-scanbus";

	QApplication::connect(cdboProc, SIGNAL(processExited(KProcess *)),
      			this, SLOT(scanbusProcessDoneSlot(KProcess *)));
 	QApplication::connect(cdboProc, SIGNAL(receivedStdout (KProcess *, char *, int)),
		this, SLOT(receivedScanbusMessageSlot(KProcess *, char *, int)));
	QApplication::connect(cdboProc, SIGNAL(receivedStderr (KProcess *, char *, int)),
		this, SLOT(receivedScanbusMessageSlot(KProcess *, char *, int)));
		
	if(!cdboProc->start(KProcess::NotifyOnExit, KProcess::AllOutput)){
		//cerr << "failed to start scanbus" << endl;
		KMessageBox::error(this,
					"Failed to lunch 'scanbus'. Please make sure that\n" \
					"'cdrecord' is installed and you have enough privileges.");
	}
}
//---------------------------------------------------------------------------------------------
void DetectTbsPnl::receivedScanbusMessageSlot(KProcess *, char *buffer, int buflen){	
	if(buflen > 0){
		QString buff(buffer);
		buff = buff.left(buflen);
		int numOfBuses = buff.contains("scsibus");
		int drivePos = 0;
		if(numOfBuses == 0)
			return;
		else{
			buff = buff.right(buff.length()  - buff.find("scsibus", 0, false) - 11 );
			for(int i = 1; i < numOfBuses;i++)
				buff.replace( QRegExp("scsibus" + QString::number(i) + ":"), "" );
				
              	QStringList comOutput(QStringList::split("\n",buff));
              	for(int i = 0; i < (int)comOutput.count(); i++){
              		bool contains = false;
              		buff = comOutput[i].simplifyWhiteSpace();
              		if( buff == "" || buff.at(buff.length() - 1) == '*' || buff.find("CD-ROM") == -1) continue;
              				
              		
              		QListViewItem * item = new QListViewItem( scsiLst, 0);
              		item->setPixmap( 0, BarIcon("cdwriter_unmount", KIcon::SizeSmall ));
                 			
                 		QString scsiBuff = buff.left(buff.find(" ")).simplifyWhiteSpace();
                  		
                  		QString scsi;
                  		int iBuff = scsiBuff.left(scsiBuff.find(",")).toInt();
                       	if(iBuff < 10)
                        		scsi = "0" + QString::number(iBuff) + ",";
                        	else
                        		scsi = QString::number(iBuff) + ",";
                        	scsiBuff = scsiBuff.right(scsiBuff.length() - scsiBuff.find(",") - 1);
                        	iBuff = scsiBuff.left(scsiBuff.find(",")).toInt();
                        	if(iBuff < 10)
                       		scsi += "0" + QString::number(iBuff) + ",";
                      	else
                        		scsi += QString::number(iBuff) + ",";
                        	scsiBuff = scsiBuff.right(scsiBuff.length() - scsiBuff.find(",") - 1);
                        	iBuff = scsiBuff.toInt();
                        	if(iBuff < 10)
                        		scsi += "0" + QString::number(iBuff);
                        	else
                        		scsi += QString::number(iBuff);
                        	if(scsiList.contains(scsi) != 0){
                        	    contains = true;
                        	}	
                  	
                  		//item->setText( 0, " [" + buff.left(buff.find(" ")).simplifyWhiteSpace() + "] ");
                  		item->setText( 0, " [" + scsi+ "] ");
                  		buff = buff.right(buff.length() - buff.find("'")  - 1);
              		//cerr << buff << endl;
              		QString name =  buff.left(buff.find("'"));
              		item->setText( 1, buff.left(buff.find("'")));
              		
              		buff = buff.right(buff.length() - buff.find("'") - 3);
              		
              		name += " " + buff.left(buff.find("'"));
              		
              		item->setText( 2, buff.left(buff.find("'")));
              		buff = buff.right(buff.length() - buff.find("'") - 4);
              		buff = buff.right(buff.length() - buff.find(" "));
              		
              		item->setText( 3, buff.simplifyWhiteSpace());
              		
              		if(!contains){
              			
              			name = name.simplifyWhiteSpace();
              			sourceList.append(name);	
              			sourceNameMappings.append( name + "=" + "/dev/scd" + QString::number(drivePos) );
              			
	                 			//sourceNameMappings.append( name+ "=" + scsi);
              			scsiList.append(scsi);			
              			targetsMappings.append(name + "=" + scsi);
              			
              			targetsNameMappings.append( name + "=" + "/dev/scd" + QString::number(drivePos) );
              			//targetsNameMappings.append(name + "=" + scsi);
              			targetsList.append(name);
             			}
             			drivePos++;
			}
		}
	}
}
//---------------------------------------------------------------------------------------------
void DetectTbsPnl::scanbusProcessDoneSlot(KProcess *){
	if(!cdboProc)
		delete cdboProc;
	QListViewItem *item = scsiLst->firstChild();
	if(!item)
		return;
	scsiLst->setSelected(item,true);
	
	scsiDetaislBtn->setEnabled(true);
}
//---------------------------------------------------------------------------------------------
void DetectTbsPnl::autoSelectionChangedSlot(QListViewItem* item){
	if(!item)
		return;
	if(item->text(3).find("n/a") == -1)
		detailsBtn->setEnabled(true);
	else
		detailsBtn->setEnabled(false);
}
//---------------------------------------------------------------------------------------------------------
void DetectTbsPnl::browseCustomSlot(){
	KURL urlToOpen = KFileDialog::getOpenURL("/dev",
                0, this, "Choose Source Device");
	customPathTxt->setText(urlToOpen.path());
}
//---------------------------------------------------------------------------------------------------------
void DetectTbsPnl::addCustomSlot(){
	if((!customPathTxt->text() || customPathTxt->text() == ""))
		return;
		
	QString device = customPathTxt->text();
	
	QString scsi;
	if(customScsiChk->isChecked()){
		int iBuff = customScsiSpn->value();
		if(iBuff < 10)
			scsi = "0" + QString::number(iBuff) + ",";
		else
			scsi = QString::number(iBuff) + ",";
		
		iBuff = customTargetSpn->value();
		if(iBuff < 10)
			scsi += "0" + QString::number(iBuff) + ",";
		else
			scsi += QString::number(iBuff) + ",";
		
		iBuff = customLunSpn->value();
		if(iBuff < 10)
			scsi += "0" + QString::number(iBuff);
		else
			scsi += QString::number(iBuff);
			
		if(scsiList.contains(scsi) > 0){
			     KMessageBox::error(this,
             			"Device with same scsi settings already configured!");
				return;
		}	
	}
	else
		scsi =  "n/a";
		
	QString name = descriptionTxt->text();
	if(!name || name == ""){
		while(true){
			unknown++;
			name = "Custom" + QString::number(unknown);	
			if(customList.contains(name) == 0)
				break;
		}
	}
	else{
		if(customList.contains(name) > 0){
			     KMessageBox::error(this,
             			"Custom device with same name is already on the list!");
				return;
		}
	
	}
	
	QListViewItem * item = new QListViewItem( customLst, 0);
	item->setPixmap( 0, BarIcon("exec", KIcon::SizeSmall ));
     item->setText( 0, device);
	item->setText( 2, name);

     customList.append(name);	
     sourceList.append(name);	
     sourceNameMappings.append( name + "=" + device);

     if(scsi != "n/a"){
     		scsiList.append(scsi);			
		targetsMappings.append(device + "=" + scsi);
		targetsNameMappings.append(name + "=" + device);
		targetsList.append(name);
		item->setText( 1, "[" + scsi + "]");
	}
	else{
		item->setText( 1, scsi);
	}
	
	QString buff = (scsi + "|" + device);
	
	customMappings.append(buff);
	
	customPathTxt->clear();
	descriptionTxt->clear();
	customScsiSpn->setValue(0);
	customTargetSpn->setValue(0);
	customLunSpn->setValue(0);
	removeCustomBtn->setEnabled(false);
	modifyCustomBtn->setEnabled(false);
}
//---------------------------------------------------------------------------------------------------------
void DetectTbsPnl::removeCustomSlot(){
	QListViewItem * item = customLst->selectedItem();
	
	QString device = item->text(0);
	QString scsi = item->text(1);
	
	QString name = item->text(2);
	customList.remove(name);
     sourceList.remove(name);
     sourceNameMappings.remove(name + "=" + device);

	if(scsi != "n/a"){
		scsi = scsi.mid(1, scsi.length() - 2);
		scsiList.remove(scsi);	
		targetsMappings.remove(device + "=" + scsi);
		targetsNameMappings.remove(name + "=" + device);
		targetsList.remove(name);
	}
	QString buff = scsi + "|" + device;
	customMappings.remove(buff);
		
	customLst->takeItem(item);
	
	/*customPathTxt->clear();
	descriptionTxt->clear();
	customScsiSpn->setValue(0);
	customTargetSpn->setValue(0);
	customLunSpn->setValue(0);*/
	
	removeCustomBtn->setEnabled(false);
	modifyCustomBtn->setEnabled(false);
}
//---------------------------------------------------------------------------------------------------------
void DetectTbsPnl::modifyCustomSlot(){
	removeCustomSlot();
	addCustomSlot();
}
//---------------------------------------------------------------------------------------------------------
void DetectTbsPnl::customLstSlot(QListViewItem * item){
	if(!item) return;
	customPathTxt->setText(item->text(0));
	QString buff = item->text(1);
	
	if(buff != "n/a"){
		customScsiChk->setChecked(true);
		enableCustScsi(true);
		buff = buff.mid(1,buff.length() - 2);
		QStringList list(QStringList::split(",",buff));
		
		customScsiSpn->setValue(list[0].toInt());
		customTargetSpn->setValue(list[1].toInt());
		customLunSpn->setValue(list[2].toInt());
	}
	else{
		customScsiChk->setChecked(false);
	}
	
	descriptionTxt->setText(item ->text( 2));
	
	removeCustomBtn->setEnabled(true);
	modifyCustomBtn->setEnabled(true);
}
//---------------------------------------------------------------------------------------------------------
void DetectTbsPnl::customScsiSlot(){
	enableCustScsi(customScsiChk->isChecked());
}
//---------------------------------------------------------------------------------------------------------
void DetectTbsPnl::enableCustScsi(bool yes){
	customScsiLbl->setEnabled(yes);
	customScsiSpn->setEnabled(yes);
	customTargetLbl->setEnabled(yes);
	customTargetSpn->setEnabled(yes);
	customLunLbl->setEnabled(yes);
	customLunSpn->setEnabled(yes);
}
//===================================================
void DetectTbsPnl::scsiDetailesSlot(){
	QListViewItem *item = scsiLst->selectedItem();
	if ( !item )
		return;
	else{
		QString dev = item->text(0).stripWhiteSpace();
		dev = dev.right(dev.length() - 1);
		dev = dev.replace( QRegExp("]"), "" );
		
		cod = new CommandOutputDialog(this, "cod");
		cod->setCaption( item->text(1) + " " +  item->text(2) + " - detailed info");
		getScsiDetailes(dev);
	}
}
//===================================================
void DetectTbsPnl::autoScsiDetailesSlot(){
	QListViewItem *item = autoLst->currentItem();
	if ( !item )
		return;
	else if(item->text(3).find("n/a") != -1)	
		return;
	else{
		QString dev = item->text(3).stripWhiteSpace();
		dev = dev.right(dev.length() - 1);
		dev = dev.replace( QRegExp("]"), "" );
		
		cod = new CommandOutputDialog(this, "cod");
		cod->setCaption( item->text(1) + " - detailed info");
		getScsiDetailes(dev);
	}
}
//===================================================
void DetectTbsPnl::getScsiDetailes(QString &dev){
		
	cdboProc = new KProcess();
	*cdboProc << "cdrecord" << "-prcap" << "dev=" + dev;
	//cerr << "\n\ncdrecord" << " -prcap" << " dev=" + dev << "\n\n";
	QApplication::connect(cdboProc, SIGNAL(processExited(KProcess *)),
      			this, SLOT(scsiDetailesDoneSlot(KProcess *)));
 	QApplication::connect(cdboProc, SIGNAL(receivedStdout (KProcess *, char *, int)),
		this, SLOT(receivedScsiDetailesMessageSlot(KProcess *, char *, int)));
	QApplication::connect(cdboProc, SIGNAL(receivedStderr (KProcess *, char *, int)),
		this, SLOT(receivedScsiDetailesMessageSlot(KProcess *, char *, int)));
		
	if(!cdboProc->start(KProcess::NotifyOnExit, KProcess::AllOutput)){
		//cerr << "failed to start scanbus" << endl;
		KMessageBox::error(this,
					"Failed to get datailed info on '" + dev + "'\n" \
					"Please make sure you have enough privileges.");
	}
	else
		cod->exec();
}
//---------------------------------------------------------------------------------------------
void DetectTbsPnl::receivedScsiDetailesMessageSlot(KProcess *, char *buffer, int buflen){	
	if(buflen > 0){
		QString buff(buffer);
		buff = buff.left(buflen);
		//cerr << buff;
		cod->append(buff);
	}	
		
}
//---------------------------------------------------------------------------------------------
void DetectTbsPnl::scsiDetailesDoneSlot(KProcess *){
	if(!cdboProc)
		delete cdboProc;
}