/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Fri May 18 23:05:50 EDT 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kuniqueapp.h>

#include "cdbakeoven.h"

static const char *description =
	I18N_NOOP("Thanks for using CD Bake Oven - CD Burning, Baking, Cooking, etc. fasility for KDE :)");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[]){

	KAboutData aboutData( "cdbakeoven", I18N_NOOP("CD Bake Oven"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2001, Alexy Podolsky",
		"\nPlease note that this progam cares NO warranty! Use at your own risk!",
		"http://cdbakeoven.sourceforge.net");
	aboutData.addAuthor("Alexy Podolsky",
		"Had some fun with this thing, hope you do too.",
		"alexpod@users.sourceforge.net");
	//aboutData.addAuthor("Michael Kropfberger",
		//"Block Devices view (kdf part).",
		//"michael.kropfberger@gmx.net");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
  KUniqueApplication::addCmdLineOptions();

	if (!KUniqueApplication::start()) {	
       cerr << "cdbakeoven is already running!\n";
      return 0;
	}


  KUniqueApplication app;
 
  if (app.isRestored()){
    RESTORE(CDBakeOvenApp);
  }
  else{
    	CDBakeOvenApp *cdbakeoven = new CDBakeOvenApp();
    	cdbakeoven->show();

    	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		
		if (args->count()){
        		cdbakeoven->openDocumentFile(args->arg(0));
		}
		else{
			cdbakeoven->tryToShowMainDialog();
		}
		args->clear();
  	}

  	return app.exec();
}  
