/***************************************************************************
                          AdvancedCompilationTreeView.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef ADVANCEDCDCOMPILATIONVIEW_H
#define ADVANCEDCDCOMPILATIONVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qwidget.h>
#include <qsplitter.h>
#include "../EstimatePnl.h"
#include "FakeFoldersListView.h"

// forward declaration of the NewCdCompilationView classes
class KConfig;

class FakeFilesListView;
class CDBakeOvenApp;

class AdvancedCompilationTreeView : public QSplitter{
  Q_OBJECT
public:
    /** Constructor for the main view */
    AdvancedCompilationTreeView(CDBakeOvenApp * cdboApp, QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~AdvancedCompilationTreeView();

	void saveOptions();
	inline CDBakeOvenApp* getCdboApp() {return cdboApp;}
	inline FakeFoldersListView* getView() { return foldersView;}
	inline void setEstimate(EstimatePnl *estimate) { foldersView->setEstimate(estimate); }
	
public slots:
	void popUpSettings(int type);
	void createISO();
	void createCD();
	
	void doSave(QString fileToOpen);
	bool saveAs();
	bool save();
	bool saveAndRemove();
	void saveRemoveAndLoad(QString fileToOpen);
	
	void emitGotCaption();
	void removeAll();
	void contentsModified();
	
	bool loadSession();
signals:
	void gotCaption(const QString &, bool);
	
private:
  	void initView();
  	bool isEmpty();
  	
  	//members
  	CDBakeOvenApp *cdboApp;
  	KConfig *config;
  	
  	FakeFoldersListView *foldersView;
  	FakeFilesListView *filesView;	
	bool saved;
	QString listFileName;
};

#endif // ADVANCEDCDCOMPILATIONVIEW_H