/***************************************************************************
                          AudioPicker.cpp  -  description
                             -------------------
    begin                : Sun Nov 11 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// #include <iostream.h>

#include <qobject.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qapplication.h>
#include <qtimer.h>
#include <qfileinfo.h>

#include <kconfig.h>
#include <kapp.h>
#include <kmimemagic.h>

#include "AudioPicker.h"

using namespace KIO;

///=========================================================
AudioPicker::AudioPicker(const KURL &url)
    : KIO::Job(false), m_bAsync(true)
{
    	pathToProcess = url.path();	
	if(pathToProcess[pathToProcess.length()-1] != '/')
		pathToProcess = pathToProcess + "/";
	
	KConfig *config = kapp->config();
	config->setGroup("Audio Read Options");
	cdboDtct = config->readBoolEntry("CDBO Audio Files Detection", true);
    	if(cdboDtct)
    		extList = QStringList::split(QRegExp(" "),
			config->readEntry("Supported Audio Extensions",
				".mp3 .aiff .au .wav .ogg .raw .cdr .sun"));
				
    	startNextJob(url);
}
///=========================================================
void AudioPicker::processList()
{
   /* while (!m_lstItems.isEmpty())
    {
        KFileItem * item = m_lstItems.first();
        m_lstItems.removeFirst();
        if ( item->isDir() && !item->isLink() )
        {
            kdDebug(kfile_area) << "KDirSize::processList dir -> listing" << endl;
            KURL url = item->url();
            startNextJob( url );
            return; // we'll come back later, when this one's finished
        }
        else
        {
            m_totalSize += (unsigned long)item->size();
// no long long with kdDebug()
//            kdDebug(kfile_area) << "KDirSize::processList file -> " << m_totalSize << endl;
        }
    }
    kdDebug(kfile_area) << "KDirSize::processList finished" << endl;
    if ( !m_bAsync )
        qApp->exit_loop();
    emitResult();*/
}

///=========================================================
void AudioPicker::startNextJob( const KURL &path){

	KIO::ListJob * listJob = KIO::listRecursive( path, false);
    	connect( listJob, SIGNAL(entries( KIO::Job *,
                                      const KIO::UDSEntryList& )),
             		SLOT( slotEntries( KIO::Job*,
                                const KIO::UDSEntryList& )));
        connect(listJob, SIGNAL(result ( KIO::Job *)),
			this, SLOT(slotResult(KIO::Job *) ));
			
    	addSubjob( listJob );
}
///=========================================================
void AudioPicker::slotEntries( KIO::Job*, const KIO::UDSEntryList & list ){
	KIO::UDSEntryListConstIterator it = list.begin();
	KIO::UDSEntryListConstIterator end = list.end();
	KMimeMagic* mime = KMimeMagic::self();
	QString mType = "";
	bool checked = false;
	QString name;
		
	for (; it != end; ++it) {
		KIO::UDSEntry::ConstIterator it2 = (*it).begin();
		for( ; it2 != (*it).end(); it2++ ) {
			switch( (*it2).m_uds ) {
            			case KIO::UDS_NAME:{
              			name = pathToProcess + (*it2).m_str;
             				if(cdboDtct){
             					for(int i =0; i < (int)extList.count(); i++){
							if(name.find(extList[i].stripWhiteSpace(), -extList[i].length(), false) != -1){
								//cerr << "\nApproved as  audio : " << name;
								emit gotAudioFile(name);
								break;
							}
						}
	  				}
             				else{
             					mType = mime->findFileType(name)->mimeType();
             					//KMimeType::Ptr mimetype = KMimeType::findByURL(KURL(name));
						//mType = mimetype->name().latin1();
						//cerr << "\nfname : " << name;
						//cerr << "\nwith type = " << mType << "\n";
										
						if(mType.find("audio") != -1 && mType.lower().find("unknown") == -1){
							//cerr << "\nApproved as  audio : " << name;
							//cerr << "\nwith type = " << mType << "\n";
							emit gotAudioFile(name);
						}
					}
					checked = true;
              			break;
              		}
				default:
					break;
			}
			if(checked)
				break;
		}
        }
}
///=========================================================
//static
AudioPicker * AudioPicker::audioPickerJob(const KURL &url){
    return new AudioPicker(url); // useless - but consistent with other jobs
}

///=========================================================
void AudioPicker::slotResult( KIO::Job * job ){
    //cerr<< " job done" << endl;
    //cerr << "subjobs.count() = " << subjobs.count() << endl;

    	if(subjobs.count() > 0)
    		subjobs.remove(job);
	
	
    	if(subjobs.count() == 0){
    		//cerr << "calling emit result in slotResult()\n";
    		emit result(this);
    	}
}

//#include "AudioPicker.moc"