/***************************************************************************
                          DataCompilationTreeView.h  -  description
                             -------------------
    begin                : Mon Nov 19 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef DATACOMPILATIONLISTVIEW_H
#define DATACOMPILATIONLISTVIEW_H

#include <qwidget.h>
#include <qlistview.h>
#include <qevent.h>
#include <qdict.h>

#include <kio/job.h>
#include <klistview.h>


#include "CompilationTreeView.h"

class QPopupMenu;
class QListViewItem;
class EstimatePnl;
class KConfig;
//class QIntDict;
class FolderItem;

class DataCompilationTreeView : public CompilationTreeView  {
   Q_OBJECT
public:
	DataCompilationTreeView( QWidget *parent=0L, const char *name=0L);
	~DataCompilationTreeView();
	
	void setEstimate(EstimatePnl *e);


public slots:	
	virtual bool addItem(QString);
	virtual void updateSettings();
	virtual void slotReload();
	virtual void compilSettingsSlot();
	
	void collapse();
	void recalculate();
	void longProcessCanceled(QString);
	void createISO();
	void createCD();		
	
signals:
	void processStarted();
	void longProcessStarted(KIO::Job *);
	void processDone();
	void longProcessDone(KIO::Job *);
	void haveStatus(const QString &);
			
protected slots:
	void slotSelectItem(QListViewItem *);
	void slotShowHidden();
	void gotSize(KIO::Job *);
	void popupMenuSlot(QListViewItem*, const QPoint&, int);

protected:	
	virtual inline QString getType() { return "New Data CD"; }
	virtual void resetTotal();
	virtual void subtractFromTotal(int);
	//virtual QDragObject *dragObject() const;
	
private:
	
	bool canAccept(QString path);
	void addFileItem(QString path, int size);

	

	EstimatePnl *estimate;
	KConfig *config;
	QDict <FolderItem>map;

	
	QPopupMenu *folderMenu;
	QPopupMenu *fileMenu;
	QPopupMenu *isoMenu;

	int hiddenIndex;
	int hiddenFIndex;
	int createIsoIndex;
	int createIsoIndexInFileMenu;
	int createIsoIndexInFolderMenu;
	bool showHidden;
	int haveItemsIndex;
	int createCDIndex;
	int createISOIndex;

};
#endif