/***************************************************************************
                          FilesListView.h  -  description
                             -------------------
    begin                : Sat Jul 14 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef FILESLISTVIEW_H
#define FILESLISTVIEW_H

#include <qwidget.h>

#include <klistview.h>

#include "../SrcListCntPanel.h"

class QPopupMenu;
class KConfig;
class FolderItem;

class FilesListView : public KListView  {
   Q_OBJECT
public:
	FilesListView( QWidget *parent=0L, const char *name=0L, QString dir = "/" );
	~FilesListView();
	inline QString getSelectedFilePath(){ return dirPath + "/" + selectedItem()->text(0);	}
	inline void setControlPanel(SrcListCntPanel * c){ cnt = c;}
	
public slots:	
	void loadDir(FolderItem *);

protected slots:
	virtual QDragObject *dragObject() const;
	
	void slotAddToCompilation();
	void openWithSlot();
	void filePropertiesSlot();
	void reloadListSlot();
	void checkShowHidden();
	void popupMenuSlot(QListViewItem*, const QPoint&, int);
	void slotShowFolders();
	void slotShowHidden();
	virtual void keyPressEvent(QKeyEvent *e);
	void slotSelectFile(QListViewItem *);
	
signals:
	void addToCompilation( QString );
	void folderClicked(QListViewItem *);
	
	void processStarted();
	void processDone();
	void haveStatus(const QString &);

private:
	QString dirPath;
	QPopupMenu *popupMenu;
	bool showHidden;
	int showHiddenIndex;
	bool showFolders;
	int showFoldersIndex;
	
	 FolderItem *parent;
	
	int addIndex;
	int prevIndex;
	int propIndex;
	QString nameFilter;
	SrcListCntPanel *cnt;
	KConfig* config;

};
#endif
