#ifndef __CDW_CDIO_H
#define __CDW_CDIO_H

#include <cdio/cdio.h>
#include "main.h"

enum cdw_track_format {
	CDW_RED_BOOK_AUDIO,             /* all 2352 bytes are useful data */
	CDW_YELLOW_BOOK_MODE1,          /* sync + header + 2048 bytes of useful data + some error magic */
	CDW_YELLOW_BOOK_MODE2,          /* sync + header + subheader + 2336 bytes of useful data + some error magic; aka "Green Book Mode2 Formless" */
	CDW_GREEN_BOOK_MODE2_FORM1,     /* sync + header + subheader + 2048 bytes of useful data + some error magic */
	CDW_GREEN_BOOK_MODE2_FORM2,     /* sync + header + subheader + 2324 bytes of useful data + some error magic */
	CDW_MIXED,                      /* I'm puzzled, but ioctl() returns CDS_MIXED, which means data + audio */
	CDW_DVD,			/* DVD disc- all DVD discs have the same size of useful data in sector (2048) */
	CDW_BLACK_BOOK_UNKNOWN          /* unrecognized disc type */
};

typedef enum cdw_track_format cdw_track_format_t;


struct cdw_track {
	track_format_t format; /* AUDIO, DATA, XA, CDI, PSX, ERROR - this is track format provided by libcdio */
	cdw_track_format_t cdw_format; /* this is track format defined in cdw, set by cdw code - it has more direct relation to size of useful data in sector */
	lsn_t first_sector;
	lsn_t last_sector;
	int sector_size;   /* size of sectors in given track */
};


struct disc_information {
	CdIo_t *p_cdio;       /* libcdio data structure */
	discmode_t mode;      /* disc mode as defined in cdio/disc.h */
	int mode2;

	bool open;            /* is the dics opened already */

	lsn_t total_sectors;  /* total amount of sectors of all kinds */

	track_t first_track;  /* first track on disc, probably equals to 1 */
	track_t last_track;   /* last track on disc */
	track_t total_tracks; /* total amount of tracks of all kinds */

	struct cdw_track tracks[100]; /* CD dics has no more than 99 tracks */
};



typedef driver_return_code_t (*sector_reader_fun)(const CdIo_t *p_cdio, void *p_buf, lsn_t i_lsn, bool b_form2, uint32_t i_blocks);


struct disc_information *cdw_cdio_disc_open(char *device);
void cdw_cdio_disc_close(void);

int cdw_cdio_sector_size(void);

long int cdw_cdio_get_total_disc_sectors(void);
void cdw_deal_cdio_driver_error(int error_num);
bool cdw_cdio_read_write_tracks_from_disc(struct disc_information *disc, int output_image_file);
cdw_rv_t cdw_cdio_read_write_sectors_from_track(struct disc_information *disc, track_t track, int imagefile);

#endif /* CDW_CDIO_H */

