#include <stdio.h>
#include <ncurses.h>
#include <menu.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <libintl.h>
#include <locale.h>
#include <nl_types.h>
#include <time.h>
#include "config.h"
#include "../src/options.h"

#ifdef HAVE_LIBMYSQLCLIENT
#include <mysql/mysql.h>

MYSQL mysql;
MYSQL_RES *result;
MYSQL_ROW row;

#endif

#ifdef HAVE_LIBSQLITE
#include <sqlite.h>
typedef struct SQLITE_RST {
    char **result;
    int nrow;
    int ncol;
} SQLITE_RES;

sqlite *sqlite_db;
int rc;
char *errmsg = 0;
SQLITE_RES *result;
#endif

int size, i;
char query[255];
struct conf config;

int none(struct dirent *unused)
{
    if (strcmp(unused->d_name,".") && strcmp(unused->d_name,"..")) {
	return 1;
    }
    else
	return 0;
}
char *cdbpass;

#ifdef HAVE_LIBMYSQLCLIENT
int scan_content(char *dir, MYSQL mysql, int cd_id, int dirlength)
#endif
#ifdef HAVE_LIBSQLITE
int scan_content(char *dir, sqlite *sqlite_db, int cd_id, int dirlength)
#endif
{
    struct dirent **eps;
    struct stat *finfo;
    int n, ok, cnt, type;
    char *dname, *ch, *date[25], insertdir[200];
    struct tm *filetime;
    time_t fitime;
    char query[500];

#ifdef HAVE_LIBMYSQLCLIENT
    MYSQL_RES *result;
#endif
    n = scandir(dir, &eps, (void *)none, alphasort);
    if (n>=0) {
	for (cnt=0; cnt<n; ++cnt){
    	    ch=(char *) malloc(strlen(eps[cnt]->d_name)+strlen(dir)+4);
	    sprintf(ch,"%s/%s",dir,eps[cnt]->d_name);
	    finfo=(struct stat *)malloc(sizeof(finfo)+100);
	    ok=lstat(ch,finfo);
	    type=S_ISLNK(finfo->st_mode);
	    if ( (eps[cnt]->d_type=DT_DIR) && (type==0) )
#ifdef HAVE_LIBMYSQLCLIENT
		scan_content(ch, mysql, cd_id, dirlength);
#endif
#ifdef HAVE_LIBSQLITE
		scan_content(ch, sqlite_db, cd_id, dirlength);
#endif
	    if (ok=stat(ch,finfo)!=0);
	    else {
		fitime=finfo->st_mtime;
		filetime=localtime(&fitime);
		strftime((char *)date, 25, "%Y-%m-%d", filetime);

		if (strlen(dir)!=dirlength){
		    strcpy((char *)insertdir, dir+dirlength+1);
		    sprintf(query, "INSERT INTO content (file, size, date, cd_id) VALUES (\"%s/%s\",'%d','%s', %d);", insertdir, eps[cnt]->d_name, finfo->st_size, date, cd_id);
		} else
		    sprintf(query, "INSERT INTO content (file, size, date, cd_id) VALUES (\"%s\",'%d','%s', %d);", eps[cnt]->d_name, finfo->st_size, date, cd_id);
#ifdef HAVE_LIBMYSQLCLIENT
		if (mysql_query(&mysql, query)) {
		    fprintf(stderr, "Failed: %s\n", mysql_error(&mysql));
		    return 1;
		}
#endif
#ifdef HAVE_LIBSQLITE
		rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
		if (rc!=SQLITE_OK){
		    fprintf(stderr, "%s\n", errmsg);
		}
#endif
	    }
	    free(finfo);
    	    free(ch);
	}
    }
    return size;
}

int connect_database()
{
	char message[200];
#ifdef HAVE_LIBMYSQLCLIENT
	mysql_init(&mysql);
	if (!mysql_real_connect(&mysql, config.cdbhost, config.cdbuser, cdbpass, "cdw", 0, NULL, 0)){
		sprintf(message, "%s", mysql_error(&mysql));
		//dialogbox("Error", message, 0);
		fprintf(stderr, "%s", message);
		return 1;
	}
#endif
#ifdef HAVE_LIBSQLITE
	sqlite_db=sqlite_open(config.sqlite_file, 0, &errmsg);
	if (!sqlite_db) {
	    fprintf(stderr, "%s\n", errmsg);
	    return 1;
	}
#endif
	return 0;
}

int add_content(char *dir, int cd_id)
{
    if (connect_database()==0){
#ifdef HAVE_LIBMYSQLCLIENT
	scan_content(dir, mysql, cd_id, strlen(dir));
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	scan_content(dir, sqlite_db, cd_id, strlen(dir));
	sqlite_close(sqlite_db);
#endif
    }
}

static int query_content_callback(void *notused, int argc, char **argv, char **colname)
{
    printf("%s. %s: %s\n", argv[0], argv[1], argv[2]);
    return 0;
}

int query_content(char *type, char *disk, char *dir)
{
    if (connect_database()==0){
	sprintf(query, "SELECT cd.number, cd.name, content.file, content.size, content.date, type.name FROM content LEFT JOIN cd ON content.cd_id=cd.cd_id left join type on cd.type=type.type_id WHERE content.cd_id>0");
	if (strcmp(dir, "*")!=0){
	    sprintf(query, "%s AND UPPER(content.file) LIKE UPPER(\"%s/%%\")", query, dir);
	}
	if (strcmp(disk,"*")!=0){
	    sprintf(query, "%s AND cd.name=\"%s\"", query, disk);
	}
	if (strcmp(type,"*")!=0){
	    sprintf(query, "%s AND type.name=\"%s\"", query, type);
	}
	sprintf(query, "%s ORDER BY cd.number, cd.name", query);
#ifdef HAVE_LIBMYSQLCLIENT
	if (mysql_query(&mysql, query)) {
		fprintf(stderr, "Failed: %s\n", mysql_error(&mysql));
		return 1;
	} else {
	    result=mysql_store_result(&mysql);
	    while (row=mysql_fetch_row(result)){
    		printf("%s. %s: %s\n", row[0], row[1], row[2]);
	    }
	}
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	rc=sqlite_exec(sqlite_db, query, query_content_callback, 0, &errmsg);
	if (rc!=SQLITE_OK){
	    fprintf(stderr, "%s\n", errmsg);
	}
	sqlite_close(sqlite_db);
#endif
    }
}

int search_content(char *file, char *type, char *disk, char *dir)
{
    int i;

    if (connect_database()==0){
	sprintf(query, "SELECT cd.number, cd.name, content.file, content.size, content.date, type.name FROM content LEFT JOIN cd ON content.cd_id=cd.cd_id left join type on cd.type=type.type_id WHERE content.cd_id>0");
#ifdef HAVE_LIBMYSQLCLIENT
	if (strcmp(dir, "*")!=0){
	    sprintf(query, "%s AND content.file REGEXP '%s'", query, dir);
	}
	if (strcmp(file, "*")!=0){
	    sprintf(query, "%s AND content.file REGEXP '%s'", query, file);
	}
	if (strcmp(disk,"*")!=0){
	    sprintf(query, "%s AND cd.name=\"%s\"", query, disk);
	}
	if (strcmp(type,"*")!=0){
	    sprintf(query, "%s AND type.name=\"%s\"", query, type);
	}
	sprintf(query, "%s ORDER BY cd.number, cd.name", query);
	if (mysql_query(&mysql, query)) {
		fprintf(stderr, "Failed: %s\n", mysql_error(&mysql));
		return 1;
	} else {
	    result=mysql_store_result(&mysql);
	    while (row=mysql_fetch_row(result)){
    		printf("%s. %s: %s\n", row[0], row[1], row[2]);
	    }
	}
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	if (strcmp(dir, "*")!=0){
	    sprintf(query, "%s AND content.file LIKE '%%%s%%'", query, dir);
	}
	if (strcmp(file, "*")!=0){
	    sprintf(query, "%s AND content.file LIKE '%%%s%%'", query, file);
	}
	if (strcmp(disk,"*")!=0){
	    sprintf(query, "%s AND cd.name=\"%s\"", query, disk);
	}
	if (strcmp(type,"*")!=0){
	    sprintf(query, "%s AND type.name=\"%s\"", query, type);
	}
	sprintf(query, "%s ORDER BY cd.number, cd.name", query);
	rc=sqlite_exec(sqlite_db, query, query_content_callback, 0, &errmsg);
	if (rc!=SQLITE_OK){
	    fprintf(stderr, "%s\n", errmsg);
	}
	sqlite_close(sqlite_db);
#endif
    }
}

int add_disk(char *cdname, int no, int type, char *date)
{
    if (connect_database()==0){
	sprintf(query, "INSERT INTO cd (name, number, type, date) VALUES (\"%s\",%d,%d, '%s');", cdname, no, type, date);
#ifdef HAVE_LIBMYSQLCLIENT
	if (mysql_query(&mysql, query)) {
		fprintf(stderr, "Failed: %s\n", mysql_error(&mysql));
		return 1;
	}
	i=mysql_insert_id(&mysql);
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
	i=sqlite_last_insert_rowid(sqlite_db);
	if (rc!=SQLITE_OK){
	    fprintf(stderr, "%s\n", errmsg);
	}
	sqlite_close(sqlite_db);
#endif
    }
    return i;
}

static int query_disk_callback(void *notused, int argc, char **argv, char **colname)
{
    printf("%s. %s\t[%s] (%s)\n", argv[2], argv[1], argv[3], argv[4]);
    return 0;
}

int query_disk(char *cdname, int no, char *type)
{
    if (connect_database()==0){
	sprintf(query, "SELECT cd.cd_id, cd.name, cd.number, type.name, cd.date FROM cd LEFT JOIN type ON cd.type=type.type_id WHERE cd.cd_id>0");
	if (strcmp(cdname, "*")!=0){
	    sprintf(query, "%s AND UPPER(cd.name) LIKE UPPER(\"%%%s%%\")", query, cdname);
	}
	if (no!=0){
	    sprintf(query, "%s AND cd.number=%d", query, no);
	}
	if (strcmp(type, "*")!=0){
	    sprintf(query, "%s AND type.name=\"%s\"", query, type);
	}
	sprintf(query, "%s ORDER BY cd.number, cd.name", query);
#ifdef HAVE_LIBMYSQLCLIENT
	if (mysql_query(&mysql, query)) {
		fprintf(stderr, "Failed: %s\n", mysql_error(&mysql));
		return 1;
	} else {
	    result=mysql_store_result(&mysql);
	    while (row=mysql_fetch_row(result)){
		fprintf(stdout, "%s. %s\t[%s] (%s)\n", row[2], row[1], row[3], row[4]);
	    }
	}
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	rc=sqlite_exec(sqlite_db, query, query_disk_callback, 0, &errmsg);
	if (rc!=SQLITE_OK){
	    fprintf(stderr, "%s\n", errmsg);
	}
	sqlite_close(sqlite_db);
#endif
    }
}

int add_type(char *type)
{
    if (connect_database()==0){
	sprintf(query, "INSERT INTO type (name) VALUES (\"%s\");", type);
#ifdef HAVE_LIBMYSQLCLIENT
	if (mysql_query(&mysql, query)) {
		fprintf(stderr, "Failed: %s\n", mysql_error(&mysql));
		return 1;
	}
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
	if (rc!=SQLITE_OK){
	    fprintf(stderr, "%s\n", errmsg);
	}
	sqlite_close(sqlite_db);
#endif
    }
}
/*
int query_type(char *type)
{
    if (connect_database()==0){
        sprintf(query, "SELECT type.type_id, type.name FROM type", type);
	if (strcmp(type, "*")!=0){
	    sprintf(query, "%s WHERE UPPER(type.name)=UPPER(\"%s\")", query, type);
	}
	sprintf(query, "%s ORDER BY type.type_id", query);
#ifdef HAVE_LIBMYSQLCLIENT
	if (mysql_query(&mysql, query)) {
		fprintf(stderr, "Failed: %s\n", mysql_error(&mysql));
		return 1;
	} else {
	    result=mysql_store_result(&mysql);
	}
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
	if (rc!=SQLITE_OK){
	    fprintf(stderr, "%s\n", errmsg);
	}
	sqlite_close(sqlite_db);
#endif
    }
}
*/
static int switch_type_callback(void *retval, int argc, char **argv, char **colname)
{
    int *i = (int *)retval;
    printf("argv: %s\n", argv[0]);
    *i=(argv[0] ? atoi(argv[0]) : 0);
    return 0;
}

int switch_type(char *type)
{
	int i;
	//SQLITE_RES *result;
	//char **result_set;
	//int nrow;
	//int ncol;

	if (connect_database()==0){
    	    sprintf(query, "SELECT type.type_id, type.name FROM type WHERE UPPER('%s')=UPPER(type.name) ORDER BY type.type_id", type);
#ifdef HAVE_LIBMYSQLCLIENT
	    if (mysql_query(&mysql, query)) {
		fprintf(stderr, "Failed: %s\n", mysql_error(&mysql));
		return 1;
	    } else {
		result=mysql_store_result(&mysql);
		if (mysql_num_rows(result)>0){
		    row=mysql_fetch_row(result);
		    i=atoi(row[0]);
		} else {
		    i=0;
		}
	    }
	    mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	//rc=sqlite_exec(sqlite_db, query, switch_type_callback, &i, &errmsg);
	result=(SQLITE_RES *)malloc(sizeof(SQLITE_RES));
	rc=sqlite_get_table(sqlite_db, query, &result->result, &result->nrow, &result->ncol, &errmsg);
	if (rc!=SQLITE_OK){
	    fprintf(stderr, "Failed: %s\n", errmsg);
	    return 1;
	}
	if (result->nrow>0) {
	    printf("Rows: %d\nCols: %d\nResult[4]: %s\n", result->nrow, result->ncol, result->result[2]);
	    i=atoi(result->result[2]);
	} else i=0;
	sqlite_free_table(result->result);
	free(result);
	sqlite_close(sqlite_db);
#endif
	}
	printf("Return value: %d\n", i);
	return i;
}

static int delete_disk_callback(void *notused, int argc, char **argv, char **colname)
{
    i=atoi(argv[0]);
    return i;
}

int delete_disk(char *cdname, int no, char *type)
{
	int *retval, type_no;

	type_no=switch_type(type);
	if (connect_database()==0){
	    sprintf(query, "SELECT cd.cd_id FROM cd WHERE UPPER(cd.name)=UPPER(\"%s\") AND cd.number=%d AND cd.type=%d", cdname, no, type_no);
#ifdef HAVE_LIBMYSQLCLIENT
	    if (mysql_query(&mysql, query)) {
		fprintf(stderr, "Failed_sel_disk: %s\n", mysql_error(&mysql));
		return 1;
	    } else {
		result=mysql_store_result(&mysql);
		row=mysql_fetch_row(result);
		retval=atoi(row[0]);
	    }
	    mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	    rc=sqlite_exec(sqlite_db, query, switch_type_callback, &retval, &errmsg);
	    if (rc!=SQLITE_OK){
		fprintf(stderr, "%s\n", errmsg);
	    }
	    sqlite_close(sqlite_db);
#endif
	}
	if (connect_database()==0){
	    sprintf(query, "DELETE FROM cd WHERE UPPER(cd.name)=UPPER(\"%s\") AND cd.number=%d AND cd.type=%d", cdname, no, type_no);
#ifdef HAVE_LIBMYSQLCLIENT
	    if (mysql_query(&mysql, query)) {
		fprintf(stderr, "Failed_del_disk: %s\n", mysql_error(&mysql));
		return 1;
	    }
	    mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	    rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
	    if (rc!=SQLITE_OK){
		fprintf(stderr, "%s\n", errmsg);
	    }
	    sqlite_close(sqlite_db);
#endif
	}
	return *retval;
}

int delete_content(int cd_id)
{
	if (connect_database()==0){
	    sprintf(query, "DELETE FROM content WHERE content.cd_id=%d", cd_id);
#ifdef HAVE_LIBMYSQLCLIENT
	    if (mysql_query(&mysql, query)) {
		fprintf(stderr, "Failed_del_content: %s\n", mysql_error(&mysql));
		return 1;
	    }
	    mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	    rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
	    if (rc!=SQLITE_OK){
		fprintf(stderr, "%s\n", errmsg);
	    }
	    sqlite_close(sqlite_db);
#endif
	}
}

// MUST REVIEW LATER
int delete_type(char *type)
{
    int type_no;
    int cds[1000], i=0, z;

    type_no=switch_type(type);
    if (connect_database()==0){
        sprintf(query, "DELETE FROM type WHERE type.type_id=%d", type_no);
#ifdef HAVE_LIBMYSQLCLIENT
        if (mysql_query(&mysql, query)) {
    	    fprintf(stderr, "Failed_del_content: %s\n", mysql_error(&mysql));
	    return 1;
	}
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
	if (rc!=SQLITE_OK){
	    fprintf(stderr, "%s\n", errmsg);
	}
	sqlite_close(sqlite_db);
#endif
    }
    if (connect_database()==0){
	sprintf(query, "SELECT cd.cd_id FROM cd WHERE cd.type=%d", type_no);
#ifdef HAVE_LIBMYSQLCLIENT
	if (mysql_query(&mysql, query)) {
	    fprintf(stderr, "Failed_sel_disk: %s\n", mysql_error(&mysql));
	    return 1;
	} else {
	    result=mysql_store_result(&mysql);
	    i=0;
	    while (row=mysql_fetch_row(result)){
		cds[i]=atoi(row[0]);
		i++;
	    }
	}
	mysql_close(&mysql);
#endif
    }
    if (connect_database()==0){
    	sprintf(query, "DELETE FROM cd WHERE cd.type=%d", type_no);
#ifdef HAVE_LIBMYSQLCLIENT
    	if (mysql_query(&mysql, query)) {
    	    fprintf(stderr, "Failed_del_content: %s\n", mysql_error(&mysql));
	    return 1;
	}
	mysql_close(&mysql);
#endif
    }
    for (z=0; z<i; z++){
	if (connect_database()==0){
    	    sprintf(query, "DELETE FROM content WHERE content.cd_id=%d", cds[z]);
#ifdef HAVE_LIBMYSQLCLIENT
    	    if (mysql_query(&mysql, query)) {
    		fprintf(stderr, "Failed_del_content: %s\n", mysql_error(&mysql));
		return 1;
	    }
	    mysql_close(&mysql);
#endif
	}
    }
}

main(int argc, int argv[]){
#ifdef HAVE_LIBMYSQLCLIENT
	MYSQL_ROW row;
	MYSQL_RES *result;
	MYSQL connection;
#endif
	int num;
	int i, ch;

#ifdef HAVE_LIBMYSQLCLIENT
	cdbpass=getpass(gettext("Enter password: "));
#endif
#ifdef HAVE_LIBSQLITE
	result=(SQLITE_RES *)malloc(sizeof(SQLITE_RES));
#endif
	read_conf();
	if ( argc>1 ) {
	    if (strcmp((char *)argv[1],"add")==0){
		int id;
		printf("Add disk...");
		if (switch_type((char *)argv[4])==0){
		    printf("Type added: %s\n", argv[4]);
		    add_type((char *)argv[4]);
		}
		id=add_disk((char *)argv[2], atoi(argv[3]), switch_type((char *)argv[4]), (char *)argv[5]);
		add_content(config.mountpoint, id);
		printf("done\n");
	    }
	    if (strcmp((char *)argv[1],"search")==0){
		search_content((char *)argv[2], "*", "*", "*");
	    }
	    if (strcmp((char *)argv[1],"show")==0){
		query_content("*", (char *)argv[2], "*");
	    }
	    if (strcmp((char *)argv[1],"delete")==0){
		int cd_id;
		cd_id=delete_disk((char *)argv[2], atoi(argv[3]), (char *)argv[4]);
		delete_content(cd_id);
	    }
	    if (strcmp((char *)argv[1],"list")==0){
		if (argc==2) {
		    query_disk("*", 0, "*");
		} else {
		    if (strcmp((char *)argv[2],"-c")==0){
			query_disk("*", 0, (char *)argv[3]);
		    }
		}
//		query_content("*", 0);
	    }
	} else {
	    printf("Usage: %s [options] command\n", argv[0]);
	    printf("  add     <name> <no> <category> <date>   - add a new disk to the catalog\n");
	    printf("  search  <string>                        - search files in the catalog\n");
	    printf("  show    <name>                          - show the contents of disk\n");
	    printf("  list    [-c <category>]                 - list disknames\n");
	}
}
