//
// OpCodes.cs
//
// Author:
//   Jb Evain (jbevain@gmail.com)
//
// Generated by /CodeGen/cecil-gen.rb do not edit
// Thu Oct 20 15:54:57 CEST 2005
//
// (C) 2005 Jb Evain
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

namespace Mono.Cecil.Cil {

	using System.Collections;

	public sealed class OpCodes {

		OpCodes()
		{
		}

		public static readonly OpCode Nop = new OpCode (
			"nop", 0xff, 0x00, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Break = new OpCode (
			"break", 0xff, 0x01, 1, FlowControl.Break,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Ldarg_0 = new OpCode (
			"ldarg.0", 0xff, 0x02, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldarg_1 = new OpCode (
			"ldarg.1", 0xff, 0x03, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldarg_2 = new OpCode (
			"ldarg.2", 0xff, 0x04, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldarg_3 = new OpCode (
			"ldarg.3", 0xff, 0x05, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldloc_0 = new OpCode (
			"ldloc.0", 0xff, 0x06, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldloc_1 = new OpCode (
			"ldloc.1", 0xff, 0x07, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldloc_2 = new OpCode (
			"ldloc.2", 0xff, 0x08, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldloc_3 = new OpCode (
			"ldloc.3", 0xff, 0x09, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Stloc_0 = new OpCode (
			"stloc.0", 0xff, 0x0a, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Stloc_1 = new OpCode (
			"stloc.1", 0xff, 0x0b, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Stloc_2 = new OpCode (
			"stloc.2", 0xff, 0x0c, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Stloc_3 = new OpCode (
			"stloc.3", 0xff, 0x0d, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Ldarg_S = new OpCode (
			"ldarg.s", 0xff, 0x0e, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.ShortInlineParam,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldarga_S = new OpCode (
			"ldarga.s", 0xff, 0x0f, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.ShortInlineParam,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Starg_S = new OpCode (
			"starg.s", 0xff, 0x10, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.ShortInlineParam,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Ldloc_S = new OpCode (
			"ldloc.s", 0xff, 0x11, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.ShortInlineVar,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldloca_S = new OpCode (
			"ldloca.s", 0xff, 0x12, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.ShortInlineVar,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Stloc_S = new OpCode (
			"stloc.s", 0xff, 0x13, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.ShortInlineVar,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Ldnull = new OpCode (
			"ldnull", 0xff, 0x14, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushref);

		public static readonly OpCode Ldc_I4_M1 = new OpCode (
			"ldc.i4.m1", 0xff, 0x15, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_0 = new OpCode (
			"ldc.i4.0", 0xff, 0x16, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_1 = new OpCode (
			"ldc.i4.1", 0xff, 0x17, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_2 = new OpCode (
			"ldc.i4.2", 0xff, 0x18, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_3 = new OpCode (
			"ldc.i4.3", 0xff, 0x19, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_4 = new OpCode (
			"ldc.i4.4", 0xff, 0x1a, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_5 = new OpCode (
			"ldc.i4.5", 0xff, 0x1b, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_6 = new OpCode (
			"ldc.i4.6", 0xff, 0x1c, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_7 = new OpCode (
			"ldc.i4.7", 0xff, 0x1d, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_8 = new OpCode (
			"ldc.i4.8", 0xff, 0x1e, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4_S = new OpCode (
			"ldc.i4.s", 0xff, 0x1f, 1, FlowControl.Next,
			OpCodeType.Macro, OperandType.ShortInlineI,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I4 = new OpCode (
			"ldc.i4", 0xff, 0x20, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineI,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldc_I8 = new OpCode (
			"ldc.i8", 0xff, 0x21, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineI8,
			StackBehaviour.Pop0, StackBehaviour.Pushi8);

		public static readonly OpCode Ldc_R4 = new OpCode (
			"ldc.r4", 0xff, 0x22, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.ShortInlineR,
			StackBehaviour.Pop0, StackBehaviour.Pushr4);

		public static readonly OpCode Ldc_R8 = new OpCode (
			"ldc.r8", 0xff, 0x23, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineR,
			StackBehaviour.Pop0, StackBehaviour.Pushr8);

		public static readonly OpCode Dup = new OpCode (
			"dup", 0xff, 0x25, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push1_push1);

		public static readonly OpCode Pop = new OpCode (
			"pop", 0xff, 0x26, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Jmp = new OpCode (
			"jmp", 0xff, 0x27, 1, FlowControl.Call,
			OpCodeType.Primitive, OperandType.InlineMethod,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Call = new OpCode (
			"call", 0xff, 0x28, 1, FlowControl.Call,
			OpCodeType.Primitive, OperandType.InlineMethod,
			StackBehaviour.Varpop, StackBehaviour.Varpush);

		public static readonly OpCode Calli = new OpCode (
			"calli", 0xff, 0x29, 1, FlowControl.Call,
			OpCodeType.Primitive, OperandType.InlineSig,
			StackBehaviour.Varpop, StackBehaviour.Varpush);

		public static readonly OpCode Ret = new OpCode (
			"ret", 0xff, 0x2a, 1, FlowControl.Return,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Varpop, StackBehaviour.Push0);

		public static readonly OpCode Br_S = new OpCode (
			"br.s", 0xff, 0x2b, 1, FlowControl.Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Brfalse_S = new OpCode (
			"brfalse.s", 0xff, 0x2c, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Popi, StackBehaviour.Push0);

		public static readonly OpCode Brtrue_S = new OpCode (
			"brtrue.s", 0xff, 0x2d, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Popi, StackBehaviour.Push0);

		public static readonly OpCode Beq_S = new OpCode (
			"beq.s", 0xff, 0x2e, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bge_S = new OpCode (
			"bge.s", 0xff, 0x2f, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bgt_S = new OpCode (
			"bgt.s", 0xff, 0x30, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Ble_S = new OpCode (
			"ble.s", 0xff, 0x31, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Blt_S = new OpCode (
			"blt.s", 0xff, 0x32, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bne_Un_S = new OpCode (
			"bne.un.s", 0xff, 0x33, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bge_Un_S = new OpCode (
			"bge.un.s", 0xff, 0x34, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bgt_Un_S = new OpCode (
			"bgt.un.s", 0xff, 0x35, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Ble_Un_S = new OpCode (
			"ble.un.s", 0xff, 0x36, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Blt_Un_S = new OpCode (
			"blt.un.s", 0xff, 0x37, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.ShortInlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Br = new OpCode (
			"br", 0xff, 0x38, 1, FlowControl.Branch,
			OpCodeType.Primitive, OperandType.InlineBrTarget,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Brfalse = new OpCode (
			"brfalse", 0xff, 0x39, 1, FlowControl.Cond_Branch,
			OpCodeType.Primitive, OperandType.InlineBrTarget,
			StackBehaviour.Popi, StackBehaviour.Push0);

		public static readonly OpCode Brtrue = new OpCode (
			"brtrue", 0xff, 0x3a, 1, FlowControl.Cond_Branch,
			OpCodeType.Primitive, OperandType.InlineBrTarget,
			StackBehaviour.Popi, StackBehaviour.Push0);

		public static readonly OpCode Beq = new OpCode (
			"beq", 0xff, 0x3b, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bge = new OpCode (
			"bge", 0xff, 0x3c, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bgt = new OpCode (
			"bgt", 0xff, 0x3d, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Ble = new OpCode (
			"ble", 0xff, 0x3e, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Blt = new OpCode (
			"blt", 0xff, 0x3f, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bne_Un = new OpCode (
			"bne.un", 0xff, 0x40, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bge_Un = new OpCode (
			"bge.un", 0xff, 0x41, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Bgt_Un = new OpCode (
			"bgt.un", 0xff, 0x42, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Ble_Un = new OpCode (
			"ble.un", 0xff, 0x43, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Blt_Un = new OpCode (
			"blt.un", 0xff, 0x44, 1, FlowControl.Cond_Branch,
			OpCodeType.Macro, OperandType.InlineBrTarget,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push0);

		public static readonly OpCode Switch = new OpCode (
			"switch", 0xff, 0x45, 1, FlowControl.Cond_Branch,
			OpCodeType.Primitive, OperandType.InlineSwitch,
			StackBehaviour.Popi, StackBehaviour.Push0);

		public static readonly OpCode Ldind_I1 = new OpCode (
			"ldind.i1", 0xff, 0x46, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldind_U1 = new OpCode (
			"ldind.u1", 0xff, 0x47, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldind_I2 = new OpCode (
			"ldind.i2", 0xff, 0x48, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldind_U2 = new OpCode (
			"ldind.u2", 0xff, 0x49, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldind_I4 = new OpCode (
			"ldind.i4", 0xff, 0x4a, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldind_U4 = new OpCode (
			"ldind.u4", 0xff, 0x4b, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldind_I8 = new OpCode (
			"ldind.i8", 0xff, 0x4c, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi8);

		public static readonly OpCode Ldind_I = new OpCode (
			"ldind.i", 0xff, 0x4d, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldind_R4 = new OpCode (
			"ldind.r4", 0xff, 0x4e, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushr4);

		public static readonly OpCode Ldind_R8 = new OpCode (
			"ldind.r8", 0xff, 0x4f, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushr8);

		public static readonly OpCode Ldind_Ref = new OpCode (
			"ldind.ref", 0xff, 0x50, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushref);

		public static readonly OpCode Stind_Ref = new OpCode (
			"stind.ref", 0xff, 0x51, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stind_I1 = new OpCode (
			"stind.i1", 0xff, 0x52, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stind_I2 = new OpCode (
			"stind.i2", 0xff, 0x53, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stind_I4 = new OpCode (
			"stind.i4", 0xff, 0x54, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stind_I8 = new OpCode (
			"stind.i8", 0xff, 0x55, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi8, StackBehaviour.Push0);

		public static readonly OpCode Stind_R4 = new OpCode (
			"stind.r4", 0xff, 0x56, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popr4, StackBehaviour.Push0);

		public static readonly OpCode Stind_R8 = new OpCode (
			"stind.r8", 0xff, 0x57, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popr8, StackBehaviour.Push0);

		public static readonly OpCode Add = new OpCode (
			"add", 0xff, 0x58, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Sub = new OpCode (
			"sub", 0xff, 0x59, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Mul = new OpCode (
			"mul", 0xff, 0x5a, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Div = new OpCode (
			"div", 0xff, 0x5b, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Div_Un = new OpCode (
			"div.un", 0xff, 0x5c, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Rem = new OpCode (
			"rem", 0xff, 0x5d, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Rem_Un = new OpCode (
			"rem.un", 0xff, 0x5e, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode And = new OpCode (
			"and", 0xff, 0x5f, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Or = new OpCode (
			"or", 0xff, 0x60, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Xor = new OpCode (
			"xor", 0xff, 0x61, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Shl = new OpCode (
			"shl", 0xff, 0x62, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Shr = new OpCode (
			"shr", 0xff, 0x63, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Shr_Un = new OpCode (
			"shr.un", 0xff, 0x64, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Neg = new OpCode (
			"neg", 0xff, 0x65, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push1);

		public static readonly OpCode Not = new OpCode (
			"not", 0xff, 0x66, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Push1);

		public static readonly OpCode Conv_I1 = new OpCode (
			"conv.i1", 0xff, 0x67, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_I2 = new OpCode (
			"conv.i2", 0xff, 0x68, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_I4 = new OpCode (
			"conv.i4", 0xff, 0x69, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_I8 = new OpCode (
			"conv.i8", 0xff, 0x6a, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi8);

		public static readonly OpCode Conv_R4 = new OpCode (
			"conv.r4", 0xff, 0x6b, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushr4);

		public static readonly OpCode Conv_R8 = new OpCode (
			"conv.r8", 0xff, 0x6c, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushr8);

		public static readonly OpCode Conv_U4 = new OpCode (
			"conv.u4", 0xff, 0x6d, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_U8 = new OpCode (
			"conv.u8", 0xff, 0x6e, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi8);

		public static readonly OpCode Callvirt = new OpCode (
			"callvirt", 0xff, 0x6f, 1, FlowControl.Call,
			OpCodeType.Objmodel, OperandType.InlineMethod,
			StackBehaviour.Varpop, StackBehaviour.Varpush);

		public static readonly OpCode Cpobj = new OpCode (
			"cpobj", 0xff, 0x70, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Ldobj = new OpCode (
			"ldobj", 0xff, 0x71, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popi, StackBehaviour.Push1);

		public static readonly OpCode Ldstr = new OpCode (
			"ldstr", 0xff, 0x72, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineString,
			StackBehaviour.Pop0, StackBehaviour.Pushref);

		public static readonly OpCode Newobj = new OpCode (
			"newobj", 0xff, 0x73, 1, FlowControl.Call,
			OpCodeType.Objmodel, OperandType.InlineMethod,
			StackBehaviour.Varpop, StackBehaviour.Pushref);

		public static readonly OpCode Castclass = new OpCode (
			"castclass", 0xff, 0x74, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popref, StackBehaviour.Pushref);

		public static readonly OpCode Isinst = new OpCode (
			"isinst", 0xff, 0x75, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popref, StackBehaviour.Pushi);

		public static readonly OpCode Conv_R_Un = new OpCode (
			"conv.r.un", 0xff, 0x76, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushr8);

		public static readonly OpCode Unbox = new OpCode (
			"unbox", 0xff, 0x79, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineType,
			StackBehaviour.Popref, StackBehaviour.Pushi);

		public static readonly OpCode Throw = new OpCode (
			"throw", 0xff, 0x7a, 1, FlowControl.Throw,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref, StackBehaviour.Push0);

		public static readonly OpCode Ldfld = new OpCode (
			"ldfld", 0xff, 0x7b, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineField,
			StackBehaviour.Popref, StackBehaviour.Push1);

		public static readonly OpCode Ldflda = new OpCode (
			"ldflda", 0xff, 0x7c, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineField,
			StackBehaviour.Popref, StackBehaviour.Pushi);

		public static readonly OpCode Stfld = new OpCode (
			"stfld", 0xff, 0x7d, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineField,
			StackBehaviour.Popref_pop1, StackBehaviour.Push0);

		public static readonly OpCode Ldsfld = new OpCode (
			"ldsfld", 0xff, 0x7e, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineField,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldsflda = new OpCode (
			"ldsflda", 0xff, 0x7f, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineField,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Stsfld = new OpCode (
			"stsfld", 0xff, 0x80, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineField,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Stobj = new OpCode (
			"stobj", 0xff, 0x81, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popi_pop1, StackBehaviour.Push0);

		public static readonly OpCode Conv_Ovf_I1_Un = new OpCode (
			"conv.ovf.i1.un", 0xff, 0x82, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_I2_Un = new OpCode (
			"conv.ovf.i2.un", 0xff, 0x83, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_I4_Un = new OpCode (
			"conv.ovf.i4.un", 0xff, 0x84, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_I8_Un = new OpCode (
			"conv.ovf.i8.un", 0xff, 0x85, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi8);

		public static readonly OpCode Conv_Ovf_U1_Un = new OpCode (
			"conv.ovf.u1.un", 0xff, 0x86, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U2_Un = new OpCode (
			"conv.ovf.u2.un", 0xff, 0x87, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U4_Un = new OpCode (
			"conv.ovf.u4.un", 0xff, 0x88, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U8_Un = new OpCode (
			"conv.ovf.u8.un", 0xff, 0x89, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi8);

		public static readonly OpCode Conv_Ovf_I_Un = new OpCode (
			"conv.ovf.i.un", 0xff, 0x8a, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U_Un = new OpCode (
			"conv.ovf.u.un", 0xff, 0x8b, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Box = new OpCode (
			"box", 0xff, 0x8c, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineType,
			StackBehaviour.Pop1, StackBehaviour.Pushref);

		public static readonly OpCode Newarr = new OpCode (
			"newarr", 0xff, 0x8d, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popi, StackBehaviour.Pushref);

		public static readonly OpCode Ldlen = new OpCode (
			"ldlen", 0xff, 0x8e, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref, StackBehaviour.Pushi);

		public static readonly OpCode Ldelema = new OpCode (
			"ldelema", 0xff, 0x8f, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_I1 = new OpCode (
			"ldelem.i1", 0xff, 0x90, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_U1 = new OpCode (
			"ldelem.u1", 0xff, 0x91, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_I2 = new OpCode (
			"ldelem.i2", 0xff, 0x92, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_U2 = new OpCode (
			"ldelem.u2", 0xff, 0x93, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_I4 = new OpCode (
			"ldelem.i4", 0xff, 0x94, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_U4 = new OpCode (
			"ldelem.u4", 0xff, 0x95, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_I8 = new OpCode (
			"ldelem.i8", 0xff, 0x96, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi8);

		public static readonly OpCode Ldelem_I = new OpCode (
			"ldelem.i", 0xff, 0x97, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushi);

		public static readonly OpCode Ldelem_R4 = new OpCode (
			"ldelem.r4", 0xff, 0x98, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushr4);

		public static readonly OpCode Ldelem_R8 = new OpCode (
			"ldelem.r8", 0xff, 0x99, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushr8);

		public static readonly OpCode Ldelem_Ref = new OpCode (
			"ldelem.ref", 0xff, 0x9a, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi, StackBehaviour.Pushref);

		public static readonly OpCode Stelem_I = new OpCode (
			"stelem.i", 0xff, 0x9b, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stelem_I1 = new OpCode (
			"stelem.i1", 0xff, 0x9c, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stelem_I2 = new OpCode (
			"stelem.i2", 0xff, 0x9d, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stelem_I4 = new OpCode (
			"stelem.i4", 0xff, 0x9e, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Stelem_I8 = new OpCode (
			"stelem.i8", 0xff, 0x9f, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popi8, StackBehaviour.Push0);

		public static readonly OpCode Stelem_R4 = new OpCode (
			"stelem.r4", 0xff, 0xa0, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popr4, StackBehaviour.Push0);

		public static readonly OpCode Stelem_R8 = new OpCode (
			"stelem.r8", 0xff, 0xa1, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popr8, StackBehaviour.Push0);

		public static readonly OpCode Stelem_Ref = new OpCode (
			"stelem.ref", 0xff, 0xa2, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Popref_popi_popref, StackBehaviour.Push0);

		public static readonly OpCode Ldelem_Any = new OpCode (
			"ldelem.any", 0xff, 0xa3, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popi, StackBehaviour.Push1);

		public static readonly OpCode Stelem_Any = new OpCode (
			"stelem.any", 0xff, 0xa4, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popref_popi_popref, StackBehaviour.Push0);

		public static readonly OpCode Unbox_Any = new OpCode (
			"unbox.any", 0xff, 0xa5, 1, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popref, StackBehaviour.Push1);

		public static readonly OpCode Conv_Ovf_I1 = new OpCode (
			"conv.ovf.i1", 0xff, 0xb3, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U1 = new OpCode (
			"conv.ovf.u1", 0xff, 0xb4, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_I2 = new OpCode (
			"conv.ovf.i2", 0xff, 0xb5, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U2 = new OpCode (
			"conv.ovf.u2", 0xff, 0xb6, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_I4 = new OpCode (
			"conv.ovf.i4", 0xff, 0xb7, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U4 = new OpCode (
			"conv.ovf.u4", 0xff, 0xb8, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_I8 = new OpCode (
			"conv.ovf.i8", 0xff, 0xb9, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi8);

		public static readonly OpCode Conv_Ovf_U8 = new OpCode (
			"conv.ovf.u8", 0xff, 0xba, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi8);

		public static readonly OpCode Refanyval = new OpCode (
			"refanyval", 0xff, 0xc2, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineType,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Ckfinite = new OpCode (
			"ckfinite", 0xff, 0xc3, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushr8);

		public static readonly OpCode Mkrefany = new OpCode (
			"mkrefany", 0xff, 0xc6, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineType,
			StackBehaviour.Popi, StackBehaviour.Push1);

		public static readonly OpCode Ldtoken = new OpCode (
			"ldtoken", 0xff, 0xd0, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineTok,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Conv_U2 = new OpCode (
			"conv.u2", 0xff, 0xd1, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_U1 = new OpCode (
			"conv.u1", 0xff, 0xd2, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_I = new OpCode (
			"conv.i", 0xff, 0xd3, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_I = new OpCode (
			"conv.ovf.i", 0xff, 0xd4, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Conv_Ovf_U = new OpCode (
			"conv.ovf.u", 0xff, 0xd5, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Add_Ovf = new OpCode (
			"add.ovf", 0xff, 0xd6, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Add_Ovf_Un = new OpCode (
			"add.ovf.un", 0xff, 0xd7, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Mul_Ovf = new OpCode (
			"mul.ovf", 0xff, 0xd8, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Mul_Ovf_Un = new OpCode (
			"mul.ovf.un", 0xff, 0xd9, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Sub_Ovf = new OpCode (
			"sub.ovf", 0xff, 0xda, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Sub_Ovf_Un = new OpCode (
			"sub.ovf.un", 0xff, 0xdb, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Push1);

		public static readonly OpCode Endfinally = new OpCode (
			"endfinally", 0xff, 0xdc, 1, FlowControl.Return,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Leave = new OpCode (
			"leave", 0xff, 0xdd, 1, FlowControl.Branch,
			OpCodeType.Primitive, OperandType.InlineBrTarget,
			StackBehaviour.PopAll, StackBehaviour.Push0);

		public static readonly OpCode Leave_S = new OpCode (
			"leave.s", 0xff, 0xde, 1, FlowControl.Branch,
			OpCodeType.Primitive, OperandType.ShortInlineBrTarget,
			StackBehaviour.PopAll, StackBehaviour.Push0);

		public static readonly OpCode Stind_I = new OpCode (
			"stind.i", 0xff, 0xdf, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Conv_U = new OpCode (
			"conv.u", 0xff, 0xe0, 1, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Arglist = new OpCode (
			"arglist", 0xfe, 0x00, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ceq = new OpCode (
			"ceq", 0xfe, 0x01, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Pushi);

		public static readonly OpCode Cgt = new OpCode (
			"cgt", 0xfe, 0x02, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Pushi);

		public static readonly OpCode Cgt_Un = new OpCode (
			"cgt.un", 0xfe, 0x03, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Pushi);

		public static readonly OpCode Clt = new OpCode (
			"clt", 0xfe, 0x04, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Pushi);

		public static readonly OpCode Clt_Un = new OpCode (
			"clt.un", 0xfe, 0x05, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1_pop1, StackBehaviour.Pushi);

		public static readonly OpCode Ldftn = new OpCode (
			"ldftn", 0xfe, 0x06, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineMethod,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Ldvirtftn = new OpCode (
			"ldvirtftn", 0xfe, 0x07, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineMethod,
			StackBehaviour.Popref, StackBehaviour.Pushi);

		public static readonly OpCode Ldarg = new OpCode (
			"ldarg", 0xfe, 0x09, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineParam,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldarga = new OpCode (
			"ldarga", 0xfe, 0x0a, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineParam,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Starg = new OpCode (
			"starg", 0xfe, 0x0b, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineParam,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Ldloc = new OpCode (
			"ldloc", 0xfe, 0x0c, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineVar,
			StackBehaviour.Pop0, StackBehaviour.Push1);

		public static readonly OpCode Ldloca = new OpCode (
			"ldloca", 0xfe, 0x0d, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineVar,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Stloc = new OpCode (
			"stloc", 0xfe, 0x0e, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineVar,
			StackBehaviour.Pop1, StackBehaviour.Push0);

		public static readonly OpCode Localloc = new OpCode (
			"localloc", 0xfe, 0x0f, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Pushi);

		public static readonly OpCode Endfilter = new OpCode (
			"endfilter", 0xfe, 0x11, 2, FlowControl.Return,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi, StackBehaviour.Push0);

		public static readonly OpCode Unaligned = new OpCode (
			"unaligned.", 0xfe, 0x12, 2, FlowControl.Meta,
			OpCodeType.Prefix, OperandType.ShortInlineI,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Volatile = new OpCode (
			"volatile.", 0xfe, 0x13, 2, FlowControl.Meta,
			OpCodeType.Prefix, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Tail = new OpCode (
			"tail.", 0xfe, 0x14, 2, FlowControl.Meta,
			OpCodeType.Prefix, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Initobj = new OpCode (
			"initobj", 0xfe, 0x15, 2, FlowControl.Next,
			OpCodeType.Objmodel, OperandType.InlineType,
			StackBehaviour.Popi, StackBehaviour.Push0);

		public static readonly OpCode Constrained = new OpCode (
			"constrained.", 0xfe, 0x16, 2, FlowControl.Next,
			OpCodeType.Prefix, OperandType.InlineTok,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Cpblk = new OpCode (
			"cpblk", 0xfe, 0x17, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi_popi, StackBehaviour.Push0);

		public static readonly OpCode Initblk = new OpCode (
			"initblk", 0xfe, 0x18, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Popi_popi_popi, StackBehaviour.Push0);

		public static readonly OpCode No = new OpCode (
			"no.", 0xfe, 0x19, 2, FlowControl.Next,
			OpCodeType.Prefix, OperandType.ShortInlineI,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Rethrow = new OpCode (
			"rethrow", 0xfe, 0x1a, 2, FlowControl.Throw,
			OpCodeType.Objmodel, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public static readonly OpCode Sizeof = new OpCode (
			"sizeof", 0xfe, 0x1c, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineType,
			StackBehaviour.Pop0, StackBehaviour.Pushi);

		public static readonly OpCode Refanytype = new OpCode (
			"refanytype", 0xfe, 0x1d, 2, FlowControl.Next,
			OpCodeType.Primitive, OperandType.InlineNone,
			StackBehaviour.Pop1, StackBehaviour.Pushi);

		public static readonly OpCode Readonly = new OpCode (
			"readonly.", 0xfe, 0x1e, 2, FlowControl.Next,
			OpCodeType.Prefix, OperandType.InlineNone,
			StackBehaviour.Pop0, StackBehaviour.Push0);

		public sealed class Cache {

			public static readonly Cache Instance = new Cache ();

			IDictionary m_cache;
			OpCode [] m_oneByteOpCode;
			OpCode [] m_twoBytesOpCodes;

			public OpCode this [string name] {
				get { return (OpCode) m_cache [name]; }
			}

			internal IDictionary Dictionary {
				get { return m_cache; }
			}

			internal OpCode [] OneByteOpCode {
				get { return m_oneByteOpCode; }
			}

			internal OpCode [] TwoBytesOpCode {
				get { return m_twoBytesOpCodes; }
			}

			Cache ()
			{
				m_cache = new Hashtable ();
				m_oneByteOpCode = new OpCode [0xe0 + 1];
				m_twoBytesOpCodes = new OpCode [0x1e + 1];
				m_oneByteOpCode [0x00] = OpCodes.Nop;
				m_oneByteOpCode [0x01] = OpCodes.Break;
				m_oneByteOpCode [0x02] = OpCodes.Ldarg_0;
				m_oneByteOpCode [0x03] = OpCodes.Ldarg_1;
				m_oneByteOpCode [0x04] = OpCodes.Ldarg_2;
				m_oneByteOpCode [0x05] = OpCodes.Ldarg_3;
				m_oneByteOpCode [0x06] = OpCodes.Ldloc_0;
				m_oneByteOpCode [0x07] = OpCodes.Ldloc_1;
				m_oneByteOpCode [0x08] = OpCodes.Ldloc_2;
				m_oneByteOpCode [0x09] = OpCodes.Ldloc_3;
				m_oneByteOpCode [0x0a] = OpCodes.Stloc_0;
				m_oneByteOpCode [0x0b] = OpCodes.Stloc_1;
				m_oneByteOpCode [0x0c] = OpCodes.Stloc_2;
				m_oneByteOpCode [0x0d] = OpCodes.Stloc_3;
				m_oneByteOpCode [0x0e] = OpCodes.Ldarg_S;
				m_oneByteOpCode [0x0f] = OpCodes.Ldarga_S;
				m_oneByteOpCode [0x10] = OpCodes.Starg_S;
				m_oneByteOpCode [0x11] = OpCodes.Ldloc_S;
				m_oneByteOpCode [0x12] = OpCodes.Ldloca_S;
				m_oneByteOpCode [0x13] = OpCodes.Stloc_S;
				m_oneByteOpCode [0x14] = OpCodes.Ldnull;
				m_oneByteOpCode [0x15] = OpCodes.Ldc_I4_M1;
				m_oneByteOpCode [0x16] = OpCodes.Ldc_I4_0;
				m_oneByteOpCode [0x17] = OpCodes.Ldc_I4_1;
				m_oneByteOpCode [0x18] = OpCodes.Ldc_I4_2;
				m_oneByteOpCode [0x19] = OpCodes.Ldc_I4_3;
				m_oneByteOpCode [0x1a] = OpCodes.Ldc_I4_4;
				m_oneByteOpCode [0x1b] = OpCodes.Ldc_I4_5;
				m_oneByteOpCode [0x1c] = OpCodes.Ldc_I4_6;
				m_oneByteOpCode [0x1d] = OpCodes.Ldc_I4_7;
				m_oneByteOpCode [0x1e] = OpCodes.Ldc_I4_8;
				m_oneByteOpCode [0x1f] = OpCodes.Ldc_I4_S;
				m_oneByteOpCode [0x20] = OpCodes.Ldc_I4;
				m_oneByteOpCode [0x21] = OpCodes.Ldc_I8;
				m_oneByteOpCode [0x22] = OpCodes.Ldc_R4;
				m_oneByteOpCode [0x23] = OpCodes.Ldc_R8;
				m_oneByteOpCode [0x25] = OpCodes.Dup;
				m_oneByteOpCode [0x26] = OpCodes.Pop;
				m_oneByteOpCode [0x27] = OpCodes.Jmp;
				m_oneByteOpCode [0x28] = OpCodes.Call;
				m_oneByteOpCode [0x29] = OpCodes.Calli;
				m_oneByteOpCode [0x2a] = OpCodes.Ret;
				m_oneByteOpCode [0x2b] = OpCodes.Br_S;
				m_oneByteOpCode [0x2c] = OpCodes.Brfalse_S;
				m_oneByteOpCode [0x2d] = OpCodes.Brtrue_S;
				m_oneByteOpCode [0x2e] = OpCodes.Beq_S;
				m_oneByteOpCode [0x2f] = OpCodes.Bge_S;
				m_oneByteOpCode [0x30] = OpCodes.Bgt_S;
				m_oneByteOpCode [0x31] = OpCodes.Ble_S;
				m_oneByteOpCode [0x32] = OpCodes.Blt_S;
				m_oneByteOpCode [0x33] = OpCodes.Bne_Un_S;
				m_oneByteOpCode [0x34] = OpCodes.Bge_Un_S;
				m_oneByteOpCode [0x35] = OpCodes.Bgt_Un_S;
				m_oneByteOpCode [0x36] = OpCodes.Ble_Un_S;
				m_oneByteOpCode [0x37] = OpCodes.Blt_Un_S;
				m_oneByteOpCode [0x38] = OpCodes.Br;
				m_oneByteOpCode [0x39] = OpCodes.Brfalse;
				m_oneByteOpCode [0x3a] = OpCodes.Brtrue;
				m_oneByteOpCode [0x3b] = OpCodes.Beq;
				m_oneByteOpCode [0x3c] = OpCodes.Bge;
				m_oneByteOpCode [0x3d] = OpCodes.Bgt;
				m_oneByteOpCode [0x3e] = OpCodes.Ble;
				m_oneByteOpCode [0x3f] = OpCodes.Blt;
				m_oneByteOpCode [0x40] = OpCodes.Bne_Un;
				m_oneByteOpCode [0x41] = OpCodes.Bge_Un;
				m_oneByteOpCode [0x42] = OpCodes.Bgt_Un;
				m_oneByteOpCode [0x43] = OpCodes.Ble_Un;
				m_oneByteOpCode [0x44] = OpCodes.Blt_Un;
				m_oneByteOpCode [0x45] = OpCodes.Switch;
				m_oneByteOpCode [0x46] = OpCodes.Ldind_I1;
				m_oneByteOpCode [0x47] = OpCodes.Ldind_U1;
				m_oneByteOpCode [0x48] = OpCodes.Ldind_I2;
				m_oneByteOpCode [0x49] = OpCodes.Ldind_U2;
				m_oneByteOpCode [0x4a] = OpCodes.Ldind_I4;
				m_oneByteOpCode [0x4b] = OpCodes.Ldind_U4;
				m_oneByteOpCode [0x4c] = OpCodes.Ldind_I8;
				m_oneByteOpCode [0x4d] = OpCodes.Ldind_I;
				m_oneByteOpCode [0x4e] = OpCodes.Ldind_R4;
				m_oneByteOpCode [0x4f] = OpCodes.Ldind_R8;
				m_oneByteOpCode [0x50] = OpCodes.Ldind_Ref;
				m_oneByteOpCode [0x51] = OpCodes.Stind_Ref;
				m_oneByteOpCode [0x52] = OpCodes.Stind_I1;
				m_oneByteOpCode [0x53] = OpCodes.Stind_I2;
				m_oneByteOpCode [0x54] = OpCodes.Stind_I4;
				m_oneByteOpCode [0x55] = OpCodes.Stind_I8;
				m_oneByteOpCode [0x56] = OpCodes.Stind_R4;
				m_oneByteOpCode [0x57] = OpCodes.Stind_R8;
				m_oneByteOpCode [0x58] = OpCodes.Add;
				m_oneByteOpCode [0x59] = OpCodes.Sub;
				m_oneByteOpCode [0x5a] = OpCodes.Mul;
				m_oneByteOpCode [0x5b] = OpCodes.Div;
				m_oneByteOpCode [0x5c] = OpCodes.Div_Un;
				m_oneByteOpCode [0x5d] = OpCodes.Rem;
				m_oneByteOpCode [0x5e] = OpCodes.Rem_Un;
				m_oneByteOpCode [0x5f] = OpCodes.And;
				m_oneByteOpCode [0x60] = OpCodes.Or;
				m_oneByteOpCode [0x61] = OpCodes.Xor;
				m_oneByteOpCode [0x62] = OpCodes.Shl;
				m_oneByteOpCode [0x63] = OpCodes.Shr;
				m_oneByteOpCode [0x64] = OpCodes.Shr_Un;
				m_oneByteOpCode [0x65] = OpCodes.Neg;
				m_oneByteOpCode [0x66] = OpCodes.Not;
				m_oneByteOpCode [0x67] = OpCodes.Conv_I1;
				m_oneByteOpCode [0x68] = OpCodes.Conv_I2;
				m_oneByteOpCode [0x69] = OpCodes.Conv_I4;
				m_oneByteOpCode [0x6a] = OpCodes.Conv_I8;
				m_oneByteOpCode [0x6b] = OpCodes.Conv_R4;
				m_oneByteOpCode [0x6c] = OpCodes.Conv_R8;
				m_oneByteOpCode [0x6d] = OpCodes.Conv_U4;
				m_oneByteOpCode [0x6e] = OpCodes.Conv_U8;
				m_oneByteOpCode [0x6f] = OpCodes.Callvirt;
				m_oneByteOpCode [0x70] = OpCodes.Cpobj;
				m_oneByteOpCode [0x71] = OpCodes.Ldobj;
				m_oneByteOpCode [0x72] = OpCodes.Ldstr;
				m_oneByteOpCode [0x73] = OpCodes.Newobj;
				m_oneByteOpCode [0x74] = OpCodes.Castclass;
				m_oneByteOpCode [0x75] = OpCodes.Isinst;
				m_oneByteOpCode [0x76] = OpCodes.Conv_R_Un;
				m_oneByteOpCode [0x79] = OpCodes.Unbox;
				m_oneByteOpCode [0x7a] = OpCodes.Throw;
				m_oneByteOpCode [0x7b] = OpCodes.Ldfld;
				m_oneByteOpCode [0x7c] = OpCodes.Ldflda;
				m_oneByteOpCode [0x7d] = OpCodes.Stfld;
				m_oneByteOpCode [0x7e] = OpCodes.Ldsfld;
				m_oneByteOpCode [0x7f] = OpCodes.Ldsflda;
				m_oneByteOpCode [0x80] = OpCodes.Stsfld;
				m_oneByteOpCode [0x81] = OpCodes.Stobj;
				m_oneByteOpCode [0x82] = OpCodes.Conv_Ovf_I1_Un;
				m_oneByteOpCode [0x83] = OpCodes.Conv_Ovf_I2_Un;
				m_oneByteOpCode [0x84] = OpCodes.Conv_Ovf_I4_Un;
				m_oneByteOpCode [0x85] = OpCodes.Conv_Ovf_I8_Un;
				m_oneByteOpCode [0x86] = OpCodes.Conv_Ovf_U1_Un;
				m_oneByteOpCode [0x87] = OpCodes.Conv_Ovf_U2_Un;
				m_oneByteOpCode [0x88] = OpCodes.Conv_Ovf_U4_Un;
				m_oneByteOpCode [0x89] = OpCodes.Conv_Ovf_U8_Un;
				m_oneByteOpCode [0x8a] = OpCodes.Conv_Ovf_I_Un;
				m_oneByteOpCode [0x8b] = OpCodes.Conv_Ovf_U_Un;
				m_oneByteOpCode [0x8c] = OpCodes.Box;
				m_oneByteOpCode [0x8d] = OpCodes.Newarr;
				m_oneByteOpCode [0x8e] = OpCodes.Ldlen;
				m_oneByteOpCode [0x8f] = OpCodes.Ldelema;
				m_oneByteOpCode [0x90] = OpCodes.Ldelem_I1;
				m_oneByteOpCode [0x91] = OpCodes.Ldelem_U1;
				m_oneByteOpCode [0x92] = OpCodes.Ldelem_I2;
				m_oneByteOpCode [0x93] = OpCodes.Ldelem_U2;
				m_oneByteOpCode [0x94] = OpCodes.Ldelem_I4;
				m_oneByteOpCode [0x95] = OpCodes.Ldelem_U4;
				m_oneByteOpCode [0x96] = OpCodes.Ldelem_I8;
				m_oneByteOpCode [0x97] = OpCodes.Ldelem_I;
				m_oneByteOpCode [0x98] = OpCodes.Ldelem_R4;
				m_oneByteOpCode [0x99] = OpCodes.Ldelem_R8;
				m_oneByteOpCode [0x9a] = OpCodes.Ldelem_Ref;
				m_oneByteOpCode [0x9b] = OpCodes.Stelem_I;
				m_oneByteOpCode [0x9c] = OpCodes.Stelem_I1;
				m_oneByteOpCode [0x9d] = OpCodes.Stelem_I2;
				m_oneByteOpCode [0x9e] = OpCodes.Stelem_I4;
				m_oneByteOpCode [0x9f] = OpCodes.Stelem_I8;
				m_oneByteOpCode [0xa0] = OpCodes.Stelem_R4;
				m_oneByteOpCode [0xa1] = OpCodes.Stelem_R8;
				m_oneByteOpCode [0xa2] = OpCodes.Stelem_Ref;
				m_oneByteOpCode [0xa3] = OpCodes.Ldelem_Any;
				m_oneByteOpCode [0xa4] = OpCodes.Stelem_Any;
				m_oneByteOpCode [0xa5] = OpCodes.Unbox_Any;
				m_oneByteOpCode [0xb3] = OpCodes.Conv_Ovf_I1;
				m_oneByteOpCode [0xb4] = OpCodes.Conv_Ovf_U1;
				m_oneByteOpCode [0xb5] = OpCodes.Conv_Ovf_I2;
				m_oneByteOpCode [0xb6] = OpCodes.Conv_Ovf_U2;
				m_oneByteOpCode [0xb7] = OpCodes.Conv_Ovf_I4;
				m_oneByteOpCode [0xb8] = OpCodes.Conv_Ovf_U4;
				m_oneByteOpCode [0xb9] = OpCodes.Conv_Ovf_I8;
				m_oneByteOpCode [0xba] = OpCodes.Conv_Ovf_U8;
				m_oneByteOpCode [0xc2] = OpCodes.Refanyval;
				m_oneByteOpCode [0xc3] = OpCodes.Ckfinite;
				m_oneByteOpCode [0xc6] = OpCodes.Mkrefany;
				m_oneByteOpCode [0xd0] = OpCodes.Ldtoken;
				m_oneByteOpCode [0xd1] = OpCodes.Conv_U2;
				m_oneByteOpCode [0xd2] = OpCodes.Conv_U1;
				m_oneByteOpCode [0xd3] = OpCodes.Conv_I;
				m_oneByteOpCode [0xd4] = OpCodes.Conv_Ovf_I;
				m_oneByteOpCode [0xd5] = OpCodes.Conv_Ovf_U;
				m_oneByteOpCode [0xd6] = OpCodes.Add_Ovf;
				m_oneByteOpCode [0xd7] = OpCodes.Add_Ovf_Un;
				m_oneByteOpCode [0xd8] = OpCodes.Mul_Ovf;
				m_oneByteOpCode [0xd9] = OpCodes.Mul_Ovf_Un;
				m_oneByteOpCode [0xda] = OpCodes.Sub_Ovf;
				m_oneByteOpCode [0xdb] = OpCodes.Sub_Ovf_Un;
				m_oneByteOpCode [0xdc] = OpCodes.Endfinally;
				m_oneByteOpCode [0xdd] = OpCodes.Leave;
				m_oneByteOpCode [0xde] = OpCodes.Leave_S;
				m_oneByteOpCode [0xdf] = OpCodes.Stind_I;
				m_oneByteOpCode [0xe0] = OpCodes.Conv_U;
				m_twoBytesOpCodes [0x00] = OpCodes.Arglist;
				m_twoBytesOpCodes [0x01] = OpCodes.Ceq;
				m_twoBytesOpCodes [0x02] = OpCodes.Cgt;
				m_twoBytesOpCodes [0x03] = OpCodes.Cgt_Un;
				m_twoBytesOpCodes [0x04] = OpCodes.Clt;
				m_twoBytesOpCodes [0x05] = OpCodes.Clt_Un;
				m_twoBytesOpCodes [0x06] = OpCodes.Ldftn;
				m_twoBytesOpCodes [0x07] = OpCodes.Ldvirtftn;
				m_twoBytesOpCodes [0x09] = OpCodes.Ldarg;
				m_twoBytesOpCodes [0x0a] = OpCodes.Ldarga;
				m_twoBytesOpCodes [0x0b] = OpCodes.Starg;
				m_twoBytesOpCodes [0x0c] = OpCodes.Ldloc;
				m_twoBytesOpCodes [0x0d] = OpCodes.Ldloca;
				m_twoBytesOpCodes [0x0e] = OpCodes.Stloc;
				m_twoBytesOpCodes [0x0f] = OpCodes.Localloc;
				m_twoBytesOpCodes [0x11] = OpCodes.Endfilter;
				m_twoBytesOpCodes [0x12] = OpCodes.Unaligned;
				m_twoBytesOpCodes [0x13] = OpCodes.Volatile;
				m_twoBytesOpCodes [0x14] = OpCodes.Tail;
				m_twoBytesOpCodes [0x15] = OpCodes.Initobj;
				m_twoBytesOpCodes [0x16] = OpCodes.Constrained;
				m_twoBytesOpCodes [0x17] = OpCodes.Cpblk;
				m_twoBytesOpCodes [0x18] = OpCodes.Initblk;
				m_twoBytesOpCodes [0x19] = OpCodes.No;
				m_twoBytesOpCodes [0x1a] = OpCodes.Rethrow;
				m_twoBytesOpCodes [0x1c] = OpCodes.Sizeof;
				m_twoBytesOpCodes [0x1d] = OpCodes.Refanytype;
				m_twoBytesOpCodes [0x1e] = OpCodes.Readonly;

				m_cache ["nop"] = OpCodes.Nop;
				m_cache ["break"] = OpCodes.Break;
				m_cache ["ldarg.0"] = OpCodes.Ldarg_0;
				m_cache ["ldarg.1"] = OpCodes.Ldarg_1;
				m_cache ["ldarg.2"] = OpCodes.Ldarg_2;
				m_cache ["ldarg.3"] = OpCodes.Ldarg_3;
				m_cache ["ldloc.0"] = OpCodes.Ldloc_0;
				m_cache ["ldloc.1"] = OpCodes.Ldloc_1;
				m_cache ["ldloc.2"] = OpCodes.Ldloc_2;
				m_cache ["ldloc.3"] = OpCodes.Ldloc_3;
				m_cache ["stloc.0"] = OpCodes.Stloc_0;
				m_cache ["stloc.1"] = OpCodes.Stloc_1;
				m_cache ["stloc.2"] = OpCodes.Stloc_2;
				m_cache ["stloc.3"] = OpCodes.Stloc_3;
				m_cache ["ldarg.s"] = OpCodes.Ldarg_S;
				m_cache ["ldarga.s"] = OpCodes.Ldarga_S;
				m_cache ["starg.s"] = OpCodes.Starg_S;
				m_cache ["ldloc.s"] = OpCodes.Ldloc_S;
				m_cache ["ldloca.s"] = OpCodes.Ldloca_S;
				m_cache ["stloc.s"] = OpCodes.Stloc_S;
				m_cache ["ldnull"] = OpCodes.Ldnull;
				m_cache ["ldc.i4.m1"] = OpCodes.Ldc_I4_M1;
				m_cache ["ldc.i4.0"] = OpCodes.Ldc_I4_0;
				m_cache ["ldc.i4.1"] = OpCodes.Ldc_I4_1;
				m_cache ["ldc.i4.2"] = OpCodes.Ldc_I4_2;
				m_cache ["ldc.i4.3"] = OpCodes.Ldc_I4_3;
				m_cache ["ldc.i4.4"] = OpCodes.Ldc_I4_4;
				m_cache ["ldc.i4.5"] = OpCodes.Ldc_I4_5;
				m_cache ["ldc.i4.6"] = OpCodes.Ldc_I4_6;
				m_cache ["ldc.i4.7"] = OpCodes.Ldc_I4_7;
				m_cache ["ldc.i4.8"] = OpCodes.Ldc_I4_8;
				m_cache ["ldc.i4.s"] = OpCodes.Ldc_I4_S;
				m_cache ["ldc.i4"] = OpCodes.Ldc_I4;
				m_cache ["ldc.i8"] = OpCodes.Ldc_I8;
				m_cache ["ldc.r4"] = OpCodes.Ldc_R4;
				m_cache ["ldc.r8"] = OpCodes.Ldc_R8;
				m_cache ["dup"] = OpCodes.Dup;
				m_cache ["pop"] = OpCodes.Pop;
				m_cache ["jmp"] = OpCodes.Jmp;
				m_cache ["call"] = OpCodes.Call;
				m_cache ["calli"] = OpCodes.Calli;
				m_cache ["ret"] = OpCodes.Ret;
				m_cache ["br.s"] = OpCodes.Br_S;
				m_cache ["brfalse.s"] = OpCodes.Brfalse_S;
				m_cache ["brtrue.s"] = OpCodes.Brtrue_S;
				m_cache ["beq.s"] = OpCodes.Beq_S;
				m_cache ["bge.s"] = OpCodes.Bge_S;
				m_cache ["bgt.s"] = OpCodes.Bgt_S;
				m_cache ["ble.s"] = OpCodes.Ble_S;
				m_cache ["blt.s"] = OpCodes.Blt_S;
				m_cache ["bne.un.s"] = OpCodes.Bne_Un_S;
				m_cache ["bge.un.s"] = OpCodes.Bge_Un_S;
				m_cache ["bgt.un.s"] = OpCodes.Bgt_Un_S;
				m_cache ["ble.un.s"] = OpCodes.Ble_Un_S;
				m_cache ["blt.un.s"] = OpCodes.Blt_Un_S;
				m_cache ["br"] = OpCodes.Br;
				m_cache ["brfalse"] = OpCodes.Brfalse;
				m_cache ["brtrue"] = OpCodes.Brtrue;
				m_cache ["beq"] = OpCodes.Beq;
				m_cache ["bge"] = OpCodes.Bge;
				m_cache ["bgt"] = OpCodes.Bgt;
				m_cache ["ble"] = OpCodes.Ble;
				m_cache ["blt"] = OpCodes.Blt;
				m_cache ["bne.un"] = OpCodes.Bne_Un;
				m_cache ["bge.un"] = OpCodes.Bge_Un;
				m_cache ["bgt.un"] = OpCodes.Bgt_Un;
				m_cache ["ble.un"] = OpCodes.Ble_Un;
				m_cache ["blt.un"] = OpCodes.Blt_Un;
				m_cache ["switch"] = OpCodes.Switch;
				m_cache ["ldind.i1"] = OpCodes.Ldind_I1;
				m_cache ["ldind.u1"] = OpCodes.Ldind_U1;
				m_cache ["ldind.i2"] = OpCodes.Ldind_I2;
				m_cache ["ldind.u2"] = OpCodes.Ldind_U2;
				m_cache ["ldind.i4"] = OpCodes.Ldind_I4;
				m_cache ["ldind.u4"] = OpCodes.Ldind_U4;
				m_cache ["ldind.i8"] = OpCodes.Ldind_I8;
				m_cache ["ldind.i"] = OpCodes.Ldind_I;
				m_cache ["ldind.r4"] = OpCodes.Ldind_R4;
				m_cache ["ldind.r8"] = OpCodes.Ldind_R8;
				m_cache ["ldind.ref"] = OpCodes.Ldind_Ref;
				m_cache ["stind.ref"] = OpCodes.Stind_Ref;
				m_cache ["stind.i1"] = OpCodes.Stind_I1;
				m_cache ["stind.i2"] = OpCodes.Stind_I2;
				m_cache ["stind.i4"] = OpCodes.Stind_I4;
				m_cache ["stind.i8"] = OpCodes.Stind_I8;
				m_cache ["stind.r4"] = OpCodes.Stind_R4;
				m_cache ["stind.r8"] = OpCodes.Stind_R8;
				m_cache ["add"] = OpCodes.Add;
				m_cache ["sub"] = OpCodes.Sub;
				m_cache ["mul"] = OpCodes.Mul;
				m_cache ["div"] = OpCodes.Div;
				m_cache ["div.un"] = OpCodes.Div_Un;
				m_cache ["rem"] = OpCodes.Rem;
				m_cache ["rem.un"] = OpCodes.Rem_Un;
				m_cache ["and"] = OpCodes.And;
				m_cache ["or"] = OpCodes.Or;
				m_cache ["xor"] = OpCodes.Xor;
				m_cache ["shl"] = OpCodes.Shl;
				m_cache ["shr"] = OpCodes.Shr;
				m_cache ["shr.un"] = OpCodes.Shr_Un;
				m_cache ["neg"] = OpCodes.Neg;
				m_cache ["not"] = OpCodes.Not;
				m_cache ["conv.i1"] = OpCodes.Conv_I1;
				m_cache ["conv.i2"] = OpCodes.Conv_I2;
				m_cache ["conv.i4"] = OpCodes.Conv_I4;
				m_cache ["conv.i8"] = OpCodes.Conv_I8;
				m_cache ["conv.r4"] = OpCodes.Conv_R4;
				m_cache ["conv.r8"] = OpCodes.Conv_R8;
				m_cache ["conv.u4"] = OpCodes.Conv_U4;
				m_cache ["conv.u8"] = OpCodes.Conv_U8;
				m_cache ["callvirt"] = OpCodes.Callvirt;
				m_cache ["cpobj"] = OpCodes.Cpobj;
				m_cache ["ldobj"] = OpCodes.Ldobj;
				m_cache ["ldstr"] = OpCodes.Ldstr;
				m_cache ["newobj"] = OpCodes.Newobj;
				m_cache ["castclass"] = OpCodes.Castclass;
				m_cache ["isinst"] = OpCodes.Isinst;
				m_cache ["conv.r.un"] = OpCodes.Conv_R_Un;
				m_cache ["unbox"] = OpCodes.Unbox;
				m_cache ["throw"] = OpCodes.Throw;
				m_cache ["ldfld"] = OpCodes.Ldfld;
				m_cache ["ldflda"] = OpCodes.Ldflda;
				m_cache ["stfld"] = OpCodes.Stfld;
				m_cache ["ldsfld"] = OpCodes.Ldsfld;
				m_cache ["ldsflda"] = OpCodes.Ldsflda;
				m_cache ["stsfld"] = OpCodes.Stsfld;
				m_cache ["stobj"] = OpCodes.Stobj;
				m_cache ["conv.ovf.i1.un"] = OpCodes.Conv_Ovf_I1_Un;
				m_cache ["conv.ovf.i2.un"] = OpCodes.Conv_Ovf_I2_Un;
				m_cache ["conv.ovf.i4.un"] = OpCodes.Conv_Ovf_I4_Un;
				m_cache ["conv.ovf.i8.un"] = OpCodes.Conv_Ovf_I8_Un;
				m_cache ["conv.ovf.u1.un"] = OpCodes.Conv_Ovf_U1_Un;
				m_cache ["conv.ovf.u2.un"] = OpCodes.Conv_Ovf_U2_Un;
				m_cache ["conv.ovf.u4.un"] = OpCodes.Conv_Ovf_U4_Un;
				m_cache ["conv.ovf.u8.un"] = OpCodes.Conv_Ovf_U8_Un;
				m_cache ["conv.ovf.i.un"] = OpCodes.Conv_Ovf_I_Un;
				m_cache ["conv.ovf.u.un"] = OpCodes.Conv_Ovf_U_Un;
				m_cache ["box"] = OpCodes.Box;
				m_cache ["newarr"] = OpCodes.Newarr;
				m_cache ["ldlen"] = OpCodes.Ldlen;
				m_cache ["ldelema"] = OpCodes.Ldelema;
				m_cache ["ldelem.i1"] = OpCodes.Ldelem_I1;
				m_cache ["ldelem.u1"] = OpCodes.Ldelem_U1;
				m_cache ["ldelem.i2"] = OpCodes.Ldelem_I2;
				m_cache ["ldelem.u2"] = OpCodes.Ldelem_U2;
				m_cache ["ldelem.i4"] = OpCodes.Ldelem_I4;
				m_cache ["ldelem.u4"] = OpCodes.Ldelem_U4;
				m_cache ["ldelem.i8"] = OpCodes.Ldelem_I8;
				m_cache ["ldelem.i"] = OpCodes.Ldelem_I;
				m_cache ["ldelem.r4"] = OpCodes.Ldelem_R4;
				m_cache ["ldelem.r8"] = OpCodes.Ldelem_R8;
				m_cache ["ldelem.ref"] = OpCodes.Ldelem_Ref;
				m_cache ["stelem.i"] = OpCodes.Stelem_I;
				m_cache ["stelem.i1"] = OpCodes.Stelem_I1;
				m_cache ["stelem.i2"] = OpCodes.Stelem_I2;
				m_cache ["stelem.i4"] = OpCodes.Stelem_I4;
				m_cache ["stelem.i8"] = OpCodes.Stelem_I8;
				m_cache ["stelem.r4"] = OpCodes.Stelem_R4;
				m_cache ["stelem.r8"] = OpCodes.Stelem_R8;
				m_cache ["stelem.ref"] = OpCodes.Stelem_Ref;
				m_cache ["ldelem.any"] = OpCodes.Ldelem_Any;
				m_cache ["stelem.any"] = OpCodes.Stelem_Any;
				m_cache ["unbox.any"] = OpCodes.Unbox_Any;
				m_cache ["conv.ovf.i1"] = OpCodes.Conv_Ovf_I1;
				m_cache ["conv.ovf.u1"] = OpCodes.Conv_Ovf_U1;
				m_cache ["conv.ovf.i2"] = OpCodes.Conv_Ovf_I2;
				m_cache ["conv.ovf.u2"] = OpCodes.Conv_Ovf_U2;
				m_cache ["conv.ovf.i4"] = OpCodes.Conv_Ovf_I4;
				m_cache ["conv.ovf.u4"] = OpCodes.Conv_Ovf_U4;
				m_cache ["conv.ovf.i8"] = OpCodes.Conv_Ovf_I8;
				m_cache ["conv.ovf.u8"] = OpCodes.Conv_Ovf_U8;
				m_cache ["refanyval"] = OpCodes.Refanyval;
				m_cache ["ckfinite"] = OpCodes.Ckfinite;
				m_cache ["mkrefany"] = OpCodes.Mkrefany;
				m_cache ["ldtoken"] = OpCodes.Ldtoken;
				m_cache ["conv.u2"] = OpCodes.Conv_U2;
				m_cache ["conv.u1"] = OpCodes.Conv_U1;
				m_cache ["conv.i"] = OpCodes.Conv_I;
				m_cache ["conv.ovf.i"] = OpCodes.Conv_Ovf_I;
				m_cache ["conv.ovf.u"] = OpCodes.Conv_Ovf_U;
				m_cache ["add.ovf"] = OpCodes.Add_Ovf;
				m_cache ["add.ovf.un"] = OpCodes.Add_Ovf_Un;
				m_cache ["mul.ovf"] = OpCodes.Mul_Ovf;
				m_cache ["mul.ovf.un"] = OpCodes.Mul_Ovf_Un;
				m_cache ["sub.ovf"] = OpCodes.Sub_Ovf;
				m_cache ["sub.ovf.un"] = OpCodes.Sub_Ovf_Un;
				m_cache ["endfinally"] = OpCodes.Endfinally;
				m_cache ["leave"] = OpCodes.Leave;
				m_cache ["leave.s"] = OpCodes.Leave_S;
				m_cache ["stind.i"] = OpCodes.Stind_I;
				m_cache ["conv.u"] = OpCodes.Conv_U;
				m_cache ["arglist"] = OpCodes.Arglist;
				m_cache ["ceq"] = OpCodes.Ceq;
				m_cache ["cgt"] = OpCodes.Cgt;
				m_cache ["cgt.un"] = OpCodes.Cgt_Un;
				m_cache ["clt"] = OpCodes.Clt;
				m_cache ["clt.un"] = OpCodes.Clt_Un;
				m_cache ["ldftn"] = OpCodes.Ldftn;
				m_cache ["ldvirtftn"] = OpCodes.Ldvirtftn;
				m_cache ["ldarg"] = OpCodes.Ldarg;
				m_cache ["ldarga"] = OpCodes.Ldarga;
				m_cache ["starg"] = OpCodes.Starg;
				m_cache ["ldloc"] = OpCodes.Ldloc;
				m_cache ["ldloca"] = OpCodes.Ldloca;
				m_cache ["stloc"] = OpCodes.Stloc;
				m_cache ["localloc"] = OpCodes.Localloc;
				m_cache ["endfilter"] = OpCodes.Endfilter;
				m_cache ["unaligned."] = OpCodes.Unaligned;
				m_cache ["volatile."] = OpCodes.Volatile;
				m_cache ["tail."] = OpCodes.Tail;
				m_cache ["initobj"] = OpCodes.Initobj;
				m_cache ["constrained."] = OpCodes.Constrained;
				m_cache ["cpblk"] = OpCodes.Cpblk;
				m_cache ["initblk"] = OpCodes.Initblk;
				m_cache ["no."] = OpCodes.No;
				m_cache ["rethrow"] = OpCodes.Rethrow;
				m_cache ["sizeof"] = OpCodes.Sizeof;
				m_cache ["refanytype"] = OpCodes.Refanytype;
				m_cache ["readonly."] = OpCodes.Readonly;
			}
		}
	}
}
