//
// Constants.cs
//
// Author:
//   Jb Evain (jbevain@gmail.com)
//
// (C) 2005 Jb Evain
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

namespace Mono.Cecil {

	class Constants {

		Constants ()
		{
		}

		public const string Corlib = "mscorlib";

		public const string ModuleType = "<Module>";
		public const string PrivateImplDetails = "<PrivateImplementationDetails>";

		public const string Void = "System.Void";
		public const string Object = "System.Object";
		public const string String = "System.String";
		public const string Boolean = "System.Boolean";
		public const string Char = "System.Char";
		public const string Single = "System.Single";
		public const string Double = "System.Double";
		public const string SByte = "System.SByte";
		public const string Byte = "System.Byte";
		public const string Int16 = "System.Int16";
		public const string UInt16 = "System.UInt16";
		public const string Int32 = "System.Int32";
		public const string UInt32 = "System.UInt32";
		public const string Int64 = "System.Int64";
		public const string UInt64 = "System.UInt64";
		public const string IntPtr = "System.IntPtr";
		public const string UIntPtr = "System.UIntPtr";
		public const string TypedReference = "System.TypedReference";
		public const string Type = "System.Type";
		public const string ValueType = "System.ValueType";
		public const string Enum = "System.Enum";
	}
}
