/* ProjectSettings.h
 * project settings for document
 *
 * Copyright (C) 2002-2006 by vhf interservice GmbH
 * Author:   Ilonka Fleischmann, Georg Fleischmann
 *
 * Created:  2002-11-23
 * Modified: 2006-09-21
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#ifndef VHF_H_PROJECTSETTINGS
#define VHF_H_PROJECTSETTINGS

#include <AppKit/AppKit.h>
#include <VHFShared/types.h>

#define PS_INFO		0
#define PS_SETTINGS	1

@interface ProjectSettings:NSObject
{
    id			levPopup;	// popup to select level
    NSScrollView	*levView;	// we add our subviews to this view
    id			panel;		// this is our panel

    /* the controllers of subviews */
    id			settings;
    id			info;
    id			fontInfo;

    id			activeWindow;
}

- init;
- (void)makeKeyAndOrderFront:sender;
- (void)update:sender;

- (void)setLevel:sender;
- (void)setLevelAt:(int)level;
- (void)setLevelView:theView;

- windowAt:(int)level;

@end

#endif // VHF_H_PROJECTSETTINGS
