/***************************************************************************
                          interface_widget_visual1.cpp  -  description
                             -------------------
    begin                : Sun May 6 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_widget_visual1.h"

#define VU_BARS_LENGTH 25
#define VOLUME_MAX 160

int Info_View_Data::color_values[] = {
    10, 20, 30,
    100, 200, 100,
    250, 250, 150,
    50, 60, 70,
    70, 80, 90,
    10, 50, 10,
    15, 80, 15,
    250, 250, 250,
    150, 150, 150,
    210, 210, 210,
    250, 100, 100,
    70, 110, 70,

};

void Info_View_Data::allocate_colormap () {

	int i;

	for (i=0;i<Max_Colors*3;i+=3) {

		colors[i/3].red = color_values[i] * 0xFFFF / 0xFF;
		colors[i/3].green = color_values[i+1] * 0xFFFF / 0xFF;
		colors[i/3].blue = color_values[i+2] * 0xFFFF / 0xFF;
	        get_colormap().alloc(colors[i/3]);
	}

}

gint Info_View_Data::do_expose_event(GdkEventExpose* p0) {

	if (editor==NULL) {

		return 0;
	}

	queue_draw();

	return 0;

}

void Info_View_Data::realize_impl() {

	int i;

	Gdk_WindowAttr attributes;
        int attributes_mask;

	set_flags(GTK_REALIZED|GTK_CAN_FOCUS|GTK_HAS_GRAB);

	attributes->x=gtkobj()->allocation.x;
	attributes->y=gtkobj()->allocation.y;
	attributes->width = width();
	attributes->height = height();
	attributes->wclass = GDK_INPUT_OUTPUT;
	attributes->window_type = GDK_WINDOW_CHILD;
	attributes->event_mask = get_events () | GDK_EXPOSURE_MASK;
	attributes->visual = get_visual ();
	attributes->colormap = get_colormap ();	

	attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;

	window.create(get_parent_window(), attributes, attributes_mask);
	gtkobj()->window=window;

	expose_event.connect(slot(this,&Info_View_Data::do_expose_event));

	allocate_colormap();

       	for (i=0;i<Max_Colors;i++) {

		GC[i].create(get_window());
		GC[i].set_foreground(colors[i]);
	}

	GC[Col_BackGround].set_exposures(1);
	window.set_user_data(gtkobj());
	window.set_background(colors[Col_BackGround]);

}

void Info_View_Data::print_single_row(int rowofs) {

	int i;
	char number[3]={'0','0',0};
      	Sint8* sample_8bits;
      	Sint16* sample_16bits;
        int tmpvoice=player->get_channel_voice(rowofs+window_offset);
	int pos,val,tmppan;
	int numcol,sampcol,pancol,instrcol;

	number[0]='0'+(rowofs+window_offset+1)/10;
	number[1]='0'+(rowofs+window_offset+1)%10;
	
        window.draw_rectangle(GC[Col_BackGround],true,0,rowofs*get_row_height(),width(),get_row_height());


	if (editor->is_channel_muted(rowofs+window_offset)) {


		numcol=sampcol=pancol=instrcol=Col_SepChannels;
	} else {

		numcol=instrcol=Col_ForeGround;
		sampcol=Col_Cursor;
		pancol=Col_Mask;
	}
		
	
	if ((rowofs+window_offset)==editor->get_visual_channel()) numcol=Col_ForeGround_Selected;

	window.draw_string(font,GC[numcol],0,rowofs*get_row_height()+get_font_height()-1,number);

        window.draw_rectangle(GC[Col_SepChannels],true,get_font_width()*4,rowofs*get_row_height(),2,get_row_height());
        window.draw_rectangle(GC[Col_SepChannels],true,get_font_width()*(4+VU_BARS_LENGTH+1),rowofs*get_row_height(),2,get_row_height());
        window.draw_rectangle(GC[Col_SepChannels],true,get_font_width()*(4+VU_BARS_LENGTH+1+29),rowofs*get_row_height(),2,get_row_height());
        window.draw_rectangle(GC[Col_SepChannels],true,get_font_width()*(4+VU_BARS_LENGTH+1+31)+(PAN_RIGHT>>1),rowofs*get_row_height(),2,get_row_height());

	if ((tmpvoice==-1) || (player->get_mixer_ptr()->get_voice_sample_data_ptr(tmpvoice)==NULL)) return;

	sample_8bits=(Sint8*)player->get_mixer_ptr()->get_voice_sample_data_ptr(tmpvoice)->data_ptr;
	sample_16bits=player->get_mixer_ptr()->get_voice_sample_data_ptr(tmpvoice)->data_ptr;

	if (sample_8bits==NULL) return;

	pos=player->get_mixer_ptr()->get_voice_sample_pos_index(tmpvoice);
	tmppan=player->get_mixer_ptr()->get_voice_panning_pos(tmpvoice);			

	if (player->get_mixer_ptr()->get_voice_sample_data_ptr(tmpvoice)->is_16bits) {

		val=(32768+sample_16bits[pos])*(VU_BARS_LENGTH*get_font_width())/65535;
				
	} else {

		val=(128+sample_8bits[pos])*(VU_BARS_LENGTH*get_font_width())/255;
	}

	val=val*player->get_mixer_ptr()->get_voice_volume(tmpvoice)/VOLUME_MAX;

	if (val>(VU_BARS_LENGTH*get_font_width())) {

		val=VU_BARS_LENGTH*get_font_width();
		sampcol=Col_Mask;
	
	}
	
	

	
	
        window.draw_rectangle(GC[sampcol],true,get_font_width()*5,rowofs*get_row_height(),val,get_font_height());

        window.draw_string(font,GC[instrcol],get_font_width()*(4+VU_BARS_LENGTH+2),rowofs*get_row_height()+get_font_height()-1,player->get_voice_sample_name(tmpvoice));

	if (tmppan==PAN_SURROUND) {

		window.draw_string(font,GC[pancol],get_font_width()*(4+VU_BARS_LENGTH+1+32),rowofs*get_row_height()+get_font_height()-1,"->)Surround(<-");

	} else if (tmppan==PAN_LEFT) {

		window.draw_string(font,GC[pancol],get_font_width()*(4+VU_BARS_LENGTH+1+30)+(tmppan>>1),rowofs*get_row_height()-1+get_font_height(),"L");


	} else if (tmppan==PAN_RIGHT) {

		window.draw_string(font,GC[pancol],get_font_width()*(4+VU_BARS_LENGTH+1+30)+(tmppan>>1),rowofs*get_row_height()-1+get_font_height(),"R");

	} else {

	        window.draw_rectangle(GC[pancol],true,get_font_width()*(4+VU_BARS_LENGTH+1+30)+(tmppan>>1),rowofs*get_row_height(),get_font_width(),get_font_height());
	}


}



void Info_View_Data::print_rows() {

	int i;

	if (editor->get_visual_channel()<window_offset) window_offset=editor->get_visual_channel();
	if (editor->get_visual_channel()>(window_offset+get_visible_rows())-1) window_offset=(editor->get_visual_channel()-get_visible_rows())+1;

	for (i=0;i<get_visible_rows();i++) print_single_row(i);
		

}


void Info_View_Data::draw_impl(GdkRectangle* p0){

	int cursor_y_ofs_to_clear;

      	if (editor==NULL) return;
	
	print_rows();

}

void Info_View_Data::link_to_editor(Editor *p_editor) {

	editor=p_editor;
	font.load("-adobe-courier-bold-r-normal--*-120-*-*-*-*-*-*");

}

int Info_View_Data::get_font_width() {

	return font.string_width("X");

}

int Info_View_Data::get_font_height() {

	return font.ascent()+font.descent();

}

int Info_View_Data::get_row_height() {

	return get_font_height()+1;

}


int Info_View_Data::get_visible_rows() {

	return height()/get_row_height();

}


void Info_View_Data::link_to_player(Player_Data *p_player) {
	
        player=p_player;
}

Info_View_Data::Info_View_Data(){

	player=NULL;
	editor=NULL;
}
Info_View_Data::~Info_View_Data(){
}
