/***************************************************************************
                          instrument.h  -  description
                             -------------------
    begin                : Sat Jan 20 2001
    copyright            : (C) 2001 by c0del4rvi4
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INSTRUMENT_H
#define INSTRUMENT_H

#include "typedefs.h"
#include "note.h"
#include "envelope.h"


/******************************
 instrument.h
 ----------

this class describes an instrument,
and some constant values of it
********************************/

/**
  *@author Juan Linietsky
  */

struct Instrument {

	//constants

	enum {
	
		NNA_NOTE_CUT=0,
		NNA_NOTE_CONTINUE=1,
		NNA_NOTE_OFF=2,
		NNA_NOTE_FADE=3
	};
	
	
	enum {
	
		DCT_DISABLED,
		DCT_NOTE,
		DCT_SAMPLE,
		DCT_INSTRUMENT
	};
	
	enum {
	
		DCA_NOTE_CUT,
		DCA_NOTE_OFF,
		DCA_NOTE_FADE,
	};


	/* variables */

	string name;
	string filename;

	Uint8 sample_number[Note::NOTES];
	Uint8 note_number[Note::NOTES];

	Sint8 NNA_type;
	Sint8 duplicate_check_type;
	Sint8 duplicate_check_action;

	struct Volume {

		Envelope envelope;
		Uint8 global_amount;
		Uint16 fadeout;
		Uint8 random_variation;

	} volume;

	struct Panning {

		Envelope envelope;
		bool use_default;
		Uint8 default_amount;
		Sint8 pitch_separation;
		Uint8 pitch_center;
		Uint8 random_variation;

	} panning;

	struct Pitch {

		Envelope envelope;
		bool use_as_filter;
		bool use_default_cutoff;
		Uint8 default_cutoff;
		bool use_default_Q;
		Uint8 default_Q;
		
	} pitch;
	
	void reset();

	Instrument() {

		reset();
	};
	~Instrument();
};

#endif
