/***************************************************************************
                          player_data_envelopes.cpp  -  description
                             -------------------
    begin                : Fri Mar 30 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "player_data.h"


void Player_Data::Voice_Control::start_envelope(Envelope *p_envelope,Envelope_Control *p_envelope_ctrl) {

	p_envelope_ctrl->pos_index=0;
	p_envelope_ctrl->status=1;
	p_envelope_ctrl->sustain_looping=p_envelope->sustain_loop_on;
	p_envelope_ctrl->looping=p_envelope->loop_on;
	p_envelope_ctrl->terminated=false;
	p_envelope_ctrl->kill=false;
	p_envelope_ctrl->value=p_envelope->get_height_at_pos(p_envelope_ctrl->pos_index);
}

void Player_Data::Voice_Control::process_envelope(Envelope *p_envelope,Envelope_Control *p_envelope_ctrl) {

	if (p_envelope_ctrl->active) {

		if (note_end_flags&END_NOTE_OFF) p_envelope_ctrl->sustain_looping=false;

		p_envelope_ctrl->value=p_envelope->get_height_at_pos(p_envelope_ctrl->pos_index);

		p_envelope_ctrl->pos_index++;

		if (p_envelope_ctrl->sustain_looping) {

			if (p_envelope_ctrl->pos_index>p_envelope->node[p_envelope->sustain_loop_end_node].tick_offset) {

				p_envelope_ctrl->pos_index=p_envelope->node[p_envelope->sustain_loop_begin_node].tick_offset;
			}

		} else if (p_envelope_ctrl->looping) {

			if (p_envelope_ctrl->pos_index>p_envelope->node[p_envelope->loop_end_node].tick_offset) {

				p_envelope_ctrl->pos_index=p_envelope->node[p_envelope->loop_begin_node].tick_offset;
			}

		}

		if (p_envelope_ctrl->pos_index>p_envelope->node[p_envelope->node_count-1].tick_offset) {

			p_envelope_ctrl->terminated=true;
			p_envelope_ctrl->pos_index=p_envelope->node[p_envelope->node_count-1].tick_offset;
			if (p_envelope->node[p_envelope->node_count-1].value==0) p_envelope_ctrl->kill=true;
		}

	} else {

		if (p_envelope->is_signed()) {
	
			p_envelope_ctrl->value=0;
		} else {

			p_envelope_ctrl->value=p_envelope->get_max();
		}
		
	}
}
