;;;; process.scm - Run subprocess and connect to it's std I/O
;
; Copyright (c) 2000-2002, Felix L. Winkelmann
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following
; conditions are met:
;
;   Redistributions of source code must retain the above copyright notice, this list of conditions and the following
;     disclaimer. 
;   Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
;     disclaimer in the documentation and/or other materials provided with the distribution. 
;   Neither the name of the author nor the names of its contributors may be used to endorse or promote
;     products derived from this software without specific prior written permission. 
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
; OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
; AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
; CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
; THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
; OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
; POSSIBILITY OF SUCH DAMAGE.
;
; Send bugs, suggestions and ideas to: 
;
; felix@call-with-current-continuation.org
;
; Felix L. Winkelmann
; Steinweg 1A
; 37130 Gleichen, OT Weissenborn
; Germany


(declare (uses extras unistd))


(define (process cmd)
  (let-values ([(in1 out1) (create-pipe)])
    (let-values ([(in2 out2) (create-pipe)])
      (let ([pid
	     (process-fork
	      (lambda ()
		(file-close out1)
		(file-close in2)
		(unless (= fileno/stdin in1)
		  (duplicate-fileno in1 fileno/stdin)
		  (file-close in1) )
		(unless (= fileno/stdout out2)
		  (duplicate-fileno out2 fileno/stdout)
		  (file-close out2) )
		(process-execute cmd) ) ) ] )
	(file-close in1)
	(file-close out2)
	(values
	 (let ([buf (make-string 256)]
	       [len 0]
	       [pos 0] )
	   (define (fetch)
	     (when (>= pos len)
	       (set! len (nth-value 1 (file-read in2 256 buf)))
	       (set! pos 0) ) )
	   (make-input-port
	    (lambda ()
	      (fetch)
	      (if (>= pos len)
		  (end-of-file)
		  (let ([p pos])
		    (set! pos (add1 pos))
		    (string-ref buf p) ) ) )
	    (lambda () #t)
	    (lambda () (file-close in2)) ) )
	 (make-output-port
	  (lambda (s) (file-write out1 s))
	  (lambda () (file-close out1)) )
	 pid) ) ) ) )


(cond-expand [(not use-modules)])

(define-module process
  (unqualified)
  (export process) )
