/* scheme-srfi-7.c - Small stub that invokes the Chicken interpreter - felix 
   
   Usage: scheme-srfi-7 SCRIPTFILENAME ARGUMENT1 ...

   - Runs 'csi' with the given arguments like this:

     csi -quiet -batch -hygienic -srfi-7 SCRIPTFILENAME -no-init -strict -eval "(##sys#script-main 12)" -- ARGUMENT1 ...
*/


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>


#define PREFIX_ARGS        11
#define SCRIPT_ARG         5
#define CMD_PARAMETER      "(##sys#script-main 5 12)"


int main(int argc, char *argv[])
{
  char *argsin[] = { "csi", 
		     "-quiet", "-batch", "-hygienic", "-srfi-7",
		     "",
		     "-no-init", "-strict",
		     "-eval", CMD_PARAMETER,
		     "--" },
       **args = (char **)malloc(argc + 12);
  int i;

  if(args == NULL) {
    fprintf(stderr, "%s: out of memory\n", argv[ 0 ]);
    exit(1);
  }

  if(argc < 2) {
    fprintf(stderr, "%s: no script to run\n", argv[ 0 ]);
    exit(1);
  }

  for(i = 0; i < PREFIX_ARGS; ++i)
    args[ i ] = argsin[ i ];

  for(i = 1; i < argc; ++i)
    args[ i + PREFIX_ARGS - 1 ] = argv[ i ];

  args[ SCRIPT_ARG ] = argv[ 1 ];
  args[ argc + PREFIX_ARGS - 1 ] = NULL;
  i = execvp("csi", args);
  fprintf(stderr, "%s: can not execute interpreter: %s\n", argv[ 0 ], strerror(errno));
  exit(1);
}
