/* Generated from src/unistd.scm by the CHICKEN compiler, Version 0, Build 990 g
   Command line: src/unistd.scm -optimize-level 2 -quiet -:h96m -explicit-use -unsafe -feature unsafe -output-file src/uunistd.c
   Unit: unistd
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>
#include <sys/mman.h>
#include <time.h>

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANONYMOUS
# define MAP_ANONYMOUS    0
#endif

extern char **environ;

static char *C_exec_args[ ARG_MAX ];
static struct utsname C_utsname;
static struct flock C_flock;
static DIR *temphandle;
static struct dirent *finddata;
static struct passwd *C_user;
static int C_pipefds[ 2 ];
static time_t C_secs;
static struct tm C_tm;
static fd_set C_fd_sets[ 2 ];
static struct timeval C_timeval;
static char C_hostbuf[ 256 ];

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))
#define C_findfirst(str)    (temphandle = opendir(C_c_string(str)), ((temphandle && (finddata = readdir(temphandle))) ? C_fix(temphandle) : C_SCHEME_FALSE))
#define C_findnext(h)       C_mk_bool(finddata = readdir((DIR *)C_unfix(h)))
#define C_foundfile(buf)    (strcpy(C_c_string(buf), finddata->d_name), C_fix(strlen(finddata->d_name)))
#define C_findclose(h)      (closedir((DIR *)C_unfix(h)), C_SCHEME_UNDEFINED)
#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_fork              fork
#define C_set_exec_arg(i, a) (C_exec_args[ i ] = (a))
#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_fdopen            fdopen
#define C_fileno(p)         C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_alarm             alarm
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_getenventry(i)    environ[ i ]
#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))

#ifdef C_GNU_ENV
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
static C_word C_fcall C_setenv(C_word x, C_word y);
C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);				       
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

#if defined(__FreeBSD__) || defined(__NetBSD__)
static int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigprocmask(d)    C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open((char *)C_data_pointer(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)    FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd) FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd) FD_ISSET(fd, &C_fd_sets[ i ])
#define C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_select_t(m, t)    (C_timeval.tv_sec = C_unfix(t), C_timeval.tv_usec = 0, C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if !defined(C_GNU_ENV)
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), asctime(&C_tm) )
#else
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), asctime(&C_tm) )
#endif

C_extern void C_regex_toplevel(int c,C_word d,C_word k) C_noret;

static C_word lf[325];


#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub702(C_word C_buf) C_regparm;
static C_word C_fcall stub702(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);
            else return(C_hostbuf);
C_return:
return C_r;
#undef return
}

static C_word C_fcall stub695(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub695(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

static C_word C_fcall stub681(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub681(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

static C_word C_fcall stub675(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub675(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
_exit(t0);
return C_r;}

static C_word C_fcall stub664(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub664(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

static C_word C_fcall stub655(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub655(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

static C_word C_fcall stub643(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub643(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=C_c_pointer_or_null(C_a0);
int t1=C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

static C_word C_fcall stub619(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
static C_word C_fcall stub619(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=C_c_pointer_or_null(C_a0);
int t1=C_num_to_int(C_a1);
int t2=C_unfix(C_a2);
int t3=C_unfix(C_a3);
int t4=C_unfix(C_a4);
int t5=C_num_to_int(C_a5);
C_r=C_mpointer(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

static C_word C_fcall stub601(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub601(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

static C_word C_fcall stub510(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub510(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
char * t1=C_string_or_null(C_a1);
C_r=C_mpointer(&C_a,(void*)C_fdopen(t0,t1));
return C_r;}

static C_word C_fcall stub474(C_word C_buf) C_regparm;
static C_word C_fcall stub474(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

static C_word C_fcall stub472(C_word C_buf) C_regparm;
static C_word C_fcall stub472(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

static C_word C_fcall stub470(C_word C_buf) C_regparm;
static C_word C_fcall stub470(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

static C_word C_fcall stub468(C_word C_buf) C_regparm;
static C_word C_fcall stub468(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

static C_word C_fcall stub440(C_word C_buf) C_regparm;
static C_word C_fcall stub440(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

static C_word C_fcall stub438(C_word C_buf) C_regparm;
static C_word C_fcall stub438(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

static C_word C_fcall stub404(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub404(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
char * t1=C_string_or_null(C_a1);
C_r=C_fix((C_word)C_set_exec_arg(t0,t1));
return C_r;}

static C_word C_fcall stub395(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub395(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
_exit(t0);
return C_r;}

static C_word C_fcall stub390(C_word C_buf) C_regparm;
static C_word C_fcall stub390(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

static C_word C_fcall stub42(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub42(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
int t1=C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

static C_word C_fcall stub36(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub36(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
int t1=C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

static C_word C_fcall stub31(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub31(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

C_extern void C_unistd_toplevel(int c,C_word t0,C_word t1) C_noret;
static void f876(int c,C_word t0,C_word t1) C_noret;
static void f879(int c,C_word t0,C_word t1) C_noret;
static void f3711(int c,C_word t0,C_word t1) C_noret;
static void f1651(int c,C_word t0,C_word t1) C_noret;
static void f1663(int c,C_word t0,C_word t1) C_noret;
static void f1666(int c,C_word t0,C_word t1) C_noret;
static void f1848(int c,C_word t0,C_word t1) C_noret;
static void f3707(int c,C_word t0,C_word t1) C_noret;
static void f1851(int c,C_word t0,C_word t1) C_noret;
static void f1854(int c,C_word t0,C_word t1) C_noret;
static void f1857(int c,C_word t0,C_word t1) C_noret;
static void f2238(int c,C_word t0,C_word t1) C_noret;
static void f3699(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2324(int c,C_word t0,C_word t1) C_noret;
static void f2872(int c,C_word t0,C_word t1) C_noret;
static void f3680(int c,C_word t0,C_word t1) C_noret;
static void f3676(int c,C_word t0,C_word t1) C_noret;
static void f3684(int c,C_word t0,C_word t1) C_noret;
static void f3690(int c,C_word t0,C_word t1) C_noret;
static void f3687(int c,C_word t0,C_word t1) C_noret;
static void f3656(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3667(int c,C_word t0,C_word t1) C_noret;
static void f3660(int c,C_word t0,C_word t1) C_noret;
static void f3652(int c,C_word t0,C_word t1) C_noret;
static void f3632(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3636(int c,C_word t0,C_word t1) C_noret;
static void f3585(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f3585r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f3592(int c,C_word t0,C_word t1) C_noret;
static void f3606(int c,C_word t0,C_word t1) C_noret;
static void f3582(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3563(int c,C_word t0,C_word t1,...) C_noret;
static void f3563r(C_word t0,C_word t1,C_word t3) C_noret;
static void f3567(int c,C_word t0,C_word t1) C_noret;
static void f3533(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3540(int c,C_word t0,C_word t1) C_noret;
static void f3529(int c,C_word t0,C_word t1) C_noret;
static void f3543(int c,C_word t0,C_word t1) C_noret;
static void f3546(int c,C_word t0,C_word t1) C_noret;
static void f3513(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3509(int c,C_word t0,C_word t1) C_noret;
static void f3517(int c,C_word t0,C_word t1) C_noret;
static void f3520(int c,C_word t0,C_word t1) C_noret;
static void f3499(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3493(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3458(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3458r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3454(int c,C_word t0,C_word t1) C_noret;
static void f3471(int c,C_word t0,C_word t1) C_noret;
static void f3397(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
static void f3397r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
static void f3401(int c,C_word t0,C_word t1) C_noret;
static void f3407(int c,C_word t0,C_word t1) C_noret;
static void f3389(int c,C_word t0,C_word t1) C_noret;
static void f3393(int c,C_word t0,C_word t1) C_noret;
static void f3429(int c,C_word t0,C_word t1) C_noret;
static void f3422(int c,C_word t0,C_word t1) C_noret;
static void f3413(int c,C_word t0,C_word t1) C_noret;
static void f3311(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f3317(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f3307(int c,C_word t0,C_word t1) C_noret;
static void f3321(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f3329(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f3355(int c,C_word t0,C_word t1) C_noret;
static void f3359(int c,C_word t0,C_word t1) C_noret;
static void f3347(int c,C_word t0,C_word t1) C_noret;
static void f3296(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3301(int c,C_word t0,C_word t1) C_noret;
static void f3293(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f3271(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3275(int c,C_word t0,C_word t1) C_noret;
static void f3278(int c,C_word t0,C_word t1) C_noret;
static void f3235(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3235r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f3239(C_word t0,C_word t1) C_c_regparm C_noret;
static void f3256(int c,C_word t0,C_word t1) C_noret;
static void f3248(int c,C_word t0,C_word t1) C_noret;
static void f3207(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3225(int c,C_word t0,C_word t1) C_noret;
static void f3180(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3180r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3184(int c,C_word t0,C_word t1) C_noret;
static void f3165(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3165r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3169(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f3144(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f3148(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f3079(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void C_fcall f3101(C_word t0,C_word t1) C_c_regparm C_noret;
static void f3044(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f3068(int c,C_word t0,C_word t1) C_noret;
static void f3061(int c,C_word t0,C_word t1) C_noret;
static void f3054(int c,C_word t0,C_word t1) C_noret;
static void f3020(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3020r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f3024(C_word t0,C_word t1) C_c_regparm C_noret;
static void f3033(int c,C_word t0,C_word t1) C_noret;
static void f3027(int c,C_word t0,C_word t1) C_noret;
static void f3001(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3006(int c,C_word t0,C_word t1) C_noret;
static void f3015(int c,C_word t0,C_word t1) C_noret;
static void f3009(int c,C_word t0,C_word t1) C_noret;
static void f2987(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2999(int c,C_word t0,C_word t1) C_noret;
static void f2995(int c,C_word t0,C_word t1) C_noret;
static void f2973(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2973r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2985(int c,C_word t0,C_word t1) C_noret;
static void f2981(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f2940(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f2944(int c,C_word t0,C_word t1) C_noret;
static void f2956(int c,C_word t0,C_word t1) C_noret;
static void f2959(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f2910(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void C_fcall f2897(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f2901(int c,C_word t0,C_word t1) C_noret;
static void f2905(int c,C_word t0,C_word t1) C_noret;
static void f2873(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2878(int c,C_word t0,C_word t1) C_noret;
static void f2890(int c,C_word t0,C_word t1) C_noret;
static void f2881(int c,C_word t0,C_word t1) C_noret;
static void f2846(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2864(int c,C_word t0,C_word t1) C_noret;
static void f2868(int c,C_word t0,C_word t1) C_noret;
static void f2856(int c,C_word t0,C_word t1) C_noret;
static void f2828(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2832(int c,C_word t0,C_word t1) C_noret;
static void f2835(int c,C_word t0,C_word t1) C_noret;
static void f2822(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2822r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2816(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2816r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2810(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2810r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f2760(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_c_regparm C_noret;
static void f2784(int c,C_word t0,C_word t1) C_noret;
static void f2781(int c,C_word t0,C_word t1) C_noret;
static void f2773(int c,C_word t0,C_word t1) C_noret;
static void f2745(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2755(int c,C_word t0,C_word t1) C_noret;
static void f2742(int c,C_word t0,C_word t1) C_noret;
static void f2739(int c,C_word t0,C_word t1) C_noret;
static void f2736(int c,C_word t0,C_word t1) C_noret;
static void f2733(int c,C_word t0,C_word t1) C_noret;
static void f2713(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2731(int c,C_word t0,C_word t1) C_noret;
static void f2723(int c,C_word t0,C_word t1) C_noret;
static void f2693(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2711(int c,C_word t0,C_word t1) C_noret;
static void f2703(int c,C_word t0,C_word t1) C_noret;
static void f2633(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2670(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f2637(C_word t0,C_word t1) C_c_regparm C_noret;
static void f2647(int c,C_word t0,C_word t1) C_noret;
static void f2651(int c,C_word t0,C_word t1) C_noret;
static void f2655(int c,C_word t0,C_word t1) C_noret;
static void f2659(int c,C_word t0,C_word t1) C_noret;
static void f2663(int c,C_word t0,C_word t1) C_noret;
static void f2595(int c,C_word t0,C_word t1) C_noret;
static void f2628(int c,C_word t0,C_word t1) C_noret;
static void f2599(int c,C_word t0,C_word t1) C_noret;
static void f2606(int c,C_word t0,C_word t1) C_noret;
static void f2610(int c,C_word t0,C_word t1) C_noret;
static void f2614(int c,C_word t0,C_word t1) C_noret;
static void f2618(int c,C_word t0,C_word t1) C_noret;
static void f2622(int c,C_word t0,C_word t1) C_noret;
static void f2551(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2551r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2558(int c,C_word t0,C_word t1) C_noret;
static void f2573(int c,C_word t0,C_word t1) C_noret;
static void f2527(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2527r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2534(int c,C_word t0,C_word t1) C_noret;
static void f2524(int c,C_word t0,C_word t1) C_noret;
static void f2521(int c,C_word t0,C_word t1) C_noret;
static void f2445(int c,C_word t0,C_word t1,...) C_noret;
static void f2445r(C_word t0,C_word t1,C_word t3) C_noret;
static void f2473(int c,C_word t0,C_word t1) C_noret;
static void f2378(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2378r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2437(int c,C_word t0,C_word t1) C_noret;
static void f2385(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f2390(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f2422(int c,C_word t0,C_word t1) C_noret;
static void f2400(int c,C_word t0,C_word t1) C_noret;
static void f2404(int c,C_word t0,C_word t1) C_noret;
static void f2407(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f2369(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f2374(int c,C_word t0,C_word t1) C_noret;
static void f2328(int c,C_word t0,C_word t1,...) C_noret;
static void f2328r(C_word t0,C_word t1,C_word t3) C_noret;
static void f2335(int c,C_word t0,C_word t1) C_noret;
static void f2353(int c,C_word t0,C_word t1) C_noret;
static void f2357(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2302(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2320(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2306(int c,C_word t0,C_word t1) C_noret;
static void f2315(int c,C_word t0,C_word t1) C_noret;
static void f2284(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2294(int c,C_word t0,C_word t1) C_noret;
static void f2240(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f2240r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void C_fcall f2258(C_word t0,C_word t1) C_c_regparm C_noret;
static void f2259(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2265(int c,C_word t0,C_word t1) C_noret;
static void f2103(int c,C_word t0,C_word t1,...) C_noret;
static void f2103r(C_word t0,C_word t1,C_word t3) C_noret;
static void C_fcall f2109(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f2130(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2206(int c,C_word t0,C_word t1) C_noret;
static void f2134(int c,C_word t0,C_word t1) C_noret;
static void f2141(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f2143(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f2160(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f2164(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f2172(int c,C_word t0,C_word t1) C_noret;
static void f2176(int c,C_word t0,C_word t1) C_noret;
static void f2124(int c,C_word t0,C_word t1) C_noret;
static void f2041(int c,C_word t0,C_word t1,...) C_noret;
static void f2041r(C_word t0,C_word t1,C_word t3) C_noret;
static void f2045(int c,C_word t0,C_word t1) C_noret;
static void f2095(int c,C_word t0,C_word t1) C_noret;
static void f2048(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f2056(C_word t0,C_word t1) C_c_regparm C_noret;
static void f2086(int c,C_word t0,C_word t1) C_noret;
static void f2082(int c,C_word t0,C_word t1) C_noret;
static void f2063(int c,C_word t0,C_word t1) C_noret;
static void f2069(int c,C_word t0,C_word t1) C_noret;
static void f2077(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2023(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2035(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2029(int c,C_word t0,C_word t1) C_noret;
static void f2005(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2017(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2011(int c,C_word t0,C_word t1) C_noret;
static void f1987(int c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f1999(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f1993(int c,C_word t0,C_word t1) C_noret;
static void f1969(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1981(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f1975(int c,C_word t0,C_word t1) C_noret;
static void f1951(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1963(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f1957(int c,C_word t0,C_word t1) C_noret;
static void f1936(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1948(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f1942(int c,C_word t0,C_word t1) C_noret;
static void f1921(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1933(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f1927(int c,C_word t0,C_word t1) C_noret;
static void f1906(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1918(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f1912(int c,C_word t0,C_word t1) C_noret;
static void f1858(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1862(int c,C_word t0,C_word t1) C_noret;
static void f1887(int c,C_word t0,C_word t1) C_noret;
static void f1802(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1802r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1810(int c,C_word t0,C_word t1) C_noret;
static void f1826(int c,C_word t0,C_word t1) C_noret;
static void f1816(int c,C_word t0,C_word t1) C_noret;
static void f1698(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1698r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1702(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f1708(C_word t0,C_word t1) C_c_regparm C_noret;
static void C_fcall f1742(C_word t0,C_word t1) C_c_regparm C_noret;
static void C_fcall f1722(C_word t0,C_word t1) C_c_regparm C_noret;
static void C_fcall f1668(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void C_fcall f1674(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f1692(int c,C_word t0,C_word t1) C_noret;
static void f1652(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1660(int c,C_word t0,C_word t1) C_noret;
static void f1631(int c,C_word t0,C_word t1) C_noret;
static void f1644(int c,C_word t0,C_word t1) C_noret;
static void f1635(int c,C_word t0,C_word t1) C_noret;
static void f1611(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1611r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1615(int c,C_word t0,C_word t1) C_noret;
static void f1621(int c,C_word t0,C_word t1,...) C_noret;
static void f1621r(C_word t0,C_word t1,C_word t3) C_noret;
static void f1625(int c,C_word t0,C_word t1) C_noret;
static void f1591(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1591r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1595(int c,C_word t0,C_word t1) C_noret;
static void f1601(int c,C_word t0,C_word t1,...) C_noret;
static void f1601r(C_word t0,C_word t1,C_word t3) C_noret;
static void f1605(int c,C_word t0,C_word t1) C_noret;
static void f1567(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1567r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1571(int c,C_word t0,C_word t1) C_noret;
static void f1582(int c,C_word t0,C_word t1,...) C_noret;
static void f1582r(C_word t0,C_word t1,C_word t3) C_noret;
static void f1586(int c,C_word t0,C_word t1) C_noret;
static void f1576(int c,C_word t0,C_word t1) C_noret;
static void f1543(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1543r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1547(int c,C_word t0,C_word t1) C_noret;
static void f1558(int c,C_word t0,C_word t1,...) C_noret;
static void f1558r(C_word t0,C_word t1,C_word t3) C_noret;
static void f1562(int c,C_word t0,C_word t1) C_noret;
static void f1552(int c,C_word t0,C_word t1) C_noret;
static void f1527(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1531(int c,C_word t0,C_word t1) C_noret;
static void f1494(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f1494r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f1522(int c,C_word t0,C_word t1) C_noret;
static void f1512(int c,C_word t0,C_word t1) C_noret;
static void f1505(int c,C_word t0,C_word t1) C_noret;
static void f1461(int c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f1461r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f1489(int c,C_word t0,C_word t1) C_noret;
static void f1479(int c,C_word t0,C_word t1) C_noret;
static void f1472(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f1428(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f1432(int c,C_word t0,C_word t1) C_noret;
static void f1444(int c,C_word t0,C_word t1) C_noret;
static void f1447(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f1422(C_word t0,C_word t1) C_c_regparm C_noret;
static C_word C_fcall f1410(C_word t0) C_c_regparm;
static void f1392(int c,C_word t0,C_word t1) C_noret;
static void f1396(int c,C_word t0,C_word t1) C_noret;
static void f1399(int c,C_word t0,C_word t1) C_noret;
static void f1376(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1380(int c,C_word t0,C_word t1) C_noret;
static void f1341(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1345(int c,C_word t0,C_word t1) C_noret;
static void f1349(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f1357(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1361(int c,C_word t0,C_word t1) C_noret;
static void f1371(int c,C_word t0,C_word t1) C_noret;
static void f1321(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1339(int c,C_word t0,C_word t1) C_noret;
static void f1331(int c,C_word t0,C_word t1) C_noret;
static void f1301(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1319(int c,C_word t0,C_word t1) C_noret;
static void f1311(int c,C_word t0,C_word t1) C_noret;
static void f1281(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1299(int c,C_word t0,C_word t1) C_noret;
static void f1291(int c,C_word t0,C_word t1) C_noret;
static void f1232(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1232r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1239(int c,C_word t0,C_word t1) C_noret;
static void f1258(int c,C_word t0,C_word t1) C_noret;
static void f1245(int c,C_word t0,C_word t1) C_noret;
static void f1248(int c,C_word t0,C_word t1) C_noret;
static void f1198(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1221(int c,C_word t0,C_word t1) C_noret;
static void f1202(int c,C_word t0,C_word t1) C_noret;
static void f1211(int c,C_word t0,C_word t1) C_noret;
static void f1205(int c,C_word t0,C_word t1) C_noret;
static void f1180(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1184(int c,C_word t0,C_word t1) C_noret;
static void f1187(int c,C_word t0,C_word t1) C_noret;
static void f1162(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1166(int c,C_word t0,C_word t1) C_noret;
static void f1169(int c,C_word t0,C_word t1) C_noret;
static void f1144(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1148(int c,C_word t0,C_word t1) C_noret;
static void f1151(int c,C_word t0,C_word t1) C_noret;
static void f1036(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1036r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1128(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1049(int c,C_word t0,C_word t1) C_noret;
static void f1121(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1052(int c,C_word t0,C_word t1) C_noret;
static void C_fcall f1055(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1100(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1079(int c,C_word t0,C_word t1) C_noret;
static void f1087(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1082(int c,C_word t0,C_word t1) C_noret;
static void f1064(int c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f1034(C_word t0,C_word t1) C_c_regparm;
static C_word C_fcall f1032(C_word t0,C_word t1) C_c_regparm;
static C_word C_fcall f1030(C_word t0) C_c_regparm;
static void f994(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f994r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f998(int c,C_word t0,C_word t1) C_noret;
static void f1010(int c,C_word t0,C_word t1) C_noret;
static void f1004(int c,C_word t0,C_word t1) C_noret;
static void f955(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f955r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f959(int c,C_word t0,C_word t1) C_noret;
static void f962(int c,C_word t0,C_word t1) C_noret;
static void f974(int c,C_word t0,C_word t1) C_noret;
static void f965(int c,C_word t0,C_word t1) C_noret;
static void f940(int c,C_word t0,C_word t1,C_word t2) C_noret;
static void f950(int c,C_word t0,C_word t1) C_noret;
static void f912(int c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f912r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f920(int c,C_word t0,C_word t1) C_noret;
static void f929(int c,C_word t0,C_word t1) C_noret;
static void f923(int c,C_word t0,C_word t1) C_noret;

static void C_fcall trf3317(void *dummy) C_regparm C_noret;
static void C_fcall trf3317(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f3317(t0,t1,t2);}

static void C_fcall trf3329(void *dummy) C_regparm C_noret;
static void C_fcall trf3329(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f3329(t0,t1,t2);}

static void C_fcall trf3239(void *dummy) C_regparm C_noret;
static void C_fcall trf3239(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f3239(t0,t1);}

static void C_fcall trf3144(void *dummy) C_regparm C_noret;
static void C_fcall trf3144(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f3144(t0,t1,t2);}

static void C_fcall trf3079(void *dummy) C_regparm C_noret;
static void C_fcall trf3079(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f3079(t0,t1,t2);}

static void C_fcall trf3101(void *dummy) C_regparm C_noret;
static void C_fcall trf3101(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f3101(t0,t1);}

static void C_fcall trf3024(void *dummy) C_regparm C_noret;
static void C_fcall trf3024(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f3024(t0,t1);}

static void C_fcall trf2940(void *dummy) C_regparm C_noret;
static void C_fcall trf2940(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f2940(t0,t1,t2,t3);}

static void C_fcall trf2910(void *dummy) C_regparm C_noret;
static void C_fcall trf2910(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f2910(t0,t1,t2);}

static void C_fcall trf2897(void *dummy) C_regparm C_noret;
static void C_fcall trf2897(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f2897(t0,t1,t2);}

static void C_fcall trf2760(void *dummy) C_regparm C_noret;
static void C_fcall trf2760(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f2760(t0,t1,t2,t3,t4);}

static void C_fcall trf2637(void *dummy) C_regparm C_noret;
static void C_fcall trf2637(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f2637(t0,t1);}

static void C_fcall trf2390(void *dummy) C_regparm C_noret;
static void C_fcall trf2390(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f2390(t0,t1,t2,t3);}

static void C_fcall trf2369(void *dummy) C_regparm C_noret;
static void C_fcall trf2369(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f2369(t0,t1,t2);}

static void C_fcall trf2258(void *dummy) C_regparm C_noret;
static void C_fcall trf2258(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f2258(t0,t1);}

static void C_fcall trf2109(void *dummy) C_regparm C_noret;
static void C_fcall trf2109(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f2109(t0,t1,t2);}

static void C_fcall trf2143(void *dummy) C_regparm C_noret;
static void C_fcall trf2143(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f2143(t0,t1,t2);}

static void C_fcall trf2164(void *dummy) C_regparm C_noret;
static void C_fcall trf2164(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f2164(t0,t1,t2);}

static void C_fcall trf2056(void *dummy) C_regparm C_noret;
static void C_fcall trf2056(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f2056(t0,t1);}

static void C_fcall trf1708(void *dummy) C_regparm C_noret;
static void C_fcall trf1708(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1708(t0,t1);}

static void C_fcall trf1742(void *dummy) C_regparm C_noret;
static void C_fcall trf1742(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1742(t0,t1);}

static void C_fcall trf1722(void *dummy) C_regparm C_noret;
static void C_fcall trf1722(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1722(t0,t1);}

static void C_fcall trf1668(void *dummy) C_regparm C_noret;
static void C_fcall trf1668(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f1668(t0,t1,t2);}

static void C_fcall trf1674(void *dummy) C_regparm C_noret;
static void C_fcall trf1674(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f1674(t0,t1,t2);}

static void C_fcall trf1428(void *dummy) C_regparm C_noret;
static void C_fcall trf1428(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f1428(t0,t1,t2,t3);}

static void C_fcall trf1422(void *dummy) C_regparm C_noret;
static void C_fcall trf1422(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1422(t0,t1);}

static void C_fcall trf1357(void *dummy) C_regparm C_noret;
static void C_fcall trf1357(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1357(t0,t1);}

static void C_fcall trf1055(void *dummy) C_regparm C_noret;
static void C_fcall trf1055(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1055(t0,t1);}

static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n*3);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

static int toplevel_initialized=0;
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
static void C_fcall toplevel_trampoline(void *dummy){
C_unistd_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_unistd_toplevel(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("unistd_toplevel"));
if(!C_demand(3)){
C_save(t1);
C_reclaim(toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(4010)) C_bad_memory_2();
a=C_alloc(3);
lf[0]=C_intern(C_heaptop,15,"c-1009994854321");
lf[1]=C_string(C_heaptop,28,"too many optional arguments.");
lf[2]=C_intern(C_heaptop,8,"pipe/buf");
lf[3]=C_intern(C_heaptop,11,"open/rdonly");
lf[4]=C_intern(C_heaptop,11,"open/wronly");
lf[5]=C_intern(C_heaptop,9,"open/rdwr");
lf[6]=C_intern(C_heaptop,9,"open/read");
lf[7]=C_intern(C_heaptop,10,"open/write");
lf[8]=C_intern(C_heaptop,10,"open/creat");
lf[9]=C_intern(C_heaptop,11,"open/append");
lf[10]=C_intern(C_heaptop,9,"open/excl");
lf[11]=C_intern(C_heaptop,11,"open/noctty");
lf[12]=C_intern(C_heaptop,13,"open/nonblock");
lf[13]=C_intern(C_heaptop,10,"open/trunc");
lf[14]=C_intern(C_heaptop,9,"open/sync");
lf[15]=C_intern(C_heaptop,10,"perm/irusr");
lf[16]=C_intern(C_heaptop,10,"perm/iwusr");
lf[17]=C_intern(C_heaptop,10,"perm/ixusr");
lf[18]=C_intern(C_heaptop,10,"perm/irgrp");
lf[19]=C_intern(C_heaptop,10,"perm/iwgrp");
lf[20]=C_intern(C_heaptop,10,"perm/ixgrp");
lf[21]=C_intern(C_heaptop,10,"perm/iroth");
lf[22]=C_intern(C_heaptop,10,"perm/iwoth");
lf[23]=C_intern(C_heaptop,10,"perm/ixoth");
lf[24]=C_intern(C_heaptop,10,"perm/irwxu");
lf[25]=C_intern(C_heaptop,10,"perm/irwxg");
lf[26]=C_intern(C_heaptop,10,"perm/irwxo");
lf[27]=C_intern(C_heaptop,10,"perm/isvtx");
lf[28]=C_intern(C_heaptop,10,"perm/isuid");
lf[29]=C_intern(C_heaptop,10,"perm/isgid");
lf[30]=C_intern(C_heaptop,9,"file-open");
lf[31]=C_intern(C_heaptop,15,"\003syssignal-hook");
lf[32]=C_intern(C_heaptop,11,"\000file-error");
lf[33]=C_string(C_heaptop,17,"can not open file");
lf[34]=C_intern(C_heaptop,16,"\003sysupdate-errno");
lf[35]=C_intern(C_heaptop,17,"\003sysmake-c-string");
lf[36]=C_intern(C_heaptop,10,"file-close");
lf[37]=C_string(C_heaptop,18,"can not close file");
lf[38]=C_intern(C_heaptop,11,"make-string");
lf[39]=C_intern(C_heaptop,9,"file-read");
lf[40]=C_string(C_heaptop,22,"can not read from file");
lf[41]=C_intern(C_heaptop,11,"\000type-error");
lf[42]=C_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[43]=C_intern(C_heaptop,10,"file-write");
lf[44]=C_string(C_heaptop,21,"can not write to file");
lf[45]=C_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[46]=C_intern(C_heaptop,11,"file-select");
lf[47]=C_string(C_heaptop,28,"call to `file-select\047 failed");
lf[48]=C_intern(C_heaptop,12,"\003sysfor-each");
lf[49]=C_intern(C_heaptop,8,"seek/set");
lf[50]=C_intern(C_heaptop,8,"seek/end");
lf[51]=C_intern(C_heaptop,8,"seek/cur");
lf[52]=C_intern(C_heaptop,9,"file-size");
lf[53]=C_string(C_heaptop,19,"can not access file");
lf[54]=C_intern(C_heaptop,13,"\003sysfile-info");
lf[55]=C_intern(C_heaptop,22,"file-modification-time");
lf[56]=C_string(C_heaptop,19,"can not access file");
lf[57]=C_intern(C_heaptop,10,"file-owner");
lf[58]=C_string(C_heaptop,19,"can not access file");
lf[59]=C_intern(C_heaptop,13,"file-position");
lf[60]=C_string(C_heaptop,38,"can not retrieve file position of port");
lf[61]=C_intern(C_heaptop,21,"\003sysport-file-resolve");
lf[62]=C_string(C_heaptop,12,"invalid file");
lf[63]=C_intern(C_heaptop,18,"set-file-position!");
lf[64]=C_string(C_heaptop,25,"can not set file position");
lf[65]=C_string(C_heaptop,12,"invalid file");
lf[66]=C_intern(C_heaptop,9,"\003syserror");
lf[67]=C_string(C_heaptop,30,"invalid negative port position");
lf[68]=C_intern(C_heaptop,16,"create-directory");
lf[69]=C_string(C_heaptop,24,"can not create directory");
lf[70]=C_intern(C_heaptop,16,"change-directory");
lf[71]=C_string(C_heaptop,32,"can not change current directory");
lf[72]=C_intern(C_heaptop,16,"delete-directory");
lf[73]=C_string(C_heaptop,24,"can not delete directory");
lf[74]=C_intern(C_heaptop,9,"substring");
lf[75]=C_intern(C_heaptop,9,"directory");
lf[76]=C_intern(C_heaptop,10,"directory?");
lf[77]=C_intern(C_heaptop,17,"current-directory");
lf[78]=C_string(C_heaptop,33,"can not examine current directory");
lf[79]=C_intern(C_heaptop,5,"\000text");
lf[80]=C_string(C_heaptop,35,"illegal input/output mode specifier");
lf[81]=C_string(C_heaptop,17,"can not open pipe");
lf[82]=C_string(C_heaptop,6,"(pipe)");
lf[83]=C_intern(C_heaptop,13,"\003sysmake-port");
lf[84]=C_intern(C_heaptop,15,"open-input-pipe");
lf[85]=C_intern(C_heaptop,7,"\000binary");
lf[86]=C_intern(C_heaptop,16,"open-output-pipe");
lf[87]=C_intern(C_heaptop,16,"close-input-pipe");
lf[88]=C_string(C_heaptop,24,"error while closing pipe");
lf[89]=C_intern(C_heaptop,17,"close-output-pipe");
lf[90]=C_intern(C_heaptop,20,"call-with-input-pipe");
lf[91]=C_intern(C_heaptop,6,"values");
lf[92]=C_intern(C_heaptop,21,"call-with-output-pipe");
lf[93]=C_intern(C_heaptop,20,"with-input-from-pipe");
lf[94]=C_intern(C_heaptop,18,"\003sysstandard-input");
lf[95]=C_intern(C_heaptop,19,"with-output-to-pipe");
lf[96]=C_intern(C_heaptop,19,"\003sysstandard-output");
lf[97]=C_intern(C_heaptop,11,"create-pipe");
lf[98]=C_string(C_heaptop,19,"can not create pipe");
lf[99]=C_intern(C_heaptop,12,"string-match");
lf[100]=C_intern(C_heaptop,18,"absolute-pathname?");
lf[101]=C_intern(C_heaptop,13,"string-append");
lf[102]=C_string(C_heaptop,0,"");
lf[103]=C_string(C_heaptop,0,"");
lf[104]=C_string(C_heaptop,0,"");
lf[105]=C_string(C_heaptop,0,"");
lf[106]=C_intern(C_heaptop,28,"pathname-extension-separator");
lf[107]=C_intern(C_heaptop,28,"pathname-directory-separator");
lf[108]=C_string(C_heaptop,0,"");
lf[109]=C_string(C_heaptop,0,"");
lf[110]=C_string(C_heaptop,0,"");
lf[111]=C_intern(C_heaptop,13,"make-pathname");
lf[112]=C_intern(C_heaptop,22,"make-absolute-pathname");
lf[113]=C_string(C_heaptop,0,"");
lf[114]=C_intern(C_heaptop,18,"decompose-pathname");
lf[115]=C_intern(C_heaptop,18,"pathname-directory");
lf[116]=C_intern(C_heaptop,13,"pathname-file");
lf[117]=C_intern(C_heaptop,18,"pathname-extension");
lf[118]=C_intern(C_heaptop,24,"pathname-strip-directory");
lf[119]=C_intern(C_heaptop,24,"pathname-strip-extension");
lf[120]=C_intern(C_heaptop,26,"pathname-replace-directory");
lf[121]=C_intern(C_heaptop,3,"dir");
lf[122]=C_intern(C_heaptop,21,"pathname-replace-file");
lf[123]=C_intern(C_heaptop,26,"pathname-replace-extension");
lf[124]=C_intern(C_heaptop,6,"getenv");
lf[125]=C_intern(C_heaptop,12,"file-exists?");
lf[126]=C_intern(C_heaptop,21,"call-with-output-file");
lf[127]=C_intern(C_heaptop,21,"create-temporary-file");
lf[128]=C_string(C_heaptop,3,"tmp");
lf[129]=C_string(C_heaptop,1,"t");
lf[130]=C_string(C_heaptop,3,"TMP");
lf[131]=C_string(C_heaptop,4,"TEMP");
lf[132]=C_string(C_heaptop,6,"TMPDIR");
lf[133]=C_intern(C_heaptop,15,"pattern->regexp");
lf[134]=C_intern(C_heaptop,4,"glob");
lf[135]=C_string(C_heaptop,1,".");
lf[136]=C_string(C_heaptop,1,"*");
lf[137]=C_intern(C_heaptop,11,"signal/term");
lf[138]=C_intern(C_heaptop,11,"signal/kill");
lf[139]=C_intern(C_heaptop,10,"signal/int");
lf[140]=C_intern(C_heaptop,10,"signal/hup");
lf[141]=C_intern(C_heaptop,10,"signal/fpe");
lf[142]=C_intern(C_heaptop,10,"signal/ill");
lf[143]=C_intern(C_heaptop,11,"signal/segv");
lf[144]=C_intern(C_heaptop,11,"signal/abrt");
lf[145]=C_intern(C_heaptop,11,"signal/trap");
lf[146]=C_intern(C_heaptop,11,"signal/quit");
lf[147]=C_intern(C_heaptop,11,"signal/alrm");
lf[148]=C_intern(C_heaptop,13,"signal/vtalrm");
lf[149]=C_intern(C_heaptop,11,"signal/prof");
lf[150]=C_intern(C_heaptop,9,"signal/io");
lf[151]=C_intern(C_heaptop,10,"signal/urg");
lf[152]=C_intern(C_heaptop,11,"signal/chld");
lf[153]=C_intern(C_heaptop,11,"signal/cont");
lf[154]=C_intern(C_heaptop,11,"signal/stop");
lf[155]=C_intern(C_heaptop,11,"signal/tstp");
lf[156]=C_intern(C_heaptop,11,"signal/pipe");
lf[157]=C_intern(C_heaptop,11,"signal/xcpu");
lf[158]=C_intern(C_heaptop,11,"signal/xfsz");
lf[159]=C_intern(C_heaptop,11,"signal/usr1");
lf[160]=C_intern(C_heaptop,11,"signal/usr2");
lf[161]=C_intern(C_heaptop,12,"signal/winch");
lf[162]=C_intern(C_heaptop,18,"\003sysinterrupt-hook");
lf[163]=C_intern(C_heaptop,19,"set-signal-handler!");
lf[164]=C_intern(C_heaptop,16,"\003sysdynamic-wind");
lf[165]=C_intern(C_heaptop,22,"\003sysdisable-interrupts");
lf[166]=C_intern(C_heaptop,21,"\003sysenable-interrupts");
lf[167]=C_intern(C_heaptop,18,"\003syscontext-switch");
lf[168]=C_intern(C_heaptop,16,"set-signal-mask!");
lf[169]=C_string(C_heaptop,23,"can not set signal mask");
lf[170]=C_intern(C_heaptop,12,"process-fork");
lf[171]=C_string(C_heaptop,28,"can not create child process");
lf[172]=C_intern(C_heaptop,15,"process-execute");
lf[173]=C_string(C_heaptop,23,"can not execute process");
lf[174]=C_intern(C_heaptop,12,"process-wait");
lf[175]=C_string(C_heaptop,32,"waiting for child process failed");
lf[176]=C_intern(C_heaptop,5,"error");
lf[177]=C_intern(C_heaptop,18,"current-process-id");
lf[178]=C_intern(C_heaptop,17,"parent-process-id");
lf[179]=C_intern(C_heaptop,14,"process-signal");
lf[180]=C_string(C_heaptop,32,"could not send signal to process");
lf[181]=C_intern(C_heaptop,11,"process-run");
lf[182]=C_string(C_heaptop,7,"/bin/sh");
lf[183]=C_string(C_heaptop,2,"-c");
lf[184]=C_string(C_heaptop,5,"SHELL");
lf[185]=C_intern(C_heaptop,18,"system-information");
lf[186]=C_intern(C_heaptop,17,"\003syspeek-c-string");
lf[187]=C_string(C_heaptop,35,"can not retrieve system information");
lf[188]=C_intern(C_heaptop,16,"user-information");
lf[189]=C_intern(C_heaptop,10,"errno/perm");
lf[190]=C_intern(C_heaptop,11,"errno/noent");
lf[191]=C_intern(C_heaptop,10,"errno/srch");
lf[192]=C_intern(C_heaptop,10,"errno/intr");
lf[193]=C_intern(C_heaptop,8,"errno/io");
lf[194]=C_intern(C_heaptop,12,"errno/noexec");
lf[195]=C_intern(C_heaptop,10,"errno/badf");
lf[196]=C_intern(C_heaptop,11,"errno/child");
lf[197]=C_intern(C_heaptop,11,"errno/nomem");
lf[198]=C_intern(C_heaptop,11,"errno/acces");
lf[199]=C_intern(C_heaptop,11,"errno/fault");
lf[200]=C_intern(C_heaptop,10,"errno/busy");
lf[201]=C_intern(C_heaptop,12,"errno/notdir");
lf[202]=C_intern(C_heaptop,11,"errno/isdir");
lf[203]=C_intern(C_heaptop,11,"errno/inval");
lf[204]=C_intern(C_heaptop,11,"errno/mfile");
lf[205]=C_intern(C_heaptop,11,"errno/nospc");
lf[206]=C_intern(C_heaptop,11,"errno/spipe");
lf[207]=C_intern(C_heaptop,10,"errno/pipe");
lf[208]=C_intern(C_heaptop,11,"errno/again");
lf[209]=C_intern(C_heaptop,10,"errno/rofs");
lf[210]=C_intern(C_heaptop,16,"change-file-mode");
lf[211]=C_string(C_heaptop,24,"can not change file mode");
lf[212]=C_intern(C_heaptop,17,"change-file-owner");
lf[213]=C_string(C_heaptop,25,"can not change file owner");
lf[214]=C_intern(C_heaptop,15,"current-user-id");
lf[215]=C_intern(C_heaptop,16,"current-group-id");
lf[216]=C_intern(C_heaptop,25,"current-effective-user-id");
lf[217]=C_intern(C_heaptop,26,"current-effective-group-id");
lf[218]=C_intern(C_heaptop,12,"set-user-id!");
lf[219]=C_string(C_heaptop,19,"can not set user id");
lf[220]=C_intern(C_heaptop,17,"file-read-access?");
lf[221]=C_intern(C_heaptop,18,"file-write-access?");
lf[222]=C_intern(C_heaptop,20,"file-execute-access?");
lf[223]=C_intern(C_heaptop,16,"file-permissions");
lf[224]=C_string(C_heaptop,31,"can not access file permissions");
lf[225]=C_intern(C_heaptop,20,"create-symbolic-link");
lf[226]=C_string(C_heaptop,28,"can not create symbolic link");
lf[227]=C_intern(C_heaptop,18,"read-symbolic-link");
lf[228]=C_string(C_heaptop,26,"can not read symbolic link");
lf[229]=C_intern(C_heaptop,12,"fileno/stdin");
lf[230]=C_intern(C_heaptop,13,"fileno/stdout");
lf[231]=C_intern(C_heaptop,13,"fileno/stderr");
lf[232]=C_intern(C_heaptop,19,"\003sysallocate-vector");
lf[233]=C_intern(C_heaptop,7,"\000append");
lf[234]=C_string(C_heaptop,1,"a");
lf[235]=C_string(C_heaptop,27,"invalid mode for input file");
lf[236]=C_string(C_heaptop,21,"invalid mode argument");
lf[237]=C_string(C_heaptop,1,"w");
lf[238]=C_string(C_heaptop,1,"r");
lf[239]=C_string(C_heaptop,17,"can not open file");
lf[240]=C_string(C_heaptop,8,"(fdport)");
lf[241]=C_intern(C_heaptop,16,"open-input-file*");
lf[242]=C_intern(C_heaptop,17,"open-output-file*");
lf[243]=C_string(C_heaptop,1,"w");
lf[244]=C_intern(C_heaptop,12,"port->fileno");
lf[245]=C_string(C_heaptop,38,"can not access file-descriptor of port");
lf[246]=C_intern(C_heaptop,16,"duplicate-fileno");
lf[247]=C_string(C_heaptop,33,"can not duplicate file descriptor");
lf[248]=C_intern(C_heaptop,13,"file-truncate");
lf[249]=C_string(C_heaptop,21,"can not truncate file");
lf[250]=C_string(C_heaptop,12,"invalid file");
lf[251]=C_intern(C_heaptop,4,"lock");
lf[252]=C_intern(C_heaptop,9,"file-lock");
lf[253]=C_string(C_heaptop,17,"can not lock file");
lf[254]=C_intern(C_heaptop,14,"file-test-lock");
lf[255]=C_string(C_heaptop,19,"can not unlock file");
lf[256]=C_intern(C_heaptop,11,"file-unlock");
lf[257]=C_string(C_heaptop,19,"can not unlock file");
lf[258]=C_intern(C_heaptop,11,"create-fifo");
lf[259]=C_string(C_heaptop,19,"can not create FIFO");
lf[260]=C_intern(C_heaptop,5,"fifo?");
lf[261]=C_string(C_heaptop,19,"file does not exist");
lf[262]=C_intern(C_heaptop,6,"setenv");
lf[263]=C_intern(C_heaptop,8,"unsetenv");
lf[264]=C_intern(C_heaptop,19,"current-environment");
lf[265]=C_intern(C_heaptop,9,"prot/read");
lf[266]=C_intern(C_heaptop,10,"prot/write");
lf[267]=C_intern(C_heaptop,9,"prot/exec");
lf[268]=C_intern(C_heaptop,9,"prot/none");
lf[269]=C_intern(C_heaptop,9,"map/fixed");
lf[270]=C_intern(C_heaptop,10,"map/shared");
lf[271]=C_intern(C_heaptop,11,"map/private");
lf[272]=C_intern(C_heaptop,13,"map/anonymous");
lf[273]=C_intern(C_heaptop,8,"map/file");
lf[274]=C_intern(C_heaptop,18,"map-file-to-memory");
lf[275]=C_intern(C_heaptop,4,"mmap");
lf[276]=C_string(C_heaptop,26,"can not map file to memory");
lf[277]=C_intern(C_heaptop,20,"\003syspointer->address");
lf[278]=C_intern(C_heaptop,28,"\003sysforeign-pointer-argument");
lf[279]=C_string(C_heaptop,41,"bad argument type - not a foreign pointer");
lf[280]=C_intern(C_heaptop,16,"\003sysnull-pointer");
lf[281]=C_intern(C_heaptop,22,"ummap-file-from-memory");
lf[282]=C_string(C_heaptop,30,"can not unmap file from memory");
lf[283]=C_intern(C_heaptop,19,"seconds->local-time");
lf[284]=C_intern(C_heaptop,18,"\003sysdecode-seconds");
lf[285]=C_intern(C_heaptop,17,"seconds->utc-time");
lf[286]=C_intern(C_heaptop,15,"seconds->string");
lf[287]=C_string(C_heaptop,33,"can not convert seconds to string");
lf[288]=C_intern(C_heaptop,12,"time->string");
lf[289]=C_string(C_heaptop,33,"can not convert seconds to string");
lf[290]=C_intern(C_heaptop,4,"secs");
lf[291]=C_string(C_heaptop,21,"time vector too short");
lf[292]=C_intern(C_heaptop,5,"_exit");
lf[293]=C_intern(C_heaptop,23,"\003syscleanup-before-exit");
lf[294]=C_intern(C_heaptop,10,"set-alarm!");
lf[295]=C_intern(C_heaptop,19,"set-buffering-mode!");
lf[296]=C_string(C_heaptop,26,"can not set buffering mode");
lf[297]=C_intern(C_heaptop,5,"\000full");
lf[298]=C_intern(C_heaptop,5,"\000line");
lf[299]=C_intern(C_heaptop,5,"\000none");
lf[300]=C_string(C_heaptop,22,"invalid buffering-mode");
lf[301]=C_intern(C_heaptop,14,"terminal-port?");
lf[302]=C_intern(C_heaptop,25,"\003syspeek-unsigned-integer");
lf[303]=C_intern(C_heaptop,13,"terminal-name");
lf[304]=C_intern(C_heaptop,2,"fp");
lf[305]=C_string(C_heaptop,35,"port is not connected to a terminal");
lf[306]=C_intern(C_heaptop,13,"get-host-name");
lf[307]=C_string(C_heaptop,26,"can not retrieve host-name");
lf[308]=C_intern(C_heaptop,23,"\003sysuser-interrupt-hook");
lf[309]=C_intern(C_heaptop,11,"make-vector");
lf[310]=C_string(C_heaptop,5,"^(.*[");
lf[311]=C_string(C_heaptop,6,"])?((\134");
lf[312]=C_string(C_heaptop,4,")?[^");
lf[313]=C_string(C_heaptop,4,"]+)$");
lf[314]=C_string(C_heaptop,5,"^(.*[");
lf[315]=C_string(C_heaptop,6,"])?([^");
lf[316]=C_string(C_heaptop,5,"]+)(\134");
lf[317]=C_string(C_heaptop,3,"([^");
lf[318]=C_string(C_heaptop,5,"]+))$");
lf[319]=C_string(C_heaptop,1,"/");
lf[320]=C_intern(C_heaptop,6,"string");
lf[321]=C_string(C_heaptop,14,"([A-Za-z]:)?[/");
lf[322]=C_string(C_heaptop,3,"].+");
lf[323]=C_intern(C_heaptop,17,"register-feature!");
lf[324]=C_intern(C_heaptop,6,"unistd");
C_register_lf(lf,325);
t2=C_mutate((C_word*)lf[0]+1,lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f876,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t3);}

static void f876(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f876);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f879,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[323]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[324]);}

static void f879(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word ab[89],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f879);}
t2=C_mutate((C_word*)lf[2]+1,C_fix((C_word)PIPE_BUF));
t3=C_mutate((C_word*)lf[3]+1,C_fix((C_word)O_RDONLY));
t4=C_mutate((C_word*)lf[4]+1,C_fix((C_word)O_WRONLY));
t5=C_mutate((C_word*)lf[5]+1,C_fix((C_word)O_RDWR));
t6=C_mutate((C_word*)lf[6]+1,C_fix((C_word)O_RDWR));
t7=C_mutate((C_word*)lf[7]+1,C_fix((C_word)O_WRONLY));
t8=C_mutate((C_word*)lf[8]+1,C_fix((C_word)O_CREAT));
t9=C_mutate((C_word*)lf[9]+1,C_fix((C_word)O_CREAT));
t10=C_mutate((C_word*)lf[10]+1,C_fix((C_word)O_CREAT));
t11=C_mutate((C_word*)lf[11]+1,C_fix((C_word)O_CREAT));
t12=C_mutate((C_word*)lf[12]+1,C_fix((C_word)O_CREAT));
t13=C_mutate((C_word*)lf[13]+1,C_fix((C_word)O_CREAT));
t14=C_mutate((C_word*)lf[14]+1,C_fix((C_word)O_CREAT));
t15=C_mutate((C_word*)lf[15]+1,C_fix((C_word)S_IRUSR));
t16=C_mutate((C_word*)lf[16]+1,C_fix((C_word)S_IWUSR));
t17=C_mutate((C_word*)lf[17]+1,C_fix((C_word)S_IXUSR));
t18=C_mutate((C_word*)lf[18]+1,C_fix((C_word)S_IRGRP));
t19=C_mutate((C_word*)lf[19]+1,C_fix((C_word)S_IWGRP));
t20=C_mutate((C_word*)lf[20]+1,C_fix((C_word)S_IXGRP));
t21=C_mutate((C_word*)lf[21]+1,C_fix((C_word)S_IROTH));
t22=C_mutate((C_word*)lf[22]+1,C_fix((C_word)S_IWOTH));
t23=C_mutate((C_word*)lf[23]+1,C_fix((C_word)S_IXOTH));
t24=C_mutate((C_word*)lf[24]+1,C_fix((C_word)S_IRWXU));
t25=C_mutate((C_word*)lf[25]+1,C_fix((C_word)S_IRWXG));
t26=C_mutate((C_word*)lf[26]+1,C_fix((C_word)S_IRWXO));
t27=C_mutate((C_word*)lf[27]+1,C_fix((C_word)S_ISVTX));
t28=C_mutate((C_word*)lf[28]+1,C_fix((C_word)S_ISUID));
t29=C_mutate((C_word*)lf[29]+1,C_fix((C_word)S_ISGID));
t30=(C_word)C_u_fixnum_or(C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t31=(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXU),t30);
t32=C_mutate((C_word*)lf[30]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f912,a[2]=t31,tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[36]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f940,tmp=(C_word)a,a+=2,tmp));
t34=*((C_word*)lf[38]+1);
t35=C_mutate((C_word*)lf[39]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f955,a[2]=t34,tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[43]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f994,tmp=(C_word)a,a+=2,tmp));
t37=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1030,tmp=(C_word)a,a+=2,tmp);
t38=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1032,tmp=(C_word)a,a+=2,tmp);
t39=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1034,tmp=(C_word)a,a+=2,tmp);
t40=C_mutate((C_word*)lf[46]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1036,a[2]=t38,a[3]=t39,a[4]=t37,tmp=(C_word)a,a+=5,tmp));
t41=C_mutate((C_word*)lf[49]+1,C_fix((C_word)SEEK_SET));
t42=C_mutate((C_word*)lf[50]+1,C_fix((C_word)SEEK_END));
t43=C_mutate((C_word*)lf[51]+1,C_fix((C_word)SEEK_CUR));
t44=C_mutate((C_word*)lf[52]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1144,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate((C_word*)lf[55]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1162,tmp=(C_word)a,a+=2,tmp));
t46=C_mutate((C_word*)lf[57]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1180,tmp=(C_word)a,a+=2,tmp));
t47=C_mutate((C_word*)lf[59]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1198,tmp=(C_word)a,a+=2,tmp));
t48=C_mutate((C_word*)lf[63]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1232,tmp=(C_word)a,a+=2,tmp));
t49=C_mutate((C_word*)lf[68]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1281,tmp=(C_word)a,a+=2,tmp));
t50=C_mutate((C_word*)lf[70]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1301,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[72]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1321,tmp=(C_word)a,a+=2,tmp));
t52=*((C_word*)lf[38]+1);
t53=*((C_word*)lf[74]+1);
t54=C_mutate((C_word*)lf[75]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1341,a[2]=t52,a[3]=t53,tmp=(C_word)a,a+=4,tmp));
t55=C_mutate((C_word*)lf[76]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1376,tmp=(C_word)a,a+=2,tmp));
t56=*((C_word*)lf[38]+1);
t57=*((C_word*)lf[74]+1);
t58=C_mutate((C_word*)lf[77]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1392,a[2]=t56,a[3]=t57,tmp=(C_word)a,a+=4,tmp));
t59=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1410,tmp=(C_word)a,a+=2,tmp);
t60=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1422,tmp=(C_word)a,a+=2,tmp);
t61=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1428,tmp=(C_word)a,a+=2,tmp);
t62=C_mutate((C_word*)lf[84]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1461,a[2]=t60,a[3]=t61,a[4]=t59,tmp=(C_word)a,a+=5,tmp));
t63=C_mutate((C_word*)lf[86]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1494,a[2]=t60,a[3]=t61,a[4]=t59,tmp=(C_word)a,a+=5,tmp));
t64=C_mutate((C_word*)lf[87]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1527,tmp=(C_word)a,a+=2,tmp));
t65=C_mutate((C_word*)lf[89]+1,*((C_word*)lf[87]+1));
t66=*((C_word*)lf[84]+1);
t67=*((C_word*)lf[86]+1);
t68=*((C_word*)lf[87]+1);
t69=*((C_word*)lf[89]+1);
t70=C_mutate((C_word*)lf[90]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1543,a[2]=t66,a[3]=t68,tmp=(C_word)a,a+=4,tmp));
t71=C_mutate((C_word*)lf[92]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1567,a[2]=t67,a[3]=t69,tmp=(C_word)a,a+=4,tmp));
t72=C_mutate((C_word*)lf[93]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1591,a[2]=t66,a[3]=t68,tmp=(C_word)a,a+=4,tmp));
t73=C_mutate((C_word*)lf[95]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1611,a[2]=t67,a[3]=t69,tmp=(C_word)a,a+=4,tmp));
t74=C_mutate((C_word*)lf[97]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1631,tmp=(C_word)a,a+=2,tmp));
t75=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1651,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t76=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3711,a[2]=t75,tmp=(C_word)a,a+=3,tmp);
t77=*((C_word*)lf[320]+1);
((C_proc3)(void*)(*((C_word*)t77+1)))(3,t77,t76,*((C_word*)lf[107]+1));}

static void f3711(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[101]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[321],t1,lf[322]);}

static void f1651(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1651);}
t2=*((C_word*)lf[99]+1);
t3=C_mutate((C_word*)lf[100]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1652,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp));
t4=*((C_word*)lf[101]+1);
t5=*((C_word*)lf[100]+1);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1663,a[2]=((C_word*)t0)[2],a[3]=t5,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
t7=*((C_word*)lf[320]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,*((C_word*)lf[107]+1));}

static void f1663(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1663);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1666,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[320]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,*((C_word*)lf[106]+1));}

static void f1666(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1666);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1668,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1698,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=C_mutate((C_word*)lf[111]+1,t3);
t5=C_mutate((C_word*)lf[112]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f1802,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,tmp=(C_word)a,a+=7,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1848,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t7=*((C_word*)lf[320]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,*((C_word*)lf[106]+1));}

static void f1848(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1848);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1851,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3707,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[320]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,*((C_word*)lf[107]+1));}

static void f3707(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[101]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[319],t1);}

static void f1851(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1851);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1854,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[101]+1);
((C_proc12)(void*)(*((C_word*)t3+1)))(12,t3,t2,lf[314],t1,lf[315],t1,lf[316],((C_word*)t0)[2],lf[317],t1,((C_word*)t0)[2],lf[318]);}

static void f1854(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1854);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1857,a[2]=((C_word*)t0)[4],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[101]+1);
((C_proc9)(void*)(*((C_word*)t3+1)))(9,t3,t2,lf[310],((C_word*)t0)[3],lf[311],((C_word*)t0)[2],lf[312],((C_word*)t0)[3],lf[313]);}

static void f1857(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word ab[46],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1857);}
t2=*((C_word*)lf[99]+1);
t3=C_mutate((C_word*)lf[114]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1858,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp));
t4=*((C_word*)lf[114]+1);
t5=C_mutate((C_word*)lf[115]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1906,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[116]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1921,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[117]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1936,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[118]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1951,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[119]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1969,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[120]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1987,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[122]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2005,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[123]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2023,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t13=*((C_word*)lf[124]+1);
t14=*((C_word*)lf[111]+1);
t15=*((C_word*)lf[101]+1);
t16=*((C_word*)lf[125]+1);
t17=*((C_word*)lf[126]+1);
t18=C_mutate((C_word*)lf[127]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2041,a[2]=t13,a[3]=t15,a[4]=t14,a[5]=t16,a[6]=t17,tmp=(C_word)a,a+=7,tmp));
t19=*((C_word*)lf[133]+1);
t20=*((C_word*)lf[75]+1);
t21=*((C_word*)lf[111]+1);
t22=*((C_word*)lf[114]+1);
t23=C_mutate((C_word*)lf[134]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2103,a[2]=t19,a[3]=t20,a[4]=t21,a[5]=t22,tmp=(C_word)a,a+=6,tmp));
t24=C_mutate((C_word*)lf[137]+1,C_fix((C_word)SIGTERM));
t25=C_mutate((C_word*)lf[138]+1,C_fix((C_word)SIGKILL));
t26=C_mutate((C_word*)lf[139]+1,C_fix((C_word)SIGINT));
t27=C_mutate((C_word*)lf[140]+1,C_fix((C_word)SIGHUP));
t28=C_mutate((C_word*)lf[141]+1,C_fix((C_word)SIGFPE));
t29=C_mutate((C_word*)lf[142]+1,C_fix((C_word)SIGILL));
t30=C_mutate((C_word*)lf[143]+1,C_fix((C_word)SIGSEGV));
t31=C_mutate((C_word*)lf[144]+1,C_fix((C_word)SIGABRT));
t32=C_mutate((C_word*)lf[145]+1,C_fix((C_word)SIGTRAP));
t33=C_mutate((C_word*)lf[146]+1,C_fix((C_word)SIGQUIT));
t34=C_mutate((C_word*)lf[147]+1,C_fix((C_word)SIGALRM));
t35=C_mutate((C_word*)lf[148]+1,C_fix((C_word)SIGVTALRM));
t36=C_mutate((C_word*)lf[149]+1,C_fix((C_word)SIGPROF));
t37=C_mutate((C_word*)lf[150]+1,C_fix((C_word)SIGIO));
t38=C_mutate((C_word*)lf[151]+1,C_fix((C_word)SIGURG));
t39=C_mutate((C_word*)lf[152]+1,C_fix((C_word)SIGCHLD));
t40=C_mutate((C_word*)lf[153]+1,C_fix((C_word)SIGCONT));
t41=C_mutate((C_word*)lf[154]+1,C_fix((C_word)SIGSTOP));
t42=C_mutate((C_word*)lf[155]+1,C_fix((C_word)SIGTSTP));
t43=C_mutate((C_word*)lf[156]+1,C_fix((C_word)SIGPIPE));
t44=C_mutate((C_word*)lf[157]+1,C_fix((C_word)SIGXCPU));
t45=C_mutate((C_word*)lf[158]+1,C_fix((C_word)SIGXFSZ));
t46=C_mutate((C_word*)lf[159]+1,C_fix((C_word)SIGUSR1));
t47=C_mutate((C_word*)lf[160]+1,C_fix((C_word)SIGUSR2));
t48=C_mutate((C_word*)lf[161]+1,C_fix((C_word)SIGWINCH));
t49=*((C_word*)lf[162]+1);
t50=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2238,a[2]=((C_word*)t0)[2],a[3]=t49,tmp=(C_word)a,a+=4,tmp);
t51=*((C_word*)lf[309]+1);
((C_proc4)(void*)(*((C_word*)t51+1)))(4,t51,t50,C_fix(256),C_SCHEME_FALSE);}

static void f2238(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2238);}
t2=C_mutate((C_word*)lf[163]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2240,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[162]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2284,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[168]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2302,tmp=(C_word)a,a+=2,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2324,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3699,tmp=(C_word)a,a+=2,tmp);
t7=*((C_word*)lf[163]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t5,*((C_word*)lf[139]+1),t6,C_SCHEME_TRUE);}

static void f3699(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3699);}
t3=*((C_word*)lf[308]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

static void f2324(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word ab[58],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2324);}
t2=C_mutate((C_word*)lf[170]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2328,tmp=(C_word)a,a+=2,tmp));
t3=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2369,tmp=(C_word)a,a+=2,tmp);
t4=*((C_word*)lf[118]+1);
t5=C_mutate((C_word*)lf[172]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2378,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp));
t6=C_mutate((C_word*)lf[174]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2445,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate((C_word*)lf[177]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2521,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate((C_word*)lf[178]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2524,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate((C_word*)lf[179]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2527,tmp=(C_word)a,a+=2,tmp));
t10=*((C_word*)lf[170]+1);
t11=*((C_word*)lf[172]+1);
t12=*((C_word*)lf[124]+1);
t13=C_mutate((C_word*)lf[181]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2551,a[2]=t10,a[3]=t12,a[4]=t11,tmp=(C_word)a,a+=5,tmp));
t14=C_mutate((C_word*)lf[185]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2595,tmp=(C_word)a,a+=2,tmp));
t15=C_mutate((C_word*)lf[188]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2633,tmp=(C_word)a,a+=2,tmp));
t16=C_mutate((C_word*)lf[189]+1,C_fix((C_word)EPERM));
t17=C_mutate((C_word*)lf[190]+1,C_fix((C_word)ENOENT));
t18=C_mutate((C_word*)lf[191]+1,C_fix((C_word)ESRCH));
t19=C_mutate((C_word*)lf[192]+1,C_fix((C_word)EINTR));
t20=C_mutate((C_word*)lf[193]+1,C_fix((C_word)EIO));
t21=C_mutate((C_word*)lf[194]+1,C_fix((C_word)ENOEXEC));
t22=C_mutate((C_word*)lf[195]+1,C_fix((C_word)EBADF));
t23=C_mutate((C_word*)lf[196]+1,C_fix((C_word)ECHILD));
t24=C_mutate((C_word*)lf[197]+1,C_fix((C_word)ENOMEM));
t25=C_mutate((C_word*)lf[198]+1,C_fix((C_word)EACCES));
t26=C_mutate((C_word*)lf[199]+1,C_fix((C_word)EFAULT));
t27=C_mutate((C_word*)lf[200]+1,C_fix((C_word)EBUSY));
t28=C_mutate((C_word*)lf[201]+1,C_fix((C_word)ENOTDIR));
t29=C_mutate((C_word*)lf[202]+1,C_fix((C_word)EISDIR));
t30=C_mutate((C_word*)lf[203]+1,C_fix((C_word)EINVAL));
t31=C_mutate((C_word*)lf[204]+1,C_fix((C_word)EMFILE));
t32=C_mutate((C_word*)lf[205]+1,C_fix((C_word)ENOSPC));
t33=C_mutate((C_word*)lf[206]+1,C_fix((C_word)ESPIPE));
t34=C_mutate((C_word*)lf[207]+1,C_fix((C_word)EPIPE));
t35=C_mutate((C_word*)lf[208]+1,C_fix((C_word)EAGAIN));
t36=C_mutate((C_word*)lf[209]+1,C_fix((C_word)EROFS));
t37=C_mutate((C_word*)lf[210]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2693,tmp=(C_word)a,a+=2,tmp));
t38=C_mutate((C_word*)lf[212]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2713,tmp=(C_word)a,a+=2,tmp));
t39=C_mutate((C_word*)lf[214]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2733,tmp=(C_word)a,a+=2,tmp));
t40=C_mutate((C_word*)lf[215]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2736,tmp=(C_word)a,a+=2,tmp));
t41=C_mutate((C_word*)lf[216]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2739,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[217]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2742,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[218]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2745,tmp=(C_word)a,a+=2,tmp));
t44=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2760,tmp=(C_word)a,a+=2,tmp);
t45=C_mutate((C_word*)lf[220]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2810,a[2]=t44,tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[221]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2816,a[2]=t44,tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[222]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2822,a[2]=t44,tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[223]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2828,tmp=(C_word)a,a+=2,tmp));
t49=C_mutate((C_word*)lf[225]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2846,tmp=(C_word)a,a+=2,tmp));
t50=*((C_word*)lf[74]+1);
t51=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2872,a[2]=((C_word*)t0)[2],a[3]=t50,tmp=(C_word)a,a+=4,tmp);
t52=(C_word)C_u_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
t53=*((C_word*)lf[38]+1);
((C_proc3)(void*)(*((C_word*)t53+1)))(3,t53,t51,t52);}

static void f2872(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word ab[75],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2872);}
t2=C_mutate((C_word*)lf[227]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2873,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[229]+1,C_fix((C_word)STDIN_FILENO));
t4=C_mutate((C_word*)lf[230]+1,C_fix((C_word)STDOUT_FILENO));
t5=C_mutate((C_word*)lf[231]+1,C_fix((C_word)STDERR_FILENO));
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2897,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2910,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2940,tmp=(C_word)a,a+=2,tmp);
t9=C_mutate((C_word*)lf[241]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2973,a[2]=t7,a[3]=t6,a[4]=t8,tmp=(C_word)a,a+=5,tmp));
t10=C_mutate((C_word*)lf[242]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2987,a[2]=t7,a[3]=t6,a[4]=t8,tmp=(C_word)a,a+=5,tmp));
t11=C_mutate((C_word*)lf[244]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3001,tmp=(C_word)a,a+=2,tmp));
t12=C_mutate((C_word*)lf[246]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3020,tmp=(C_word)a,a+=2,tmp));
t13=C_mutate((C_word*)lf[248]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3044,tmp=(C_word)a,a+=2,tmp));
t14=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3079,tmp=(C_word)a,a+=2,tmp);
t15=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3144,tmp=(C_word)a,a+=2,tmp);
t16=C_mutate((C_word*)lf[252]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3165,a[2]=t14,a[3]=t15,tmp=(C_word)a,a+=4,tmp));
t17=C_mutate((C_word*)lf[254]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3180,a[2]=t14,a[3]=t15,tmp=(C_word)a,a+=4,tmp));
t18=C_mutate((C_word*)lf[256]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3207,tmp=(C_word)a,a+=2,tmp));
t19=C_mutate((C_word*)lf[258]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3235,tmp=(C_word)a,a+=2,tmp));
t20=C_mutate((C_word*)lf[260]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3271,tmp=(C_word)a,a+=2,tmp));
t21=C_mutate((C_word*)lf[262]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3293,tmp=(C_word)a,a+=2,tmp));
t22=C_mutate((C_word*)lf[263]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3296,tmp=(C_word)a,a+=2,tmp));
t23=*((C_word*)lf[74]+1);
t24=C_mutate((C_word*)lf[264]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3311,a[2]=t23,tmp=(C_word)a,a+=3,tmp));
t25=C_mutate((C_word*)lf[265]+1,C_fix((C_word)PROT_READ));
t26=C_mutate((C_word*)lf[266]+1,C_fix((C_word)PROT_WRITE));
t27=C_mutate((C_word*)lf[267]+1,C_fix((C_word)PROT_EXEC));
t28=C_mutate((C_word*)lf[268]+1,C_fix((C_word)PROT_NONE));
t29=C_mutate((C_word*)lf[269]+1,C_fix((C_word)MAP_FIXED));
t30=C_mutate((C_word*)lf[270]+1,C_fix((C_word)MAP_SHARED));
t31=C_mutate((C_word*)lf[271]+1,C_fix((C_word)MAP_PRIVATE));
t32=C_mutate((C_word*)lf[272]+1,C_fix((C_word)MAP_ANONYMOUS));
t33=C_mutate((C_word*)lf[273]+1,C_fix((C_word)MAP_FILE));
t34=C_mutate((C_word*)lf[274]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3397,tmp=(C_word)a,a+=2,tmp));
t35=C_mutate((C_word*)lf[281]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3458,tmp=(C_word)a,a+=2,tmp));
t36=C_mutate((C_word*)lf[283]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3493,tmp=(C_word)a,a+=2,tmp));
t37=C_mutate((C_word*)lf[285]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3499,tmp=(C_word)a,a+=2,tmp));
t38=C_mutate((C_word*)lf[286]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3513,tmp=(C_word)a,a+=2,tmp));
t39=C_mutate((C_word*)lf[288]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3533,tmp=(C_word)a,a+=2,tmp));
t40=C_mutate((C_word*)lf[292]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3563,tmp=(C_word)a,a+=2,tmp));
t41=C_mutate((C_word*)lf[294]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3582,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[295]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3585,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[301]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3632,tmp=(C_word)a,a+=2,tmp));
t44=C_mutate((C_word*)lf[303]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3656,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate((C_word*)lf[306]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3680,tmp=(C_word)a,a+=2,tmp));
t46=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t46+1)))(2,t46,t45);}

static void f3680(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3680);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3684,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3676,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[232]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t3,C_fix(12),C_SCHEME_TRUE,C_SCHEME_FALSE,C_SCHEME_TRUE);}

static void f3676(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],(C_word)stub702(t1),C_fix(0));}

static void f3684(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3684);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3687,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f3687(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3690,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

static void f3690(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[66]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],lf[307]);}

static void f3687(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f3656(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3656);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3660,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3667,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[61]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f3667(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_tty_portp(t1))){
t2=((C_word*)t0)[3];
f3660(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],lf[305],((C_word*)t0)[2]);}}

static void f3660(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3660);}
t2=((C_word*)t0)[2];
t3=(C_word)C_fileno(*((C_word*)lf[304]+1));
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3652,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[232]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t4,C_fix(12),C_SCHEME_TRUE,C_SCHEME_FALSE,C_SCHEME_TRUE);}

static void f3652(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],(C_word)stub695(t1,((C_word*)t0)[2]),C_fix(0));}

static void f3632(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3632);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3636,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[302]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,C_fix(0));}

static void f3636(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(t1,C_fix(0));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

static void f3585(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_stack_probe(&a-9)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f3585r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f3585r(t0,t1,t2,t3,t4);}}

static void f3585r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(5);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)BUFSIZ));
t7=t3;
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3592,a[2]=t2,a[3]=t1,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=(C_word)C_eqp(t7,lf[297]);
if(C_truep(t9)){
t10=t8;
f3592(2,t10,C_fix((C_word)_IOFBF));}
else{
t10=(C_word)C_eqp(t7,lf[298]);
if(C_truep(t10)){
t11=t8;
f3592(2,t11,C_fix((C_word)_IOLBF));}
else{
t11=(C_word)C_eqp(t7,lf[299]);
if(C_truep(t11)){
t12=t8;
f3592(2,t12,C_fix((C_word)_IONBF));}
else{
t12=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t12+1)))(5,t12,t8,lf[300],t3,t2);}}}}

static void f3592(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3592);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3606,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[61]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f3606(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setvbuf(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=*((C_word*)lf[66]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[3],lf[296],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f3582(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3582);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub681(C_SCHEME_UNDEFINED,t2));}

static void f3563(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-6)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2rv,f3563r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f3563r(t0,t1,t2);}}

static void f3563r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3567,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[293]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

static void f3567(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_notvemptyp(((C_word*)t0)[3]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[3],C_fix(0)):C_fix(0));
t4=((C_word*)t0)[2];
t5=t4;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub675(C_SCHEME_UNDEFINED,t3));}

static void f3533(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3533);}
t3=(C_word)C_i_check_vector(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3540,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(9)))){
t6=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[291],t2);}
else{
t6=t4;
f3540(2,t6,C_SCHEME_UNDEFINED);}}

static void f3540(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3540);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3543,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t3=((C_word*)t0)[2];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3529,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[232]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t4,C_fix(12),C_SCHEME_TRUE,C_SCHEME_FALSE,C_SCHEME_TRUE);}

static void f3529(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],(C_word)stub664(t1,((C_word*)t0)[2]),C_fix(0));}

static void f3543(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3543);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3546,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f3546(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,lf[289],*((C_word*)lf[290]+1));}}

static void f3546(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f3513(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3513);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3517,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3509,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t6=*((C_word*)lf[232]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t5,C_fix(12),C_SCHEME_TRUE,C_SCHEME_FALSE,C_SCHEME_TRUE);}

static void f3509(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],(C_word)stub655(t1,((C_word*)t0)[2]),C_fix(0));}

static void f3517(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3517);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3520,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f3520(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,lf[287],((C_word*)t0)[2]);}}

static void f3520(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f3499(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3499);}
t3=*((C_word*)lf[284]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,C_SCHEME_TRUE);}

static void f3493(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3493);}
t3=*((C_word*)lf[284]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,C_SCHEME_FALSE);}

static void f3458(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_stack_probe(&a-8)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3rv,f3458r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f3458r(t0,t1,t2,t3);}}

static void f3458r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t6=(C_word)C_slot(t2,C_fix(1));
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3454,a[2]=t2,a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t6)){
t8=*((C_word*)lf[278]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t6);}
else{
t8=t7;
f3454(2,t8,C_SCHEME_FALSE);}}

static void f3454(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3454);}
t2=(C_word)stub643(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[4]);
t3=(C_word)C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3471,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

static void f3471(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[282],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f3397(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(!C_stack_probe(&a-15)){
C_adjust_stack(7);
C_rescue(t0,6);
C_rescue(t1,5);
C_rescue(t2,4);
C_rescue(t3,3);
C_rescue(t4,2);
C_rescue(t5,1);
C_rescue(t6,0);
C_reclaim(tr7rv,f3397r);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f3397r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void f3397r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3401,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f3401(2,t10,t2);}
else{
t10=*((C_word*)lf[280]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t8);}}

static void f3401(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3401);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f3407,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_pointerp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f3407(2,t6,C_SCHEME_UNDEFINED);}
else{
t6=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[41],lf[279],t1);}}

static void f3407(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3407);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f3389,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[2],a[9]=((C_word*)t0)[3],a[10]=t6,a[11]=t5,a[12]=t4,a[13]=t3,tmp=(C_word)a,a+=14,tmp);
t8=*((C_word*)lf[232]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t7,C_fix(12),C_SCHEME_TRUE,C_SCHEME_FALSE,C_SCHEME_TRUE);}

static void f3389(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3389);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f3393,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=t1,tmp=(C_word)a,a+=14,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=*((C_word*)lf[278]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t3=t2;
f3393(2,t3,C_SCHEME_FALSE);}}

static void f3393(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3393);}
t2=(C_word)stub619(((C_word*)t0)[13],t1,((C_word*)t0)[12],((C_word*)t0)[11],((C_word*)t0)[10],((C_word*)t0)[9],((C_word*)t0)[8]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3413,a[2]=((C_word*)t0)[6],a[3]=t2,a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f3429,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[5],a[8]=t3,tmp=(C_word)a,a+=9,tmp);
t5=*((C_word*)lf[277]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f3429(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3429);}
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f3422,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[8];
f3413(2,t3,C_SCHEME_UNDEFINED);}}

static void f3422(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc10)(void*)(*((C_word*)t2+1)))(10,t2,((C_word*)t0)[8],lf[32],lf[276],((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f3413(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3413);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[275],((C_word*)t0)[3],((C_word*)t0)[2]));}

static void f3311(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3311);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3317,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f3317(t5,t1,C_fix(0));}

static void C_fcall f3317(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf3317,NULL);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3321,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=t2;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3307,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t6=*((C_word*)lf[232]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t5,C_fix(12),C_SCHEME_TRUE,C_SCHEME_FALSE,C_SCHEME_TRUE);}

static void f3307(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],(C_word)stub601(t1,((C_word*)t0)[2]),C_fix(0));}

static void f3321(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3321);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3329,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f3329(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

static void C_fcall f3329(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf3329,NULL);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[6],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3355,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
t5=((C_word*)t0)[3];
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[6],C_fix(0),t2);}
else{
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

static void f3355(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3355);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3359,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[3]);
t5=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[3],t3,t4);}

static void f3359(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3359);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3347,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[2])[1];
f3317(t5,t3,t4);}

static void f3347(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3347);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

static void f3296(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3296);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3301,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f3301(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

static void f3293(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f3293);}
t4=(C_word)C_setenv(t2,t3);
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}

static void f3271(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3271);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3275,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f3275(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3275);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3278,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

static void f3278(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[261],((C_word*)t0)[2]);}}

static void f3235(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_stack_probe(&a-7)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3rv,f3235r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f3235r(t0,t1,t2,t3);}}

static void f3235r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3239,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t5=t4;
f3239(t5,(C_word)C_slot(t3,C_fix(0)));}
else{
t5=(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t6=t4;
f3239(t6,(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXU),t5));}}

static void C_fcall f3239(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf3239,NULL);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3256,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f3256(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3256);}
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3248,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f3248(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[259],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f3207(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3207);}
t3=(C_word)C_slot(t2,C_fix(2));
t4=(C_word)C_slot(t2,C_fix(3));
t5=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t3,t4);
t6=(C_word)C_slot(t2,C_fix(1));
t7=(C_word)C_flock_lock(t6);
if(C_truep((C_word)C_fixnum_lessp(t7,C_fix(0)))){
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3225,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t9=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}
else{
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,C_SCHEME_UNDEFINED);}}

static void f3225(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[257],((C_word*)t0)[2]);}

static void f3180(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_stack_probe(&a-8)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f3180r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f3180r(t0,t1,t2,t3);}}

static void f3180r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3184,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
f3079(t4,t2,t3);}

static void f3184(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[4]);
if(C_truep(t2)){
t3=((C_word*)t0)[3];
t4=(C_word)C_eqp(t2,C_fix(0));
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_truep(t4)?C_SCHEME_FALSE:t2));}
else{
f3144(((C_word*)t0)[3],lf[255],t1);}}

static void f3165(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_stack_probe(&a-8)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f3165r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f3165r(t0,t1,t2,t3);}}

static void f3165r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3169,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
f3079(t4,t2,t3);}

static void f3169(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[4]),C_fix(0)))){
f3144(((C_word*)t0)[2],lf[253],t1);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

static void C_fcall f3144(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(trf3144,NULL);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3148,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}

static void f3148(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(1));
t3=(C_word)C_slot(((C_word*)t0)[4],C_fix(2));
t4=(C_word)C_slot(((C_word*)t0)[4],C_fix(3));
t5=*((C_word*)lf[66]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,((C_word*)t0)[3],((C_word*)t0)[2],t2,t3,t4);}

static void C_fcall f3079(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(trf3079,NULL);}
t4=(C_word)C_i_nullp(t3);
t5=(C_truep(t4)?C_fix(0):(C_word)C_u_i_car(t3));
t6=(C_word)C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t3,C_fix(1)));
t8=(C_word)C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_TRUE:(C_word)C_u_i_car(t7));
t10=t9;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(C_word)C_i_nullp(t7);
t13=(C_truep(t12)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t7,C_fix(1)));
if(C_truep((C_word)C_i_nullp(t13))){
t14=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3101,a[2]=t1,a[3]=t11,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t15=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)t11)[1]);
if(C_truep(t15)){
t16=C_set_block_item(t11,0,C_fix(0));
t17=t14;
f3101(t17,t16);}
else{
t16=t14;
f3101(t16,C_SCHEME_UNDEFINED);}}
else{
t14=*((C_word*)lf[176]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t1,*((C_word*)lf[0]+1),t13);}}

static void C_fcall f3101(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf3101,NULL);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_WRLCK):C_fix((C_word)F_RDLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[251],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

static void f3044(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f3044);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3061,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3068,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t5=t4;
f3061(2,t5,(C_word)C_ftruncate(t2,t3));}
else{
t5=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,lf[250],t2);}}}

static void f3068(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f3061(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

static void f3061(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3061);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3054,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

static void f3054(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[249],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f3020(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_stack_probe(&a-8)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f3020r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f3020r(t0,t1,t2,t3);}}

static void f3020r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3024,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f3024(t5,(C_word)C_dup(t2));}
else{
t5=(C_word)C_u_i_car(t3);
t6=t4;
f3024(t6,(C_word)C_dup2(t2,t5));}}

static void C_fcall f3024(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf3024,NULL);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3027,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3033,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f3027(2,t3,C_SCHEME_UNDEFINED);}}

static void f3033(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[247],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f3027(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f3001(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f3001);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3006,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[61]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f3006(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f3006);}
t2=(C_word)C_fileno(t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3009,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3015,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f3009(2,t4,C_SCHEME_UNDEFINED);}}

static void f3015(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],lf[245],((C_word*)t0)[2]);}

static void f3009(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f2987(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2987);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2995,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2999,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
f2910(t4,C_SCHEME_TRUE,lf[243]);}

static void f2999(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f2897(((C_word*)t0)[3],((C_word*)t0)[2],t1);}

static void f2995(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f2940(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

static void f2973(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_stack_probe(&a-13)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f2973r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f2973r(t0,t1,t2,t3);}}

static void f2973r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(10);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2981,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2985,a[2]=t2,a[3]=t4,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
f2910(t5,C_SCHEME_FALSE,t3);}

static void f2985(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f2897(((C_word*)t0)[3],((C_word*)t0)[2],t1);}

static void f2981(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f2940(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

static void C_fcall f2940(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(trf2940,NULL);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2944,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

static void f2944(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2944);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[32],lf[239],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2956,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[83]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,C_fix(-1),C_fix(6),C_SCHEME_FALSE,((C_word*)t0)[5]);}}

static void f2956(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2956);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2959,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

static void f2959(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_setslot(((C_word*)t0)[4],C_fix(1),((C_word*)t0)[3]);
t3=(C_word)C_i_setslot(((C_word*)t0)[4],C_fix(3),lf[240]);
t4=(C_word)C_i_set_i_slot(((C_word*)t0)[4],C_fix(4),C_fix(0));
t5=(C_word)C_i_set_i_slot(((C_word*)t0)[4],C_fix(5),C_fix(0));
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,((C_word*)t0)[4]);}

static void C_fcall f2910(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(trf2910,NULL);}
if(C_truep((C_word)C_i_pairp(t3))){
t4=(C_word)C_u_i_car(t3);
t5=(C_word)C_eqp(t4,lf[233]);
if(C_truep(t5)){
if(C_truep(t2)){
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,lf[234]);}
else{
t6=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t1,lf[235],t4);}}
else{
t6=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t1,lf[236],t4);}}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t2)?lf[237]:lf[238]));}}

static void C_fcall f2897(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(trf2897,NULL);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2901,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[232]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t4,C_fix(12),C_SCHEME_TRUE,C_SCHEME_FALSE,C_SCHEME_TRUE);}

static void f2901(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2901);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2905,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t3=t2;
f2905(2,t3,C_SCHEME_FALSE);}}

static void f2905(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub510(((C_word*)t0)[3],((C_word*)t0)[2],t1));}

static void f2873(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2873);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2878,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f2878(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2878);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2881,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2890,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f2881(2,t4,C_SCHEME_UNDEFINED);}}

static void f2890(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[228],((C_word*)t0)[2]);}

static void f2881(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[5];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

static void f2846(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f2846);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2864,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f2864(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2864);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2868,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f2868(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2868);}
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2856,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f2856(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[226],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f2828(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2828);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2832,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f2832(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2832);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2835,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

static void f2835(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_slot(((C_word*)t0)[4],C_fix(5)));}
else{
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[224],((C_word*)t0)[2]);}}

static void f2822(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_stack_probe(&a-3)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f2822r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f2822r(t0,t1,t2,t3);}}

static void f2822r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
f2760(t1,t2,t3,C_fix((C_word)X_OK),C_fix((C_word)S_IXUSR));}

static void f2816(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_stack_probe(&a-3)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f2816r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f2816r(t0,t1,t2,t3);}}

static void f2816r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
f2760(t1,t2,t3,C_fix((C_word)W_OK),C_fix((C_word)S_IWUSR));}

static void f2810(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_stack_probe(&a-3)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f2810r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f2810r(t0,t1,t2,t3);}}

static void f2810r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
f2760(t1,t2,t3,C_fix((C_word)R_OK),C_fix((C_word)S_IRUSR));}

static void C_fcall f2760(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t1,4);
C_rescue(t2,3);
C_rescue(t3,2);
C_rescue(t4,1);
C_rescue(t5,0);
C_reclaim(trf2760,NULL);}
t6=(C_word)C_i_pairp(t3);
t7=(C_truep(t6)?(C_word)C_u_i_car(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2781,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t9=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2784,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t9=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}}

static void f2784(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(5));
t3=(C_word)C_u_fixnum_and(((C_word*)t0)[3],t2);
t4=(C_word)C_eqp(C_fix(0),t3);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_i_not(t4));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

static void f2781(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2781);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2773,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f2773(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

static void f2773(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f2745(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2745);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2755,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f2755(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],lf[219],((C_word*)t0)[2]);}

static void f2742(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2742);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub474(C_SCHEME_UNDEFINED));}

static void f2739(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2739);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub472(C_SCHEME_UNDEFINED));}

static void f2736(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2736);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub470(C_SCHEME_UNDEFINED));}

static void f2733(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2733);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub468(C_SCHEME_UNDEFINED));}

static void f2713(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f2713);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2731,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

static void f2731(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2731);}
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2723,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f2723(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[5],lf[32],lf[213],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f2693(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f2693);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2711,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

static void f2711(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2711);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2703,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f2703(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[211],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f2633(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2633);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2637,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f2637(t4,(C_word)C_getpwuid(t2));}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2670,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}}

static void f2670(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f2637(t2,(C_word)C_getpwnam(t1));}

static void C_fcall f2637(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf2637,NULL);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2647,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

static void f2647(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2647);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2651,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

static void f2651(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2651);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2655,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

static void f2655(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2655);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2659,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

static void f2659(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2659);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2663,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

static void f2663(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(9,0,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1);}

static void f2595(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2595);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2599,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2628,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f2599(2,t3,C_SCHEME_UNDEFINED);}}

static void f2628(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[66]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],lf[187]);}

static void f2599(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2599);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2606,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

static void f2606(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2606);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2610,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

static void f2610(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2610);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2614,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

static void f2614(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2614);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2618,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

static void f2618(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2618);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2622,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=*((C_word*)lf[186]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

static void f2622(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(7,0,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

static void f2551(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_stack_probe(&a-10)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3rv,f2551r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f2551r(t0,t1,t2,t3);}}

static void f2551r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2558,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=t5,tmp=(C_word)a,a+=7,tmp);
t7=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

static void f2558(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2558);}
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[6])){
t3=((C_word*)t0)[5];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[6]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2573,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,lf[184]);}}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

static void f2573(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2573);}
t2=(C_truep(t1)?t1:lf[182]);
t3=(C_word)C_a_i_list(&a,2,lf[183],((C_word*)t0)[4]);
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],t2,t3);}

static void f2527(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_stack_probe(&a-9)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3rv,f2527r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f2527r(t0,t1,t2,t3);}}

static void f2527r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_kill(t2,t5);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2534,a[2]=t5,a[3]=t2,a[4]=t1,a[5]=t6,tmp=(C_word)a,a+=6,tmp);
t8=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}

static void f2534(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[5],C_fix(-1));
if(C_truep(t2)){
t3=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[4],lf[180],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f2524(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2524);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub440(C_SCHEME_UNDEFINED));}

static void f2521(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2521);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub438(C_SCHEME_UNDEFINED));}

static void f2445(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-8)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2r,f2445r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f2445r(t0,t1,t2);}}

static void f2445r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(6);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_u_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t2,C_fix(1)));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_u_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t6,C_fix(1)));
if(C_truep((C_word)C_i_nullp(t10))){
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_truep(t8)?C_fix((C_word)WNOHANG):C_fix(0));
t13=(C_word)C_waitpid(t11,t12);
t14=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t15=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2473,a[2]=t14,a[3]=t11,a[4]=t1,a[5]=t13,tmp=(C_word)a,a+=6,tmp);
t16=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t16+1)))(2,t16,t15);}
else{
t11=*((C_word*)lf[176]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,*((C_word*)lf[0]+1),t10);}}

static void f2473(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[5],C_fix(-1));
if(C_truep(t2)){
t3=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[4],lf[175],((C_word*)t0)[3]);}
else{
t3=(C_truep(((C_word*)t0)[2])?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
C_values(5,0,((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[2],t3);}}

static void f2378(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_stack_probe(&a-13)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3rv,f2378r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f2378r(t0,t1,t2,t3);}}

static void f2378r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(10);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_SCHEME_END_OF_LIST);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2385,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2437,a[2]=t6,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t8=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

static void f2437(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f2369(((C_word*)t0)[2],C_fix(0),t1);}

static void f2385(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2385);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2390,a[2]=t3,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f2390(t5,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

static void C_fcall f2390(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(trf2390,NULL);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2400,a[2]=((C_word*)t0)[4],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
f2369(t4,t3,C_SCHEME_FALSE);}
else{
t4=(C_word)C_u_i_car(t2);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2422,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
f2369(t5,t3,t4);}}

static void f2422(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=((C_word*)((C_word*)t0)[3])[1];
f2390(t4,((C_word*)t0)[2],t2,t3);}

static void f2400(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2400);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2404,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f2404(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2404);}
t2=(C_word)C_execvp(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2407,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

static void f2407(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[4],C_fix(-1));
if(C_truep(t2)){
t3=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[3],lf[173],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void C_fcall f2369(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(trf2369,NULL);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2374,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t3);}
else{
t5=t4;
f2374(2,t5,C_SCHEME_FALSE);}}

static void f2374(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub404(C_SCHEME_UNDEFINED,((C_word*)t0)[2],t1));}

static void f2328(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-7)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2rv,f2328r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f2328r(t0,t1,t2);}}

static void f2328r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t3=(C_word)stub390(C_SCHEME_UNDEFINED);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2335,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}

static void f2335(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2335);}
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
t3=*((C_word*)lf[66]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,((C_word*)t0)[3],lf[171]);}
else{
t3=(C_word)C_notvemptyp(((C_word*)t0)[2]);
t4=(C_truep(t3)?(C_word)C_eqp(((C_word*)t0)[4],C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2353,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t6=(C_word)C_slot(((C_word*)t0)[2],C_fix(0));
t7=t6;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t5);}
else{
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,((C_word*)t0)[4]);}}}

static void f2353(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2353);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2357,tmp=(C_word)a,a+=2,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

static void f2357(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2357);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub395(C_SCHEME_UNDEFINED,t2));}

static void f2302(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2302);}
t3=(C_word)C_sigemptyset(C_fix(0));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2306,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2320,tmp=(C_word)a,a+=2,tmp);
t6=*((C_word*)lf[48]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,t5,t2);}

static void f2320(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2320);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_sigaddset(t2));}

static void f2306(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2306);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask(C_fix(0)),C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2315,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

static void f2315(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[66]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],lf[169]);}

static void f2284(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f2284);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2294,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t6=t4;
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}
else{
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t2,t3);}}

static void f2294(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[167]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f2240(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_stack_probe(&a-10)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f2240r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f2240r(t0,t1,t2,t3,t4);}}

static void f2240r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=(C_word)C_i_not(t3);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2258,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t7)){
t9=t8;
f2258(t9,t7);}
else{
if(C_truep((C_word)C_notvemptyp(t4))){
t9=(C_word)C_slot(t4,C_fix(0));
t10=t8;
f2258(t10,(C_word)C_i_not(t9));}
else{
t9=t8;
f2258(t9,C_SCHEME_FALSE);}}}

static void C_fcall f2258(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf2258,NULL);}
t2=(C_truep(t1)?((C_word*)t0)[5]:(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2259,a[2]=((C_word*)t0)[5],tmp=(C_word)a,a+=3,tmp));
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_setslot(((C_word*)t0)[3],((C_word*)t0)[2],t2));}

static void f2259(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2259);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2265,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[164]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t1,*((C_word*)lf[165]+1),t3,*((C_word*)lf[166]+1));}

static void f2265(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2265);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

static void f2103(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-11)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2r,f2103r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f2103r(t0,t1,t2);}}

static void f2103r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(9);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2109,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f2109(t6,t1,t2);}

static void C_fcall f2109(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf2109,NULL);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_u_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2124,a[2]=t3,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2130,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
C_u_call_with_values(4,0,t1,t4,t5);}}

static void f2130(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f2130);}
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f2134,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2206,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[136]);
t8=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

static void f2206(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

static void f2134(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2134);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f2141,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(C_truep(((C_word*)t0)[4])?((C_word*)t0)[4]:lf[135]);
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

static void f2141(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2141);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f2143,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f2143(t5,((C_word*)t0)[2],t1);}

static void C_fcall f2143(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf2143,NULL);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_slot(((C_word*)t0)[7],C_fix(1));
t4=((C_word*)((C_word*)t0)[6])[1];
f2109(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2160,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_u_i_car(t2);
t5=*((C_word*)lf[99]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[2],t4);}}

static void f2160(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2160);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2164,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=t2;
f2164(t3,((C_word*)t0)[2],t1);}
else{
t2=(C_word)C_slot(((C_word*)t0)[6],C_fix(1));
t3=((C_word*)((C_word*)t0)[5])[1];
f2143(t3,((C_word*)t0)[2],t2);}}

static void C_fcall f2164(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf2164,NULL);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2172,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_u_i_car(t2);
t5=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[2],t4);}

static void f2172(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2172);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2176,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(1));
t4=((C_word*)((C_word*)t0)[2])[1];
f2143(t4,t2,t3);}

static void f2176(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2176);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

static void f2124(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2124);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

static void f2041(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-11)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2rv,f2041r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f2041r(t0,t1,t2);}}

static void f2041r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(9);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f2045,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,lf[132]);}

static void f2045(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2045);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f2048,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t1)){
t3=t2;
f2048(2,t3,t1);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2095,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,lf[131]);}}

static void f2095(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
f2048(2,t2,t1);}
else{
t2=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],lf[130]);}}

static void f2048(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2048);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[7],C_fix(0)):lf[128]);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f2056,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t5,tmp=(C_word)a,a+=9,tmp));
t7=((C_word*)t5)[1];
f2056(t7,((C_word*)t0)[2]);}

static void C_fcall f2056(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf2056,NULL);}
t2=(C_word)C_fudge(C_fix(16));
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2063,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=t1,a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2082,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t3,a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2086,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
C_number_to_string(4,0,t5,t2,C_fix(16));}

static void f2086(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[129],t1);}

static void f2082(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[5];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

static void f2063(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2063);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2069,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

static void f2069(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2069);}
if(C_truep(t1)){
t2=((C_word*)((C_word*)t0)[5])[1];
f2056(t2,((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2077,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t3=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[4],((C_word*)t0)[3],t2);}}

static void f2077(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f2077);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,((C_word*)t0)[2]);}

static void f2023(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f2023);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2029,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2035,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
C_u_call_with_values(4,0,t1,t4,t5);}

static void f2035(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f2035);}
t5=*((C_word*)lf[111]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t1,t2,t3,((C_word*)t0)[2]);}

static void f2029(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2029);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

static void f2005(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f2005);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2011,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2017,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
C_u_call_with_values(4,0,t1,t4,t5);}

static void f2017(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f2017);}
t5=*((C_word*)lf[111]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t1,t2,((C_word*)t0)[2],t4);}

static void f2011(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f2011);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

static void f1987(int c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4,f1987);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1993,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1999,tmp=(C_word)a,a+=2,tmp);
C_u_call_with_values(4,0,t1,t4,t5);}

static void f1999(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f1999);}
t5=*((C_word*)lf[111]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t1,*((C_word*)lf[121]+1),t3,t4);}

static void f1993(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1993);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

static void f1969(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1969);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1975,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1981,tmp=(C_word)a,a+=2,tmp);
C_u_call_with_values(4,0,t1,t3,t4);}

static void f1981(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f1981);}
t5=*((C_word*)lf[111]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t2,t3);}

static void f1975(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1975);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

static void f1951(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1951);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1957,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1963,tmp=(C_word)a,a+=2,tmp);
C_u_call_with_values(4,0,t1,t3,t4);}

static void f1963(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f1963);}
t5=*((C_word*)lf[111]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t1,C_SCHEME_FALSE,t3,t4);}

static void f1957(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1957);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

static void f1936(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1936);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1942,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1948,tmp=(C_word)a,a+=2,tmp);
C_u_call_with_values(4,0,t1,t3,t4);}

static void f1948(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f1948);}
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}

static void f1942(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1942);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

static void f1921(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1921);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1927,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1933,tmp=(C_word)a,a+=2,tmp);
C_u_call_with_values(4,0,t1,t3,t4);}

static void f1933(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f1933);}
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t3);}

static void f1927(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1927);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

static void f1906(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1906);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1912,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1918,tmp=(C_word)a,a+=2,tmp);
C_u_call_with_values(4,0,t1,t3,t4);}

static void f1918(int c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(5);
C_rescue(t0,4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(tr5,f1918);}
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}

static void f1912(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1912);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

static void f1858(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1858);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1862,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t4=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[2],t2);}

static void f1862(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1862);}
if(C_truep(t1)){
t2=(C_word)C_u_i_cadr(t1);
t3=(C_word)C_u_i_caddr(t1);
t4=(C_word)C_u_i_cddddr(t1);
t5=(C_word)C_u_i_car(t4);
C_values(5,0,((C_word*)t0)[5],t2,t3,t5);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1887,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],((C_word*)t0)[4]);}}

static void f1887(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_u_i_cadr(t1);
t3=(C_word)C_u_i_caddr(t1);
C_values(5,0,((C_word*)t0)[3],t2,t3,C_SCHEME_FALSE);}
else{
C_values(5,0,((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,C_SCHEME_FALSE);}}

static void f1802(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_stack_probe(&a-13)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4r,f1802r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f1802r(t0,t1,t2,t3,t4);}}

static void f1802r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(9);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f1810,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=t3,a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t6=(C_word)C_i_not(t2);
t7=(C_truep(t6)?t6:(C_word)C_i_nullp(t2));
if(C_truep(t7)){
t8=t5;
f1810(2,t8,lf[113]);}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t8=t5;
f1810(2,t8,t2);}
else{
t8=((C_word*)t0)[2];
f1668(t8,t5,t2);}}}

static void f1810(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1810);}
t2=(C_word)C_block_size(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1816,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1826,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t1);}

static void f1826(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[5];
f1816(2,t2,((C_word*)t0)[4]);}
else{
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[5],((C_word*)t0)[2],((C_word*)t0)[4]);}}

static void f1816(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(6,0,((C_word*)t0)[5],((C_word*)t0)[4],t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f1698(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_stack_probe(&a-12)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f1698r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1698r(t0,t1,t2,t3,t4);}}

static void f1698r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(8);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f1702,a[2]=t4,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,tmp=(C_word)a,a+=8,tmp);
t6=(C_word)C_i_not(t2);
t7=(C_truep(t6)?t6:(C_word)C_i_nullp(t2));
if(C_truep(t7)){
t8=t5;
f1702(2,t8,lf[110]);}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t8=t5;
f1702(2,t8,t2);}
else{
t8=((C_word*)t0)[2];
f1668(t8,t5,t2);}}}

static void f1702(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1702);}
t2=((C_word*)t0)[7];
t3=(C_truep(t2)?t2:lf[103]);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f1708,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
if(C_truep((C_word)C_notvemptyp(((C_word*)t0)[2]))){
t5=(C_word)C_slot(((C_word*)t0)[2],C_fix(0));
t6=t4;
f1708(t6,(C_truep(t5)?t5:lf[108]));}
else{
t5=t4;
f1708(t5,lf[109]);}}

static void C_fcall f1708(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf1708,NULL);}
t2=(C_word)C_block_size(((C_word*)t0)[7]);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f1742,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],tmp=(C_word)a,a+=9,tmp);
if(C_truep(t2)){
if(C_truep((C_word)C_fixnum_greaterp(t2,C_fix(0)))){
t4=(C_word)C_u_fixnum_difference(t2,C_fix(1));
t5=(C_word)C_subchar(((C_word*)t0)[7],t4);
if(C_truep(t5)){
t6=(C_word)C_eqp(*((C_word*)lf[107]+1),t5);
if(C_truep(t6)){
t7=t3;
f1742(t7,C_SCHEME_FALSE);}
else{
t7=(C_word)C_eqp(C_make_character(47),t5);
t8=t3;
f1742(t8,(C_word)C_i_not(t7));}}
else{
t6=t3;
f1742(t6,C_SCHEME_FALSE);}}
else{
t4=t3;
f1742(t4,C_SCHEME_FALSE);}}
else{
t4=t3;
f1742(t4,C_SCHEME_FALSE);}}

static void C_fcall f1742(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf1742,NULL);}
t2=(C_truep(t1)?((C_word*)t0)[8]:lf[104]);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f1722,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t4=(C_word)C_block_size(((C_word*)t0)[2]);
if(C_truep((C_word)C_fixnum_greaterp(t4,C_fix(0)))){
t5=(C_word)C_eqp((C_word)C_subchar(((C_word*)t0)[2],C_fix(0)),*((C_word*)lf[106]+1));
t6=t3;
f1722(t6,(C_word)C_i_not(t5));}
else{
t5=t3;
f1722(t5,C_SCHEME_FALSE);}}

static void C_fcall f1722(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(t1)?((C_word*)t0)[8]:lf[105]);
t3=((C_word*)t0)[7];
((C_proc7)(void*)(*((C_word*)t3+1)))(7,t3,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t2,((C_word*)t0)[2]);}

static void C_fcall f1668(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf1668,NULL);}
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1674,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f1674(t6,t1,t2);}

static void C_fcall f1674(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(6);
if(!C_stack_probe(a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf1674,NULL);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[102]);}
else{
t3=(C_word)C_u_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1692,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_slot(t2,C_fix(1));
t7=t4;
t8=t5;
t1=t7;
t2=t8;
goto loop;}}

static void f1692(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[5];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

static void f1652(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1652);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1660,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[2],t2);}

static void f1660(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_i_pairp(t1));}

static void f1631(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1631);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1635,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1644,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f1635(2,t3,C_SCHEME_UNDEFINED);}}

static void f1644(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[32],lf[98]);}

static void f1635(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

static void f1611(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_stack_probe(&a-10)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4r,f1611r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f1611r(t0,t1,t2,t3,t4);}}

static void f1611r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[96]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1615,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

static void f1615(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1615);}
t2=C_mutate((C_word*)lf[96]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1621,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

static void f1621(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-7)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2r,f1621r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f1621r(t0,t1,t2);}}

static void f1621r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1625,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

static void f1625(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[96]+1,((C_word*)t0)[4]);
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[91]+1),((C_word*)t0)[2]);}

static void f1591(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_stack_probe(&a-10)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4r,f1591r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f1591r(t0,t1,t2,t3,t4);}}

static void f1591r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[94]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1595,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

static void f1595(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1595);}
t2=C_mutate((C_word*)lf[94]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1601,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

static void f1601(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-7)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2r,f1601r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f1601r(t0,t1,t2);}}

static void f1601r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1605,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

static void f1605(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[94]+1,((C_word*)t0)[4]);
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[91]+1),((C_word*)t0)[2]);}

static void f1567(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_stack_probe(&a-9)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4r,f1567r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f1567r(t0,t1,t2,t3,t4);}}

static void f1567r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1571,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

static void f1571(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1571);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1576,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1582,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

static void f1582(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-6)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2r,f1582r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f1582r(t0,t1,t2);}}

static void f1582r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1586,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

static void f1586(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[91]+1),((C_word*)t0)[2]);}

static void f1576(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1576);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

static void f1543(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_stack_probe(&a-9)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4r,f1543r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f1543r(t0,t1,t2,t3,t4);}}

static void f1543r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1547,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

static void f1547(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1547);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1552,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1558,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

static void f1558(int c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_stack_probe(&a-6)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2r,f1558r);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f1558r(t0,t1,t2);}}

static void f1558r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1562,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

static void f1562(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[91]+1),((C_word*)t0)[2]);}

static void f1552(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1552);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

static void f1527(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1527);}
t3=(C_word)close_pipe(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1531,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}

static void f1531(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
t3=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[3],lf[32],lf[88],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f1494(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_stack_probe(&a-14)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f1494r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f1494r(t0,t1,t2,t3);}}

static void f1494r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(11);
t4=f1410(t3);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1505,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[79]);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1512,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t8=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=(C_word)C_eqp(t4,lf[85]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1522,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t9=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
f1422(t5,t4);}}}

static void f1522(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1522);}
t2=((C_word*)t0)[2];
f1505(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

static void f1512(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1512);}
t2=((C_word*)t0)[2];
f1505(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

static void f1505(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f1428(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

static void f1461(int c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_stack_probe(&a-14)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3r,f1461r);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f1461r(t0,t1,t2,t3);}}

static void f1461r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(11);
t4=f1410(t3);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1472,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[79]);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1479,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t8=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=(C_word)C_eqp(t4,lf[85]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1489,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t9=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
f1422(t5,t4);}}}

static void f1489(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1489);}
t2=((C_word*)t0)[2];
f1472(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

static void f1479(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1479);}
t2=((C_word*)t0)[2];
f1472(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

static void f1472(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f1428(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

static void C_fcall f1428(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(4);
C_rescue(t1,3);
C_rescue(t2,2);
C_rescue(t3,1);
C_rescue(t4,0);
C_reclaim(trf1428,NULL);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1432,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

static void f1432(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1432);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[32],lf[81],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1444,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[83]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,C_fix(-1),C_fix(6),C_SCHEME_FALSE,((C_word*)t0)[5]);}}

static void f1444(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1444);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1447,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

static void f1447(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_setslot(((C_word*)t0)[4],C_fix(1),((C_word*)t0)[3]);
t3=(C_word)C_i_setslot(((C_word*)t0)[4],C_fix(3),lf[82]);
t4=(C_word)C_i_set_i_slot(((C_word*)t0)[4],C_fix(4),C_fix(0));
t5=(C_word)C_i_set_i_slot(((C_word*)t0)[4],C_fix(5),C_fix(0));
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,((C_word*)t0)[4]);}

static void C_fcall f1422(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(trf1422,NULL);}
t3=*((C_word*)lf[66]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[80],t2);}

static C_word C_fcall f1410(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[79]));}

static void f1392(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1392);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1396,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix(256));}

static void f1396(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1396);}
t2=(C_word)C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1399,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

static void f1399(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[5])){
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),((C_word*)t0)[5]);}
else{
t2=*((C_word*)lf[31]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],lf[32],lf[78]);}}

static void f1376(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1376);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1380,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f1380(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

static void f1341(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1341);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1345,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,C_fix(256));}

static void f1345(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1345);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1349,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

static void f1349(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1349);}
t2=(C_word)C_findfirst(t1);
if(C_truep(t2)){
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1357,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f1357(t6,((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}}

static void C_fcall f1357(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf1357,NULL);}
t2=(C_word)C_foundfile(((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1361,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)t0)[5],C_fix(0),t2);}

static void f1361(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1361);}
if(C_truep((C_word)C_findnext(((C_word*)t0)[4]))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1371,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)((C_word*)t0)[2])[1];
f1357(t3,t2);}
else{
t2=(C_word)C_findclose(((C_word*)t0)[4]);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_a_i_cons(&a,2,t1,C_SCHEME_END_OF_LIST));}}

static void f1371(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1371);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

static void f1321(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1321);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1339,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f1339(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1339);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1331,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

static void f1331(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[73],((C_word*)t0)[2]);}

static void f1301(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1301);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1319,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f1319(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1319);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1311,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

static void f1311(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[71],((C_word*)t0)[2]);}

static void f1281(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1281);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1299,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f1299(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1299);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1291,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

static void f1291(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[69],((C_word*)t0)[2]);}

static void f1232(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_stack_probe(&a-10)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f1232r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1232r(t0,t1,t2,t3,t4);}}

static void f1232r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1239,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t8=*((C_word*)lf[66]+1);
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t7,lf[67],t3,t2);}
else{
t8=t7;
f1239(2,t8,C_SCHEME_UNDEFINED);}}

static void f1239(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1239);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1245,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_portp(((C_word*)t0)[4]))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1258,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[61]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[4]))){
t3=t2;
f1245(2,t3,(C_word)C_lseek(((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t3=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[41],lf[65],((C_word*)t0)[4]);}}}

static void f1258(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[4];
f1245(2,t2,(C_word)C_fseek(t1,((C_word*)t0)[3],((C_word*)t0)[2]));}

static void f1245(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1245);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1248,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

static void f1248(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[64],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f1198(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1198);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1202,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_portp(t2))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1221,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[61]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f1202(2,t4,(C_word)C_lseek(t2,C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
t4=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,lf[41],lf[62],t2);}}}

static void f1221(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f1202(2,t2,(C_word)C_ftell(t1));}

static void f1202(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1202);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1205,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1211,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f1205(2,t3,C_SCHEME_UNDEFINED);}}

static void f1211(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[60],((C_word*)t0)[2]);}

static void f1205(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f1180(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1180);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1184,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f1184(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1184);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1187,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

static void f1187(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_slot(((C_word*)t0)[4],C_fix(6)));}
else{
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[58],((C_word*)t0)[2]);}}

static void f1162(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1162);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1166,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f1166(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1166);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1169,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

static void f1169(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_slot(((C_word*)t0)[4],C_fix(2)));}
else{
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[56],((C_word*)t0)[2]);}}

static void f1144(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1144);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1148,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

static void f1148(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1148);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1151,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

static void f1151(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_slot(((C_word*)t0)[4],C_fix(3)));}
else{
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[53],((C_word*)t0)[2]);}}

static void f1036(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_stack_probe(&a-19)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f1036r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1036r(t0,t1,t2,t3,t4);}}

static void f1036r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a=C_alloc(15);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_slot(t4,C_fix(0)):C_SCHEME_FALSE);
t9=f1030(C_fix(0));
t10=f1030(C_fix(1));
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f1049,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t3,a[7]=t2,a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t12=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1128,a[2]=((C_word*)t0)[2],a[3]=t6,tmp=(C_word)a,a+=4,tmp);
t13=*((C_word*)lf[48]+1);
((C_proc4)(void*)(*((C_word*)t13+1)))(4,t13,t11,t12,t2);}

static void f1128(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1128);}
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,f1032(C_fix(0),t2));}

static void f1049(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1049);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f1052,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1121,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[48]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,((C_word*)t0)[6]);}

static void f1121(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1121);}
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,f1032(C_fix(1),t2));}

static void f1052(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1052);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1055,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f1055(t4,(C_word)C_select_t(t3,((C_word*)t0)[3]));}
else{
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f1055(t4,(C_word)C_select(t3));}}

static void C_fcall f1055(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(trf1055,NULL);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1064,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
C_values(4,0,((C_word*)t0)[5],C_SCHEME_END_OF_LIST,C_SCHEME_END_OF_LIST);}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_END_OF_LIST;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f1079,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=t4,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1100,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t9=*((C_word*)lf[48]+1);
((C_proc4)(void*)(*((C_word*)t9+1)))(4,t9,t7,t8,((C_word*)t0)[4]);}}}

static void f1100(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1100);}
t3=f1034(C_fix(0),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

static void f1079(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f1079);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1082,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1087,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[48]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,((C_word*)t0)[2]);}

static void f1087(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f1087);}
t3=f1034(C_fix(1),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

static void f1082(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(4,0,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[2])[1]);}

static void f1064(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[47],((C_word*)t0)[3],((C_word*)t0)[2]);}

static C_word C_fcall f1034(C_word t1,C_word t2){
C_word tmp;
C_word t3;
return((C_word)stub42(C_SCHEME_UNDEFINED,t1,t2));}

static C_word C_fcall f1032(C_word t1,C_word t2){
C_word tmp;
C_word t3;
return((C_word)stub36(C_SCHEME_UNDEFINED,t1,t2));}

static C_word C_fcall f1030(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub31(C_SCHEME_UNDEFINED,t1));}

static void f994(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_stack_probe(&a-10)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f994r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f994r(t0,t1,t2,t3,t4);}}

static void f994r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f998,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t5;
f998(2,t7,C_SCHEME_UNDEFINED);}
else{
t7=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t5,lf[41],lf[45],t3);}}

static void f998(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f998);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1004,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_eqp(C_fix(-1),t4);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1010,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t8=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}
else{
t7=t5;
f1004(2,t7,C_SCHEME_UNDEFINED);}}

static void f1010(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[44],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f1004(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

static void f955(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_stack_probe(&a-9)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f955r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f955r(t0,t1,t2,t3,t4);}}

static void f955r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f959,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t6=t5;
f959(2,t6,(C_word)C_slot(t4,C_fix(0)));}
else{
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t3);}}

static void f959(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f959);}
t2=(C_word)C_read(((C_word*)t0)[4],t1,((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f962,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=t1,a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
t4=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=t3;
f962(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t3,lf[41],lf[42],t1);}}

static void f962(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f962);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f965,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f974,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f965(2,t4,C_SCHEME_UNDEFINED);}}

static void f974(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[32],lf[40],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f965(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(4,0,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f940(int c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(3);
C_rescue(t0,2);
C_rescue(t1,1);
C_rescue(t2,0);
C_reclaim(tr3,f940);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f950,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

static void f950(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[32],lf[37],((C_word*)t0)[2]);}

static void f912(int c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_stack_probe(&a-10)){
C_adjust_stack(4);
C_rescue(t0,3);
C_rescue(t1,2);
C_rescue(t2,1);
C_rescue(t3,0);
C_reclaim(tr4rv,f912r);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f912r(t0,t1,t2,t3,t4);}}

static void f912r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f920,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t8=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

static void f920(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_adjust_stack(2);
C_rescue(t0,1);
C_rescue(t1,0);
C_reclaim(tr2,f920);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f923,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f929,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[34]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f923(2,t5,C_SCHEME_UNDEFINED);}}

static void f929(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[31]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[5],lf[32],lf[33],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

static void f923(int c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
/* END OF FILE */
