/* wire/datadir.c
// GetDirHome
// Copyright Dec 2, 2002, Robin.Rowe@MovieEditor.com
// License MIT (http://opensource.org/licenses/mit-license.php)
*/

#ifdef WIN32

#include "../../win32/GetWinUserDir.h"
#include "datadir.h"

#define DOT_DIR ".cinepaint"
#define DATA_DIR "share"

ReplaceBackslashWithSlash(char* path)
{	char* c=strchr(path,'\\');
	while(c)
	{	*c='/';
		c=strchr(c,'\\');
}	}

const char* GetDirHome()
{	static TCHAR* path;
	if(!path)
	{	path=(TCHAR*)malloc(sizeof(TCHAR)*MAX_PATH);
		if(!path)
		{	return "error";
		}
		path[0]=0;
		GetWinUserDir(path,MAX_PATH);
		ReplaceBackslashWithSlash(path);
	}
	return path;
}

const char* GetDirDot()
{	return DOT_DIR;
}

const char* GetDirData()
{	return DATA_DIR;
}


const char* gimp_personal_rc_file (const char* rcfile)
{
    static TCHAR* rc_file;
    rc_file = (TCHAR*)malloc(sizeof(TCHAR)*MAX_PATH);
               if(!path)
               {       return "error";
               }
    sprintf( rc_file, "%s\\%s\\%s",GetDirHome(), GetDirDot(), rcfile );
    return rc_file;
}

/*
const char* GetDirHome()
{	static char username[33];
	DWORD len=33;
	if(!username[0])
	{	if(!GetUserName(username,&len))
		{	strcpy(username,"unknown");
	}	}
	return username;
}
*/
#else

#include <stdio.h>
#include <stdlib.h>

/*
#define DATA_DIR "share"
#define GetDirData() DATA_DIR
#define GetDirDot() ".cinepaint"
 getenv("GIMP_DIRECTORY") 
#define GetDirHome() getenv("HOME")
#define DOT_DIR ".cinepaint"


 -DLIBDIR=\""/opt/lib/filmgimp/0.16"\" -DDATADIR=\""/opt/share/filmgimp/0.16"\" -DGIMPDIR=\"".filmgimp"\"

programdatadir=$datadir/cinepaint/$VERSION
programplugindir=$libdir/cinepaint/$VERSION
programincludedir=${prefix}/include/cinepaint-$VERSION

*/

const char* GetDirHome()
{	const char* home=getenv("HOME");
	d_printf("GetDirHome: %s\n",home);
	return home;
}

const char* GetDirDot()
{	d_printf("GetDirDot: %s\n",DOTDIR);
	return DOTDIR;
}

const char* GetDirData()
{	d_printf("GetDirData: %s\n",DATADIR);
	return DATADIR;
}

const char* gimp_personal_rc_file (const char* rcfile)
{
    static char* rc_file;
    rc_file = (char*)malloc(sizeof(char)*2048);
               if(!rc_file)
               {       return "error";
               }
    sprintf( rc_file, "%s/%s/%s",GetDirHome(), GetDirDot(), rcfile );
    return rc_file;
}

#endif
