/* iodebug.c
// Debugging and trace output
// Copyright Mar 23, 2003, Robin.Rowe@MovieEditor.com
// License MIT (http://opensource.org/licenses/mit-license.php)
*/

#include "iodebug.h"

#ifdef _DEBUG

void d_heap()
{	int  heapstatus = _heapchk();
	switch( heapstatus )
	{	case _HEAPOK:
			return;
		case _HEAPEMPTY:
			return;
		case _HEAPBADBEGIN:
			printf( "ERROR - bad start of heap\n" );
		break;
		case _HEAPBADNODE:
			printf( "ERROR - bad node in heap\n" );
		break;
	}
	__asm INT 3;
}

#else
void d_printf( const char *format, ...)
{}

void e_printf( const char *format, ...)
{}

void d_puts(const char* string)
{}

void e_puts(const char* string)
{}

#endif