/*
 * FollowCurveWindow.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  FollowCurveWindow.hpp
  
  TODO: 
*/
#ifndef FollowCurveWindow_hpp
#define FollowCurveWindow_hpp


#include <FL/Fl_Window.H>
#include <FL/Fl_Menu_.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Button.H>

#include "br_types_plot.hpp"    // PlotDataT, CurvePlotClass
#include "Br.hpp"               // BracketingCore::Event


typedef enum { Z_AVERAGE, Z_AVERAGE_SMOOTH } FollowCurveMethod;  

/**================================================================
 *
 * FollowCurvePanel  --  class 
 *
 * Currently the inheritor `FollowCurveTabPanel' needs a different 
 *   event_msg than provided here. So it is decl. virtual.
 *
 *=================================================================*/
class FollowCurvePanel : public Fl_Group
{
public:
  //typedef enum { Z_AVERAGE, Z_AVERAGE_SMOOTH } Method;  
  
private:
#if 0
  typedef struct {const char* text; FollowCurveMethod method;}  MenuMap_method;
  static MenuMap_method  menuMap_method[];
  static Fl_Menu_Item    menu_choice_method[];
  
  typedef struct {const char* text; char channel;}  MenuMap_channel;
  static MenuMap_channel menuMap_channel[];
  static Fl_Menu_Item    menu_choice_channel[];
#endif
  
  CurvePlotClass*   plot_;
  Fl_Choice*        choice_refpic_;
  char              channel_;
  FollowCurveMethod method_;

public:
  FollowCurvePanel (int X, int Y, int W, int H, const char* la=0);
  ~FollowCurvePanel();
  
protected:
  void update();        // for our inheritor `FollowCurveTabPanel'
  
private:
  void update_plot()      { DB_ build_plot(); plot_->redraw(); }
  void build_plot();
  void build_choice_refpic();
  
  // Fl_Callback(s)...
  void        cb_choice_method (Fl_Menu_*);
  static void cb_choice_method_(Fl_Menu_* w, FollowCurvePanel* I)
    { I -> cb_choice_method (w); }

  void        cb_choice_channel (Fl_Menu_*);
  static void cb_choice_channel_(Fl_Menu_* w, FollowCurvePanel* I)
    { I -> cb_choice_channel (w); }
  
  void        cb_choice_refpic (Fl_Menu_*);
  static void cb_choice_refpic_(Fl_Menu_* w, FollowCurvePanel* I)
    { I -> cb_choice_refpic (w); }
  
  void        cb_update (Fl_Button*);
  static void cb_update_(Fl_Button* w, FollowCurvePanel* I)
    { I -> cb_update (w); }
    
  // Distributor Callback(s)...
  void        refpic_msg (int pic);                 
  static void refpic_msg_(int* pic, FollowCurvePanel* I) 
    { I -> refpic_msg (*pic); }
  
  virtual void event_msg (BracketingCore::Event);
  static void event_msg_(BracketingCore::Event* e, FollowCurvePanel* I)
    { I -> event_msg (*e); }  
};


/**================================================================
 *
 * FollowCurveTabPanel  --  class 
 *
 *=================================================================*/
class FollowCurveTabPanel : public FollowCurvePanel
{
public:
  FollowCurveTabPanel (int X, int Y, int W, int H, const char* la=0)
   : FollowCurvePanel (X,Y,W,H, la) {}
 
private:
  virtual void event_msg (BracketingCore::Event);
};


/**================================================================
 *
 * FollowCurveWindow  --  class 
 *
 *=================================================================*/
class FollowCurveWindow : public Fl_Window
{
  static const char* default_title_;
  FollowCurvePanel* panel_; 
  
public:
  FollowCurveWindow (int W, int H, const char* la=default_title_);
  FollowCurveWindow (int X, int Y, int W, int H, const char* la=default_title_);
  ~FollowCurveWindow()   {DTOR(label());}

private:  
  // Fl_Callback(s)...
  void        cb_window ();
  static void cb_window_(Fl_Widget* w, FollowCurveWindow* I)
    { I -> cb_window(); }
};


#endif // FollowCurveWindow_hpp

// END OF FILE
