/*
 * ShiftMenu.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
  ShiftMenu.hpp
*/
#ifndef ShiftMenu_hpp
#define ShiftMenu_hpp

#include "br_defs.hpp"          // BR_WITH_SHIFT


#ifndef BR_WITH_SHIFT

#include <FL/Fl_Window.H>
/**====================
 * ShiftMenu  -  dummy
 *=====================*/
class ShiftMenu : public Fl_Window
{
public:
  ShiftMenu (int W, int H, const char* la=0) : Fl_Window(W,H,la) {}
  ~ShiftMenu() {}
};

#else


#include <FL/Fl_Window.H>
#include <FL/Fl_Menu_.H>
#include <FL/Fl_Int_Input.H>
#include "Fl_Table.H"

#include "YS/ys_dbg.hpp"        // DTOR() 


/**====================================================================
 *
 * ShiftMenu  -  class 
 *
 * Gedacht als eigenstaendiges Hauptfenster. 
 *
 *=====================================================================*/
class ShiftMenu : public Fl_Window
{
  static Fl_Menu_Item  menu_menubar_[];
  Fl_Table     *table_;
  Fl_Int_Input *input_nx_, *input_ny_, *input_mx_, *input_my_;
     
public:
  ShiftMenu (int W, int H, const char* la=0);
  ~ShiftMenu() { DTOR(label()) }
                    
private:
  void        cb_window ();
  static void cb_window_(Fl_Widget* w, ShiftMenu* I)
    { I -> cb_window(); }

  void        cb_close (Fl_Menu_*)      { cb_window(); }
  static void cb_close_(Fl_Menu_* o, void*)
    { ((ShiftMenu*)o->user_data()) -> cb_close(o); }  
    
  void        cb_compute (Fl_Menu_*);
  static void cb_compute_(Fl_Menu_* o, void*)
    { ((ShiftMenu*)o->user_data()) -> cb_compute(o); }  
  
  void        cb_table (Fl_Table*);
  static void cb_table_(Fl_Table* w, ShiftMenu* I)
    { I -> cb_table(w); }
    
  void        cb_input_nx (Fl_Int_Input*);
  static void cb_input_nx_(Fl_Int_Input* w, ShiftMenu* I)
    { I -> cb_input_nx (w); }
  
  void        cb_input_ny (Fl_Int_Input*);
  static void cb_input_ny_(Fl_Int_Input* w, ShiftMenu* I)
    { I -> cb_input_ny (w); }
  
  void        cb_input_mx (Fl_Int_Input*);
  static void cb_input_mx_(Fl_Int_Input* w, ShiftMenu* I)
    { I -> cb_input_mx (w); }
  
  void        cb_input_my (Fl_Int_Input*);
  static void cb_input_my_(Fl_Int_Input* w, ShiftMenu* I)
    { I -> cb_input_my (w); }

  void set_nm_values();  
};

#endif // BR_WITH_SHIFT
#endif // FollowCurveMenu_hpp

// END OF FILE
