/*
 * ShiftPanel.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  ShiftPanel.hpp
*/
#ifndef ShiftPanel_hpp
#define ShiftPanel_hpp


#include <FL/Fl_Group.H>
#include <FL/Fl_Int_Input.H>
#include "Fl_Table.H"

#include "br_defs.hpp"          // BR_WITH_SHIFT
#include "Br.hpp"               // BracketingCore::Event
#include "YS/ys_dbg.hpp"        // DTOR() 


#ifndef BR_WITH_SHIFT

/**======================
 * ShiftPanel  -  dummy
 *=======================*/
class ShiftPanel : public Fl_Group
{
public:
  ShiftPanel (int X, int Y, int W, int H, const char* la=0) 
    : Fl_Group(X,Y,W,H, la) {}
  ~ShiftPanel() {}
  
  Fl_Table* table() const   { return NULL; }
  void      update()        {}
};                    

#else


/**====================================================================
 *
 * ShiftPanel  -  class 
 *
 *=====================================================================*/
class ShiftPanel : public Fl_Group
{
  Fl_Table     *table_;
  Fl_Int_Input *input_nx_, *input_ny_, *input_mx_, *input_my_;
     
public:
  ShiftPanel (int X, int Y, int W, int H, const char* la=0);
  ~ShiftPanel();
  
  Fl_Table* table() const   { return table_; }
  void      update()        { out_nm_values(); }
                    
private:
  void        cb_compute (Fl_Menu_*);
  static void cb_compute_(Fl_Menu_* o, void*)
    { ((ShiftPanel*)o->user_data()) -> cb_compute(o); }  
  
  void        cb_table (Fl_Table*);
  static void cb_table_(Fl_Table* w, ShiftPanel* I)
    { I -> cb_table(w); }
    
  void        cb_input_nx (Fl_Int_Input*);
  static void cb_input_nx_(Fl_Int_Input* w, ShiftPanel* I)
    { I -> cb_input_nx (w); }
  
  void        cb_input_ny (Fl_Int_Input*);
  static void cb_input_ny_(Fl_Int_Input* w, ShiftPanel* I)
    { I -> cb_input_ny (w); }
  
  void        cb_input_mx (Fl_Int_Input*);
  static void cb_input_mx_(Fl_Int_Input* w, ShiftPanel* I)
    { I -> cb_input_mx (w); }
  
  void        cb_input_my (Fl_Int_Input*);
  static void cb_input_my_(Fl_Int_Input* w, ShiftPanel* I)
    { I -> cb_input_my (w); }

  void out_nm_values();  
  
  // Distributor Callback(s)...
  void        event_msg (BracketingCore::Event);
  static void event_msg_(BracketingCore::Event* e, ShiftPanel* I)
    { I -> event_msg (*e); } 

};

#endif // BR_WITH_SHIFT
#endif // ShiftPanel_hpp

// END OF FILE
