/*
 * StatusLine.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  StatusLine.hpp  --  Statuszeile mittels Fltk.
  
  Statuszeile als solche ist vom Haupt-Widget (Hauptfenster) zu 
  installieren und positionieren, doch sollen auch in Sub-Widgets schon
  Statusmeldungen moeglich sein. Weil diese i.d.R. vor dem Haupt-Widget
  definiert werden, benutze ich einen globalen Zeiger `__statusline', der 
  im Haupt-Widget entsprechend zu setzen ist. Vereinbaren wir noch, dass die
  Sub-Widgets den Fall __statusline == 0 nicht abfangen brauchen.
  
  Die Ausgabefunktionen will ich `out()' und `out_default()' nennen, wobei
  out() einfach auf Fl_Output's value() abgebildet wird. Wegen der
  public-Vererbung existiert dann auch die Funktion `value()' neben `out()'.
  Kriegt man die weg? Durch private-Vererbung, klar, aber dann muessten alle
  von Fl_Output sonst gebrauchte Funktionalitaet wie `color()' explizit durch-
  gereicht werden.
*/
#ifndef StatusLine_hpp
#define StatusLine_hpp


#include "FL/Fl_Output.H"


class StatusLine : public Fl_Output
{
  char* default_text_;
public:
  StatusLine (int X, int Y, int W, int H, const char* la=0)
    : Fl_Output(X,Y,W,H,la),
      default_text_ (0) 
    { box(FL_THIN_DOWN_BOX); }
    
  void out (const char* s)         { value (s);            } 
  void out_default ()              { value (default_text_);}
  void default_text (const char* s);
  const char* default_text() const { return default_text_; }
};


// declaration of the global pointer...
extern StatusLine* __statusline;       


#endif

// END OF FILE
