C    TEST EXAMPLE FROM MOTIUR RAHMAN

      SUBROUTINE SETUP
      INCLUDE 'O8COMM.INC'

      TE2=.TRUE.
      TE3=.TRUE.
      RETURN
      END



      SUBROUTINE SETUP0
      INCLUDE 'O8COMM.INC'
      INCLUDE 'O8CONS.INC'
      INCLUDE 'O8FINT.INC'
      INTEGER           I
      DOUBLE PRECISION XST0(5)
      DATA XST0 / 2300.D0, 0.11D0, 8.D0, 0.077D0, 2700.D0 /

      NAME='FRAC_OPT'
      N = 5
      NH = 0
      NG = 18

      ANALYT=.FALSE.
      DIFFTYPE=3
      EPSFCN=1.D-13
      TAUBND=0.01D0
      EPSDIF=TM8
      PROU=10
      MEU=20
      COLD=.TRUE.
      SILENT=.FALSE.
      NRESET=N
      DEL0=0.1D0
C      TAU0=0.50D0
      TAU0=1.D0
      TAU=0.1D0
      DO I=1,5
      X(I)=XST0(I)
      ENDDO

      GUNIT(1,0) =-1
      GUNIT(2,0) =0
      GUNIT(3,0) =0
      DO I=1,8
        GUNIT(1,I) =-1
        GUNIT(2,I) =0
        GUNIT(3,I) =0
      ENDDO

      DO I=9,18
        GUNIT(1,I) =1
        IF (I .GT. 13) THEN
         GUNIT(2,I) = I-13
         GUNIT(3,I) =-1
        ELSE
         GUNIT(2,I) =I-8
         GUNIT(3,I) =1
        ENDIF
      ENDDO

      RETURN
      END



      SUBROUTINE EF(X,FX)
      INCLUDE 'O8FUCO.INC'
      DOUBLE PRECISION X(*),FX,NPV

      CALL OBJECTIVE(X, NPV)

      ICF=ICF + 1

      FX =- NPV


      RETURN
      END



      SUBROUTINE EH(I,X,HXI)
      INCLUDE 'O8FUCO.INC'
      INTEGER I
      DOUBLE PRECISION X(*),HXI

      CRES(I)=CRES(I) + 1

C IF ( I .EQ. 1 )   HXI=1.22D0*X(4) - X(1) - X(5)
C IF ( I.EQ. 2 )  HXI=9.8D4*X(3)/(X(4)*X(9) + 1.D3*X(3))-X(6)
C IF ( I .EQ. 3 )  HXI=(X(2) + X(5))/X(1) - X(8)
      RETURN
      END

      SUBROUTINE EG(I,X,GXI)
      INCLUDE 'O8FUCO.INC'
      INTEGER I
      DOUBLE PRECISION X(*),GXI
      DOUBLE PRECISION UG(5),OG(5)
      DATA OG/ 3300.0D0, 0.205D0, 12.0D0, 0.22D0, 12000.0D0 /
      DATA UG/ 100.0D0, 0.03D0, 0.5D0, 0.04D0, 2000.0D0 /
      DOUBLE PRECISION WA, HF, PFCR, PTREAT, DELTA_SIGMAH, PNET,
     * DELTA_SIGMA, HPAV, HPREQD, PBURST,PSURF_MAX,PSURF_EQ,H
      SAVE
      IF ( GUNIT(1,I+NH) .NE. 1 ) CRES(I+NH)=CRES(I+NH) + 1
      IF ( I .LE. 8 )
     *  CALL CONSTRAINT(X,WA,HF, PFCR, PTREAT, DELTA_SIGMAH, PNET,
     *  DELTA_SIGMA, HPAV, HPREQD,PBURST, PSURF_MAX, PSURF_EQ, H)

C      SELECT CASE (I)
      IF ( I .GE. 9 ) GOTO 1000
      GOTO (100,200,300,400,500,600,700,800) I
100   CONTINUE
      GXI=X(1)-HF
      RETURN
200   CONTINUE
      GXI=PFCR - PTREAT
      RETURN
CC300   CONTINUE
CC     GXI=DELTA_SIGMAH - PNET
CC      RETURN
300   CONTINUE
      GXI=DELTA_SIGMA - 0.70D0*PNET
      RETURN
400   CONTINUE
      GXI=HPAV - HPREQD
      RETURN
500   CONTINUE
      GXI=PBURST - PSURF_MAX*1.1D0
      RETURN
600   CONTINUE

      GXI=PSURF_EQ - PSURF_MAX
      RETURN
700   CONTINUE
      GXI = H - HF
      RETURN
800   CONTINUE
      GXI = HF - 25.0D0
      RETURN
1000  CONTINUE
      IF ( I .LE. 13 ) THEN
        GXI=X(I-8) - UG(I-8)
      ELSE
        GXI = OG(I - 13) - X(I - 13)
      ENDIF
      RETURN
      END

      SUBROUTINE EGRADF(XL,GRADXL)
      INCLUDE 'O8COMM.INC'
      INCLUDE 'O8CONS.INC'
      INTEGER I
      DOUBLE PRECISION XL(*),GRADXL(*)
      DOUBLE PRECISION  FXL(6)
      DOUBLE PRECISION SD1,SD2,SD3,XINCR,ZZ,D1,D2,D3
C      !*******************************************************************
C      !     HIGH PRECISION NUMERICAL DIFFERENTIATION BY SIXTH ORDER EXTRAPOLATION
C      !     USES RICHARDSON-EXTRAPOLATION OF THREE VALUES OF THE SYMMETRIC
C      !     DIFFERENCE QUOTIENT WITH RATHER LARGE DISCRETIZATION STEPSIZE.
C      !     THE OPTIMAL STEPSIZE DEPENDS ON THE SEVENTH PARTIAL DERIVATIVES OF THE
C      !     FUNCTION.  SINCE THESE ARE INACCESSIBLE, WE REPLACE THEM BY ONE IN THE
C      !     ESTIMATE OF DELDIF.
C      !*******************************************************************

      DELDIF=EXP(LOG(EPSMAC)/SEVEN)*TWOM2
      ICGF=ICGF + 1
      DO   I=1,N
        ZZ=XL(I)
        XINCR=DELDIF*(ABS(XL(I)) + ONE)
        XL(I)=ZZ - XINCR
        CALL EF(XL,FXL(1))
        XL(I)=ZZ + XINCR
        CALL EF(XL,FXL(2))
        XINCR=XINCR + XINCR
        D1=XINCR
        XL(I)=ZZ - XINCR
        CALL EF(XL,FXL(3))
        XL(I)=ZZ + XINCR
        CALL EF(XL,FXL(4))
        XINCR=XINCR + XINCR
        D2=XINCR
        XL(I)=ZZ - XINCR
        CALL EF(XL,FXL(5))
        XL(I)=ZZ + XINCR
        CALL EF(XL,FXL(6))
        XL(I)=ZZ
        D3=XINCR + XINCR
        SD1=(FXL(2) - FXL(1))/D1
        SD2=(FXL(4) - FXL(3))/D2
        SD3=(FXL(6) - FXL(5))/D3
        SD3=SD2 - SD3
        SD2=SD1 - SD2
        SD3=SD2 - SD3
        GRADXL(I)=SD1 + P4*SD2 + SD3/C45
      END DO
      RETURN
      END
      SUBROUTINE EGRADG(J,XL,GRADXL)
      INCLUDE 'O8FUCO.INC'
      INCLUDE 'O8CONS.INC'
      INTEGER J
      DOUBLE PRECISION XL(*),GRADXL(*)
      DOUBLE PRECISION FXL(6)
      DOUBLE PRECISION SD1,SD2,SD3,XINCR,ZZ,D1,D2,D3
      INTEGER I

C      !*******************************************************************
C      !     HIGH PRECISION NUMERICAL DIFFERENTIATION BY SIXTH ORDER EXTRAPOLATION
C      !     USES RICHARDSON-EXTRAPOLATION OF THREE VALUES OF THE SYMMETRIC
C      !     DIFFERENCE QUOTIENT WITH RATHER LARGE DISCRETIZATION STEPSIZE.
C      !     THE OPTIMAL STEPSIZE DEPENDS ON THE SEVENTH PARTIAL DERIVATIVES OF THE
C      !     FUNCTION.  SINCE THESE ARE INACCESSIBLE, WE REPLACE THEM BY ONE IN THE
C      !     ESTIMATE OF DELDIF.
C      !*******************************************************************
      DELDIF=EXP(LOG(EPSMAC)/SEVEN)*TWOM2
      CGRES(J+NH)=CGRES(J+NH) + 1

      DO   I=1,N
        ZZ=XL(I)
        XINCR=DELDIF*(ABS(XL(I)) + ONE)
        XL(I)=ZZ - XINCR
        CALL EG(J,XL,FXL(1))
        XL(I)=ZZ + XINCR
        CALL EG(J,XL,FXL(2))
        XINCR=XINCR + XINCR
        D1=XINCR
        XL(I)=ZZ - XINCR
        CALL EG(J,XL,FXL(3))
        XL(I)=ZZ + XINCR
        CALL EG(J,XL,FXL(4))
        XINCR=XINCR + XINCR
        D2=XINCR
        XL(I)=ZZ - XINCR
        CALL EG(J,XL,FXL(5))
        XL(I)=ZZ + XINCR
        CALL EG(J,XL,FXL(6))
        XL(I)=ZZ
        D3=XINCR + XINCR
        SD1=(FXL(2) - FXL(1))/D1
        SD2=(FXL(4) - FXL(3))/D2
        SD3=(FXL(6) - FXL(5))/D3
        SD3=SD2 - SD3
        SD2=SD1 - SD2
        SD3=SD2 - SD3
        GRADXL(I)=SD1 + P4*SD2 + SD3/C45
      END DO
      RETURN
      END
      SUBROUTINE EGRADH(J,XL,GRADXL)
      INCLUDE 'O8FUCO.INC'
      INCLUDE 'O8CONS.INC'
      INTEGER J
      DOUBLE PRECISION  XL(*),GRADXL(*)

      DOUBLE PRECISION FXL(6)
      DOUBLE PRECISION SD1,SD2,SD3,XINCR,ZZ,D1,D2,D3
      INTEGER I

C      !*******************************************************************
C      !     HIGH PRECISION NUMERICAL DIFFERENTIATION BY SIXTH ORDER EXTRAPOLATION
C      !     USES RICHARDSON-EXTRAPOLATION OF THREE VALUES OF THE SYMMETRIC
C      !     DIFFERENCE QUOTIENT WITH RATHER LARGE DISCRETIZATION STEPSIZE.
C      !     THE OPTIMAL STEPSIZE DEPENDS ON THE SEVENTH PARTIAL DERIVATIVES OF THE
C      !     FUNCTION.  SINCE THESE ARE INACCESSIBLE, WE REPLACE THEM BY ONE IN THE
C      !     ESTIMATE OF DELDIF.
C      !*******************************************************************
      DELDIF=EXP(LOG(EPSMAC)/SEVEN)*TWOM2
      CGRES(J)=CGRES(J) + 1
      DO   I=1,N
        ZZ=XL(I)
        XINCR=DELDIF*(ABS(XL(I)) + ONE)
        XL(I)=ZZ - XINCR
        CALL EH(J,XL,FXL(1))
        XL(I)=ZZ + XINCR
        CALL EH(J,XL,FXL(2))
        XINCR=XINCR + XINCR
        D1=XINCR
        XL(I)=ZZ - XINCR
        CALL EH(J,XL,FXL(3))
        XL(I)=ZZ + XINCR
        CALL EH(J,XL,FXL(4))
        XINCR=XINCR + XINCR
        D2=XINCR
        XL(I)=ZZ - XINCR
        CALL EH(J,XL,FXL(5))
        XL(I)=ZZ + XINCR
        CALL EH(J,XL,FXL(6))
        XL(I)=ZZ
        D3=XINCR + XINCR
        SD1=(FXL(2) - FXL(1))/D1
        SD2=(FXL(4) - FXL(3))/D2
        SD3=(FXL(6) - FXL(5))/D3
        SD3=SD2 - SD3
        SD2=SD1 - SD2
        SD3=SD2 - SD3
        GRADXL(I)=SD1 + P4*SD2 + SD3/C45
      END DO
      RETURN
      END



C      ! FUNCTIONS REQUIRED TO FORMULATE CONSTRAINTS

      SUBROUTINE CONSTRAINT(XL,WA,HF,PFCR,PTREAT,DELTA_SIGMAH,
     *     PNET,DELTA_SIGMA,HPAV,HPREQD,PBURST,PSURF_MAX,PSURF_EQ,H)
      IMPLICIT NONE
      DOUBLE PRECISION XL(*)
      DOUBLE PRECISION WA,HF,PFCR,PTREAT,
     *     PNET,DELTA_SIGMA,HPAV,HPREQD,PBURST,PSURF_MAX,PSURF_EQ,H
      DOUBLE PRECISION EY,NU,CL,SP,RHOF,HT,SGF,SGP,DI,DELTA_PSURF,
     *   SIGMAH,SIGMASH,SIGMAHX,AA,BB,EX

      external erfc
      DOUBLE PRECISION WF, BETA1, HF1,
     *  DELTA_SIGMAH,
     *  RHOR, PHEAD, V, N1, KP, MUE, NRE, Y, THETA1, MUR, CF,
     *  DELTA_PFRIC, PSURF, E1


      DOUBLE PRECISION ERFC1
      INTEGER    NB
      SAVE
      DATA EY/ 3.5D10/, NU/ 0.20D0/, CL/ 9.84D-6/, SP/ 0.0d0/,
     *  RHOF/8.33D0/, HT/ 9500.0D0/,SGF/ 1.0D0/, SGP/ 2.65D0/,
     *   DI/ 2.992D0/, DELTA_PSURF/ 100.0D0/,SIGMAH/ 6000.0D0/,
     *  SIGMASH/ 7050.0D0/, SIGMAHX/ 7100.0D0/, AA / 0.0001D0/,
     * BB/ 0.009D0/, EX/ 1.0D-12/
      INTEGER J

      NB=200
C      !SOME MORE INITIALIZE VALUES

      PBURST = 13500.0D0
      PSURF_EQ = 14000.0D0
      HPAV = 12000.0D0
      H=100.0D0

C       ! FRACTURE WIDTH CALCULATION

        E1=EY/ (1.D0 - NU**2)
        WF=3.27D0*3.281D0*((XL(4)*XL(2)*XL(1)*0.3048D0)
     *     /(2.D0*E1))**0.25D0
        WA=(3.14159D0/5.0D0)*WF



C       ! FRACTURE HEIGHT CALCULATION


        BETA1=2.0D0*CL*DSQRT(3.14159D0*DABS(XL(5)))
     *     /(WA*0.3048D0+2.0D0*SP)


        CALL ERFC (BETA1, ERFC1)


        HF1=(DEXP(BETA1**2.D0)*ERFC1-1.0D0
     *     +2.0D0*BETA1/DSQRT(3.14159D0))/(4.0D0*(CL**2.D0)
     *     *3.14159D0*XL(1)*0.3048D0)

        HF=(WA*0.3048D0+2.0D0*SP)*XL(2)/2.0D0*HF1*3.281D0

C
C	! NET PRESSURE, TREATMENT PRESSURE, FORMATION CRITICAL PRESSURE


        PNET=E1*WF*0.000145D0/(2.0D0*HF)

        PTREAT=SIGMAH + PNET

        DELTA_SIGMAH=SIGMASH - SIGMAH

        PFCR=SIGMAH + DELTA_SIGMAH

        DELTA_SIGMA=SIGMAHX - SIGMAH



C       !CALCULATION OF PHEAD

        RHOR=(8.33D0+XL(3)/SGF)/(8.33D0+DABS(XL(3))/SGP)

        PHEAD=0.052D0*HT*RHOF*RHOR


C       !CALCULATION OF DELTA_PFRIC LOSS IN THE TUBING

        V=(XL(2)/(3.14159D0*DI**2.D0))*4.0D0*35.31466D0*144.0D0

        N1=0.4116D0*(1000.0D0*DABS(XL(4)))**(-0.1233D0)

        KP=(0.0005D0*1000.0D0*DABS(XL(4)) - 0.0159D0)*47880.0D0

        MUE=KP*DI**(1.D0-N1)*((3.D0+1.D0/N1)**N1)
     *      /(96.0D0*V**(1.D0-N1)*(0.0416D0)**N1)



        NRE=928.0D0*RHOF*V*DI/MUE


        CALL BISECT (AA, BB, EX, NB, Y, N1,NRE)


C  ! INCREASE IN FRICTIONAL LOSS DUE TO PROPPANT ADDITION

        THETA1=XL(3)/(8.33D0*SGP+DABS(XL(3)))

        MUR=1.0D0+2.5D0*THETA1+10.05D0*(THETA1**2.D0)
     *        +0.00273D0*DEXP(16.6D0*THETA1)


        CF=MUR**0.2D0 * RHOR**0.8D0

C                       ! FRICTIONAL PRESSURE LOSS (PSI)

        DELTA_PFRIC=Y*RHOF*V**2.D0*HT*CF/(25.8D0*DI)


C                       ! SURFACE PRESSURE (PUMPING PRESSURE, PSI)

        PSURF=PTREAT + DELTA_PFRIC + DELTA_PSURF - PHEAD


        PSURF_MAX=HPAV*550.0D0/(DABS(XL(2))*35.31466D0*144.0D0)

C                         ! TOTAL HORSE POWER REQUIRED

        HPREQD=PSURF*XL(2)*35.3144D0*144.0D0/550.0D0


	RETURN
      END


C      ! CALCULATION OF OBJECTIVE FUNCTION NPV

      SUBROUTINE OBJECTIVE(X, NPV)
      IMPLICIT NONE
      DOUBLE PRECISION X(*),NPV
C      ! PARAMETERS DECLARED
      DOUBLE PRECISION KI,H,S,PI,PWF,RE,RW,MUG,Z,TRES,EY,NU,CL,SP,
     *  PWFF,PCH,KWFH,ARES,BRES,PF,PPR,PPUM,PG,HPAV,DR

      DOUBLE PRECISION  QNF1, QNF, E1, WF, WA,BETA1, HF1, HF,
     *  L, M, Q1X, PCX, KWF, Q1Y, Q1Z, Q1ZZ,
     *  Q1, Q2X, Q2, QF, VI, CF, WP, CPR, CPUM, CTR, RN, PV,
     *  TPV, XFCOSH,  ACOQ1Z

      INTEGER RR
      SAVE
      DATA RR/10/
      DATA KI/ 0.20D0/,
     * H/ 100.0D0/, S / 0.D0/, PI /4300.0D0/, PWF /1600.0D0/,
     * RE /2978.0D0/, RW /0.3D0 /, MUG /0.028D0/, Z /0.88D0     /,
     * TRES /660.0D0/, EY /3.5D10      /, NU /0.20D0   /,
     * CL /9.84D-6      /, SP /0.0D0    /, PWFF /2000.0D0/,
     * PCH /2.0D0      /, KWFH /5000.0D0/, ARES /5280.0D0/,
     * BRES /5280.0D0/, PF /1.2D0       /, PPR /1.5D0   /,
     * PPUM /20.0D0/, PG /1.0D0 /, HPAV /12000.0D0/, DR /0.10D0 /

      DOUBLE PRECISION ERFC1
      external erfc

      INTEGER   INPV,J

C      !PRODUCTION BEFORE FRACTURING (MSCF/D)


       QNF1=1422.0D0*MUG*Z*TRES*(DLOG(RE/RW)-0.75D0 + S)


       QNF= KI*H*(PI**2.D0 - PWF**2.D0) / QNF1


C      !PRODUCTION AFTER FRACTRUING (MSCF/D)
C      !QF=L*Q1+M*Q2

       E1=EY/(1.D0-NU**2.D0)


       WF=3.27D0*3.281D0*((X(4)*X(2)*X(1)*0.3048D0)
     *        /(2.D0*E1))**0.25D0


       WA=(3.14159D0/5.0D0)*WF


C      !   CALCULATION OF FRACTURE HEIGHT HF


       BETA1=2.0D0*CL*DSQRT(3.14159D0*X(5))
     *    /(WA*0.3048D0+2.0D0*SP)


       CALL ERFC (BETA1, ERFC1)

       HF1=(DEXP(BETA1**2.0D0)*ERFC1-1.0D0
     *     +2.0D0*BETA1/DSQRT(3.14159D0))/(4.0D0*(CL**2.D0)
     *     *3.14159D0*X(1)*0.3048D0)



       HF=(WA*0.3048D0+2.0D0*SP)*X(2)/2.0D0*HF1*3.281D0



       L=(WF*HF)/(2.0D0*3.14159D0*RW*H+WF*HF)


       M=1.0D0-L



C      !   CALCULATION OF Q1

       Q1X=(PI**2.D0 - PWFF**2.D0)/(711.0D0*TRES*Z*MUG)




C      !        CALCULATION OF FRACTURE CONDUCTIVITY FROM BJH GRAPH


       PCX=X(3)*7.48052D0*WA


       KWF=KWFH*PCX/PCH


       Q1Y=X(1)/(2.0D0*KWF*HF)



       Q1Z=(DCOSH(3.14159D0*BRES/(2.0D0*ARES)))/
     *     (DSIN(3.14159D0*DABS(X(1))/(4.0D0*ARES)))


       IF(Q1Z.LE.0.0D0) THEN
        XFCOSH = Q1Z - DSQRT(Q1Z**2.D0 - 1.0D0)
        ELSE
        XFCOSH = Q1Z + DSQRT(Q1Z**2.D0 - 1.0D0)
       END IF


       ACOQ1Z = DLOG(XFCOSH)


       Q1ZZ=ACOQ1Z/(6.0D0*3.14159D0*KI*H)



       Q1=Q1X/(Q1ZZ + Q1Y)


C      !     CALCULATION OF Q2


       Q2X=1422.0D0*MUG*Z*TRES*(DLOG(RE/RW)-0.75D0 + S)

       Q2=KI*H*(PI**2.D0 - PWFF**2.D0)/Q2X


       QF=L*Q1 + M*Q2



C      ! CALCULATION OF TREATMENT COST
C      !               CTR=CF+CPR+CPUM

       VI= (X(2)/2.0D0)*X(5)*264.173D0


       CF=PF*VI

       WP=X(3)*VI

       CPR=PPR*WP

       CPUM=PPUM*HPAV

       CTR=CF+CPR+CPUM


C      ! CALCULATION OF NPV

       RN=PG*(QF-QNF)*365.0D0

       TPV=0.0D0
       DO INPV = 1,RR
        PV=(RN/(1.0D0+DR)**RR)
        TPV=TPV+PV

       ENDDO

       NPV = TPV - CTR

      RETURN
      END


C      !  CALCULATION OF ERROR FUNCTION: SUBROUTINE ERFC
C*******************************************************************
C*******************************************************************
      SUBROUTINE ERFC(X,ERFCVAL)
      IMPLICIT NONE
      DOUBLE PRECISION X,ERFCVAL
C********* COMPUTES THE GAUSSIAN NORMAL DISTRIBUTION INTEGRAL
C********* PRECISION ABOUT 16 DIGITS
      DOUBLE PRECISION P1(0:8),Q1(0:9),P2(0:5),Q2(0:6)
      DOUBLE PRECISION SQRT2,RSQRTPI,ARG,ARG2,XABS,ERF
C********** COEFFICIENTS TAKEN FROM HART COMPUTER APPROXIMATIONS
C********** NO ERFC 5708 AND ERFC 5725
      SAVE
      DATA P1/.37235079815548067D4, .71136632469540499D4,
     F        .67582169641104859D4, .40322670108300497D4,
     F        .16317602687537147D4, .45626145870609263D3,
     F        .86082762211948595D2, .10064858974909542D2,
     F        .56418958676181361d0/
      DATA Q1/.37235079815548065D4, .11315192081854405D5,
     F        .15802535999402043D5, .13349346561284457D5,
     F        .75424795101934758D4, .29680049014823087D4,
     F        .81762238630454408D3, .15307771075036222D3,
     F        .17839498439139557D2, .1D1/
      DATA P2/.29788656263939929D1, .74097406059647418D1,
     F        .61602098531096305D1, .50190497267842675D1,
     F        .12753666447299660D1, .56418958354775507d0/
      DATA Q2/.33690752069827528D1, .96089653271927879D1,
     F        .17081440747466004D2, .12048951927855129D2,
     F        .93960340162350542D1, .22605285207673270D1, .1D1/
      DATA SQRT2/1.41421356237390505D0/
      DATA RSQRTPI/.56418958354775629D0/
      XABS=DABS(X)
      IF ( XABS .GT. .47D0 ) THEN
	IF ( XABS .GT. 8.D0 ) THEN
C******* TAKE APPROXIMATION 5725
	  IF ( XABS .GT. 100.D0 ) THEN
	    ERFCVAL=0.D0
	  ELSE
	    ARG=XABS
	    ERFCVAL=(((((P2(5)*ARG+P2(4))*ARG+P2(3))*ARG+P2(2))*ARG+P2(1)
     F             )*ARG+P2(0))/
     F           ((((((ARG+Q2(5))*ARG+Q2(4))*ARG+Q2(3))*ARG+Q2(2))*ARG
     F                 +Q2(1))*ARG+Q2(0))*DEXP(-ARG**2)
	  ENDIF
	ELSE
C******** TAKE APPROXIMATION 5708
	  ARG=XABS
	  ERFCVAL=((((((((P1(8)*ARG+P1(7))*ARG+P1(6))*ARG+P1(5))*ARG
     F                 +P1(4))*ARG+P1(3))*ARG+P1(2))*ARG+P1(1))*ARG
     F                 +P1(0))/
     F         (((((((((ARG+Q1(8))*ARG+Q1(7))*ARG+Q1(6))*ARG+Q1(5))
     F                 *ARG+Q1(4))*ARG+Q1(3))*ARG+Q1(2))*ARG+Q1(1))
     F                 *ARG+Q1(0))*DEXP(-ARG**2)
	ENDIF
	IF ( X .LT. 0.D0 ) ERFCVAL=2.D0-ERFCVAL
      ELSE
C************ TAKE POWER SERIES APPROXIMATION
	ARG=XABS
	ARG2=ARG**2
	ERF=ARG*2.D0*RSQRTPI*((((((((((ARG2/210.D0-1.D0/19.D0)*ARG2
     F     /9.D0+1.D0/17.D0)*ARG2/8.D0-1.D0/15.D0)*ARG2/7.D0+1.D0/13.D0)
     F     *ARG2/6.D0-1.D0/11.D0)*ARG2/5.D0+1.D0/9.D0)*ARG2/4.D0
     F     -1.D0/7.D0)*ARG2/3.D0+1.D0/5.D0)*ARG2/2.D0-1.D0/3.D0)*ARG2
     F     +1.D0)
        IF ( X .GE. 0.D0 ) THEN
             ERFCVAL=1.D0-ERF
	ELSE
             ERFCVAL=1.D0+ERF
        ENDIF
	RETURN

      ENDIF
      END




C      ! CALCULATION OF FRICTION FACTOR: BISECTION SUBROUTINE


        SUBROUTINE BISECT (AA, BB, EX, NB, YM,N1,NRE)
C               !       IMPLEMENTS BISECTION METHOD
        IMPLICIT NONE
        DOUBLE PRECISION AA, BB, EX
        DOUBLE PRECISION YM
        INTEGER NB
        DOUBLE PRECISION N1,NRE
        DOUBLE PRECISION  YL, YR,F1,F2
        INTEGER IB
        YL = AA
        YR = BB
        NB = DLOG(DABS(AA-BB)/EX) / DLOG(2.0D0) + 1.D0

        DO IB = 1, NB
          YM = (YL + YR) / 2.D0
          CALL FF(YL,N1,NRE,F1)
          CALL FF(YM,N1,NRE,F2)
          IF (F1*F2 .GT. 0.D0) THEN
            YL = YM
          ELSE
           YR = YM
          END IF
        END DO

        RETURN
      END

      SUBROUTINE FF(Y,N1,NRE,FN)
      DOUBLE PRECISION  FN
      DOUBLE PRECISION  Y
      DOUBLE PRECISION  AX,BX,CX,N1,NRE

      AX= 0.395D0/(N1**1.2D0)
      BX= NRE*(Y**(1.D0-N1/2.D0))

      CX= 4.D0/(N1**0.75D0)
      FN = DSQRT(1.D0/Y) + AX - CX* DLOG10(BX)

	RETURN
      END



C      SUBROUTINE SOLCHK()
C      INCLUDE 'O8COMM.INC'
C      DOUBLE PRECISION WA, HF, PFCR, PTREAT, DELTA_SIGMAH,
C     *      PNET, DELTA_SIGMA, HPAV, HPREQD,PBURST,
C     *      PSURF_MAX,PSURF_EQ,H
C      CALL CONSTRAINT(X,WA,HF,PFCR,PTREAT,DELTA_SIGMAH,PNET,
C     *     DELTA_SIGMA,HPAV,HPREQD,PBURST,PSURF_MAX,PSURF_EQ,H)
C
C      WRITE(PROU,FMT='(''HF FINAL= '',E23.16)') HF
C      WRITE(PROU,FMT='(''WA FINAL= '',E23.16)') WA
C      CLOSE(50)
C      RETURN
C      END


