;;; -*- Mode: Lisp -*-
;;; $Id: database-funcs.lisp,v 1.12 2002/02/25 22:10:12 craig Exp $
;;;
;;; Copyright (c) 2000, 2001 onShore Development, Inc.
;;;
;;; MaiSQL-specific functions

(in-package :local-time)

(defmethod maisql-sys::database-output-sql ((local-time local-time)
					    database)
  (declare (ignore database))
  (db-timestring local-time))

(defmethod maisql-sys::database-output-sql ((duration duration)
					    database)
  (declare (ignore database))
  (princ-to-string (designate-duration duration)))

(defconstant +decimal-printer+ #(#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9))

(defun db-timestring (local-time)
  "return the string to store the given time as UTC in the database"
  (declare (optimize (speed 3)))
  (let ((output (copy-seq "'XXXX-XX-XX XX:XX:XX+00'"))
        (day (local-time-day local-time))
        (sec (local-time-sec local-time)))
    (flet ((inscribe-base-10 (output offset size decimal)
             (declare (type fixnum offset size decimal))
             (dotimes (x size)
               (declare (type fixnum x)
                        (optimize (safety 0)))
               (multiple-value-bind (next this)
                   (floor decimal 10)
                 (setf (aref output (+ (- size x 1) offset))
                       (aref +decimal-printer+ this))
                 (setf decimal next)))))
      (multiple-value-bind (year month day)
          (%gregorian-date day)
        (multiple-value-bind (hour minute second)
            (%local-time-hms sec)
          (inscribe-base-10 output 1 4 year)
          (inscribe-base-10 output 6 2 month)
          (inscribe-base-10 output 9 2 day)
          (inscribe-base-10 output 12 2 hour)
          (inscribe-base-10 output 15 2 minute)
          (inscribe-base-10 output 18 2 second)
          output)))))

(defmethod maisql-sys::database-get-type-specifier ((type (eql 'local-time))
                                                    args database)
  (declare (ignore database args))
  "DATETIME")

(defmethod maisql-sys::database-get-type-specifier ((type (eql 'duration))
                                                    args database)
  (declare (ignore database args))
  "INT8")

;; Read a value from the DB e.g. 2000-11-11 00:00:00-06

(defmethod maisql-sys::read-sql-value (val (type (eql 'local-time)) database)
  (declare (ignore database))
  (when (not (eq 'NULL val))
    (parse-timestring val)))

(defmethod maisql-sys::read-sql-value (val (type (eql 'duration)) database)
  (declare (ignore database))
  (when (not (eq 'NULL val))
    (etypecase val
      (string
       (duration-designator (read-from-string val)))
      (integer
       (duration-designator val)))))

(defmethod maisql-sys::coerce-to-ec-key-value ((value local-time))
  (designate-local-time value))

(defmethod maisql-sys::coerce-to-ec-key-value ((value duration))
  (designate-local-time value))
