;;; -*- Mode: Lisp -*-
;;; $Id: unix-uffi.lisp,v 1.2 2002/03/29 04:34:10 craig Exp $
;;;
;;; Copyright (c) 2000, 2001 onShore Development, Inc.
;;; Provided by Kevin Rozenberg <kevin@rosenberg.net>

;;; Calls to unix.

(in-package :local-time)

(declaim (optimize (speed 3) (debug 1) #+cmu (extensions:inhibit-warnings 3)))

(eval-when (:compile-toplevel :load-toplevel :execute)
  (use-package :uffi))

(progn
(def-foreign-type time-t :long)

(def-struct time
    (tm-sec   :int)			; seconds
  (tm-min   :int)			; minutes
  (tm-hour  :int)			; hours
  (tm-mday  :int)			; day of month
  (tm-mon   :int)			; month
  (tm-year  :int)			; year
  (tm-wday  :int)			; day of week
  (tm-yday  :int)			; day of year
  (tm-isdst :int))			; daylight savings time

(def-function "gmtime"
    ((time (* time-t)))
  :returning (* time))

(def-function "localtime"
    ((time (* time-t)))
  :returning (* time))

(defun libc-gmtime (time)
  (declare (type integer time))
  (with-foreign-object (alien-time 'time-t)
    (setf (deref-pointer alien-time 'time-t) time)
    (let ((result (gmtime alien-time)))
      (values (get-slot-value result 'time 'tm-sec)	; seconds
	      (get-slot-value result 'time 'tm-min)	; minutes
	      (get-slot-value result 'time 'tm-hour)	; hours
	      (get-slot-value result 'time 'tm-mday)	; day of month
	      (get-slot-value result 'time 'tm-mon)	; month
	      (get-slot-value result 'time 'tm-year)	; year
	      (get-slot-value result 'time 'tm-wday)	; day of week
	      (get-slot-value result 'time 'tm-yday)	; day of year
	      (get-slot-value result 'time 'tm-isdst))))) ; daylight savings time

(defun libc-localtime (time)
  (declare (type integer time))
  (with-foreign-object (alien-time 'time-t)
    (setf (deref-pointer alien-time 'time-t) time)
    (let ((result (localtime alien-time)))
      (values (get-slot-value result 'time 'tm-sec)	; seconds
	      (get-slot-value result 'time 'tm-min)	; minutes
	      (get-slot-value result 'time 'tm-hour)	; hours
	      (get-slot-value result 'time 'tm-mday)	; day of month
	      (get-slot-value result 'time 'tm-mon)	; month
	      (get-slot-value result 'time 'tm-year)	; year
	      (get-slot-value result 'time 'tm-wday)	; day of week
	      (get-slot-value result 'time 'tm-yday)	; day of year
	      (get-slot-value result 'time 'tm-isdst))))) ; daylight savings time

(defun gmt-offset (time)
  (let* ((gmt (multiple-value-list (libc-gmtime time)))
         (loc (multiple-value-list (libc-localtime time)))
         (delta (mapcar #'- gmt loc)))
    (* -3600 (if (not (= 0 (nth 7 delta)))
                (+ 24 (nth 2 delta))
                (nth 2 delta)))))

(def-struct timeval
    (tv-sec :long)
  (tv-usec :long))

(def-struct timezone
    (tz-minuteswest :int)
  (tz-dsttime :int))

(def-function "gettimeofday"
    ((timeval (* timeval))
     (timezone (* timezone)))
  :returning :int)

(defun libc-gettimeofday ()
    (with-foreign-objects ((timeval 'timeval)
			   (timezone 'timezone))
      (let ((result (gettimeofday timeval timezone)))
	(values (if (zerop result) t nil)
		(get-slot-value timeval 'timeval 'tv-sec)
		(get-slot-value timeval 'timeval 'tv-usec)
		(get-slot-value timezone 'timezone 'tz-minuteswest)
		(get-slot-value timezone 'timezone 'tz-dsttime)))))

      
(defun utc-offset ()
  (gmt-offset (nth 1 (multiple-value-list (libc-gettimeofday)))))

;(def-alien-variable ("timezone" libc-timezone) time-t)

;(def-alien-variable ("tzname" libc-tzname) (array c-string 2))

(def-function "mktime"
    ((* time))
  :returning time-t)

(defun libc-mktime (year mon mday &optional (hour 0) (min 0) (sec 0))
  (declare (type integer year mon mday hour min sec))
  (with-foreign-object (alien-time 'time)
      (setf (get-slot-value alien-time 'time 'tm-year) (- year 1900))
      (setf (get-slot-value alien-time 'time 'tm-mon) (1- mon))
      (setf (get-slot-value alien-time 'time 'tm-mday) mday)
      (setf (get-slot-value alien-time 'time 'tm-hour) hour)
      (setf (get-slot-value alien-time 'time 'tm-min) min)
      (setf (get-slot-value alien-time 'time 'tm-sec) sec)
      (setf (get-slot-value alien-time 'time 'tm-yday) 0)
      (setf (get-slot-value alien-time 'time 'tm-wday) 0)
      (setf (get-slot-value alien-time 'time 'tm-isdst) 0)
      (mktime alien-time)))

(defun maketime (year mon mday)
  (let ((time-a (libc-mktime year mon mday))
        (time-b (libc-mktime year 1 1)))
    (+ time-a (- (gmt-offset time-a) (gmt-offset time-b)))))



)
