;;; -*- Mode: Lisp -*-
;;; $Id: alist.lisp,v 1.6 2002/03/29 03:10:46 jesse Exp $
;;;
;;; Copyright (c) 2001 onShore Development, Inc.

(in-package :odcl)

(defmacro update-alist (item value alist &key (test '#'eql) (key '#'identity))
  "If alist already has a value for Key, it is updated to be Value.
Otherwise the passed alist is updated with key-value added as a new
pair."
  (let ((entry (gensym)))
    `(let ((,entry (assoc ,item ,alist :test ,test :key ,key)))
      (if ,entry
          (progn (setf (cdr ,entry) ,value)
                 ,alist)
          (setf ,alist (acons ,item ,value ,alist))))))

(defun get-alist (item alist &key (test #'eql))
  (cdr (assoc item alist :test test)))

(defun (setf get-alist) (value item alist &key (test #'eql))
  (update-alist item value alist :test test)
  value)

(defun flatten-alist (alist)
  (apply #'append (mapcar (lambda (x)
                            (list (car x) (cdr x))) alist)))
