/*
 * Copyright (c) 2001-2004 MUSIC TECHNOLOGY GROUP (MTG)
 *                         UNIVERSITAT POMPEU FABRA
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


#ifndef _OD_AudioDecimator_
#define _OD_AudioDecimator_

#include "Processing.hxx"
#include "Array.hxx"

namespace CLAM
{

	namespace OnsetDetection
	{
		
		class AudioDecimatorConfig: public ProcessingConfig
		{
		public:
			DYNAMIC_TYPE_USING_INTERFACE (AudioDecimatorConfig, 0, ProcessingConfig);
		};
		
		class AudioDecimator: public Processing
		{
		private:			
			bool ConcreteConfigure(const ProcessingConfig& cfg);
		public:
			
			const char * GetClassName() const {return "AudioDecimator";}
			AudioDecimator();
			AudioDecimator(AudioDecimatorConfig& c);
			~AudioDecimator();
			
			bool Do(void);
			bool Do(DataArray &in, int sampleRate, int type);

			// 44.1kHz to 22.05kHz decimation ( 2:1 ). Input signal
			// is smoothed with a Tchebyshev filter to minimize
			// aliasing. Filter coefficients were generated by
			// MATLAB's cheby1 function with order=8, R=0.5 and wn=0.4
			void DecimateFrom44100To22050( const DataArray& signal,
						       DataArray& decimatedSignal );

			// 22.05kHz to 245 Hz decimation ( 90:1 ). Input signal
			// is smoothed with a Tchebyshev filter to minimize
			// aliasing. Due to the "extreme" decimation factor two
			// filters are applied in sequence - one forward and the
			// second one backwards - so to avoid phase distortion.
			// Filter coefficients were generated by
			// MATLAB's cheby1 function with order=4, R=0.5 and wn=1/90.
			void DecimateFrom22050To245( const Array<double>& signal,
						     Array<double>& decimatedSignal );
			void DecimateFrom22050To245( const Array<float>& signal,
						     Array<double>& decimatedSignal );
			

			const ProcessingConfig &GetConfig() const { return mConfig;}
		
		private: // attributes
			AudioDecimatorConfig mConfig;
			Array<double>            mOutput;
			Array<double>            mOutputRev;
		};
		
	} // namespace OnsetDetection
	
} // namespace CLAM

#endif // _AudioDecimator_

