/*
	$Id: displaycard_win32compatible.h,v 1.2 2001/09/08 19:12:46 japj Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/
#ifndef header_displaycard_win32compatible
#define header_displaycard_win32compatible

#include "../Generic/displaycard_generic.h"
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "Core/System/Win32/init_win32.h"

class CL_DisplayCard_Win32Compatible : public CL_DisplayCard_Generic, CL_Win32EventListener
{
public:
	CL_DisplayCard_Win32Compatible(int card_no);
	virtual ~CL_DisplayCard_Win32Compatible();

	HWND get_hwnd() { return hwnd; }

	void create_window(
		int width,
		int height,
		int bpp,
		bool full_screen,
		bool allow_resize);

	virtual void show_system_cursor();
	virtual void hide_system_cursor();

protected:
	void destroy_window();
        HWND hwnd; //This needs to be inherited

private:
	virtual bool received_event(UINT uMsg, WPARAM wParam, LPARAM lParam);


};

#endif