/*
	$Id: sprite2.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Sprite surface provider especially designed for the font class.
		Most likely not very usable other places.

*/

//! component="SurfaceProviders"

#ifndef header_sprite2
#define header_sprite2

#include "generic_surfaceprovider.h"
#include "../IOData/inputsource.h"
#include "../IOData/inputsource_provider.h"
#include "../Display/pixelformat.h"

class CL_Sprite2Provider : public CL_SurfaceProvider_Generic
{
protected:
	std::string surface_id;
	void *surface_data;
	int width, height, no_sprs, transcol;
	CL_Palette *palette;
	EPixelFormat pixelformat;
	unsigned int red_mask, green_mask, blue_mask, alpha_mask;
	unsigned int bpp;
	bool m_is_indexed;

	void load_data(CL_InputSource *datafile);

public:
	CL_Sprite2Provider(CL_InputSource *source);
	CL_Sprite2Provider(
		CL_SurfaceProvider *src,
		int x, int y, int width, int height,
		int *tcols, int tcols_num);
	virtual ~CL_Sprite2Provider();

	virtual unsigned int get_width() const;
	//: Returns the width of the sprite2.

	virtual unsigned int get_height() const;
	//: Returns the height of the sprite2.

	virtual unsigned int get_pitch() const;
	//: Returns the pitch of the sprite2.
	
	virtual unsigned int get_num_frames() const;
	//: Returns the number of subsprite2s in this sprite2.
	
//	virtual EPixelFormat get_pixel_format() const;
	//: Returns the pixel format used by the sprite2.

	virtual CL_Palette *get_palette() const;
	//: Returns the palette used by the surface. NULL if the system palette is 
	//: used.

	virtual bool uses_src_colorkey() const;
	virtual unsigned int get_src_colorkey() const;
	//: Returns the transparency color used, or -1 if none.

	virtual bool is_indexed() const;
	virtual unsigned int get_red_mask() const;
	virtual unsigned int get_green_mask() const;
	virtual unsigned int get_blue_mask() const;
	virtual unsigned int get_alpha_mask() const;
	virtual unsigned int get_depth() const;
	
	virtual void *get_data() const;
	//: Returns a pointer to the sprite2s image data. Can only be called between 
	//: lock() and unlock().

	virtual void perform_lock();
	//: Locks the surface provider. This causes the sprite2 to retrieve its 
	//: surface data from the datafile.
	
	virtual void perform_unlock();
	//: Unlocks the surface provider. The sprite2 releases its surface data when
	//: it is called.
};

#endif
