/*
	$Id: displaycard_ptc.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#ifdef USE_PTC

#include <ptc/ptc.h>

#include <Core/Display/PTC/displaycard_ptc.h>
#include <Core/Display/X11/display_xwindow.h>
#include <Core/Display/Generic/mousecursor_generic.h>

#include <API/Core/Display/palette.h>
#include <API/Core/Display/target.h>
#include <API/Core/Display/vidmode.h>
#include <API/Core/System/clanapp.h>

#ifndef WIN32
#include "Core/System/Generic/string_asm.h"
#else
#define asm_memmove memcpy
#define asm_memset memset
#endif

CL_DisplayCard_PTC::CL_DisplayCard_PTC(int card_no)
#ifndef WIN32
: CL_XWindow_CompatibleCard(card_no)
#else
: CL_DisplayCard_Generic(card_no)
#endif
{
	m_initialized = false;
	m_target = new CL_Target_PTC(&m_console, &m_palette);
}

CL_DisplayCard_PTC::~CL_DisplayCard_PTC()
{
	CL_MouseCursor::hide();
	if (m_initialized) m_console.close();
	delete m_target;
}

void CL_DisplayCard_PTC::flip_display(bool /*sync*/)
{
	signal_preflip();
	m_console.update();
	signal_postflip();
}

CL_Target *CL_DisplayCard_PTC::get_target()
{
	return m_target;
}

CL_Target *CL_DisplayCard_PTC::get_frontbuffer()
{
	return m_target;
}

/*
	MBN: Not needed anymore - instead make ClanLib call Hermes' clear func.

void CL_DisplayCard_PTC::clear_display(
	float red,
	float green,
	float blue,
	float alpha)
{
	Color color(red, green, blue, alpha);
	m_console.clear(color);
}
*/

void CL_DisplayCard_PTC::set_palette(CL_Palette *cl_pal)
{
	int32 pal_ptr[3*256];

	for (int i=0; i<256; i++)
	pal_ptr[i] = ((cl_pal->palette[i*3]&0xff)<<16)|
	             ((cl_pal->palette[i*3+1]&0xff)<<8)|
	             (cl_pal->palette[i*3+2]&0xff);

	Palette pal(pal_ptr);
	m_console.palette(pal);

	asm_memmove((char *) m_palette.palette, (char *) cl_pal->palette, 3*256);
}

CL_Palette *CL_DisplayCard_PTC::get_palette()
{
	return &m_palette;
}

void CL_DisplayCard_PTC::set_videomode(
	int width,
	int height,
	int bpp,
	bool fullscreen,
	bool allow_resize)
{
	set_gfxmode(width, height, bpp, fullscreen, allow_resize);
	
//	Format format(16, 0x7c00, 0x3c0, 0x1f);
	Format format;
	m_console.open(CL_ClanApplication::app->get_title(), width, height, format);

#ifdef WIN32
	m_console.option("disable key buffering");
#endif
	
	m_initialized = true;
}

bool CL_DisplayCard_PTC::is_initialized()
{
	return m_initialized;
}

const std::list<CL_VidMode*> &CL_DisplayCard_PTC::get_videomodes()
{
	// PTC doesn't have a list of videomodes, does it?

	static std::list<CL_VidMode*> list;
	return list;
}

#ifdef WIN32

CL_Display_PTC::CL_Display_PTC(int options)
{
	int card_no=0;
	CL_Display::cards.push_back(new CL_DisplayCard_PTC(card_no++));//, NULL, "Default Display Driver", options));

	CL_Display_PTC::cur_card = (CL_DisplayCard_PTC *) (*CL_Display::cards.begin());
}

CL_Display_PTC::~CL_Display_PTC()
{
	/*
	for (int i=0;i<CL_Display::cards.size();i++)
	{
		delete CL_Display::cards[i];
	}
*/
}

CL_DisplayCard_PTC *CL_Display_PTC::cur_card = NULL;;


void CL_Display::select_card(CL_DisplayCard *card)
{
	CL_Display_PTC::cur_card = (CL_DisplayCard_PTC*) card;
}

CL_DisplayCard *CL_Display::get_current_card()
{
	return CL_Display_PTC::cur_card;
}
#endif

#endif /* USE_PTC */
