/*
	$Id: keyboard_be.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#include <Core/Input/Be/keyboard_be.h>
#include <API/Core/Input/inputaxis.h>
#include <API/Core/Input/inputbuffer.h>
#include <Core/Input/Be/keyboard_be.h>
#include <API/Core/Input/inputbutton.h>
#include <Core/Input/Be/keyboard_be.h>
#include <API/Core/Input/inputcursor.h>
#include <API/Core/Input/inputhat.h>
#include <Core/System/Be/app_beos.h>

/******************
  Keyboard
******************/

CL_BeKeyboard::CL_BeKeyboard()
{
	memset( &keymap, 0, sizeof(keymap) );
	
	CL_System_Generic::keep_alives.add(this);
}

CL_BeKeyboard::~CL_BeKeyboard()
{
	CL_System_Generic::keep_alives.del(this);
	
	int num = buttons.get_num_items();
	for (int i=0; i<num; i++) delete buttons[i];
}

bool CL_BeKeyboard::keep_alive()
{
	return false;
}

void CL_BeKeyboard::handle_modifiers(BMessage* msg)
{
	int32 mods;
	msg->FindInt32("modifiers", &mods);
	
	keymap[KEY_LSHIFT] = (mods & B_LEFT_SHIFT_KEY);
	keymap[KEY_RSHIFT] = (mods & B_RIGHT_SHIFT_KEY);
	keymap[KEY_LCTRL] = (mods & B_LEFT_CONTROL_KEY);
	keymap[KEY_RCTRL] = (mods & B_RIGHT_CONTROL_KEY);
	keymap[KEY_ALT] = (mods & B_LEFT_OPTION_KEY);
	keymap[KEY_ALTGR] = (mods & B_RIGHT_OPTION_KEY);
}

void CL_BeKeyboard::handle_key(BMessage* msg, bool down)
{
	int8 val;
	msg->FindInt8("byte", &val);

	switch (val)
	{
		case B_ENTER:
			if (down) buffer.add_key( KEY_ENTER );
			keymap[KEY_ENTER] = down;
			break;
		case B_ESCAPE:
			if (down) buffer.add_key( KEY_ESCAPE );
			keymap[KEY_ESCAPE] = down;
			break;
		case B_BACKSPACE:
			if (down) buffer.add_key( KEY_BACKSPACE );
			keymap[KEY_BACKSPACE] = down;
			break;
		case B_SPACE:
			if (down) buffer.add_key( KEY_SPACE );
			keymap[KEY_SPACE] = down;
			break;
		case B_TAB:
			if (down) buffer.add_key( KEY_TAB );
			keymap[KEY_TAB] = down;
			break;
		case B_LEFT_ARROW:
			if (down) buffer.add_key( KEY_LEFT );
			keymap[KEY_LEFT] = down;
			break;
		case B_RIGHT_ARROW:
			if (down) buffer.add_key( KEY_RIGHT );
			keymap[KEY_RIGHT] = down;
			break;
		case B_UP_ARROW:
			if (down) buffer.add_key( KEY_UP );
			keymap[KEY_UP] = down;
			break;
		case B_DOWN_ARROW:
			if (down) buffer.add_key( KEY_DOWN );
			keymap[KEY_DOWN] = down;
			break;
		case B_INSERT:
			if (down) buffer.add_key( KEY_INSERT );
			keymap[KEY_INSERT] = down;
			break;
		case B_DELETE:
			if (down) buffer.add_key( KEY_DELETE );
			keymap[KEY_DELETE] = down;
			break;
		case B_HOME:
			if (down) buffer.add_key( KEY_HOME );
			keymap[KEY_HOME] = down;
			break;
		case B_END:
			if (down) buffer.add_key( KEY_END );
			keymap[KEY_END] = down;
			break;
		case B_PAGE_UP:
			if (down) buffer.add_key( KEY_PAGEUP );
			keymap[KEY_PAGEUP] = down;
			break;
		case B_PAGE_DOWN:
			if (down) buffer.add_key( KEY_PAGEDOWN );
			keymap[KEY_PAGEDOWN] = down;
			break;
	}
	
	switch (msg->FindInt32("key"))
	{
		case B_F1_KEY:
			if (down) buffer.add_key( KEY_F1 );
			keymap[KEY_F1] = down;
			break;
		case B_F2_KEY:
			if (down) buffer.add_key( KEY_F2 );
			keymap[KEY_F2] = down;
			break;
		case B_F3_KEY:
			if (down) buffer.add_key( KEY_F3 );
			keymap[KEY_F3] = down;
			break;
		case B_F4_KEY:
			if (down) buffer.add_key( KEY_F4 );
			keymap[KEY_F4] = down;
			break;
		case B_F5_KEY:
			if (down) buffer.add_key( KEY_F5 );
			keymap[KEY_F5] = down;
			break;
		case B_F6_KEY:
			if (down) buffer.add_key( KEY_F6 );
			keymap[KEY_F6] = down;
			break;
		case B_F7_KEY:
			if (down) buffer.add_key( KEY_F7 );
			keymap[KEY_F7] = down;
			break;
		case B_F8_KEY:
			if (down) buffer.add_key( KEY_F8 );
			keymap[KEY_F8] = down;
			break;
		case B_F9_KEY:
			if (down) buffer.add_key( KEY_F9 );
			keymap[KEY_F9] = down;
			break;
		case B_F10_KEY:
			if (down) buffer.add_key( KEY_F10 );
			keymap[KEY_F10] = down;
			break;
		case B_F11_KEY:
			if (down) buffer.add_key( KEY_F11 );
			keymap[KEY_F11] = down;
			break;
		case B_F12_KEY:
			if (down) buffer.add_key( KEY_F12 );
			keymap[KEY_F12] = down;
			break;
	}

	switch (msg->FindInt32("raw_char"))
	{
		case 'a':
			if (down) buffer.add_key( KEY_A );
			keymap[KEY_A] = down;
			break;
		case 'b':
			if (down) buffer.add_key( KEY_B );
			keymap[KEY_B] = down;
			break;
		case 'c':
			if (down) buffer.add_key( KEY_C );
			keymap[KEY_C] = down;
			break;
		case 'd':
			if (down) buffer.add_key( KEY_D );
			keymap[KEY_D] = down;
			break;
		case 'e':
			if (down) buffer.add_key( KEY_E );
			keymap[KEY_E] = down;
			break;
		case 'f':
			if (down) buffer.add_key( KEY_F );
			keymap[KEY_F] = down;
			break;
		case 'g':
			if (down) buffer.add_key( KEY_G );
			keymap[KEY_G] = down;
			break;
		case 'h':
			if (down) buffer.add_key( KEY_H );
			keymap[KEY_H] = down;
			break;
		case 'i':
			if (down) buffer.add_key( KEY_I );
			keymap[KEY_I] = down;
			break;
		case 'j':
			if (down) buffer.add_key( KEY_J );
			keymap[KEY_J] = down;
			break;
		case 'k':
			if (down) buffer.add_key( KEY_K );
			keymap[KEY_K] = down;
			break;
		case 'l':
			if (down) buffer.add_key( KEY_L );
			keymap[KEY_L] = down;
			break;
		case 'm':
			if (down) buffer.add_key( KEY_M );
			keymap[KEY_M] = down;
			break;
		case 'n':
			if (down) buffer.add_key( KEY_N );
			keymap[KEY_N] = down;
			break;
		case 'o':
			if (down) buffer.add_key( KEY_O );
			keymap[KEY_O] = down;
			break;
		case 'p':
			if (down) buffer.add_key( KEY_P );
			keymap[KEY_P] = down;
			break;
		case 'q':
			if (down) buffer.add_key( KEY_Q );
			keymap[KEY_Q] = down;
			break;
		case 'r':
			if (down) buffer.add_key( KEY_R );
			keymap[KEY_R] = down;
			break;
		case 's':
			if (down) buffer.add_key( KEY_S );
			keymap[KEY_S] = down;
			break;
		case 't':
			if (down) buffer.add_key( KEY_T );
			keymap[KEY_T] = down;
			break;
		case 'u':
			if (down) buffer.add_key( KEY_U );
			keymap[KEY_U] = down;
			break;
		case 'v':
			if (down) buffer.add_key( KEY_V );
			keymap[KEY_V] = down;
			break;
		case 'w':
			if (down) buffer.add_key( KEY_W );
			keymap[KEY_W] = down;
			break;
		case 'x':
			if (down) buffer.add_key( KEY_X );
			keymap[KEY_X] = down;
			break;
		case 'y':
			if (down) buffer.add_key( KEY_Y );
			keymap[KEY_Y] = down;
			break;
		case 'z':
			if (down) buffer.add_key( KEY_Z );
			keymap[KEY_Z] = down;
			break;
	}
}

char *CL_BeKeyboard::get_name() const
{
	return "Be Keyboard";
}

int CL_BeKeyboard::get_num_buttons() const
{
	return NUM_KEYS;
}

CL_InputButton *CL_BeKeyboard::get_button(int button_num)
{
	if (buttons[button_num] != NULL) return buttons[button_num];
	
	buttons.add( new CL_InputButton_BeKeyboard(button_num, keymap), button_num );

	return buttons[button_num];
}

int CL_BeKeyboard::get_num_axes() const
{
	return 0;
}

CL_InputAxis *CL_BeKeyboard::get_axis(int /*axis_num*/)
{
	return NULL;
}

int CL_BeKeyboard::get_num_hats() const
{
	return 0;
}

CL_InputHat *CL_BeKeyboard::get_hat(int /*hat_num*/)
{
	return NULL;
}

int CL_BeKeyboard::get_num_buffers() const
{
	return 1;
}

CL_InputBuffer *CL_BeKeyboard::get_buffer(int /*buffer_num*/)
{
	return &buffer;
}

int CL_BeKeyboard::get_num_cursors() const
{
	return 0;
}

CL_InputCursor *CL_BeKeyboard::get_cursor(int /*cursor_num*/)
{
	return NULL;
}

/***************************
  CL_InputBuffer_BeKeyboard
***************************/

CL_InputBuffer_BeKeyboard::CL_InputBuffer_BeKeyboard()
{
	m_begin = 0;
	m_end = 0;
	m_buffer_size = 1024;
	m_buffer = new int[m_buffer_size];
}

CL_InputBuffer_BeKeyboard::~CL_InputBuffer_BeKeyboard()
{
	delete[] m_buffer;
}

int CL_InputBuffer_BeKeyboard::peek_key() const
{
	if (m_begin == m_end) return -1;
	return m_buffer[m_begin];
}

int CL_InputBuffer_BeKeyboard::get_key()
{
	if (m_begin == m_end) return -1;

	return (m_buffer[m_begin++]);
}

int CL_InputBuffer_BeKeyboard::keys_left()
{
	return m_end - m_begin;
}

void CL_InputBuffer_BeKeyboard::clear()
{
	m_begin = 0;
	m_end = 0;
}

int CL_InputBuffer_BeKeyboard::get_ascii()
{
	static bool first_time = true;
	if (first_time)
		cl_info(2, "CL_InputBuffer::get_ascii() not (yet) implemented in GGI.");
	first_time = false;
	return 0;
}

unsigned int CL_InputBuffer_BeKeyboard::get_unicode()
{
	static bool first_time = true;
	if (first_time)
		cl_info(2, "CL_InputBuffer::get_unicode() not (yet) implemented in GGI.");
	first_time = false;
	return 0;
}

void CL_InputBuffer_BeKeyboard::add_key(int key)
{
	if (m_end == m_buffer_size) // reached end of buffer
	{
		if (m_begin == 0) return; // totally full! - discard

		// Move contents to beginning of buffer...
		memcpy((char *) m_buffer, (char *) (m_buffer+m_begin), m_end-m_begin);
		m_end = m_end-m_begin;
		m_begin = 0;
	}
	m_buffer[m_end++] = key;
}

/***************************
  CL_InputButton_BeKeyboard
***************************/

CL_InputButton_BeKeyboard::CL_InputButton_BeKeyboard(
	int _key, bool *_keymap)
{
	key = _key;
	keymap = _keymap;
}

bool CL_InputButton_BeKeyboard::is_pressed()
{
	return keymap[key];
}
