
#include "Core/precomp.h"

#ifndef header_runnable_func
#define header_runnable_func

#include "API/Core/System/thread.h"

class CL_Runnable_Func : public CL_Runnable
{
public:
	CL_Runnable_Func(int (*func)(void*), void* value)
	{
		this->func = func;
		this->value = value;
	}
	
	virtual void run()
	{
		func(value);
	}

private:
	int (*func)(void*);
	void* value;
};

CL_Thread *CL_Thread::create(int (*func)(void*), void* value)
{
	return CL_Thread::create(
		new CL_Runnable_Func(func, value));
}
	
#endif
