package Language::INTERCAL::Splats;

# Splats and error messages

# This file is part of CLC-INTERCAL

# Copyright (c) 2006 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

@@DATA Splats@@

use strict;
use vars qw($PERVERSION);
$PERVERSION = "CLC-INTERCAL INTERCAL/Splats.pm 1.-94.-4";

use Carp;

use Language::INTERCAL::Exporter '1.-94.-4';

use vars qw(@EXPORT @EXPORT_OK %EXPORT_TAGS);

@EXPORT_OK = qw(
    splatnumber splatname splatdescription faint
    @@FILL SPLATS 'SP_' NAME '' 76 ' '@@
);

%EXPORT_TAGS = (
    SP => [qw(
	faint
	@@FILL SPLATS 'SP_' NAME '' 76 ' '@@
    )],
);

my %splatbyname = (
    @@ALL SPLATS NAME@@ => @@NUMBER@@,
);

my %splats = (
    @@ALL SPLATS NUMBER@@ => ['@@NAME@@', '@@'DESCR'@@'],
);

sub SP_@@ALL SPLATS NAME@@ () { @@NUMBER@@ }

sub faint {
    @_ >= 1 or croak "Usage: faint(NUM, ARGS)";
    die splatdescription(@_) . "\n";
}

sub splatnumber {
    @_ == 1 or croak "Usage: splatnumber(SPLATNAME)";
    my $s = shift;
    exists $splatbyname{$s} ? $splatbyname{$s} : -1;
}

sub splatname {
    @_ == 1 or croak "Usage: splatname(SPLAT)";
    my $s = shift;
    exists $splats{$s} ? $splats{$s}[0] : undef;
}

sub splatdescription {
    @_ >= 1 or croak "Usage: splatdescription(SPLAT, ARGS)";
    my $s = shift;
    $s %= 1000;
    return 'Unknown splat code' if ! exists $splats{$s};
    my $desc = $splats{$s}[1];
    $desc =~ s/%/shift || '?'/ge;
    $desc .= " (?" . join(' ', @_) . "?)" if @_;
    sprintf("*%03d %s", $s, $desc);
}

1;

__END__

=pod

=head1 TITLE

Language::INTERCAL::Splats - errors

=head1 DESCRIPTION

Execution of I<CLC-INTERCAL> program can produce many errors, one of
the most common is attempting to execute a comment. Errors are
reported using a I<splat>, consisting of an error code and an error
message. The splat code is also available in the special expression
I<*> after the error occurred: this is only useful when the
program is multithreaded (another thread produced the splat) or
within events, as producing a splat is always fatal and causes the
program to terminate.

When printing a splat, the format will always be:

   *nnn message

where nnn is the splat code. However, the list below shows the splat
code as Snnn instead, to prevent the various pod processors from
renumbering the list. This is a bug with the design of pod, on which
we have no control. Even using *nnn causes strange renumberings or
manifest other bugs in the various I<pod2xxx> programs.

=over 5

@@MULTI SPLATS NUMBER@@
=item S@@NUMBER@@

@@DESCR:PARM '%' 'I<' '>'@@

@@DOC 76@@

@@MULTI@@
=back

=head1 SEE ALSO

A qualified psychiatrist

=head1 AUTHOR

Claudio Calvelli - intercal (at) sdf.lonestar.org

