
;;; In the following example the derived result type is (complex
;;; float), however the result of (tst) is the fixnum 0. Noticed this
;;; causing trouble in some code when I forgot to specify an initial
;;; element.

;;; This problem is at least partly fixed now. A compiler note is
;;; generated warning that the default initial-element is not a
;;; (complex float), and the continuation type is checked in safe
;;; code.  There may be some cases where the type check is not
;;; performed, when the continuation has multiple uses, a new failing
;;; case is needed below.

(defun tst ()
  (let ((x (make-array 5 :element-type '(complex float))))
    (aref x 1)))
