/*
   Copyright 2001-2004 The Apache Software Foundation.
 
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at
 
       http://www.apache.org/licenses/LICENSE-2.0
 
   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
/* @version $Id: help.c 232775 2005-08-15 08:50:17Z jfclere $ */
#include "jsvc.h"

void help(home_data *data) {
    int x;

    printf("Usage: %s [-options] class [args...]\n",log_prog);
    printf("\n");
    printf("Where options include:\n");
    printf("\n");

    printf("    -jvm <JVM name>\n");
    printf("        use a specific Java Virtual Machine. Available JVMs:\n");
    printf("           ");
    for (x=0; x<data->jnum; x++) {
      printf(" '%s'",PRINT_NULL(data->jvms[x]->name));
    }
    printf("\n");

    printf("    -cp / -classpath <directories and zip/jar files>\n");
    printf("        set search path for service classes and resouces\n");

    printf("    -home <directory>\n");
    printf("        set the path of your JDK or JRE installation (or set\n");
    printf("        the JAVA_HOME environment variable)\n");

    printf("    -version\n");
    printf("        show the current Java environment version (to check\n");
    printf("        correctness of -home and -jvm. Implies -nodetach)\n");

    printf("    -help / -?\n");
    printf("        show this help page (implies -nodetach)\n");

    printf("    -nodetach\n");
    printf("        don't detach from parent process and become a daemon\n");

    printf("    -debug\n");
    printf("        verbosely print debugging information\n");

    printf("    -check\n");
    printf("        only check service (implies -nodetach)\n");
 
    printf("    -user <user>\n");
    printf("        user used to run the daemon (defaults to current user)\n");
 
    printf("    -verbose[:class|gc|jni]\n");
    printf("        enable verbose output\n");
 
    printf("    -outfile </full/path/to/file>\n");
    printf("        Location for output from stdout (defaults to /dev/null)\n");
    printf("        Use the value '&2' to simulate '1>&2'\n");

    printf("    -errfile </full/path/to/file>\n");
    printf("        Location for output from stderr (defaults to /dev/null)\n");
    printf("        Use the value '&1' to simulate '2>&1'\n");

    printf("    -pidfile </full/path/to/file>\n");
    printf("        Location for output from the file containing the pid of jsvc\n");
    printf("        (defaults to /var/run/jsvc.pid)\n");

    printf("    -D<name>=<value>\n");
    printf("        set a Java system property\n");

    printf("    -X<option>\n");
    printf("        set Virtual Machine specific option\n");

    printf("    -procname <procname>\n");
    printf("        use the specified process name (works only for Linux)\n");

    printf("    -wait <waittime>\n");
    printf("        wait waittime seconds for the service to start\n");
    printf("        waittime should multiple of 10 (min=10)\n");

    printf("    -stop\n");
    printf("        stop the service using the file given in the -pidfile option\n");

    printf("\n");
}
