/*
 *  Author:          Serg Stoyan
 *
 *  Classes:         AuthenticationView : NSObject <PrefsViewProtocol>
 *
 *  Description:     This view contains authentication preferences
 *                   (PAP, CHAP, etc.)
 *                   
 * pppd options:
 *
 * (hide-password)
 * (noauth) ------------- Do not require the peer to authenticate itself
 * auth ----------------- Require the peer to authenticate itself
 * chap-interval n ------ Rechallenge the peer every n seconds
 * chap-max-challenge n - Maximum number of challenge transmissions
 * chap-restart n ------- Restart interval (retransmission timeout)
 * papcrypt ------------- All secrets in the /etc/ppp/pap-secrets are
 *                        encryptedand thus pppd should not accept a 
 *                        password which, before encryption, is identical
 *                        to the secret from the /etc/ppp/pap-secrets file.
 * pap-timeout n -------- Maximum  time that pppd will wait for the
 *                        peer to authenticate itself
 * pap-max-authreq n ---- Maximum number of PAP authenticate-request
 *                        transmissions
 * pap-restart n -------- Restart interval (retransmission  timeout)
 * name ----------------- This system name
 * remotename ----------- Assumed  name of the remote system
 * domain --------------- This system domain
 * user ----------------- User name
 */

#import <Foundation/NSObject.h>

#import "PrefsViewProtocol.h"

@class NSview;
@class NSBox;
@class NSButton;
@class NSPopUpButton;
@class NSTextField;
@class NSSecureTextField;

@interface AuthenticationView : NSObject <PrefsViewProtocol>
{
  NSView              *view;
                      
  NSBox               *schemeFrame;
  NSPopUpButton       *schemePop;
                      
  NSBox               *userFrame;
  NSTextField         *userNameLabel;
  NSTextField         *userNameTF;
  NSTextField         *passwordLabel;
  NSSecureTextField   *passwordTF;
  NSButton            *rememberButton;
                      
  NSBox               *systemFrame;
  NSTextField         *remoteLabel;
  NSTextField         *remoteTF;
  NSTextField         *localLabel;
  NSTextField         *localTF;
  NSTextField         *domainLabel;
  NSTextField         *domainTF;
                      
  NSButton            *advancedButton;
                      
  //Advanced          
  NSBox               *chapFrame;
  NSTextField         *intervalLabel;
  NSTextField         *intervalTF;
  NSTextField         *maxChallengeLabel;
  NSTextField         *maxChallengeTF;
  NSTextField         *restartIntervalLabel;
  NSTextField         *restartIntervalTF;
                      
  NSBox               *papFrame;
  NSButton            *fileEncrypted;
  NSTextField         *timeoutLabel;
  NSTextField         *timeoutTF;
  NSTextField         *maxAuthreqLabel;
  NSTextField         *maxAuthreqTF;
  NSTextField         *restartLabel;
  NSTextField         *restartTF;

  NSMutableDictionary *prefs;
}

@end
