/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      DialingView : NSObject <PrefsViewProtocol>
 *
 *  Description:  This view contains chat strings
 *
 */

#import <Foundation/NSObject.h>

#import "PrefsViewProtocol.h"

@class NSView;
@class NSBox;
@class NSTextField;

@interface DialingView : NSObject <PrefsViewProtocol>
{
  NSView              *view;
                      
  NSBox               *initFrame;
  NSTextField         *initLabel;
  NSTextField         *initTF;
  NSTextField         *waitInitLabel;
  NSTextField         *waitInitTF;
  NSTextField         *waitInitSecsLabel;
  NSTextField         *dialLabel;
  NSTextField         *dialTF;
  NSTextField         *waitDialLabel;
  NSTextField         *waitDialTF;
  NSTextField         *waitDialSecsLabel;
  
  NSBox               *responsesFrame;
  NSTextField         *okLabel;
  NSTextField         *okTF;
  NSTextField         *connectLabel;
  NSTextField         *connectTF;
  NSTextField         *errorLabel;
  NSTextField         *errorTF;
  NSTextField         *busyLabel;
  NSTextField         *busyTF;
  NSTextField         *voiceLabel;
  NSTextField         *voiceTF;
  NSTextField         *noAnswerLabel;
  NSTextField         *noAnswerTF;
  NSTextField         *noCarrierLabel;
  NSTextField         *noCarrierTF;
  NSTextField         *noDialtoneLabel;
  NSTextField         *noDialtoneTF;

  NSMutableDictionary *prefs;
}

@end
