/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      NetworkView : NSObject <PrefsViewProtocol>
 *
 *  Description:  Network preferences (IP, DNS, routing, proxyarp)
 *  
 *  pppd options:
 *  
 *  <local_ip>:<remote_ip> -- Local and/or remote interface IP addresses
 *  netmask ----------------- Netmask
 *  usepeerdns -------------- Ask the peer for up to 2 DNS server addresses
 *  defaultroute ------------ Default route to peer as the gateway
 *  proxyarp ---------------- Add an entry to this system's ARP table with
 *                            the IP address of the peer and the Ethernet 
 *                            address of this system.
 */

#import <Foundation/NSObject.h>

#import "PrefsViewProtocol.h"

@class NSView;
@class NSBox;
@class NSButton;
@class NSTextField;

@interface NetworkView : NSObject <PrefsViewProtocol>
{
  NSView              *view;

  NSBox               *ipFrame;
  NSButton            *dynamicIP;
  NSButton            *staticIP;
  NSTextField         *localIPLabel;
  NSTextField         *localIPTF;
  NSTextField         *remoteIPLabel;
  NSTextField         *remoteIPTF;
  NSTextField         *netmaskLabel;
  NSTextField         *netmaskTF;
                      
  NSBox               *dnsFrame;
  NSButton            *dynamicDNS;
  NSButton            *staticDNS;
  NSTextField         *primaryDNSLabel;
  NSTextField         *primaryDNSTF;
  NSTextField         *secondaryDNSLabel;
  NSTextField         *secondaryDNSTF;
                      
  NSBox               *routingFrame;
  NSButton            *defaultGateway;
  NSButton            *proxyARP;
  NSButton            *advancedRouting;

  NSMutableDictionary *prefs;
}

- (void) setIPTypeAction: (id)sender;

- (void) setDNSTypeAction: (id)sender;

@end
