/*
 Copyright (c) 2006-2010 Trevor Williams

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with this program;
 if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "genprof.h"

#ifdef DEBUG
profiler profiles[NUM_PROFILES] = {
  {"unregistered", NULL, 0, 0, 0, FALSE},
  {"instance_display_tree_helper", NULL, 0, 0, 0, TRUE},
  {"instance_display_tree", NULL, 0, 0, 0, TRUE},
  {"instance_create", NULL, 0, 0, 0, TRUE},
  {"instance_gen_scope", NULL, 0, 0, 0, TRUE},
  {"instance_compare", NULL, 0, 0, 0, TRUE},
  {"instance_find_scope", NULL, 0, 0, 0, TRUE},
  {"instance_find_by_funit", NULL, 0, 0, 0, TRUE},
  {"instance_find_by_funit_name_if_one_helper", NULL, 0, 0, 0, TRUE},
  {"instance_find_by_funit_name_if_one", NULL, 0, 0, 0, TRUE},
  {"instance_find_signal_by_exclusion_id", NULL, 0, 0, 0, TRUE},
  {"instance_find_expression_by_exclusion_id", NULL, 0, 0, 0, TRUE},
  {"instance_find_fsm_arc_index_by_exclusion_id", NULL, 0, 0, 0, TRUE},
  {"instance_add_child", NULL, 0, 0, 0, TRUE},
  {"instance_copy_helper", NULL, 0, 0, 0, TRUE},
  {"instance_copy", NULL, 0, 0, 0, TRUE},
  {"instance_parse_add", NULL, 0, 0, 0, TRUE},
  {"instance_resolve_inst", NULL, 0, 0, 0, TRUE},
  {"instance_resolve_helper", NULL, 0, 0, 0, TRUE},
  {"instance_resolve", NULL, 0, 0, 0, TRUE},
  {"instance_read_add", NULL, 0, 0, 0, TRUE},
  {"instance_merge", NULL, 0, 0, 0, TRUE},
  {"instance_get_leading_hierarchy", NULL, 0, 0, 0, TRUE},
  {"instance_mark_lhier_diffs", NULL, 0, 0, 0, TRUE},
  {"instance_merge_two_trees", NULL, 0, 0, 0, TRUE},
  {"instance_db_write", NULL, 0, 0, 0, TRUE},
  {"instance_only_db_read", NULL, 0, 0, 0, TRUE},
  {"instance_only_db_merge", NULL, 0, 0, 0, TRUE},
  {"instance_remove_stmt_blks_calling_stmt", NULL, 0, 0, 0, TRUE},
  {"instance_remove_parms_with_expr", NULL, 0, 0, 0, TRUE},
  {"instance_dealloc_single", NULL, 0, 0, 0, TRUE},
  {"instance_output_dumpvars", NULL, 0, 0, 0, TRUE},
  {"instance_dealloc_tree", NULL, 0, 0, 0, TRUE},
  {"instance_dealloc", NULL, 0, 0, 0, TRUE},
  {"statement_create", NULL, 0, 0, 0, TRUE},
  {"statement_queue_add", NULL, 0, 0, 0, TRUE},
  {"statement_queue_compare", NULL, 0, 0, 0, TRUE},
  {"statement_size_elements", NULL, 0, 0, 0, TRUE},
  {"statement_db_write", NULL, 0, 0, 0, TRUE},
  {"statement_db_write_tree", NULL, 0, 0, 0, TRUE},
  {"statement_db_write_expr_tree", NULL, 0, 0, 0, TRUE},
  {"statement_db_read", NULL, 0, 0, 0, TRUE},
  {"statement_assign_expr_ids", NULL, 0, 0, 0, TRUE},
  {"statement_connect", NULL, 0, 0, 0, TRUE},
  {"statement_get_last_line_helper", NULL, 0, 0, 0, TRUE},
  {"statement_get_last_line", NULL, 0, 0, 0, TRUE},
  {"statement_find_rhs_sigs", NULL, 0, 0, 0, TRUE},
  {"statement_find_statement", NULL, 0, 0, 0, TRUE},
  {"statement_contains_expr_calling_stmt", NULL, 0, 0, 0, TRUE},
  {"statement_dealloc_recursive", NULL, 0, 0, 0, TRUE},
  {"statement_dealloc", NULL, 0, 0, 0, TRUE},
  {"rank_create_comp_cdd_cov", NULL, 0, 0, 0, TRUE},
  {"rank_dealloc_comp_cdd_cov", NULL, 0, 0, 0, TRUE},
  {"rank_check_index", NULL, 0, 0, 0, TRUE},
  {"rank_gather_signal_cov", NULL, 0, 0, 0, TRUE},
  {"rank_gather_comb_cov", NULL, 0, 0, 0, TRUE},
  {"rank_gather_expression_cov", NULL, 0, 0, 0, TRUE},
  {"rank_gather_fsm_cov", NULL, 0, 0, 0, TRUE},
  {"rank_calc_num_cps", NULL, 0, 0, 0, TRUE},
  {"rank_gather_comp_cdd_cov", NULL, 0, 0, 0, TRUE},
  {"rank_read_cdd", NULL, 0, 0, 0, TRUE},
  {"rank_selected_cdd_cov", NULL, 0, 0, 0, TRUE},
  {"rank_perform_weighted_selection", NULL, 0, 0, 0, TRUE},
  {"rank_perform_greedy_sort", NULL, 0, 0, 0, TRUE},
  {"rank_count_cps", NULL, 0, 0, 0, TRUE},
  {"rank_perform", NULL, 0, 0, 0, TRUE},
  {"rank_output", NULL, 0, 0, 0, TRUE},
  {"command_rank", NULL, 0, 0, 0, TRUE},
  {"lexer_keyword_sys_sv_code", NULL, 0, 0, 0, TRUE},
  {"race_blk_create", NULL, 0, 0, 0, TRUE},
  {"race_find_head_statement_containing_statement_helper", NULL, 0, 0, 0, TRUE},
  {"race_find_head_statement_containing_statement", NULL, 0, 0, 0, TRUE},
  {"race_get_head_statement", NULL, 0, 0, 0, TRUE},
  {"race_find_head_statement", NULL, 0, 0, 0, TRUE},
  {"race_calc_stmt_blk_type", NULL, 0, 0, 0, TRUE},
  {"race_calc_expr_assignment", NULL, 0, 0, 0, TRUE},
  {"race_calc_assignments", NULL, 0, 0, 0, TRUE},
  {"race_handle_race_condition", NULL, 0, 0, 0, TRUE},
  {"race_check_assignment_types", NULL, 0, 0, 0, TRUE},
  {"race_check_one_block_assignment", NULL, 0, 0, 0, TRUE},
  {"race_check_race_count", NULL, 0, 0, 0, TRUE},
  {"race_check_modules", NULL, 0, 0, 0, TRUE},
  {"race_db_write", NULL, 0, 0, 0, TRUE},
  {"race_db_read", NULL, 0, 0, 0, TRUE},
  {"race_get_stats", NULL, 0, 0, 0, TRUE},
  {"race_report_summary", NULL, 0, 0, 0, TRUE},
  {"race_report_verbose", NULL, 0, 0, 0, TRUE},
  {"race_report", NULL, 0, 0, 0, TRUE},
  {"race_collect_lines", NULL, 0, 0, 0, TRUE},
  {"race_blk_delete_list", NULL, 0, 0, 0, TRUE},
  {"search_init", NULL, 0, 0, 0, FALSE},
  {"search_add_include_path", NULL, 0, 0, 0, FALSE},
  {"search_add_directory_path", NULL, 0, 0, 0, FALSE},
  {"search_add_file", NULL, 0, 0, 0, FALSE},
  {"search_add_no_score_funit", NULL, 0, 0, 0, FALSE},
  {"search_add_extensions", NULL, 0, 0, 0, FALSE},
  {"search_free_lists", NULL, 0, 0, 0, TRUE},
  {"sys_task_uniform", NULL, 0, 0, 0, TRUE},
  {"sys_task_rtl_dist_uniform", NULL, 0, 0, 0, TRUE},
  {"sys_task_srandom", NULL, 0, 0, 0, TRUE},
  {"sys_task_random", NULL, 0, 0, 0, TRUE},
  {"sys_task_urandom", NULL, 0, 0, 0, FALSE},
  {"sys_task_urandom_range", NULL, 0, 0, 0, FALSE},
  {"sys_task_realtobits", NULL, 0, 0, 0, TRUE},
  {"sys_task_bitstoreal", NULL, 0, 0, 0, TRUE},
  {"sys_task_shortrealtobits", NULL, 0, 0, 0, TRUE},
  {"sys_task_bitstoshortreal", NULL, 0, 0, 0, TRUE},
  {"sys_task_itor", NULL, 0, 0, 0, TRUE},
  {"sys_task_rtoi", NULL, 0, 0, 0, TRUE},
  {"sys_task_clog2", NULL, 0, 0, 0, TRUE},
  {"sys_task_store_plusargs", NULL, 0, 0, 0, TRUE},
  {"sys_task_test_plusarg", NULL, 0, 0, 0, TRUE},
  {"sys_task_value_plusargs", NULL, 0, 0, 0, TRUE},
  {"sys_task_dealloc", NULL, 0, 0, 0, TRUE},
  {"lxt2_rd_expand_integer_to_bits", NULL, 0, 0, 0, TRUE},
  {"lxt2_rd_expand_bits_to_integer", NULL, 0, 0, 0, TRUE},
  {"lxt2_rd_iter_radix", NULL, 0, 0, 0, TRUE},
  {"lxt2_rd_iter_radix0", NULL, 0, 0, 0, TRUE},
  {"lxt2_rd_build_radix", NULL, 0, 0, 0, TRUE},
  {"lxt2_rd_regenerate_process_mask", NULL, 0, 0, 0, TRUE},
  {"lxt2_rd_process_block", NULL, 0, 0, 0, TRUE},
  {"lxt2_rd_init", NULL, 0, 0, 0, TRUE},
  {"lxt2_rd_close", NULL, 0, 0, 0, TRUE},
  {"lxt2_rd_get_facname", NULL, 0, 0, 0, TRUE},
  {"lxt2_rd_iter_blocks", NULL, 0, 0, 0, FALSE},
  {"lxt2_rd_limit_time_range", NULL, 0, 0, 0, TRUE},
  {"lxt2_rd_unlimit_time_range", NULL, 0, 0, 0, TRUE},
  {"perf_gen_stats", NULL, 0, 0, 0, TRUE},
  {"perf_output_mod_stats", NULL, 0, 0, 0, TRUE},
  {"perf_output_inst_report_helper", NULL, 0, 0, 0, TRUE},
  {"perf_output_inst_report", NULL, 0, 0, 0, TRUE},
  {"tcl_func_get_race_reason_msgs", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_funit_list", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_instances", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_instance_list", NULL, 0, 0, 0, FALSE},
  {"tcl_func_is_funit", NULL, 0, 0, 0, TRUE},
  {"tcl_func_get_funit", NULL, 0, 0, 0, TRUE},
  {"tcl_func_get_inst", NULL, 0, 0, 0, TRUE},
  {"tcl_func_get_funit_name", NULL, 0, 0, 0, TRUE},
  {"tcl_func_get_filename", NULL, 0, 0, 0, TRUE},
  {"tcl_func_inst_scope", NULL, 0, 0, 0, TRUE},
  {"tcl_func_get_funit_start_and_end", NULL, 0, 0, 0, FALSE},
  {"tcl_func_collect_uncovered_lines", NULL, 0, 0, 0, FALSE},
  {"tcl_func_collect_covered_lines", NULL, 0, 0, 0, FALSE},
  {"tcl_func_collect_race_lines", NULL, 0, 0, 0, FALSE},
  {"tcl_func_collect_uncovered_toggles", NULL, 0, 0, 0, FALSE},
  {"tcl_func_collect_covered_toggles", NULL, 0, 0, 0, FALSE},
  {"tcl_func_collect_uncovered_memories", NULL, 0, 0, 0, FALSE},
  {"tcl_func_collect_covered_memories", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_toggle_coverage", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_memory_coverage", NULL, 0, 0, 0, FALSE},
  {"tcl_func_collect_uncovered_combs", NULL, 0, 0, 0, TRUE},
  {"tcl_func_collect_covered_combs", NULL, 0, 0, 0, TRUE},
  {"tcl_func_get_comb_expression", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_comb_coverage", NULL, 0, 0, 0, FALSE},
  {"tcl_func_collect_uncovered_fsms", NULL, 0, 0, 0, TRUE},
  {"tcl_func_collect_covered_fsms", NULL, 0, 0, 0, TRUE},
  {"tcl_func_get_fsm_coverage", NULL, 0, 0, 0, FALSE},
  {"tcl_func_collect_uncovered_assertions", NULL, 0, 0, 0, TRUE},
  {"tcl_func_collect_covered_assertions", NULL, 0, 0, 0, TRUE},
  {"tcl_func_get_assert_coverage", NULL, 0, 0, 0, FALSE},
  {"tcl_func_open_cdd", NULL, 0, 0, 0, FALSE},
  {"tcl_func_close_cdd", NULL, 0, 0, 0, FALSE},
  {"tcl_func_save_cdd", NULL, 0, 0, 0, FALSE},
  {"tcl_func_merge_cdd", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_line_summary", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_toggle_summary", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_memory_summary", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_comb_summary", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_fsm_summary", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_assert_summary", NULL, 0, 0, 0, FALSE},
  {"tcl_func_preprocess_verilog", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_score_path", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_include_pathname", NULL, 0, 0, 0, FALSE},
  {"tcl_func_get_generation", NULL, 0, 0, 0, FALSE},
  {"tcl_func_set_line_exclude", NULL, 0, 0, 0, TRUE},
  {"tcl_func_set_toggle_exclude", NULL, 0, 0, 0, TRUE},
  {"tcl_func_set_memory_exclude", NULL, 0, 0, 0, TRUE},
  {"tcl_func_set_comb_exclude", NULL, 0, 0, 0, TRUE},
  {"tcl_func_fsm_exclude", NULL, 0, 0, 0, TRUE},
  {"tcl_func_set_assert_exclude", NULL, 0, 0, 0, TRUE},
  {"tcl_func_generate_report", NULL, 0, 0, 0, FALSE},
  {"tcl_func_initialize", NULL, 0, 0, 0, TRUE},
  {"combination_calc_depth", NULL, 0, 0, 0, TRUE},
  {"combination_does_multi_exp_need_ul", NULL, 0, 0, 0, TRUE},
  {"combination_multi_expr_calc", NULL, 0, 0, 0, TRUE},
  {"combination_is_expr_multi_node", NULL, 0, 0, 0, TRUE},
  {"combination_get_tree_stats", NULL, 0, 0, 0, TRUE},
  {"combination_reset_counted_exprs", NULL, 0, 0, 0, TRUE},
  {"combination_reset_counted_expr_tree", NULL, 0, 0, 0, TRUE},
  {"combination_get_stats", NULL, 0, 0, 0, TRUE},
  {"combination_get_funit_summary", NULL, 0, 0, 0, TRUE},
  {"combination_get_inst_summary", NULL, 0, 0, 0, TRUE},
  {"combination_display_instance_summary", NULL, 0, 0, 0, TRUE},
  {"combination_instance_summary", NULL, 0, 0, 0, TRUE},
  {"combination_display_funit_summary", NULL, 0, 0, 0, TRUE},
  {"combination_funit_summary", NULL, 0, 0, 0, TRUE},
  {"combination_draw_line", NULL, 0, 0, 0, TRUE},
  {"combination_draw_centered_line", NULL, 0, 0, 0, TRUE},
  {"combination_parenthesize", NULL, 0, 0, 0, TRUE},
  {"combination_underline_tree", NULL, 0, 0, 0, TRUE},
  {"combination_prep_line", NULL, 0, 0, 0, TRUE},
  {"combination_underline", NULL, 0, 0, 0, TRUE},
  {"combination_unary", NULL, 0, 0, 0, TRUE},
  {"combination_event", NULL, 0, 0, 0, TRUE},
  {"combination_two_vars", NULL, 0, 0, 0, TRUE},
  {"combination_multi_var_exprs", NULL, 0, 0, 0, TRUE},
  {"combination_multi_expr_output_length", NULL, 0, 0, 0, TRUE},
  {"combination_multi_expr_output", NULL, 0, 0, 0, TRUE},
  {"combination_multi_vars", NULL, 0, 0, 0, TRUE},
  {"combination_get_missed_expr", NULL, 0, 0, 0, TRUE},
  {"combination_list_missed", NULL, 0, 0, 0, TRUE},
  {"combination_output_expr", NULL, 0, 0, 0, TRUE},
  {"combination_display_verbose", NULL, 0, 0, 0, TRUE},
  {"combination_instance_verbose", NULL, 0, 0, 0, TRUE},
  {"combination_funit_verbose", NULL, 0, 0, 0, TRUE},
  {"combination_collect", NULL, 0, 0, 0, TRUE},
  {"combination_get_exclude_list", NULL, 0, 0, 0, TRUE},
  {"combination_get_expression", NULL, 0, 0, 0, TRUE},
  {"combination_get_coverage", NULL, 0, 0, 0, TRUE},
  {"combination_report", NULL, 0, 0, 0, TRUE},
  {"report_parse_metrics", NULL, 0, 0, 0, TRUE},
  {"report_parse_args", NULL, 0, 0, 0, TRUE},
  {"report_gather_instance_stats", NULL, 0, 0, 0, TRUE},
  {"report_gather_funit_stats", NULL, 0, 0, 0, TRUE},
  {"report_print_header", NULL, 0, 0, 0, TRUE},
  {"report_generate", NULL, 0, 0, 0, TRUE},
  {"report_read_cdd_and_ready", NULL, 0, 0, 0, TRUE},
  {"report_close_cdd", NULL, 0, 0, 0, TRUE},
  {"report_save_cdd", NULL, 0, 0, 0, TRUE},
  {"report_format_exclusion_reason", NULL, 0, 0, 0, TRUE},
  {"report_output_exclusion_reason", NULL, 0, 0, 0, TRUE},
  {"command_report", NULL, 0, 0, 0, TRUE},
  {"ovl_is_assertion_name", NULL, 0, 0, 0, TRUE},
  {"ovl_is_assertion_module", NULL, 0, 0, 0, TRUE},
  {"ovl_is_coverage_point", NULL, 0, 0, 0, TRUE},
  {"ovl_add_assertions_to_no_score_list", NULL, 0, 0, 0, TRUE},
  {"ovl_get_funit_stats", NULL, 0, 0, 0, TRUE},
  {"ovl_get_coverage_point", NULL, 0, 0, 0, TRUE},
  {"ovl_display_verbose", NULL, 0, 0, 0, TRUE},
  {"ovl_collect", NULL, 0, 0, 0, TRUE},
  {"ovl_get_coverage", NULL, 0, 0, 0, TRUE},
  {"sim_current_thread", NULL, 0, 0, 0, FALSE},
  {"sim_thread_pop_head", NULL, 0, 0, 0, TRUE},
  {"sim_thread_insert_into_delay_queue", NULL, 0, 0, 0, TRUE},
  {"sim_thread_push", NULL, 0, 0, 0, TRUE},
  {"sim_expr_changed", NULL, 0, 0, 0, TRUE},
  {"sim_create_thread", NULL, 0, 0, 0, TRUE},
  {"sim_add_thread", NULL, 0, 0, 0, TRUE},
  {"sim_kill_thread", NULL, 0, 0, 0, TRUE},
  {"sim_kill_thread_with_funit", NULL, 0, 0, 0, TRUE},
  {"sim_add_statics", NULL, 0, 0, 0, TRUE},
  {"sim_expression", NULL, 0, 0, 0, TRUE},
  {"sim_thread", NULL, 0, 0, 0, TRUE},
  {"sim_simulate", NULL, 0, 0, 0, TRUE},
  {"sim_initialize", NULL, 0, 0, 0, TRUE},
  {"sim_stop", NULL, 0, 0, 0, TRUE},
  {"sim_finish", NULL, 0, 0, 0, TRUE},
  {"sim_add_nonblock_assign", NULL, 0, 0, 0, TRUE},
  {"sim_perform_nba", NULL, 0, 0, 0, TRUE},
  {"sim_dealloc", NULL, 0, 0, 0, TRUE},
  {"vcdid", NULL, 0, 0, 0, TRUE},
  {"vcd_callback", NULL, 0, 0, 0, TRUE},
  {"lxt_parse", NULL, 0, 0, 0, TRUE},
  {"vcd_parse_def_ignore", NULL, 0, 0, 0, TRUE},
  {"vcd_parse_def_var", NULL, 0, 0, 0, TRUE},
  {"vcd_parse_def_scope", NULL, 0, 0, 0, TRUE},
  {"vcd_parse_def", NULL, 0, 0, 0, TRUE},
  {"vcd_parse_sim_vector", NULL, 0, 0, 0, TRUE},
  {"vcd_parse_sim_real", NULL, 0, 0, 0, TRUE},
  {"vcd_parse_sim_ignore", NULL, 0, 0, 0, TRUE},
  {"vcd_parse_sim", NULL, 0, 0, 0, TRUE},
  {"vcd_parse", NULL, 0, 0, 0, TRUE},
  {"score_generate_top_vpi_module", NULL, 0, 0, 0, TRUE},
  {"score_generate_top_dumpvars_module", NULL, 0, 0, 0, TRUE},
  {"score_generate_pli_tab_file", NULL, 0, 0, 0, FALSE},
  {"score_parse_define", NULL, 0, 0, 0, FALSE},
  {"score_parse_args", NULL, 0, 0, 0, FALSE},
  {"command_score", NULL, 0, 0, 0, TRUE},
  {"fsm_create", NULL, 0, 0, 0, FALSE},
  {"fsm_add_arc", NULL, 0, 0, 0, TRUE},
  {"fsm_create_tables", NULL, 0, 0, 0, TRUE},
  {"fsm_db_write", NULL, 0, 0, 0, TRUE},
  {"fsm_db_read", NULL, 0, 0, 0, TRUE},
  {"fsm_db_merge", NULL, 0, 0, 0, TRUE},
  {"fsm_merge", NULL, 0, 0, 0, TRUE},
  {"fsm_table_set", NULL, 0, 0, 0, TRUE},
  {"fsm_get_stats", NULL, 0, 0, 0, TRUE},
  {"fsm_get_funit_summary", NULL, 0, 0, 0, TRUE},
  {"fsm_get_inst_summary", NULL, 0, 0, 0, TRUE},
  {"fsm_gather_signals", NULL, 0, 0, 0, TRUE},
  {"fsm_collect", NULL, 0, 0, 0, TRUE},
  {"fsm_get_coverage", NULL, 0, 0, 0, TRUE},
  {"fsm_display_instance_summary", NULL, 0, 0, 0, TRUE},
  {"fsm_instance_summary", NULL, 0, 0, 0, TRUE},
  {"fsm_display_funit_summary", NULL, 0, 0, 0, TRUE},
  {"fsm_funit_summary", NULL, 0, 0, 0, TRUE},
  {"fsm_display_state_verbose", NULL, 0, 0, 0, TRUE},
  {"fsm_display_arc_verbose", NULL, 0, 0, 0, TRUE},
  {"fsm_display_verbose", NULL, 0, 0, 0, TRUE},
  {"fsm_instance_verbose", NULL, 0, 0, 0, TRUE},
  {"fsm_funit_verbose", NULL, 0, 0, 0, TRUE},
  {"fsm_report", NULL, 0, 0, 0, TRUE},
  {"fsm_dealloc", NULL, 0, 0, 0, TRUE},
  {"lexer_keyword_sys_1995_code", NULL, 0, 0, 0, TRUE},
  {"fsm_var_add", NULL, 0, 0, 0, FALSE},
  {"fsm_var_is_output_state", NULL, 0, 0, 0, TRUE},
  {"fsm_var_bind_expr", NULL, 0, 0, 0, TRUE},
  {"fsm_var_add_expr", NULL, 0, 0, 0, TRUE},
  {"fsm_var_bind_stmt", NULL, 0, 0, 0, TRUE},
  {"fsm_var_bind_add", NULL, 0, 0, 0, TRUE},
  {"fsm_var_stmt_add", NULL, 0, 0, 0, TRUE},
  {"fsm_var_bind", NULL, 0, 0, 0, TRUE},
  {"fsm_var_dealloc", NULL, 0, 0, 0, TRUE},
  {"fsm_var_remove", NULL, 0, 0, 0, TRUE},
  {"fsm_var_cleanup", NULL, 0, 0, 0, TRUE},
  {"check_option_value", NULL, 0, 0, 0, TRUE},
  {"is_variable", NULL, 0, 0, 0, TRUE},
  {"is_func_unit", NULL, 0, 0, 0, TRUE},
  {"is_legal_filename", NULL, 0, 0, 0, TRUE},
  {"get_basename", NULL, 0, 0, 0, TRUE},
  {"get_dirname", NULL, 0, 0, 0, TRUE},
  {"get_absolute_path", NULL, 0, 0, 0, TRUE},
  {"get_relative_path", NULL, 0, 0, 0, TRUE},
  {"directory_exists", NULL, 0, 0, 0, TRUE},
  {"directory_load", NULL, 0, 0, 0, TRUE},
  {"file_exists", NULL, 0, 0, 0, TRUE},
  {"util_readline", NULL, 0, 0, 0, TRUE},
  {"get_quoted_string", NULL, 0, 0, 0, TRUE},
  {"substitute_env_vars", NULL, 0, 0, 0, TRUE},
  {"scope_extract_front", NULL, 0, 0, 0, TRUE},
  {"scope_extract_back", NULL, 0, 0, 0, TRUE},
  {"scope_extract_scope", NULL, 0, 0, 0, TRUE},
  {"scope_gen_printable", NULL, 0, 0, 0, TRUE},
  {"scope_compare", NULL, 0, 0, 0, TRUE},
  {"scope_local", NULL, 0, 0, 0, TRUE},
  {"convert_file_to_module", NULL, 0, 0, 0, TRUE},
  {"get_next_vfile", NULL, 0, 0, 0, TRUE},
  {"gen_space", NULL, 0, 0, 0, TRUE},
  {"remove_underscores", NULL, 0, 0, 0, TRUE},
  {"get_funit_type", NULL, 0, 0, 0, TRUE},
  {"calc_miss_percent", NULL, 0, 0, 0, TRUE},
  {"read_command_file", NULL, 0, 0, 0, FALSE},
  {"attribute_create", NULL, 0, 0, 0, TRUE},
  {"attribute_parse", NULL, 0, 0, 0, TRUE},
  {"attribute_dealloc", NULL, 0, 0, 0, TRUE},
  {"static_expr_gen_unary", NULL, 0, 0, 0, TRUE},
  {"static_expr_gen", NULL, 0, 0, 0, FALSE},
  {"static_expr_calc_lsb_and_width_pre", NULL, 0, 0, 0, TRUE},
  {"static_expr_calc_lsb_and_width_post", NULL, 0, 0, 0, TRUE},
  {"static_expr_dealloc", NULL, 0, 0, 0, FALSE},
  {"vector_init", NULL, 0, 0, 0, TRUE},
  {"vector_int_r64", NULL, 0, 0, 0, TRUE},
  {"vector_int_r32", NULL, 0, 0, 0, TRUE},
  {"vector_create", NULL, 0, 0, 0, TRUE},
  {"vector_copy", NULL, 0, 0, 0, TRUE},
  {"vector_copy_range", NULL, 0, 0, 0, TRUE},
  {"vector_clone", NULL, 0, 0, 0, TRUE},
  {"vector_db_write", NULL, 0, 0, 0, TRUE},
  {"vector_db_read", NULL, 0, 0, 0, TRUE},
  {"vector_db_merge", NULL, 0, 0, 0, TRUE},
  {"vector_merge", NULL, 0, 0, 0, TRUE},
  {"vector_get_eval_a", NULL, 0, 0, 0, TRUE},
  {"vector_get_eval_b", NULL, 0, 0, 0, TRUE},
  {"vector_get_eval_c", NULL, 0, 0, 0, TRUE},
  {"vector_get_eval_d", NULL, 0, 0, 0, TRUE},
  {"vector_get_eval_ab_count", NULL, 0, 0, 0, TRUE},
  {"vector_get_eval_abc_count", NULL, 0, 0, 0, TRUE},
  {"vector_get_eval_abcd_count", NULL, 0, 0, 0, TRUE},
  {"vector_get_toggle01_ulong", NULL, 0, 0, 0, TRUE},
  {"vector_get_toggle10_ulong", NULL, 0, 0, 0, TRUE},
  {"vector_display_toggle01_ulong", NULL, 0, 0, 0, TRUE},
  {"vector_display_toggle10_ulong", NULL, 0, 0, 0, TRUE},
  {"vector_toggle_count", NULL, 0, 0, 0, TRUE},
  {"vector_mem_rw_count", NULL, 0, 0, 0, TRUE},
  {"vector_set_assigned", NULL, 0, 0, 0, TRUE},
  {"vector_set_coverage_and_assign", NULL, 0, 0, 0, TRUE},
  {"vector_get_sign_extend_vector_ulong", NULL, 0, 0, 0, TRUE},
  {"vector_sign_extend_ulong", NULL, 0, 0, 0, TRUE},
  {"vector_lshift_ulong", NULL, 0, 0, 0, TRUE},
  {"vector_rshift_ulong", NULL, 0, 0, 0, TRUE},
  {"vector_set_value", NULL, 0, 0, 0, TRUE},
  {"vector_part_select_pull", NULL, 0, 0, 0, TRUE},
  {"vector_part_select_push", NULL, 0, 0, 0, TRUE},
  {"vector_set_unary_evals", NULL, 0, 0, 0, TRUE},
  {"vector_set_and_comb_evals", NULL, 0, 0, 0, TRUE},
  {"vector_set_or_comb_evals", NULL, 0, 0, 0, TRUE},
  {"vector_set_other_comb_evals", NULL, 0, 0, 0, TRUE},
  {"vector_is_uknown", NULL, 0, 0, 0, TRUE},
  {"vector_is_not_zero", NULL, 0, 0, 0, TRUE},
  {"vector_set_to_x", NULL, 0, 0, 0, TRUE},
  {"vector_to_int", NULL, 0, 0, 0, TRUE},
  {"vector_to_uint64", NULL, 0, 0, 0, TRUE},
  {"vector_to_real64", NULL, 0, 0, 0, TRUE},
  {"vector_to_sim_time", NULL, 0, 0, 0, TRUE},
  {"vector_from_int", NULL, 0, 0, 0, TRUE},
  {"vector_from_uint64", NULL, 0, 0, 0, TRUE},
  {"vector_from_real64", NULL, 0, 0, 0, TRUE},
  {"vector_set_static", NULL, 0, 0, 0, TRUE},
  {"vector_to_string", NULL, 0, 0, 0, TRUE},
  {"vector_from_string_fixed", NULL, 0, 0, 0, TRUE},
  {"vector_from_string", NULL, 0, 0, 0, TRUE},
  {"vector_vcd_assign", NULL, 0, 0, 0, TRUE},
  {"vector_bitwise_and_op", NULL, 0, 0, 0, TRUE},
  {"vector_bitwise_nand_op", NULL, 0, 0, 0, TRUE},
  {"vector_bitwise_or_op", NULL, 0, 0, 0, TRUE},
  {"vector_bitwise_nor_op", NULL, 0, 0, 0, TRUE},
  {"vector_bitwise_xor_op", NULL, 0, 0, 0, TRUE},
  {"vector_bitwise_nxor_op", NULL, 0, 0, 0, TRUE},
  {"vector_op_lt", NULL, 0, 0, 0, TRUE},
  {"vector_op_le", NULL, 0, 0, 0, TRUE},
  {"vector_op_gt", NULL, 0, 0, 0, TRUE},
  {"vector_op_ge", NULL, 0, 0, 0, TRUE},
  {"vector_op_eq", NULL, 0, 0, 0, TRUE},
  {"vector_ceq_ulong", NULL, 0, 0, 0, TRUE},
  {"vector_op_ceq", NULL, 0, 0, 0, TRUE},
  {"vector_op_cxeq", NULL, 0, 0, 0, TRUE},
  {"vector_op_czeq", NULL, 0, 0, 0, TRUE},
  {"vector_op_ne", NULL, 0, 0, 0, TRUE},
  {"vector_op_cne", NULL, 0, 0, 0, TRUE},
  {"vector_op_lor", NULL, 0, 0, 0, TRUE},
  {"vector_op_land", NULL, 0, 0, 0, TRUE},
  {"vector_op_lshift", NULL, 0, 0, 0, TRUE},
  {"vector_op_rshift", NULL, 0, 0, 0, TRUE},
  {"vector_op_arshift", NULL, 0, 0, 0, TRUE},
  {"vector_op_add", NULL, 0, 0, 0, TRUE},
  {"vector_op_negate", NULL, 0, 0, 0, TRUE},
  {"vector_op_subtract", NULL, 0, 0, 0, TRUE},
  {"vector_op_multiply", NULL, 0, 0, 0, TRUE},
  {"vector_op_divide", NULL, 0, 0, 0, TRUE},
  {"vector_op_modulus", NULL, 0, 0, 0, TRUE},
  {"vector_op_inc", NULL, 0, 0, 0, TRUE},
  {"vector_op_dec", NULL, 0, 0, 0, TRUE},
  {"vector_unary_inv", NULL, 0, 0, 0, TRUE},
  {"vector_unary_and", NULL, 0, 0, 0, TRUE},
  {"vector_unary_nand", NULL, 0, 0, 0, TRUE},
  {"vector_unary_or", NULL, 0, 0, 0, TRUE},
  {"vector_unary_nor", NULL, 0, 0, 0, TRUE},
  {"vector_unary_xor", NULL, 0, 0, 0, TRUE},
  {"vector_unary_nxor", NULL, 0, 0, 0, TRUE},
  {"vector_unary_not", NULL, 0, 0, 0, TRUE},
  {"vector_op_expand", NULL, 0, 0, 0, TRUE},
  {"vector_op_list", NULL, 0, 0, 0, TRUE},
  {"vector_op_clog2", NULL, 0, 0, 0, TRUE},
  {"vector_dealloc_value", NULL, 0, 0, 0, TRUE},
  {"vector_dealloc", NULL, 0, 0, 0, TRUE},
  {"struct_union_length", NULL, 0, 0, 0, TRUE},
  {"struct_union_add_member", NULL, 0, 0, 0, TRUE},
  {"struct_union_add_member_void", NULL, 0, 0, 0, TRUE},
  {"struct_union_add_member_sig", NULL, 0, 0, 0, TRUE},
  {"struct_union_add_member_typedef", NULL, 0, 0, 0, TRUE},
  {"struct_union_add_member_enum", NULL, 0, 0, 0, TRUE},
  {"struct_union_add_member_struct_union", NULL, 0, 0, 0, TRUE},
  {"struct_union_create", NULL, 0, 0, 0, TRUE},
  {"struct_union_member_dealloc", NULL, 0, 0, 0, TRUE},
  {"struct_union_dealloc", NULL, 0, 0, 0, TRUE},
  {"struct_union_dealloc_list", NULL, 0, 0, 0, TRUE},
  {"fsm_arg_parse_state", NULL, 0, 0, 0, TRUE},
  {"fsm_arg_parse", NULL, 0, 0, 0, TRUE},
  {"fsm_arg_parse_value", NULL, 0, 0, 0, TRUE},
  {"fsm_arg_parse_trans", NULL, 0, 0, 0, TRUE},
  {"fsm_arg_parse_attr", NULL, 0, 0, 0, TRUE},
  {"score_add_args", NULL, 0, 0, 0, FALSE},
  {"info_set_vector_elem_size", NULL, 0, 0, 0, TRUE},
  {"info_db_write", NULL, 0, 0, 0, TRUE},
  {"info_db_read", NULL, 0, 0, 0, TRUE},
  {"args_db_read", NULL, 0, 0, 0, TRUE},
  {"message_db_read", NULL, 0, 0, 0, TRUE},
  {"merged_cdd_db_read", NULL, 0, 0, 0, TRUE},
  {"info_dealloc", NULL, 0, 0, 0, TRUE},
  {"codegen_create_expr_helper", NULL, 0, 0, 0, FALSE},
  {"codegen_create_expr", NULL, 0, 0, 0, FALSE},
  {"codegen_gen_expr", NULL, 0, 0, 0, FALSE},
  {"merge_check", NULL, 0, 0, 0, TRUE},
  {"command_merge", NULL, 0, 0, 0, TRUE},
  {"symtable_add_sym_sig", NULL, 0, 0, 0, TRUE},
  {"symtable_init", NULL, 0, 0, 0, TRUE},
  {"symtable_create", NULL, 0, 0, 0, TRUE},
  {"symtable_add", NULL, 0, 0, 0, TRUE},
  {"symtable_set_value", NULL, 0, 0, 0, TRUE},
  {"symtable_assign", NULL, 0, 0, 0, TRUE},
  {"symtable_dealloc", NULL, 0, 0, 0, TRUE},
  {"line_get_stats", NULL, 0, 0, 0, TRUE},
  {"line_collect", NULL, 0, 0, 0, TRUE},
  {"line_get_funit_summary", NULL, 0, 0, 0, TRUE},
  {"line_get_inst_summary", NULL, 0, 0, 0, TRUE},
  {"line_display_instance_summary", NULL, 0, 0, 0, TRUE},
  {"line_instance_summary", NULL, 0, 0, 0, TRUE},
  {"line_display_funit_summary", NULL, 0, 0, 0, TRUE},
  {"line_funit_summary", NULL, 0, 0, 0, TRUE},
  {"line_display_verbose", NULL, 0, 0, 0, TRUE},
  {"line_instance_verbose", NULL, 0, 0, 0, TRUE},
  {"line_funit_verbose", NULL, 0, 0, 0, TRUE},
  {"line_report", NULL, 0, 0, 0, TRUE},
  {"enumerate_add_item", NULL, 0, 0, 0, TRUE},
  {"enumerate_end_list", NULL, 0, 0, 0, TRUE},
  {"enumerate_resolve", NULL, 0, 0, 0, TRUE},
  {"enumerate_dealloc", NULL, 0, 0, 0, TRUE},
  {"enumerate_dealloc_list", NULL, 0, 0, 0, TRUE},
  {"exclude_expr_assign_and_recalc", NULL, 0, 0, 0, TRUE},
  {"exclude_sig_assign_and_recalc", NULL, 0, 0, 0, TRUE},
  {"exclude_arc_assign_and_recalc", NULL, 0, 0, 0, TRUE},
  {"exclude_add_exclude_reason", NULL, 0, 0, 0, FALSE},
  {"exclude_remove_exclude_reason", NULL, 0, 0, 0, TRUE},
  {"exclude_is_line_excluded", NULL, 0, 0, 0, TRUE},
  {"exclude_set_line_exclude", NULL, 0, 0, 0, TRUE},
  {"exclude_is_toggle_excluded", NULL, 0, 0, 0, TRUE},
  {"exclude_set_toggle_exclude", NULL, 0, 0, 0, TRUE},
  {"exclude_is_comb_excluded", NULL, 0, 0, 0, TRUE},
  {"exclude_set_comb_exclude", NULL, 0, 0, 0, TRUE},
  {"exclude_is_fsm_excluded", NULL, 0, 0, 0, TRUE},
  {"exclude_set_fsm_exclude", NULL, 0, 0, 0, TRUE},
  {"exclude_is_assert_excluded", NULL, 0, 0, 0, TRUE},
  {"exclude_set_assert_exclude", NULL, 0, 0, 0, TRUE},
  {"exclude_find_exclude_reason", NULL, 0, 0, 0, TRUE},
  {"exclude_db_write", NULL, 0, 0, 0, TRUE},
  {"exclude_db_read", NULL, 0, 0, 0, TRUE},
  {"exclude_resolve_reason", NULL, 0, 0, 0, TRUE},
  {"exclude_db_merge", NULL, 0, 0, 0, TRUE},
  {"exclude_merge", NULL, 0, 0, 0, TRUE},
  {"exclude_find_signal", NULL, 0, 0, 0, TRUE},
  {"exclude_find_expression", NULL, 0, 0, 0, TRUE},
  {"exclude_find_fsm_arc", NULL, 0, 0, 0, TRUE},
  {"exclude_format_reason", NULL, 0, 0, 0, TRUE},
  {"excluded_get_message", NULL, 0, 0, 0, TRUE},
  {"exclude_handle_exclude_reason", NULL, 0, 0, 0, TRUE},
  {"exclude_print_exclusion", NULL, 0, 0, 0, TRUE},
  {"exclude_line_from_id", NULL, 0, 0, 0, TRUE},
  {"exclude_toggle_from_id", NULL, 0, 0, 0, TRUE},
  {"exclude_memory_from_id", NULL, 0, 0, 0, TRUE},
  {"exclude_expr_from_id", NULL, 0, 0, 0, TRUE},
  {"exclude_fsm_from_id", NULL, 0, 0, 0, TRUE},
  {"exclude_assert_from_id", NULL, 0, 0, 0, TRUE},
  {"exclude_apply_exclusions", NULL, 0, 0, 0, TRUE},
  {"command_exclude", NULL, 0, 0, 0, TRUE},
  {"assertion_parse", NULL, 0, 0, 0, TRUE},
  {"assertion_parse_attr", NULL, 0, 0, 0, TRUE},
  {"assertion_get_stats", NULL, 0, 0, 0, TRUE},
  {"assertion_display_instance_summary", NULL, 0, 0, 0, TRUE},
  {"assertion_instance_summary", NULL, 0, 0, 0, TRUE},
  {"assertion_display_funit_summary", NULL, 0, 0, 0, TRUE},
  {"assertion_funit_summary", NULL, 0, 0, 0, TRUE},
  {"assertion_display_verbose", NULL, 0, 0, 0, TRUE},
  {"assertion_instance_verbose", NULL, 0, 0, 0, TRUE},
  {"assertion_funit_verbose", NULL, 0, 0, 0, TRUE},
  {"assertion_report", NULL, 0, 0, 0, TRUE},
  {"assertion_get_funit_summary", NULL, 0, 0, 0, TRUE},
  {"assertion_collect", NULL, 0, 0, 0, TRUE},
  {"assertion_get_coverage", NULL, 0, 0, 0, TRUE},
  {"reentrant_count_afu_bits", NULL, 0, 0, 0, TRUE},
  {"reentrant_store_data_bits", NULL, 0, 0, 0, TRUE},
  {"reentrant_restore_data_bits", NULL, 0, 0, 0, TRUE},
  {"reentrant_create", NULL, 0, 0, 0, TRUE},
  {"reentrant_dealloc", NULL, 0, 0, 0, TRUE},
  {"toggle_get_stats", NULL, 0, 0, 0, TRUE},
  {"toggle_collect", NULL, 0, 0, 0, TRUE},
  {"toggle_get_coverage", NULL, 0, 0, 0, TRUE},
  {"toggle_get_funit_summary", NULL, 0, 0, 0, TRUE},
  {"toggle_get_inst_summary", NULL, 0, 0, 0, TRUE},
  {"toggle_display_instance_summary", NULL, 0, 0, 0, TRUE},
  {"toggle_instance_summary", NULL, 0, 0, 0, TRUE},
  {"toggle_display_funit_summary", NULL, 0, 0, 0, TRUE},
  {"toggle_funit_summary", NULL, 0, 0, 0, TRUE},
  {"toggle_display_verbose", NULL, 0, 0, 0, TRUE},
  {"toggle_instance_verbose", NULL, 0, 0, 0, TRUE},
  {"toggle_funit_verbose", NULL, 0, 0, 0, TRUE},
  {"toggle_report", NULL, 0, 0, 0, TRUE},
  {"def_lookup", NULL, 0, 0, 0, TRUE},
  {"is_defined", NULL, 0, 0, 0, TRUE},
  {"def_match", NULL, 0, 0, 0, TRUE},
  {"def_start", NULL, 0, 0, 0, TRUE},
  {"define_macro", NULL, 0, 0, 0, TRUE},
  {"do_define", NULL, 0, 0, 0, TRUE},
  {"def_is_done", NULL, 0, 0, 0, TRUE},
  {"def_finish", NULL, 0, 0, 0, TRUE},
  {"def_undefine", NULL, 0, 0, 0, TRUE},
  {"include_filename", NULL, 0, 0, 0, TRUE},
  {"do_include", NULL, 0, 0, 0, TRUE},
  {"yywrap", NULL, 0, 0, 0, TRUE},
  {"reset_pplexer", NULL, 0, 0, 0, TRUE},
  {"arc_find_from_state", NULL, 0, 0, 0, TRUE},
  {"arc_find_to_state", NULL, 0, 0, 0, TRUE},
  {"arc_find_arc", NULL, 0, 0, 0, TRUE},
  {"arc_find_arc_by_exclusion_id", NULL, 0, 0, 0, TRUE},
  {"arc_create", NULL, 0, 0, 0, TRUE},
  {"arc_add", NULL, 0, 0, 0, TRUE},
  {"arc_state_hits", NULL, 0, 0, 0, TRUE},
  {"arc_transition_hits", NULL, 0, 0, 0, TRUE},
  {"arc_transition_excluded", NULL, 0, 0, 0, TRUE},
  {"arc_get_stats", NULL, 0, 0, 0, TRUE},
  {"arc_db_write", NULL, 0, 0, 0, TRUE},
  {"arc_db_read", NULL, 0, 0, 0, TRUE},
  {"arc_db_merge", NULL, 0, 0, 0, TRUE},
  {"arc_merge", NULL, 0, 0, 0, TRUE},
  {"arc_get_states", NULL, 0, 0, 0, TRUE},
  {"arc_get_transitions", NULL, 0, 0, 0, TRUE},
  {"arc_are_any_excluded", NULL, 0, 0, 0, TRUE},
  {"arc_dealloc", NULL, 0, 0, 0, TRUE},
  {"lexer_keyword_2001_code", NULL, 0, 0, 0, TRUE},
  {"lexer_keyword_1995_code", NULL, 0, 0, 0, TRUE},
  {"vsignal_init", NULL, 0, 0, 0, TRUE},
  {"vsignal_create", NULL, 0, 0, 0, TRUE},
  {"vsignal_create_vec", NULL, 0, 0, 0, TRUE},
  {"vsignal_duplicate", NULL, 0, 0, 0, TRUE},
  {"vsignal_db_write", NULL, 0, 0, 0, TRUE},
  {"vsignal_db_read", NULL, 0, 0, 0, TRUE},
  {"vsignal_db_merge", NULL, 0, 0, 0, TRUE},
  {"vsignal_merge", NULL, 0, 0, 0, TRUE},
  {"vsignal_propagate", NULL, 0, 0, 0, TRUE},
  {"vsignal_vcd_assign", NULL, 0, 0, 0, TRUE},
  {"vsignal_add_expression", NULL, 0, 0, 0, TRUE},
  {"vsignal_from_string", NULL, 0, 0, 0, TRUE},
  {"vsignal_calc_width_for_expr", NULL, 0, 0, 0, TRUE},
  {"vsignal_calc_lsb_for_expr", NULL, 0, 0, 0, TRUE},
  {"vsignal_dealloc", NULL, 0, 0, 0, TRUE},
  {"lexer_keyword_sv_code", NULL, 0, 0, 0, TRUE},
  {"parser_port_declaration_a", NULL, 0, 0, 0, FALSE},
  {"parser_port_declaration_b", NULL, 0, 0, 0, FALSE},
  {"parser_port_declaration_c", NULL, 0, 0, 0, FALSE},
  {"parser_static_expr_primary_a", NULL, 0, 0, 0, FALSE},
  {"parser_static_expr_primary_b", NULL, 0, 0, 0, FALSE},
  {"parser_expression_list_a", NULL, 0, 0, 0, TRUE},
  {"parser_expression_list_b", NULL, 0, 0, 0, TRUE},
  {"parser_expression_list_c", NULL, 0, 0, 0, TRUE},
  {"parser_expression_list_d", NULL, 0, 0, 0, TRUE},
  {"parser_identifier_a", NULL, 0, 0, 0, FALSE},
  {"parser_generate_case_item_a", NULL, 0, 0, 0, FALSE},
  {"parser_generate_case_item_b", NULL, 0, 0, 0, FALSE},
  {"parser_generate_case_item_c", NULL, 0, 0, 0, FALSE},
  {"parser_statement_begin_a", NULL, 0, 0, 0, FALSE},
  {"parser_statement_fork_a", NULL, 0, 0, 0, FALSE},
  {"parser_statement_for_a", NULL, 0, 0, 0, FALSE},
  {"parser_case_item_a", NULL, 0, 0, 0, FALSE},
  {"parser_case_item_b", NULL, 0, 0, 0, FALSE},
  {"parser_case_item_c", NULL, 0, 0, 0, FALSE},
  {"parser_delay_value_a", NULL, 0, 0, 0, TRUE},
  {"parser_delay_value_b", NULL, 0, 0, 0, TRUE},
  {"parser_parameter_value_byname_a", NULL, 0, 0, 0, FALSE},
  {"parser_gate_instance_a", NULL, 0, 0, 0, FALSE},
  {"parser_gate_instance_b", NULL, 0, 0, 0, FALSE},
  {"parser_gate_instance_c", NULL, 0, 0, 0, FALSE},
  {"parser_gate_instance_d", NULL, 0, 0, 0, FALSE},
  {"parser_list_of_names_a", NULL, 0, 0, 0, FALSE},
  {"parser_list_of_names_b", NULL, 0, 0, 0, FALSE},
  {"memory_get_stat", NULL, 0, 0, 0, TRUE},
  {"memory_get_stats", NULL, 0, 0, 0, TRUE},
  {"memory_get_funit_summary", NULL, 0, 0, 0, TRUE},
  {"memory_get_inst_summary", NULL, 0, 0, 0, TRUE},
  {"memory_create_pdim_bit_array", NULL, 0, 0, 0, TRUE},
  {"memory_get_mem_coverage", NULL, 0, 0, 0, TRUE},
  {"memory_get_coverage", NULL, 0, 0, 0, TRUE},
  {"memory_collect", NULL, 0, 0, 0, TRUE},
  {"memory_display_toggle_instance_summary", NULL, 0, 0, 0, TRUE},
  {"memory_toggle_instance_summary", NULL, 0, 0, 0, TRUE},
  {"memory_display_ae_instance_summary", NULL, 0, 0, 0, TRUE},
  {"memory_ae_instance_summary", NULL, 0, 0, 0, TRUE},
  {"memory_display_toggle_funit_summary", NULL, 0, 0, 0, TRUE},
  {"memory_toggle_funit_summary", NULL, 0, 0, 0, TRUE},
  {"memory_display_ae_funit_summary", NULL, 0, 0, 0, TRUE},
  {"memory_ae_funit_summary", NULL, 0, 0, 0, TRUE},
  {"memory_display_memory", NULL, 0, 0, 0, TRUE},
  {"memory_display_verbose", NULL, 0, 0, 0, TRUE},
  {"memory_instance_verbose", NULL, 0, 0, 0, TRUE},
  {"memory_funit_verbose", NULL, 0, 0, 0, TRUE},
  {"memory_report", NULL, 0, 0, 0, TRUE},
  {"expression_create_tmp_vecs", NULL, 0, 0, 0, TRUE},
  {"expression_create_nba", NULL, 0, 0, 0, TRUE},
  {"expression_is_nba_lhs", NULL, 0, 0, 0, TRUE},
  {"expression_create_value", NULL, 0, 0, 0, TRUE},
  {"expression_create", NULL, 0, 0, 0, TRUE},
  {"expression_set_value", NULL, 0, 0, 0, TRUE},
  {"expression_set_signed", NULL, 0, 0, 0, TRUE},
  {"expression_resize", NULL, 0, 0, 0, TRUE},
  {"expression_get_id", NULL, 0, 0, 0, TRUE},
  {"expression_get_first_line_expr", NULL, 0, 0, 0, TRUE},
  {"expression_get_last_line_expr", NULL, 0, 0, 0, TRUE},
  {"expression_get_curr_dimension", NULL, 0, 0, 0, TRUE},
  {"expression_find_rhs_sigs", NULL, 0, 0, 0, TRUE},
  {"expression_find_params", NULL, 0, 0, 0, TRUE},
  {"expression_find_uline_id", NULL, 0, 0, 0, TRUE},
  {"expression_find_expr", NULL, 0, 0, 0, TRUE},
  {"expression_contains_expr_calling_stmt", NULL, 0, 0, 0, TRUE},
  {"expression_get_root_statement", NULL, 0, 0, 0, TRUE},
  {"expression_assign_expr_ids", NULL, 0, 0, 0, TRUE},
  {"expression_db_write", NULL, 0, 0, 0, TRUE},
  {"expression_db_write_tree", NULL, 0, 0, 0, TRUE},
  {"expression_db_read", NULL, 0, 0, 0, TRUE},
  {"expression_db_merge", NULL, 0, 0, 0, TRUE},
  {"expression_merge", NULL, 0, 0, 0, TRUE},
  {"expression_string_op", NULL, 0, 0, 0, TRUE},
  {"expression_string", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__xor", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__xor_a", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__multiply", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__multiply_a", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__divide", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__divide_a", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__mod", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__mod_a", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__add", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__add_a", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__subtract", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__sub_a", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__and", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__and_a", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__or", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__or_a", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__nand", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__nor", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__nxor", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__lt", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__gt", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__lshift", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__lshift_a", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__rshift", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__rshift_a", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__arshift", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__arshift_a", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__time", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__random", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__sassign", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__srandom", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__urandom", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__urandom_range", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__realtobits", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__bitstoreal", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__shortrealtobits", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__bitstoshortreal", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__itor", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__rtoi", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__test_plusargs", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__value_plusargs", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__signed", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__unsigned", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__clog2", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__eq", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__ceq", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__le", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__ge", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__ne", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__cne", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__lor", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__land", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__cond", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__cond_sel", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__uinv", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__uand", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__unot", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__uor", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__uxor", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__unand", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__unor", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__unxor", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__null", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__sig", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__sbit", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__mbit", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__expand", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__list", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__concat", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__pedge", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__nedge", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__aedge", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__eor", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__slist", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__delay", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__trigger", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__case", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__casex", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__casez", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__default", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__bassign", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__func_call", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__task_call", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__nb_call", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__fork", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__join", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__disable", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__repeat", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__exponent", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__passign", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__mbit_pos", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__mbit_neg", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__negate", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__iinc", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__pinc", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__idec", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__pdec", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__dly_assign", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__dly_op", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__repeat_dly", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__dim", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__wait", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__finish", NULL, 0, 0, 0, TRUE},
  {"expression_op_func__stop", NULL, 0, 0, 0, TRUE},
  {"expression_operate", NULL, 0, 0, 0, TRUE},
  {"expression_operate_recursively", NULL, 0, 0, 0, TRUE},
  {"expression_is_static_only_helper", NULL, 0, 0, 0, TRUE},
  {"expression_is_assigned", NULL, 0, 0, 0, TRUE},
  {"expression_is_bit_select", NULL, 0, 0, 0, TRUE},
  {"expression_is_last_select", NULL, 0, 0, 0, TRUE},
  {"expression_is_in_rassign", NULL, 0, 0, 0, TRUE},
  {"expression_set_assigned", NULL, 0, 0, 0, TRUE},
  {"expression_set_changed", NULL, 0, 0, 0, TRUE},
  {"expression_assign", NULL, 0, 0, 0, TRUE},
  {"expression_dealloc", NULL, 0, 0, 0, TRUE},
  {"parse_readline", NULL, 0, 0, 0, TRUE},
  {"parse_design", NULL, 0, 0, 0, TRUE},
  {"parse_and_score_dumpfile", NULL, 0, 0, 0, TRUE},
  {"func_iter_display", NULL, 0, 0, 0, TRUE},
  {"func_iter_sort", NULL, 0, 0, 0, TRUE},
  {"func_iter_count_stmt_iters", NULL, 0, 0, 0, TRUE},
  {"func_iter_add_stmt_links", NULL, 0, 0, 0, TRUE},
  {"func_iter_add_sig_links", NULL, 0, 0, 0, TRUE},
  {"func_iter_init", NULL, 0, 0, 0, TRUE},
  {"func_iter_get_next_statement", NULL, 0, 0, 0, TRUE},
  {"func_iter_get_next_signal", NULL, 0, 0, 0, TRUE},
  {"func_iter_dealloc", NULL, 0, 0, 0, TRUE},
  {"db_create", NULL, 0, 0, 0, TRUE},
  {"db_close", NULL, 0, 0, 0, TRUE},
  {"db_check_for_top_module", NULL, 0, 0, 0, TRUE},
  {"db_write", NULL, 0, 0, 0, TRUE},
  {"db_read", NULL, 0, 0, 0, TRUE},
  {"db_merge_instance_trees", NULL, 0, 0, 0, TRUE},
  {"db_scale_to_precision", NULL, 0, 0, 0, TRUE},
  {"db_create_unnamed_scope", NULL, 0, 0, 0, TRUE},
  {"db_is_unnamed_scope", NULL, 0, 0, 0, TRUE},
  {"db_set_timescale", NULL, 0, 0, 0, TRUE},
  {"db_get_curr_funit", NULL, 0, 0, 0, TRUE},
  {"db_get_exclusion_id_size", NULL, 0, 0, 0, TRUE},
  {"db_gen_exclusion_id", NULL, 0, 0, 0, TRUE},
  {"db_add_file_version", NULL, 0, 0, 0, TRUE},
  {"db_output_dumpvars", NULL, 0, 0, 0, TRUE},
  {"db_add_instance", NULL, 0, 0, 0, TRUE},
  {"db_add_module", NULL, 0, 0, 0, TRUE},
  {"db_end_module", NULL, 0, 0, 0, TRUE},
  {"db_add_function_task_namedblock", NULL, 0, 0, 0, TRUE},
  {"db_end_function_task_namedblock", NULL, 0, 0, 0, TRUE},
  {"db_add_declared_param", NULL, 0, 0, 0, TRUE},
  {"db_add_override_param", NULL, 0, 0, 0, TRUE},
  {"db_add_vector_param", NULL, 0, 0, 0, TRUE},
  {"db_add_defparam", NULL, 0, 0, 0, TRUE},
  {"db_add_signal", NULL, 0, 0, 0, TRUE},
  {"db_add_enum", NULL, 0, 0, 0, TRUE},
  {"db_end_enum_list", NULL, 0, 0, 0, TRUE},
  {"db_add_typedef", NULL, 0, 0, 0, TRUE},
  {"db_find_signal", NULL, 0, 0, 0, TRUE},
  {"db_add_gen_item_block", NULL, 0, 0, 0, TRUE},
  {"db_find_gen_item", NULL, 0, 0, 0, TRUE},
  {"db_find_typedef", NULL, 0, 0, 0, TRUE},
  {"db_get_curr_gen_block", NULL, 0, 0, 0, TRUE},
  {"db_curr_signal_count", NULL, 0, 0, 0, TRUE},
  {"db_create_expression", NULL, 0, 0, 0, TRUE},
  {"db_bind_expr_tree", NULL, 0, 0, 0, TRUE},
  {"db_create_expr_from_static", NULL, 0, 0, 0, TRUE},
  {"db_add_expression", NULL, 0, 0, 0, TRUE},
  {"db_create_sensitivity_list", NULL, 0, 0, 0, TRUE},
  {"db_parallelize_statement", NULL, 0, 0, 0, TRUE},
  {"db_create_statement", NULL, 0, 0, 0, TRUE},
  {"db_add_statement", NULL, 0, 0, 0, TRUE},
  {"db_remove_statement_from_current_funit", NULL, 0, 0, 0, TRUE},
  {"db_remove_statement", NULL, 0, 0, 0, TRUE},
  {"db_connect_statement_true", NULL, 0, 0, 0, TRUE},
  {"db_connect_statement_false", NULL, 0, 0, 0, TRUE},
  {"db_gen_item_connect_true", NULL, 0, 0, 0, TRUE},
  {"db_gen_item_connect_false", NULL, 0, 0, 0, TRUE},
  {"db_gen_item_connect", NULL, 0, 0, 0, TRUE},
  {"db_statement_connect", NULL, 0, 0, 0, TRUE},
  {"db_create_attr_param", NULL, 0, 0, 0, TRUE},
  {"db_parse_attribute", NULL, 0, 0, 0, TRUE},
  {"db_remove_stmt_blks_calling_statement", NULL, 0, 0, 0, TRUE},
  {"db_gen_curr_inst_scope", NULL, 0, 0, 0, TRUE},
  {"db_sync_curr_instance", NULL, 0, 0, 0, TRUE},
  {"db_set_vcd_scope", NULL, 0, 0, 0, TRUE},
  {"db_vcd_upscope", NULL, 0, 0, 0, TRUE},
  {"db_assign_symbol", NULL, 0, 0, 0, TRUE},
  {"db_set_symbol_char", NULL, 0, 0, 0, TRUE},
  {"db_set_symbol_string", NULL, 0, 0, 0, TRUE},
  {"db_do_timestep", NULL, 0, 0, 0, TRUE},
  {"db_check_dumpfile_scopes", NULL, 0, 0, 0, TRUE},
  {"vlerror", NULL, 0, 0, 0, TRUE},
  {"vlwarn", NULL, 0, 0, 0, TRUE},
  {"parser_dealloc_sig_range", NULL, 0, 0, 0, TRUE},
  {"parser_copy_curr_range", NULL, 0, 0, 0, FALSE},
  {"parser_copy_range_to_curr_range", NULL, 0, 0, 0, FALSE},
  {"parser_explicitly_set_curr_range", NULL, 0, 0, 0, FALSE},
  {"parser_implicitly_set_curr_range", NULL, 0, 0, 0, FALSE},
  {"parser_check_generation", NULL, 0, 0, 0, TRUE},
  {"parser_handle_case_statement", NULL, 0, 0, 0, TRUE},
  {"parser_handle_case_statement_list", NULL, 0, 0, 0, TRUE},
  {"parser_handle_generate_case_statement", NULL, 0, 0, 0, TRUE},
  {"parser_handle_generate_case_statement_list", NULL, 0, 0, 0, TRUE},
  {"mod_parm_find", NULL, 0, 0, 0, TRUE},
  {"mod_parm_find_expr_and_remove", NULL, 0, 0, 0, TRUE},
  {"mod_parm_add", NULL, 0, 0, 0, TRUE},
  {"inst_parm_find", NULL, 0, 0, 0, TRUE},
  {"inst_parm_add", NULL, 0, 0, 0, TRUE},
  {"inst_parm_add_genvar", NULL, 0, 0, 0, TRUE},
  {"inst_parm_bind", NULL, 0, 0, 0, TRUE},
  {"defparam_add", NULL, 0, 0, 0, TRUE},
  {"defparam_dealloc", NULL, 0, 0, 0, TRUE},
  {"param_find_and_set_expr_value", NULL, 0, 0, 0, TRUE},
  {"param_set_sig_size", NULL, 0, 0, 0, TRUE},
  {"param_size_function", NULL, 0, 0, 0, TRUE},
  {"param_expr_eval", NULL, 0, 0, 0, TRUE},
  {"param_has_override", NULL, 0, 0, 0, TRUE},
  {"param_has_defparam", NULL, 0, 0, 0, TRUE},
  {"param_resolve_declared", NULL, 0, 0, 0, TRUE},
  {"param_resolve_override", NULL, 0, 0, 0, TRUE},
  {"param_resolve_inst", NULL, 0, 0, 0, TRUE},
  {"param_resolve", NULL, 0, 0, 0, TRUE},
  {"param_db_write", NULL, 0, 0, 0, TRUE},
  {"mod_parm_dealloc", NULL, 0, 0, 0, TRUE},
  {"inst_parm_dealloc", NULL, 0, 0, 0, TRUE},
  {"str_link_add", NULL, 0, 0, 0, TRUE},
  {"stmt_link_add_head", NULL, 0, 0, 0, TRUE},
  {"exp_link_add", NULL, 0, 0, 0, TRUE},
  {"sig_link_add", NULL, 0, 0, 0, TRUE},
  {"fsm_link_add", NULL, 0, 0, 0, TRUE},
  {"funit_link_add", NULL, 0, 0, 0, TRUE},
  {"gitem_link_add", NULL, 0, 0, 0, TRUE},
  {"inst_link_add", NULL, 0, 0, 0, TRUE},
  {"str_link_find", NULL, 0, 0, 0, TRUE},
  {"stmt_link_find", NULL, 0, 0, 0, TRUE},
  {"stmt_link_find_by_pos", NULL, 0, 0, 0, TRUE},
  {"exp_link_find", NULL, 0, 0, 0, TRUE},
  {"exp_link_find_by_pos", NULL, 0, 0, 0, TRUE},
  {"sig_link_find", NULL, 0, 0, 0, TRUE},
  {"fsm_link_find", NULL, 0, 0, 0, TRUE},
  {"fsm_link_find_by_pos", NULL, 0, 0, 0, TRUE},
  {"funit_link_find", NULL, 0, 0, 0, TRUE},
  {"gitem_link_find", NULL, 0, 0, 0, TRUE},
  {"inst_link_find_by_scope", NULL, 0, 0, 0, TRUE},
  {"inst_link_find_by_funit", NULL, 0, 0, 0, TRUE},
  {"str_link_remove", NULL, 0, 0, 0, TRUE},
  {"exp_link_remove", NULL, 0, 0, 0, TRUE},
  {"gitem_link_remove", NULL, 0, 0, 0, TRUE},
  {"funit_link_remove", NULL, 0, 0, 0, TRUE},
  {"str_link_delete_list", NULL, 0, 0, 0, TRUE},
  {"stmt_link_unlink", NULL, 0, 0, 0, TRUE},
  {"stmt_link_delete_list", NULL, 0, 0, 0, TRUE},
  {"exp_link_delete_list", NULL, 0, 0, 0, TRUE},
  {"sig_link_delete_list", NULL, 0, 0, 0, TRUE},
  {"fsm_link_delete_list", NULL, 0, 0, 0, TRUE},
  {"funit_link_delete_list", NULL, 0, 0, 0, TRUE},
  {"gitem_link_delete_list", NULL, 0, 0, 0, TRUE},
  {"inst_link_delete_list", NULL, 0, 0, 0, TRUE},
  {"funit_init", NULL, 0, 0, 0, TRUE},
  {"funit_create", NULL, 0, 0, 0, TRUE},
  {"funit_get_curr_module", NULL, 0, 0, 0, TRUE},
  {"funit_get_curr_module_safe", NULL, 0, 0, 0, TRUE},
  {"funit_get_curr_function", NULL, 0, 0, 0, TRUE},
  {"funit_get_curr_task", NULL, 0, 0, 0, TRUE},
  {"funit_get_port_count", NULL, 0, 0, 0, TRUE},
  {"funit_find_param", NULL, 0, 0, 0, TRUE},
  {"funit_find_signal", NULL, 0, 0, 0, TRUE},
  {"funit_remove_stmt_blks_calling_stmt", NULL, 0, 0, 0, TRUE},
  {"funit_gen_task_function_namedblock_name", NULL, 0, 0, 0, TRUE},
  {"funit_size_elements", NULL, 0, 0, 0, TRUE},
  {"funit_db_write", NULL, 0, 0, 0, TRUE},
  {"funit_db_read", NULL, 0, 0, 0, TRUE},
  {"funit_version_db_read", NULL, 0, 0, 0, TRUE},
  {"funit_db_inst_merge", NULL, 0, 0, 0, TRUE},
  {"funit_db_mod_merge", NULL, 0, 0, 0, TRUE},
  {"funit_merge", NULL, 0, 0, 0, TRUE},
  {"funit_flatten_name", NULL, 0, 0, 0, TRUE},
  {"funit_find_by_id", NULL, 0, 0, 0, TRUE},
  {"funit_is_top_module", NULL, 0, 0, 0, TRUE},
  {"funit_is_unnamed", NULL, 0, 0, 0, TRUE},
  {"funit_is_unnamed_child_of", NULL, 0, 0, 0, TRUE},
  {"funit_is_child_of", NULL, 0, 0, 0, TRUE},
  {"funit_display_signals", NULL, 0, 0, 0, TRUE},
  {"funit_display_expressions", NULL, 0, 0, 0, TRUE},
  {"statement_add_thread", NULL, 0, 0, 0, FALSE},
  {"funit_push_threads", NULL, 0, 0, 0, TRUE},
  {"statement_delete_thread", NULL, 0, 0, 0, TRUE},
  {"funit_output_dumpvars", NULL, 0, 0, 0, TRUE},
  {"funit_is_one_signal_assigned", NULL, 0, 0, 0, TRUE},
  {"funit_clean", NULL, 0, 0, 0, TRUE},
  {"funit_dealloc", NULL, 0, 0, 0, TRUE},
  {"sym_value_store", NULL, 0, 0, 0, TRUE},
  {"add_sym_values_to_sim", NULL, 0, 0, 0, TRUE},
  {"covered_value_change_bin", NULL, 0, 0, 0, TRUE},
  {"covered_value_change_real", NULL, 0, 0, 0, TRUE},
  {"covered_end_of_sim", NULL, 0, 0, 0, TRUE},
  {"covered_cb_error_handler", NULL, 0, 0, 0, TRUE},
  {"gen_next_symbol", NULL, 0, 0, 0, TRUE},
  {"covered_create_value_change_cb", NULL, 0, 0, 0, TRUE},
  {"covered_parse_task_func", NULL, 0, 0, 0, TRUE},
  {"covered_parse_signals", NULL, 0, 0, 0, TRUE},
  {"covered_parse_instance", NULL, 0, 0, 0, TRUE},
  {"covered_sim_calltf", NULL, 0, 0, 0, TRUE},
  {"obfuscate_set_mode", NULL, 0, 0, 0, TRUE},
  {"obfuscate_name", NULL, 0, 0, 0, TRUE},
  {"obfuscate_dealloc", NULL, 0, 0, 0, TRUE},
  {"statistic_create", NULL, 0, 0, 0, TRUE},
  {"statistic_is_empty", NULL, 0, 0, 0, TRUE},
  {"statistic_dealloc", NULL, 0, 0, 0, TRUE},
  {"bind_add", NULL, 0, 0, 0, TRUE},
  {"bind_append_fsm_expr", NULL, 0, 0, 0, TRUE},
  {"bind_remove", NULL, 0, 0, 0, TRUE},
  {"bind_find_sig_name", NULL, 0, 0, 0, TRUE},
  {"bind_param", NULL, 0, 0, 0, TRUE},
  {"bind_signal", NULL, 0, 0, 0, TRUE},
  {"bind_task_function_ports", NULL, 0, 0, 0, TRUE},
  {"bind_task_function_namedblock", NULL, 0, 0, 0, TRUE},
  {"bind_perform", NULL, 0, 0, 0, TRUE},
  {"bind_dealloc", NULL, 0, 0, 0, TRUE},
  {"lexer_cstring_a", NULL, 0, 0, 0, FALSE},
  {"lexer_keyword_a", NULL, 0, 0, 0, FALSE},
  {"lexer_escaped_name", NULL, 0, 0, 0, FALSE},
  {"lexer_system_call", NULL, 0, 0, 0, FALSE},
  {"line_directive", NULL, 0, 0, 0, TRUE},
  {"line_directive2", NULL, 0, 0, 0, TRUE},
  {"process_timescale_token", NULL, 0, 0, 0, TRUE},
  {"process_timescale", NULL, 0, 0, 0, TRUE},
  {"lexer_yywrap", NULL, 0, 0, 0, TRUE},
  {"reset_lexer", NULL, 0, 0, 0, TRUE},
  {"check_for_pragma", NULL, 0, 0, 0, TRUE},
  {"lexer_keyword_sys_2001_code", NULL, 0, 0, 0, TRUE},
  {"stmt_blk_add_to_remove_list", NULL, 0, 0, 0, TRUE},
  {"stmt_blk_remove", NULL, 0, 0, 0, TRUE},
  {"stmt_blk_specify_removal_reason", NULL, 0, 0, 0, TRUE},
  {"scope_find_funit_from_scope", NULL, 0, 0, 0, TRUE},
  {"scope_find_param", NULL, 0, 0, 0, TRUE},
  {"scope_find_signal", NULL, 0, 0, 0, TRUE},
  {"scope_find_task_function_namedblock", NULL, 0, 0, 0, TRUE},
  {"scope_get_parent_funit", NULL, 0, 0, 0, TRUE},
  {"scope_get_parent_module", NULL, 0, 0, 0, TRUE},
  {"gen_item_stringify", NULL, 0, 0, 0, TRUE},
  {"gen_item_display", NULL, 0, 0, 0, TRUE},
  {"gen_item_display_block_helper", NULL, 0, 0, 0, TRUE},
  {"gen_item_display_block", NULL, 0, 0, 0, TRUE},
  {"gen_item_compare", NULL, 0, 0, 0, TRUE},
  {"gen_item_find", NULL, 0, 0, 0, TRUE},
  {"gen_item_remove_if_contains_expr_calling_stmt", NULL, 0, 0, 0, TRUE},
  {"gen_item_get_genvar", NULL, 0, 0, 0, TRUE},
  {"gen_item_varname_contains_genvar", NULL, 0, 0, 0, FALSE},
  {"gen_item_calc_signal_name", NULL, 0, 0, 0, FALSE},
  {"gen_item_create_expr", NULL, 0, 0, 0, FALSE},
  {"gen_item_create_sig", NULL, 0, 0, 0, FALSE},
  {"gen_item_create_stmt", NULL, 0, 0, 0, FALSE},
  {"gen_item_create_inst", NULL, 0, 0, 0, FALSE},
  {"gen_item_create_tfn", NULL, 0, 0, 0, FALSE},
  {"gen_item_create_bind", NULL, 0, 0, 0, FALSE},
  {"gen_item_resize_stmts_and_sigs", NULL, 0, 0, 0, TRUE},
  {"gen_item_assign_ids", NULL, 0, 0, 0, TRUE},
  {"gen_item_db_write", NULL, 0, 0, 0, TRUE},
  {"gen_item_db_write_expr_tree", NULL, 0, 0, 0, TRUE},
  {"gen_item_connect", NULL, 0, 0, 0, TRUE},
  {"gen_item_resolve", NULL, 0, 0, 0, TRUE},
  {"gen_item_bind", NULL, 0, 0, 0, TRUE},
  {"generate_resolve_inst", NULL, 0, 0, 0, TRUE},
  {"generate_remove_stmt_helper", NULL, 0, 0, 0, TRUE},
  {"generate_remove_stmt", NULL, 0, 0, 0, TRUE},
  {"gen_item_dealloc", NULL, 0, 0, 0, TRUE},
  {"tree_add", NULL, 0, 0, 0, TRUE},
  {"tree_find", NULL, 0, 0, 0, TRUE},
  {"tree_remove", NULL, 0, 0, 0, TRUE},
  {"tree_dealloc", NULL, 0, 0, 0, TRUE}
};
#endif

unsigned int profile_index = 0;

