/* cfed -- a level editor for Crimson Fields
   Copyright (C) 2000, 2001 Jens Granseuer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*******************************************************
**  ed_list.c  -  linked lists functions              **
*******************************************************/

#include <stddef.h>	/* for NULL */
#include "ed_list.h"

/* start of module functions */

/* initialize the given List structure */ 
void NewList( struct List *l ) {
	l->lh_Head = (struct Node *)&l->lh_Tail;
	l->lh_Tail = NULL;
	l->lh_TailPred = (struct Node *)l;
}

/* add the given Node at the head of the list */
void AddHead( struct List *l, struct Node *n ) {
	n->ln_Next = l->lh_Head;
	n->ln_Prev = (struct Node *)l;

	n->ln_Next->ln_Prev = n;
	l->lh_Head = n;
}

/* add the given Node at the tail of the list */
void AddTail( struct List *l, struct Node *n ) {
	n->ln_Next = (struct Node *)&l->lh_Tail;
	n->ln_Prev = l->lh_TailPred;

	n->ln_Prev->ln_Next = n;
	l->lh_TailPred = n;
}

/*
 * Remove the head of the given List.
 * CAUTION: The function does NOT check whether the
 * list is already empty!
 */ 
struct Node *RemHead( struct List *l ) {
	struct Node *n = l->lh_Head;

	l->lh_Head = n->ln_Next;
	l->lh_Head->ln_Prev = (struct Node *)l;
	return n;
}

/*
 * Remove the tail of the given List.
 * CAUTION: The function does NOT check for an empty list!
 */
struct Node *RemTail( struct List *l ) {
	struct Node *n = l->lh_TailPred;

	l->lh_TailPred = n->ln_Prev;
	l->lh_TailPred->ln_Next = (struct Node *)&l->lh_Tail;
	return n;
}

/* Remove the given Node from the List */
void Remove( struct Node *n ) {
	n->ln_Next->ln_Prev = n->ln_Prev;
	n->ln_Prev->ln_Next = n->ln_Next;
}

/*
 * Put the Node n into the list after the Node m.
 * If m is NULL, make n the new list head.
 */
void Insert( struct List *l, struct Node *n, struct Node *m ) {
	if ( m == NULL ) m = (struct Node *)l;
	n->ln_Next = m->ln_Next;
	n->ln_Next->ln_Prev = n;
	n->ln_Prev = m;
	m->ln_Next = n;
}

