// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// container.h - UnitContainer and Transport classes
//
// Changes:
//   09-06-2001 - increase UC_MAX_SLOTS from 12 to 250
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_CONTAINER_H
#define _INCLUDE_CONTAINER_H

#include "list.h"
#include "unit.h"

#define UC_MAX_SLOTS	250    // maximum number of units
#define UC_MAX_WEIGHT	250    // maximum weight of units

// node class used for keeping track of units
class UCNode : public Node {
public:
  UCNode( Unit *unit ) { uc_unit = unit; }

  Unit *uc_unit;
};


class UnitContainer {
public:
  UnitContainer( void );
  virtual ~UnitContainer( void ) {}

  virtual Player *Owner( void ) const = 0;
  virtual unsigned short Crystals( void ) const = 0;
  virtual void SetCrystals( unsigned short crystals ) = 0;

  short InsertUnit( Unit *unit );
  void RemoveUnit( Unit *unit );

  Unit *GetUnit( short slot ) const;
  virtual bool Allow( const Unit *unit ) const;

  unsigned char FullSlots( void ) const { return uc_slots_full; }
  unsigned char Slots( void ) const { return uc_slots; }
  unsigned char MaxWeight( void ) const { return uc_max_weight; }

protected:
  unsigned char uc_slots;
  unsigned char uc_slots_full;
  unsigned char uc_max_weight;
  unsigned char reserved;

  List uc_units;
};


class Transport : public Unit, public UnitContainer {
public:
  Transport( const UnitType *type, Player *player, unsigned short id,
             short x, short y );
  Transport( SDL_RWops *file, const UnitType *types, Player **players );

  int Save( SDL_RWops *file ) const;
  void SetCrystals( unsigned short crystals ) { t_crystals = crystals; }

  unsigned short Crystals( void ) const { return t_crystals; }
  Player *Owner( void ) const { return Unit::Owner(); }
  void SetPosition( short x, short y );
  bool Hit( unsigned short damage );
  bool Allow( const Unit *unit ) const;

private:
  unsigned short t_crystals;
};

#endif	/* _INCLUDE_CONTAINER_H */

