// Description:
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#include <Random.hpp>
#include <BaseSurface.hpp>
#include <Hero.hpp>
#include <Tracer.hpp>
#include <Constants.hpp>

void Hero::Remove( void)
{
    if( (x&3) || (y&3))
    {
	Character::Remove();
    }
    else
    {
	for( int i=0; i<9; i++)
	{
	    SurfaceS()->SetPixel( oldx + (i%3) +1, oldy + (i/3) +1, BGCOLOR);
	}
    }
}

void Hero::Update( void)
{
    if( power > 10)
    {
	power--;
    }

    //this doesn't really belong here, but it's closely related to hero,
    //and it's almost 2am in the morning, and I have no Coke left, and
    //I'll keep it here for now...
    int pct = (power - 10)/5;
    int i;
    for( i=0; i < 100; i++)
    {
	int c = 0;

	if( i < pct)
	{
	    if( i > 75)
	    {
		c = MEDIUMGREEN;
	    }
	    else if( i > 50)
	    {
		c = LIGHTYELLOW ;
	    }
	    else if( i > 25)
	    {
		c = MEDIUMRED;
	    }
	    else if( i > 0)
	    {
		c = LIGHTRED;
	    }
	}               
	SurfaceS()->SetPixel( 
	    SurfaceS()->Width()-10, (SurfaceS()->Height()>>1)-i, c);
    }
}

void Hero::Check( void)
{
    if( (x&3)==0 && (y&3)==0)
    {
	if( maze->isElement( x>>2, y>>2, POINT))
	{
	    maze->ClearPoint( x>>2, y>>2);
	    //	    PlaySound( 1); 
	}

	if( maze->isElement( x>>2, y>>2, POWERPOINT))
	{
	    maze->RemoveElement( x>>2, y>>2, POWERPOINT);
	    //	    PlaySound( 0); 
	    power += 500;
	}
    }
}

//move hero and play some sound effects
bool Hero::Move( int dir)
{
    Remove();

    bool ret = Character::Move( dir);
    Check();

    Add();

    return( ret);
}

//show hero. No compiled bitmaps here :))
void Hero::Draw( void)
{
    SurfaceS()->SetPixel( x+1, y+1, HEROCOLOR);
    SurfaceS()->SetPixel( x+2, y+1, HEROCOLOR);
    SurfaceS()->SetPixel( x+3, y+1, HEROCOLOR);

    SurfaceS()->SetPixel( x+1, y+2, HEROCOLOR);
    SurfaceS()->SetPixel( x+2, y+2, HEROCOLOR);
    SurfaceS()->SetPixel( x+3, y+2, HEROCOLOR);

    SurfaceS()->SetPixel( x+1, y+3, HEROCOLOR);
    SurfaceS()->SetPixel( x+2, y+3, HEROCOLOR);
    SurfaceS()->SetPixel( x+3, y+3, HEROCOLOR);
}

//hero looks for element
void Hero::Track( int element)
{
    static int oldDir = WallDN;
    static int dir;
    int count = 0;

    Remove();

    while( x & 3)
    {
	Move( WallLT);
    }

    while( y & 3)
    {
	Move( WallUP);
    }

    NEWTracer trace( maze);

    dir = trace.Find( x>>2, y>>2, element);

    //the chunk below makes sure that random movement
    //isn't too wild.
    if( dir == 0)
    {
	dir = oldDir;
	while( maze->isElement( x>>2, y>>2, dir))
	{
	    dir = 1 << (Random::random()%4);
	    while( dir == oldDir || dir == Reverse( oldDir))
	    {
		dir = 1 << (Random::random()%4);
	    }
	    count++;
	    if( count > (Random::random()%8))
	    {
		dir = 1 << (Random::random()%4);
		count = 0;
	    }
	}
	oldDir = dir;
    }

    Move( dir);
    Move( dir);
    Move( dir);
    Move( dir);

    Add();
}

//turn around.
int Hero::Reverse( int dir)
{
    switch( dir)
    {
	case WallLT:
	    return WallRT;

	case WallRT:
	    return WallLT;

	case WallUP:
	    return WallDN;

	case WallDN:
	    return WallUP;
    }

    return 0;
}

