/*
  regex.h - POSIX.2 compatible regexp interface

  Copyright (C) 2001-2003 Ville Laurikari <vl@iki.fi>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 2 (June
  1991) as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/* Versions with a maximum length argument and therefore the capability to
   handle null characters in the middle of the strings (not in POSIX.2). */
int regncomp(regex_t *preg, const char *regex, size_t len, int cflags);
int regnexec(const regex_t *preg, const char *string, size_t len,
	     size_t nmatch, regmatch_t pmatch[], int eflags);

/* Approximate matching parameter struct. */
typedef struct {
  int cost_ins;        /* Default cost of an inserted character. */
  int cost_del;        /* Default cost of a deleted character. */
  int cost_subst;      /* Default cost of a substituted character. */
  int max_cost;        /* Maximum allowed cost of a match. */
} regaparams_t;

/* Approximate matching result struct. */
typedef struct {
  size_t nmatch;       /* Length of pmatch[] array. */
  regmatch_t *pmatch;  /* Submatch data. */
  int cost;            /* Cost of the match. */
} regamatch_t;


/* Approximate matching functions. */
int regaexec(const regex_t *preg, const char *string,
	     regamatch_t *match, regaparams_t params, int eflags);
int reganexec(const regex_t *preg, const char *string, size_t len,
	      regamatch_t *match, regaparams_t params, int eflags);

